/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.xmlComponent.component;

import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentLayoutOption;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentWrapper;
import oracle.bali.xml.gui.jdev.resource.JDevBundle;
import oracle.bali.xml.gui.jdev.xmlComponent.AbstractXmlPanelWrapper;
import oracle.bali.xml.gui.jdev.xmlComponent.XmlComponentWrapperImpl;
import oracle.bali.xml.gui.jdev.xmlComponent.XmlPanelLayoutPolicy;
import oracle.bali.xml.gui.swing.xmlComponent.XmlLayoutOption;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlView;
import oracle.ide.controls.FlatEditorTransparentPanel;

public class ChoiceRadioComponent
extends FlatEditorTransparentPanel {
    private AbstractXmlPanelWrapper _panel;
    private Collection<XmlKey> _choiceKeys;
    private ButtonGroup _group;
    private Map<AbstractButton, XmlComponentWrapper> _buttonMap;

    public ChoiceRadioComponent(AbstractXmlPanelWrapper panel, Collection<XmlKey> choiceKeys) {
        this._panel = panel;
        this._choiceKeys = choiceKeys;
        this.setLayout(this._createLayout());
        this._initComponents();
    }

    protected XmlPanelLayoutPolicy getLayoutPolicy() {
        return this._panel.getLayoutPolicy();
    }

    private void _initComponents() {
        this._group = new ButtonGroup();
        this._buttonMap = new HashMap<AbstractButton, XmlComponentWrapper>();
        for (XmlKey choiceKey : this._choiceKeys) {
            this._addChoiceRadioButton(choiceKey);
        }
    }

    private void _addChoiceRadioButton(XmlKey xmlKey) {
        XmlLayoutOption options = new XmlLayoutOption();
        options.setAddLabel(false);
        JRadioButton button = new JRadioButton();
        XmlComponentWrapperImpl wrapper = this._createChoiceXmlComponentWrapper(xmlKey, button);
        this._panel.add((XmlComponentWrapper)wrapper, false);
        button.setModel(new ChoiceButtonModel(wrapper));
        button.setText(wrapper.getXmlComponentModel().getShortDisplayName());
        this.add(button, new CC());
        this.getLayoutPolicy().add((JPanel)((Object)this), wrapper, (XmlComponentLayoutOption)options);
        this._buttonMap.put(button, wrapper);
        this._group.add(button);
        ButtonListener listener = new ButtonListener();
        button.addActionListener(listener);
    }

    private XmlComponentWrapperImpl _createChoiceXmlComponentWrapper(XmlKey xmlKey, final AbstractButton button) {
        return new XmlComponentWrapperImpl(new JTextField(), xmlKey, this._panel.getXmlGui(), this._panel, this._panel.getXmlPanelRootXmlKey()){

            @Override
            public void updateXmlComponentFromModel() {
                super.updateXmlComponentFromModel();
                if (this.getXmlComponentModel().getNode() != null) {
                    ChoiceRadioComponent.this._group.setSelected(button.getModel(), true);
                } else {
                    button.getModel().setSelected(false);
                }
            }
        };
    }

    private LayoutManager _createLayout() {
        return new MigLayout(new LC().insets("0", "0", "0", "0").minWidth("1px"), new AC().gap("rel"), new AC().gap(String.valueOf(6)));
    }

    private class ChoiceButtonModel
    extends JToggleButton.ToggleButtonModel {
        private XmlComponentWrapper _wrapper;

        public ChoiceButtonModel(XmlComponentWrapper wrapper) {
            this._wrapper = wrapper;
        }

        @Override
        public void setSelected(boolean b) {
            super.setSelected(b);
            if (this.group != null) {
                b = this.group.isSelected(this);
            }
            this._wrapper.setEnabled(b);
        }
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Enumeration<AbstractButton> buttons = ChoiceRadioComponent.this._group.getElements();
            while (buttons.hasMoreElements()) {
                AbstractButton button = buttons.nextElement();
                XmlComponentWrapper wrapper = ChoiceRadioComponent.this._buttonMap.get(button);
                if (button.isSelected()) continue;
                wrapper.setEnabled(false);
                if (wrapper.getXmlComponentModel().getNode() == null) continue;
                XmlView model = wrapper.getXmlComponentModel().getView();
                try {
                    model.deleteNodes(JDevBundle.get("CHOICE_RADIO.REMOVE_NODE"), Collections.singletonList(wrapper.getXmlComponentModel().getNode()), false);
                }
                catch (XmlCommitException xmlCommitException) {}
            }
        }
    }
}

