/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.selection;

import java.lang.ref.Reference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlView;
import oracle.ide.help.DynamicHelpProvider;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultAttributes;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.SupportsInspection;
import oracle.ide.net.URLFactory;
import oracle.ide.util.Assert;
import org.w3c.dom.Document;

public class XmlSelectionElement
implements Element,
Locatable,
SupportsInspection,
DynamicHelpProvider {
    static final String __NODE_SEPARATOR = "_";
    static final String __QUERY_TOKEN = "&";
    private final Reference<DomModel> _domModelRef;
    private final List<org.w3c.dom.Node> _selection;
    private final int _hashCode;

    public XmlSelectionElement(JDevXmlContext context) {
        if (context == null) {
            throw new IllegalArgumentException("context is null!");
        }
        this._domModelRef = context.getSourceModel().getDomModel().getDomModelReference();
        this._selection = this._getSelectedNodes(context);
        this._hashCode = this.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (XmlSelectionElement.class != o.getClass()) {
            return false;
        }
        if (this._hashCode != o.hashCode()) {
            return false;
        }
        XmlSelectionElement xse = (XmlSelectionElement)o;
        if (!this._modelRefsEqual(this._domModelRef, xse._domModelRef)) {
            return false;
        }
        return this._selection.equals(xse._selection);
    }

    private boolean _modelRefsEqual(Reference<DomModel> r1, Reference<DomModel> r2) {
        DomModel dm1 = r1.get();
        DomModel dm2 = r2.get();
        if (dm1 != null) {
            return dm1.equals(dm2);
        }
        return dm1 == dm2;
    }

    public int hashCode() {
        int code = 19;
        code = 31 * code + this._domModelRef.hashCode();
        code = 31 * code + this._selection.hashCode();
        return code;
    }

    public boolean mayHaveChildren() {
        return false;
    }

    public Iterator getChildren() {
        return null;
    }

    public Attributes getAttributes() {
        return DefaultAttributes.EMPTY_ATTRIBUTES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<org.w3c.dom.Node> _getSelectedNodes(JDevXmlContext context) {
        XmlModel model = context.getSourceModel();
        model.acquireReadLock();
        try {
            List list = model.getSelection().getSelectedNodesList();
            return list;
        }
        finally {
            model.releaseReadLock();
        }
    }

    public String getShortLabel() {
        return (String)new DisplayableDelegate<String>(){

            @Override
            String getNoValue(XmlModel model, Node node) {
                return "";
            }

            @Override
            String getDocumentValue(XmlModel model, Node node, Document selection) {
                return node.getShortLabel();
            }

            @Override
            String getNodeValue(XmlModel model, Node node, org.w3c.dom.Node selection) {
                return model.getXmlMetadataResolver().getMediumDisplayName(selection);
            }

            @Override
            String getMultipleValue(XmlModel model, Node node, org.w3c.dom.Node[] selection) {
                return "Selected";
            }

            @Override
            String getFallbackValue() {
                return "Selected";
            }
        }.getValue();
    }

    public String getLongLabel() {
        return (String)new DisplayableDelegate<String>(){

            @Override
            String getNoValue(XmlModel model, Node node) {
                return "";
            }

            @Override
            String getDocumentValue(XmlModel model, Node node, Document selection) {
                return node.getLongLabel();
            }

            @Override
            String getNodeValue(XmlModel model, Node node, org.w3c.dom.Node selection) {
                return model.getXmlMetadataResolver().getLongDisplayName(selection);
            }

            @Override
            String getMultipleValue(XmlModel model, Node node, org.w3c.dom.Node[] selection) {
                return "Selected";
            }

            @Override
            String getFallbackValue() {
                return "Selected";
            }
        }.getValue();
    }

    public Icon getIcon() {
        return (Icon)new DisplayableDelegate<Icon>(){

            @Override
            Icon getNoValue(XmlModel model, Node node) {
                return null;
            }

            @Override
            Icon getDocumentValue(XmlModel model, Node node, Document selection) {
                return node.getIcon();
            }

            @Override
            Icon getNodeValue(XmlModel model, Node node, org.w3c.dom.Node selection) {
                return model.getXmlMetadataResolver().getSmallIcon(selection);
            }

            @Override
            Icon getMultipleValue(XmlModel model, Node node, org.w3c.dom.Node[] selection) {
                return null;
            }

            @Override
            Icon getFallbackValue() {
                return null;
            }
        }.getValue();
    }

    public String getToolTipText() {
        return this.getNode() == null ? null : this.getNode().getToolTipText();
    }

    public Object getData() {
        return this;
    }

    public XMLSourceNode getNode() {
        JDevXmlContext context = this._context();
        return context == null ? null : context.getIdeDocument();
    }

    public JDevXmlContext getXmlContext() {
        return this._context();
    }

    private JDevXmlContext _context() {
        DomModel model = this._domModelRef.get();
        if (model == null) {
            return null;
        }
        return (JDevXmlContext)model.getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getURL() {
        JDevXmlContext context = this._context();
        if (context == null) {
            return null;
        }
        XMLSourceNode node = context.getIdeDocument();
        if (node == null) {
            return null;
        }
        String src = node.getURL().toString();
        Selection s = context.getModel().getSelection();
        Object query = null;
        s.acquireModelReadLock();
        try {
            if (!s.isEmpty()) {
                query = "";
                org.w3c.dom.Node[] selection = s.getSelectedNodesArray();
                for (int i = 0; i < selection.length; ++i) {
                    query = (String)query + XmlSelectionElement._toString(selection[i]);
                    if (i == selection.length - 1) continue;
                    query = (String)query + __QUERY_TOKEN;
                }
            }
        }
        finally {
            s.releaseModelReadLock();
        }
        URL u = URLFactory.newURL((String)"xmlselection", null, null, (int)-1, (String)src, (String)query, null);
        return u;
    }

    public void setURL(URL url) {
        Assert.print((String)"oracle.bali.xml.gui.jdev.XmlSelectionElement.setURL() not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getDynamicHelpIds() {
        LinkedHashSet<String> topicIDs = Collections.EMPTY_SET;
        JDevXmlContext context = this._context();
        if (context == null) {
            return topicIDs;
        }
        XmlView model = context.getActiveView();
        if (model == null) {
            model = context.getModel();
        }
        model.acquireReadLock();
        try {
            Selection s = model.getSelection();
            XmlMetadataResolver resolver = model.getXmlMetadataResolver();
            DomPosition cursorLocation = s.getCursorLocation();
            ArrayList<org.w3c.dom.Node> helpableNodes = new ArrayList<org.w3c.dom.Node>(13);
            helpableNodes.addAll(s.getSelectedNodesList());
            if (cursorLocation != null) {
                org.w3c.dom.Node cursorNode = cursorLocation.getContainerNode(model.getTreeTraversal());
                if (cursorNode != null) {
                    helpableNodes.add(cursorNode);
                }
                if ((cursorNode = cursorLocation.getTargetNode()) != null) {
                    helpableNodes.add(cursorNode);
                }
            }
            if (!helpableNodes.isEmpty()) {
                topicIDs = new LinkedHashSet<String>(13);
                Iterator iter = helpableNodes.iterator();
                XmlGui gui = context.getActiveGui();
                while (iter.hasNext()) {
                    org.w3c.dom.Node helpableNode = (org.w3c.dom.Node)iter.next();
                    String topicID = gui != null ? gui.getHelpTopic(helpableNode, model.getNodeXmlKey(helpableNode)) : resolver.getHelpTopic(helpableNode);
                    if (topicID == null) continue;
                    topicIDs.add(topicID);
                }
            }
        }
        finally {
            model.releaseReadLock();
        }
        return topicIDs;
    }

    private static String _toString(org.w3c.dom.Node node) {
        try {
            int[] path = DomUtils.getPathToNode((org.w3c.dom.Node)node);
            StringBuffer b = new StringBuffer(path.length * 2);
            for (int i = 0; i < path.length; ++i) {
                b.append(path[i]);
                if (i == path.length - 1) continue;
                b.append(__NODE_SEPARATOR);
            }
            return b.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    private abstract class DisplayableDelegate<T> {
        private DisplayableDelegate() {
        }

        abstract T getNoValue(XmlModel var1, Node var2);

        abstract T getDocumentValue(XmlModel var1, Node var2, Document var3);

        abstract T getNodeValue(XmlModel var1, Node var2, org.w3c.dom.Node var3);

        abstract T getMultipleValue(XmlModel var1, Node var2, org.w3c.dom.Node[] var3);

        abstract T getFallbackValue();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        T getValue() {
            JDevXmlContext context = XmlSelectionElement.this._context();
            if (context == null) {
                return this.getFallbackValue();
            }
            XMLSourceNode node = context.getIdeDocument();
            if (node == null) {
                return this.getFallbackValue();
            }
            XmlModel model = context.getModel();
            model.acquireReadLock();
            try {
                org.w3c.dom.Node[] selection = model.getSelection().getSelectedNodesArray();
                switch (selection.length) {
                    case 0: {
                        T t = this.getNoValue(model, (Node)node);
                        return t;
                    }
                    case 1: {
                        if (selection[0] instanceof Document) {
                            T t = this.getDocumentValue(model, (Node)node, (Document)selection[0]);
                            return t;
                        }
                        T t = this.getNodeValue(model, (Node)node, selection[0]);
                        return t;
                    }
                }
                T t = this.getMultipleValue(model, (Node)node, selection);
                return t;
            }
            finally {
                model.releaseReadLock();
            }
        }
    }
}

