/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.palette;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.Icon;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.gui.jdev.palette.JDevPaletteGui;
import oracle.bali.xml.gui.jdev.palette.XmlPaletteItem;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.creatable.XmlCreatable;
import oracle.bali.xml.model.creatable.XmlKeyCreatable;
import oracle.bali.xml.model.event.XmlModelAdapter;
import oracle.bali.xml.model.task.ReadOnlyTask;
import oracle.bali.xml.share.UnmodifiableArrayList;
import oracle.ide.Context;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PalettePage;
import oracle.ide.palette2.PalettePages;
import oracle.ide.palette2.PalettePagesListener;
import oracle.ide.palette2.PaletteSection;

class ValidComponentsPalettePages
extends PalettePages {
    private Set<PaletteItem> _suggestedPaletteItemSet = null;
    private Set<PaletteItem> _otherValidPaletteItemSet = null;
    private final Object _itemSetLock = new Object();
    private Set<PalettePage> _pages = null;
    private final JDevPaletteGui _gui;
    private final Set<PalettePagesListener> _listeners = new CopyOnWriteArraySet<PalettePagesListener>();

    ValidComponentsPalettePages(JDevPaletteGui gui) {
        this._gui = gui;
    }

    public Collection<PalettePage> getPages() {
        if (this._pages == null) {
            new ReadOnlyTask(){

                protected Object runImpl(AbstractModel model) {
                    ValidComponentsPalettePages.this._initPage();
                    return null;
                }
            }.run((AbstractModel)this._gui.getView());
        }
        return this._pages;
    }

    public PaletteItem getItem(String providerId, String itemId) {
        return null;
    }

    public void addPalettePagesListener(PalettePagesListener listener) {
        this._listeners.add(listener);
    }

    public void removePalettePagesListener(PalettePagesListener listener) {
        this._listeners.remove(listener);
    }

    private void _initPage() {
        this._gui.addModelListener((XmlModelListener)new Updater());
        DynamicSection otherValidSection = new DynamicSection("", false);
        DynamicSection suggestedSection = new DynamicSection("", true);
        Group suggestedGroup = new Group(this._gui.getTranslatedString("PALETTE.SUGGESTED_SECTION_NAME"), suggestedSection);
        Group otherGroup = new Group(this._gui.getTranslatedString("PALETTE.OTHER_VALID_SECTION_NAME"), otherValidSection);
        UnmodifiableArrayList groups = new UnmodifiableArrayList((Object[])new PaletteGroup[]{suggestedGroup, otherGroup});
        String name = this._gui.getTranslatedString("PALETTE.VALID_COMPONENTS_PAGE_NAME");
        Page page = new Page(name, (Collection<PaletteGroup>)groups);
        this._pages = Collections.singleton(page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private Collection<PaletteItem> _getDynamicPaletteItems(boolean suggested) {
        Set<PaletteItem> set;
        XmlView model;
        block12: {
            model = this._gui.getView();
            model.acquireReadLock();
            try {
                Object object = this._itemSetLock;
                // MONITORENTER : object
                if (this._suggestedPaletteItemSet == null) {
                    Set<XmlKey> otherValidKeys;
                    Collection<Object> suggestedKeys;
                    DomPosition cursor = model.getSelection().getCursorLocation();
                    if (cursor == null) {
                        suggestedKeys = Collections.emptySet();
                        otherValidKeys = Collections.emptySet();
                    } else {
                        XmlMetadataResolver resolver = model.getXmlMetadataResolver();
                        Collection allValidKeys = resolver.getCreateableChildrenXmlKeys(cursor);
                        List preferredKeys = resolver.getPreferredChildrenXmlKeys(cursor.getContainerNode());
                        otherValidKeys = new HashSet<XmlKey>(allValidKeys);
                        Iterator itor = preferredKeys.iterator();
                        while (itor.hasNext()) {
                            if (otherValidKeys.contains(itor.next())) continue;
                            itor.remove();
                        }
                        otherValidKeys.removeAll(preferredKeys);
                        suggestedKeys = preferredKeys;
                    }
                    TreeSet<PaletteItem> suggestedPaletteItems = new TreeSet<PaletteItem>();
                    for (XmlKey suggestedKey : suggestedKeys) {
                        suggestedPaletteItems.add(new XmlPaletteItem((XmlCreatable)new XmlKeyCreatable(suggestedKey), this._gui));
                    }
                    TreeSet<PaletteItem> otherValidPaletteItems = new TreeSet<PaletteItem>();
                    for (XmlKey otherValidKey : otherValidKeys) {
                        otherValidPaletteItems.add(new XmlPaletteItem((XmlCreatable)new XmlKeyCreatable(otherValidKey), this._gui));
                    }
                    this._suggestedPaletteItemSet = suggestedPaletteItems;
                    this._otherValidPaletteItemSet = otherValidPaletteItems;
                }
                if (!suggested) break block12;
                set = this._suggestedPaletteItemSet;
                // MONITOREXIT : object
            }
            catch (Throwable throwable) {
                model.releaseReadLock();
                throw throwable;
            }
            model.releaseReadLock();
            return set;
        }
        set = this._otherValidPaletteItemSet;
        // MONITOREXIT : object
        model.releaseReadLock();
        return set;
    }

    private class Updater
    extends XmlModelAdapter {
        private Updater() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modelChanged(XmlModelEvent event) {
            if (event.getCursorLocationPropertyChange() != null) {
                Iterator<PalettePagesListener> iterator = ValidComponentsPalettePages.this._itemSetLock;
                synchronized (iterator) {
                    ValidComponentsPalettePages.this._suggestedPaletteItemSet = null;
                    ValidComponentsPalettePages.this._otherValidPaletteItemSet = null;
                }
                for (PalettePagesListener listener : ValidComponentsPalettePages.this._listeners) {
                    listener.palettePagesChanged(Collections.emptySet(), Collections.emptySet(), ValidComponentsPalettePages.this._pages);
                }
            }
        }

        public void listenerAttached(XmlModelEvent event) {
            this.modelChanged(event);
        }
    }

    private class DynamicSection
    extends PaletteSection {
        private final String _name;
        private final boolean _suggested;

        public DynamicSection(String name, boolean suggested) {
            this._name = name;
            this._suggested = suggested;
        }

        public Object getData(Object key) {
            return null;
        }

        public Collection<PaletteItem> getItems() {
            return ValidComponentsPalettePages.this._getDynamicPaletteItems(this._suggested);
        }

        public String getName() {
            return this._name;
        }
    }

    private class Group
    extends PaletteGroup {
        private final Collection<PaletteSection> _sections;
        private final String _name;

        public Group(String name, PaletteSection section) {
            this._name = name;
            this._sections = Collections.singletonList(section);
        }

        public Object getData(Object key) {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public Icon getIcon() {
            return null;
        }

        public String getName() {
            return this._name;
        }

        public Collection<PaletteSection> getSections() {
            return this._sections;
        }

        public boolean isVisible(Context context) {
            return true;
        }
    }

    private class Page
    extends PalettePage {
        private final Collection<PaletteGroup> _groups;
        private final String _name;

        public Page(String name, Collection<PaletteGroup> groups) {
            this._name = name;
            this._groups = groups;
        }

        public Collection<PaletteGroup> getGroups() {
            return this._groups;
        }

        public String getName() {
            return this._name;
        }

        public String getDescription() {
            return null;
        }

        public Icon getIcon() {
            return null;
        }

        public Object getData(Object key) {
            return null;
        }
    }
}

