/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.nodeComponent;

import java.awt.Component;
import java.util.Observable;
import java.util.Observer;
import javax.swing.SwingUtilities;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.xml.gui.base.inspector.XmlDomPropertyModel;
import oracle.bali.xml.gui.base.inspector.XmlMultiObjectModel;
import oracle.bali.xml.gui.jdev.nodeComponent.JDevDomNodeComponentGui;
import oracle.bali.xml.gui.swing.nodeComponent.DomNodeComponent;
import oracle.bali.xml.gui.swing.nodeComponent.SwingDomNodeComponentGui;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.ide.inspector.PropertyInspector;
import org.w3c.dom.Node;

public class JDevDomNodeComponent
extends DomNodeComponent {
    private PropertyInspector _pi;
    private XmlMultiObjectModel _model;

    public JDevDomNodeComponent(SwingDomNodeComponentGui gui, Node node, XmlKey key) {
        super(gui, node, key);
    }

    public Component getComponent() {
        if (this._pi != null) {
            return this._pi;
        }
        this._pi = new PropertyInspector();
        this._createPropertyModel();
        if (!this._componentNeeded()) {
            return null;
        }
        this._pi.setPropertyModel((PropertyModel)this._model);
        return this._pi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate() {
        if (this._model == null) {
            return true;
        }
        this._model.startRead();
        try {
            for (int i = 0; i < this._model.getRowCount(); ++i) {
                boolean required = this._model.getBooleanData(XmlDomPropertyModel.COLUMN_IS_REQUIRED, i);
                boolean hidden = this._model.getBooleanData(PropertyModel.COLUMN_IS_HIDDEN, i);
                if (!required || hidden) continue;
                Object value = this._model.getData(PropertyModel.COLUMN_VALUE, i);
                boolean emptyValue = value == null || "".equals(value);
                boolean isSet = this._model.getBooleanData(XmlDomPropertyModel.COLUMN_IS_SET, i);
                boolean isWritable = this._model.getBooleanData(XmlDomPropertyModel.COLUMN_IS_WRITABLE, i);
                if (!isWritable || !emptyValue && isSet) continue;
                String name = (String)this._model.getData(PropertyModel.COLUMN_DISPLAY_NAME, i);
                String requiredFormat = this.getGui().getTranslatedString("NODE_WIZARD.REQUIRED_ATTR_FORMAT");
                String requiredMessage = FastMessageFormat.formatMessage((String)requiredFormat, (String)name);
                this.getGui().getGuiContext().showErrorMessage(requiredMessage);
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this._model.stopRead();
        }
        return true;
    }

    public void dispose() {
        super.dispose();
        this._pi = null;
        this._model.dispose();
        this._model = null;
    }

    private void _createPropertyModel() {
        JDevDomNodeComponentGui gui = (JDevDomNodeComponentGui)this.getGui();
        this._model = (XmlMultiObjectModel)gui.getPropertyModel(this.getNode(), this.getKey());
        this._model.addObserver((Observer)new CreatorObserver());
    }

    private boolean _componentNeeded() {
        if (this._model.getRowCount() == 0) {
            return false;
        }
        int count = this._model.getRowCount();
        for (int i = 0; i < count; ++i) {
            if (this._model.getBooleanData(PropertyModel.COLUMN_IS_HIDDEN, i)) continue;
            return true;
        }
        return false;
    }

    private class CreatorObserver
    implements Observer {
        private CreatorObserver() {
        }

        @Override
        public void update(Observable observable, Object arg) {
            JDevDomNodeComponent.this._createPropertyModel();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (JDevDomNodeComponent.this._pi != null) {
                        JDevDomNodeComponent.this._pi.updatePropertyEditors((PropertyModel)JDevDomNodeComponent.this._model);
                        JDevDomNodeComponent.this._pi.validate();
                        JDevDomNodeComponent.this._pi.repaint();
                    }
                }
            });
        }
    }
}

