/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.inspector.editors;

import java.awt.Component;
import java.net.URI;
import java.net.URL;
import oracle.bali.xml.gui.base.inspector.editors.URIEditor;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.metadata.ContextualPropertyEditor;
import oracle.bali.xml.model.metadata.PropertyEditorContext;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.model.Project;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLChooserAdapter;
import oracle.ide.net.URLChooserEvent;
import oracle.ide.net.URLChooserListener;
import oracle.ide.net.URLFactory;

public class JDevURIEditor
extends URIEditor
implements ContextualPropertyEditor {
    private URLListener _urlListener = new URLListener();
    private URLChooser _urlChooser;
    private JDevXmlContext _xmlContext;

    public Component getCustomEditor() {
        URL selectedURL = this.getValueAsURL();
        if (this._xmlContext != null) {
            if (selectedURL == null || !"file".equals(selectedURL.getProtocol())) {
                selectedURL = this.getProject().getURL();
            }
            this._urlChooser = this.createURLChooser(selectedURL);
            this._urlChooser.addURLChooserListener((URLChooserListener)this._urlListener);
            return this._urlChooser;
        }
        return null;
    }

    public boolean supportsCustomEditor() {
        return this._xmlContext != null;
    }

    public void setAsURL(URL url) {
        if (this._xmlContext != null) {
            if ("file".equals(url.getProtocol())) {
                this.setAsText(this._xmlContext.getRelativePathForURL(url));
            } else {
                this.setAsText(url.toString());
            }
        }
    }

    public URL getValueAsURL() {
        Object value = super.getValue();
        if (this._xmlContext != null && value != null) {
            URI uri = (URI)value;
            if (uri.isAbsolute()) {
                return URLFactory.newURL((String)uri.toString());
            }
            return this._xmlContext.getURLForRelativePath(value.toString());
        }
        return null;
    }

    public void setContext(PropertyEditorContext context) {
        if (context.getXmlContext() instanceof JDevXmlContext) {
            this._xmlContext = (JDevXmlContext)context.getXmlContext();
        } else {
            this.clearContext();
        }
    }

    public void clearContext() {
        this._xmlContext = null;
    }

    protected URLChooser createURLChooser(URL selectedURL) {
        URLChooser chooser = DialogUtil.newURLChooser((URL)selectedURL);
        chooser.setSelectionMode(0);
        return chooser;
    }

    protected JDevXmlContext getContext() {
        return this._xmlContext;
    }

    protected Project getProject() {
        return this._xmlContext.getProject();
    }

    private class URLListener
    extends URLChooserAdapter {
        private URLListener() {
        }

        public void listSelectionChanged(URLChooserEvent event) {
            try {
                JDevURIEditor.this.setAsURL(JDevURIEditor.this._urlChooser.getSelectedURL());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

