/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.inspector;

import java.io.IOException;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.multi.ArraySelectionModel;
import oracle.bali.inspector.multi.SelectionModel;
import oracle.bali.xml.gui.base.inspector.TransactedPIMultiModel;
import oracle.bali.xml.gui.jdev.inspector.XmlIdeMultiObjectModel;
import oracle.bali.xml.gui.jdev.selection.XmlSelectionElement;
import oracle.ide.Context;
import oracle.ide.model.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public final class XmlInspectorUtils {
    public static boolean isSupportedContext(Context c) {
        Element[] sel = c.getSelection();
        return sel != null && sel.length > 0 && XmlInspectorUtils._isXmlSelection(sel[0]);
    }

    public static PropertyModel createXmlPropertyModel(List<PropertyModel> models) {
        XmlIdeMultiObjectModel outerModel = null;
        PropertyModel primaryInnerModel = XmlInspectorUtils._getPrimaryModel(models);
        if (primaryInnerModel != null) {
            outerModel = new XmlIdeMultiObjectModel(primaryInnerModel);
            outerModel.setSelectionModel(XmlInspectorUtils._getSelectionModel(primaryInnerModel, models));
        }
        return outerModel;
    }

    public static XMLReader createFilteredXmlReader() throws Exception {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        spf.setValidating(false);
        SAXParser sp = spf.newSAXParser();
        XMLReader xmlReader = sp.getXMLReader();
        xmlReader = new FormLayoutConfigFilter(xmlReader);
        return xmlReader;
    }

    private static SelectionModel _getSelectionModel(PropertyModel ppm, List<PropertyModel> l) {
        ArraySelectionModel asm = new ArraySelectionModel();
        asm.addItem(0, (Object)ppm);
        int i = 1;
        for (PropertyModel pm : l) {
            if (ppm == pm) continue;
            asm.addItem(i, (Object)pm);
            ++i;
        }
        return asm;
    }

    private static boolean _isXmlSelection(Element e) {
        return e instanceof XmlSelectionElement;
    }

    private static PropertyModel _getPrimaryModel(List<PropertyModel> l) {
        if (l.size() == 1) {
            return l.get(0);
        }
        PropertyModel pm = null;
        for (PropertyModel m : l) {
            if (!(m instanceof TransactedPIMultiModel)) continue;
            if (pm == null) {
                pm = m;
                continue;
            }
            throw new IllegalStateException("There cannot be more than one primary PropertyModel");
        }
        return pm;
    }

    private static class FormLayoutConfigFilter
    extends XMLFilterImpl {
        public FormLayoutConfigFilter(XMLReader parent) {
            super(parent);
        }

        @Override
        public void parse(InputSource input) throws IOException, SAXException {
            String ns = "http://xmlns.oracle.com/ide/extension";
            String hookName = "property-inspector-hook";
            String pflName = "property-form-layouts";
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("http://www.w3.org/2000/xmlns/", "xmlns", "xmlns", "CDATA", ns);
            this.startElement(ns, hookName, hookName, attrs);
            attrs.clear();
            this.startElement(ns, pflName, pflName, attrs);
            super.parse(input);
            this.endElement(ns, pflName, pflName);
            this.endElement(ns, hookName, hookName);
        }

        @Override
        public void parse(String systemId) throws IOException, SAXException {
            this.parse(new InputSource(systemId));
        }
    }
}

