/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.inspector;

import java.util.HashMap;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import oracle.bali.xml.gui.jdev.inspector.XmlInspectable;
import oracle.bali.xml.gui.jdev.inspector.XmlInspectorUtils;
import oracle.ide.Context;
import oracle.ide.inspector.Inspectable;
import oracle.ide.inspector.InspectableFactory;
import oracle.ide.view.View;
import oracle.ide.view.ViewAdapter;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;

public final class XmlInspectableFactory
implements InspectableFactory {
    private final WeakHashMap<View, ViewCombinedListener> _viewsToListeners = new WeakHashMap();
    private final HashMap<View, XmlInspectable> _viewsToInspectables = new HashMap();

    public Inspectable getInspectable(Context context) {
        View view = context.getView();
        if (view != null && XmlInspectorUtils.isSupportedContext(view.getContext())) {
            if (this._viewsToListeners.get(view) == null) {
                ViewCombinedListener listener = new ViewCombinedListener();
                this._viewsToListeners.put(view, listener);
                view.addViewListener((ViewListener)listener);
                view.addViewSelectionListener((ViewSelectionListener)listener);
            }
            if (this._viewsToInspectables.get(view) == null) {
                this._viewsToInspectables.put(view, new XmlInspectable());
            }
            Inspectable i = (Inspectable)this._viewsToInspectables.get(view);
            i.setContext(context);
            return i;
        }
        if (this._viewsToInspectables.get(view) != null) {
            XmlInspectable xi = this._viewsToInspectables.remove(view);
            xi.dispose();
        }
        return null;
    }

    private class ViewCombinedListener
    extends ViewAdapter
    implements ViewSelectionListener {
        private ViewCombinedListener() {
        }

        public void viewClosed(ViewEvent ve) {
            View view = ve.getView();
            XmlInspectable xi = XmlInspectableFactory.this._viewsToInspectables.remove(view);
            if (xi != null) {
                xi.dispose();
            }
            XmlInspectableFactory.this._viewsToListeners.remove(view);
        }

        public void viewSelectionChanged(ViewSelectionEvent e) {
            final View view = e.getView();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    XmlInspectable xi;
                    if (!XmlInspectorUtils.isSupportedContext(view.getContext()) && (xi = XmlInspectableFactory.this._viewsToInspectables.remove(view)) != null) {
                        xi.dispose();
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        }
    }
}

