/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.extension.viewfactory;

import java.util.concurrent.CopyOnWriteArrayList;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.extension.HookDataListener;
import oracle.bali.xml.gui.jdev.extension.viewfactory.DeclarativeViewFactoryHookData;
import oracle.bali.xml.gui.jdev.extension.viewfactory.DeclarativeViewFactoryHookSupport;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.XmlViewFactory;

public class DeclarativeViewFactory
extends XmlViewFactory
implements HookDataListener<DeclarativeViewFactoryHookData> {
    private final JDevXmlContext _xmlContext;
    private final CopyOnWriteArrayList<DeclarativeViewFactoryHookData> _factories;
    private boolean _bAttached = false;

    public DeclarativeViewFactory(JDevXmlContext xmlContext) {
        this._xmlContext = xmlContext;
        this._factories = new CopyOnWriteArrayList();
    }

    public XmlView createView(XmlModel model, XmlUsage usage) {
        this.ensureAttached();
        for (DeclarativeViewFactoryHookData xmlViewFactory : this._factories) {
            XmlView view;
            if (!xmlViewFactory.supportsUsage(usage) || (view = xmlViewFactory.createView(model, usage)) == null) continue;
            return view;
        }
        return null;
    }

    @Override
    public void hookDataAdded(DeclarativeViewFactoryHookData hookData) {
        if (hookData.evaluateRule(this._xmlContext)) {
            this._factories.add(0, hookData);
        }
    }

    private synchronized void ensureAttached() {
        if (!this._bAttached) {
            this._bAttached = true;
            DeclarativeViewFactoryHookSupport.getInstance().addHookDataListener(this);
        }
    }
}

