/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.explorer;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.gui.base.explorer.XmlTreeModel;
import oracle.bali.xml.gui.jdev.XmlController;
import oracle.bali.xml.gui.jdev.explorer.AbstractExplorerAction;
import oracle.bali.xml.gui.jdev.explorer.JDevExplorerGui;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.task.ReadOnlyTask;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.javatools.icons.OracleIcons;
import org.w3c.dom.Node;

public final class ExplorerShowAsTopAction
extends AbstractExplorerAction {
    public static final int EXPLORER_SHOW_AS_TOP_CMD_ID = Ide.findOrCreateCmdID((String)"XmlContext.showAsTop");
    public static final Icon ICON = OracleIcons.getIcon((String)"showtop_ena.png");
    public static final IdeAction IDEACTION = IdeAction.get((int)EXPLORER_SHOW_AS_TOP_CMD_ID, (String)Ide.findCmdName((int)EXPLORER_SHOW_AS_TOP_CMD_ID), (String)StringUtils.stripMnemonic((String)JDevExplorerGui.getTranslatedResource("EXPLORER.SHOW_AS_TOP")), null, (Integer)StringUtils.getMnemonicKeyCode((String)JDevExplorerGui.getTranslatedResource("EXPLORER.SHOW_AS_TOP")), null, null, (boolean)true);

    public ExplorerShowAsTopAction(String mnemonicAndDisplayName) {
        super(mnemonicAndDisplayName, "showAsTop");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        JDevExplorerGui xmlGui = this.getXmlGui();
        if (xmlGui == null) {
            return;
        }
        this.setEnabled(false);
        xmlGui.showAsTop();
    }

    @Override
    protected boolean isEnabledImpl() {
        AbstractModel model = this.getModel();
        if (model == null) {
            return false;
        }
        final JDevExplorerGui xmlGui = this.getXmlGui();
        if (xmlGui == null) {
            return false;
        }
        boolean isEnabled = (Boolean)new ReadOnlyTask<Boolean>(){

            protected Boolean runImpl(AbstractModel model) {
                XmlTreeModel treeModel;
                XmlTreeModel xmlTreeModel;
                Node selectedNode = model.getSelection().getFirstSelectedNode();
                int childCount = 0;
                if (selectedNode != null) {
                    childCount = model.getTreeTraversal().getChildCount(selectedNode);
                }
                if (childCount == 0) {
                    return false;
                }
                if (DomUtils.getNodeDepth((TreeTraversal)model.getTreeTraversal(), (Node)selectedNode) == 1) {
                    return false;
                }
                if (xmlGui != null && selectedNode.equals((xmlTreeModel = (treeModel = xmlGui.getTreeModel())).getSubTreeRootNode())) {
                    return false;
                }
                return true;
            }
        }.run(model);
        return isEnabled;
    }

    public static void registerActionMapping(XmlController xmlController) {
        xmlController.registerActionMapping("showAsTop", EXPLORER_SHOW_AS_TOP_CMD_ID, MenuConstants.increment((float)MenuConstants.SECTION_DYNAMIC_CTXT_MENU), 0.3f);
    }
}

