/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.ceditor.folding;

import java.util.Iterator;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.editor.folding.CodeFoldingModel;
import org.w3c.dom.Node;

final class JDevXmlCodeFoldingController
implements Controller {
    static final IdeAction collapseAllAction = IdeAction.get((int)55);
    static final IdeAction collapseBlockAction = IdeAction.get((int)88);
    static final IdeAction expandAllAction = IdeAction.get((int)54);
    static final IdeAction expandBlockAction = IdeAction.get((int)89);

    JDevXmlCodeFoldingController() {
    }

    public boolean update(IdeAction action, Context context) {
        CodeFoldingMargin margin = JDevXmlCodeFoldingController.getCodeFoldingMargin(context);
        return JDevXmlCodeFoldingController.update(action, margin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleEvent(IdeAction action, Context context) {
        if (!(context.getNode() instanceof XMLSourceNode)) {
            return false;
        }
        CodeFoldingMargin margin = JDevXmlCodeFoldingController.getCodeFoldingMargin(context);
        int cmdId = action.getCommandId();
        if (cmdId == 55) {
            JDevXmlCodeFoldingController.setExpansion(margin, false);
            return true;
        }
        if (cmdId == 88) {
            CodeFoldingModel model = margin.getModel();
            BasicEditorPane basicEditorPane = JDevXmlCodeFoldingController.getEditor(context);
            if (basicEditorPane != null) {
                int offset = basicEditorPane.getCaretPosition();
                model.readLock();
                try {
                    Node node = (Node)model.getSmallestEnclosingBlock(offset);
                    if (node == null) {
                        node = (Node)model.getFirstBlockAtLine(basicEditorPane.getLineFromOffset(offset));
                    }
                    if (node != null && model.isExpanded((Object)node)) {
                        margin.setExpansionState((Object)node, false, true);
                        int[] offsets = model.getTextOffsets((Object)node, null);
                        basicEditorPane.setCaretPosition(offsets[0]);
                    }
                }
                finally {
                    model.readUnlock();
                }
            }
            return true;
        }
        if (cmdId == 54) {
            JDevXmlCodeFoldingController.setExpansion(margin, true);
            return true;
        }
        if (cmdId == 89) {
            CodeFoldingModel model = margin.getModel();
            BasicEditorPane basicEditorPane = JDevXmlCodeFoldingController.getEditor(context);
            if (basicEditorPane != null) {
                model.readLock();
                try {
                    int offset = basicEditorPane.getCaretPosition();
                    int line = basicEditorPane.getLineFromOffset(offset);
                    Node node = (Node)model.getSmallestEnclosingBlock(offset);
                    if (node == null) {
                        node = (Node)model.getFirstBlockAtLine(line);
                    }
                    if (node != null) {
                        JDevXmlCodeFoldingController.expandFirstCollapsedChild(margin, node, basicEditorPane, line);
                    }
                }
                finally {
                    model.readUnlock();
                }
            }
            return true;
        }
        return false;
    }

    static boolean update(IdeAction action, CodeFoldingMargin margin) {
        int cmdId = action.getCommandId();
        if (cmdId == 55 || cmdId == 88 || cmdId == 54 || cmdId == 89) {
            boolean enabled = JDevXmlCodeFoldingController.isFoldingActionEnabled(margin);
            action.setEnabled(enabled);
            return true;
        }
        return false;
    }

    private static BasicEditorPane getEditor(Context context) {
        View view;
        if (context != null && (view = context.getView()) instanceof BasicEditorPaneContainer) {
            BasicEditorPaneContainer editor = (BasicEditorPaneContainer)view;
            return editor.getFocusedEditorPane();
        }
        return null;
    }

    private static CodeFoldingMargin getCodeFoldingMargin(Context context) {
        BasicEditorPane basicEditorPane = JDevXmlCodeFoldingController.getEditor(context);
        if (basicEditorPane != null) {
            Object value = basicEditorPane.getProperty("code-folding-margin");
            return (CodeFoldingMargin)value;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isFoldingActionEnabled(CodeFoldingMargin margin) {
        CodeFoldingModel model;
        if (margin != null && (model = margin.getModel()) != null) {
            model.readLock();
            try {
                Node root = (Node)model.getRoot();
                if (root != null) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                model.readUnlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setExpansion(CodeFoldingMargin margin, boolean expanded) {
        CodeFoldingModel model = margin.getModel();
        model.readLock();
        try {
            margin.beginCompoundFold();
            try {
                JDevXmlCodeFoldingController.foldChildren(margin, expanded, (Node)model.getRoot());
            }
            finally {
                margin.endCompoundFold();
                margin.repaint();
            }
        }
        finally {
            model.readUnlock();
        }
    }

    private static void foldChildren(CodeFoldingMargin margin, boolean expanded, Node node) {
        CodeFoldingModel model = margin.getModel();
        Iterator it = model.getChildren((Object)node);
        while (it.hasNext()) {
            Node child = (Node)it.next();
            margin.setExpansionState((Object)child, expanded);
            JDevXmlCodeFoldingController.foldChildren(margin, expanded, child);
        }
    }

    private static boolean expandFirstCollapsedChild(CodeFoldingMargin margin, Node node, BasicEditorPane editor, int line) {
        CodeFoldingModel model = margin.getModel();
        int[] offsets = model.getTextOffsets((Object)node, null);
        int startLine = editor.getLineFromOffset(offsets[0]);
        int endLine = editor.getLineFromOffset(offsets[1]);
        if (!(model.isExpanded((Object)node) || startLine != line && endLine != line)) {
            margin.setExpansionState((Object)node, true, true);
            editor.setCaretPosition(offsets[0] + 1);
            return true;
        }
        Iterator it = model.getChildren((Object)node);
        while (it.hasNext()) {
            Node child = (Node)it.next();
            if (!JDevXmlCodeFoldingController.expandFirstCollapsedChild(margin, child, editor, line)) continue;
            return true;
        }
        return false;
    }
}

