/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.ceditor.breadcrumbs;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.ceditor.breadcrumbs.JDevXmlCodeEditorBreadcrumbsGui;
import oracle.bali.xml.gui.jdev.ceditor.breadcrumbs.XmlBreadcrumb;
import oracle.bali.xml.gui.jdev.ceditor.breadcrumbs.XmlBreadcrumbsModel;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.TransactionOptions;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlView;
import oracle.ide.peek.CodePeek;
import oracle.javatools.ui.breadcrumbs.Breadcrumb;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsListener;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsModel;
import oracle.javatools.ui.breadcrumbs.JBreadcrumbs;
import oracle.javatools.util.SwingUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;

public class XmlBreadcrumbs {
    private JBreadcrumbs _mBreadcrumbs;
    private BreadcrumbsListener _mBreadcrumbsListener;
    private XmlBreadcrumbsModel _mBreadcrumbsModel;
    private XmlBreadcrumbsContextMenuListener _mXmlListener;
    private JDevXmlCodeEditorBreadcrumbsGui _mXmlBreadcrumbsGui;
    private XmlView _mXmlView;

    public XmlBreadcrumbs(XmlView xmlView, JDevXmlCodeEditorBreadcrumbsGui xmlBreadcrumbsGui, NodeFilter filter) {
        this.install(xmlView, xmlBreadcrumbsGui, filter);
    }

    protected XmlView getXmlView() {
        return this._mXmlView;
    }

    protected JDevXmlCodeEditorBreadcrumbsGui getBreadcrumbsGui() {
        return this._mXmlBreadcrumbsGui;
    }

    void setBreadcrumbs(JBreadcrumbs breadcrumbs) {
        assert (breadcrumbs != null);
        this.disposeGui();
        this.installGui(breadcrumbs);
    }

    private void install(XmlView xmlView, JDevXmlCodeEditorBreadcrumbsGui xmlBreadcrumbsGui, NodeFilter filter) {
        this._mXmlBreadcrumbsGui = xmlBreadcrumbsGui;
        this._mXmlView = xmlView;
        this._mBreadcrumbsModel = this.createModel(xmlView, filter);
        this.installGui(new JBreadcrumbs());
    }

    protected XmlBreadcrumbsModel createModel(XmlView xmlView, NodeFilter filter) {
        return new XmlBreadcrumbsModel(xmlView, filter);
    }

    public void dispose() {
        this.disposeGui();
        if (this._mBreadcrumbsModel != null) {
            this._mBreadcrumbsModel.dispose();
            this._mBreadcrumbsModel = null;
            this._mXmlListener = null;
            this._mXmlView = null;
        }
    }

    private void installGui(final JBreadcrumbs gui) {
        assert (gui != null);
        this._mBreadcrumbs = gui;
        this._mBreadcrumbsListener = new XmlBreadcrumbsListener();
        this._mBreadcrumbs.addBreadcrumbsListener(this._mBreadcrumbsListener);
        Runnable modelSetter = new Runnable(){

            @Override
            public void run() {
                if (gui.getModel() != XmlBreadcrumbs.this._mBreadcrumbsModel) {
                    gui.setModel((BreadcrumbsModel)XmlBreadcrumbs.this._mBreadcrumbsModel);
                }
            }
        };
        SwingUtils.dispatch((Runnable)modelSetter);
    }

    private void disposeGui() {
        if (this._mBreadcrumbs != null) {
            this._mBreadcrumbs.removeBreadcrumbsListener(this._mBreadcrumbsListener);
            this._mBreadcrumbsListener = null;
            this._mBreadcrumbs = null;
        }
    }

    public void setXmlBreadcrumbsContextMenuListener(XmlBreadcrumbsContextMenuListener l) {
        this._mXmlListener = l;
    }

    JBreadcrumbs getBreadcrumbsComponent() {
        return this._mBreadcrumbs;
    }

    void updateModel() {
        this._mBreadcrumbsModel.updateModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSelection(Node node) {
        JDevXmlContext context = (JDevXmlContext)this._mXmlBreadcrumbsGui.getGuiContext();
        XmlGui activeGui = context.getActiveGui();
        if (activeGui != null) {
            context.releaseActiveGui(activeGui);
        }
        boolean ok = false;
        this._mXmlView.startTransaction(new TransactionOptions("select node", true));
        try {
            Selection selection = this._mXmlView.getSelection();
            Node nodeToSelect = node;
            DomPosition cursor = null;
            if (node.getNodeType() == 2) {
                nodeToSelect = ((Attr)node).getOwnerElement();
                cursor = DomPositionFactory.createAttributePosition((Attr)((Attr)node), (int)0);
            } else {
                cursor = DomPositionFactory.createInsideOrAfterPosition((Node)nodeToSelect);
            }
            selection.clear();
            selection.set(nodeToSelect);
            selection.setCursorLocation(cursor);
            this._mXmlView.commitTransaction();
            ok = true;
        }
        catch (XmlCommitException exc) {
            ok = false;
        }
        finally {
            if (!ok) {
                this._mXmlView.rollbackTransaction();
            }
        }
        context.acquireActiveGui(activeGui);
        this._mXmlBreadcrumbsGui.getOwningJDevView().getGUI().requestFocus();
        this._mBreadcrumbsModel.updateModel();
    }

    public static interface XmlBreadcrumbsContextMenuListener {
        public void contextMenuClicked(Point var1);
    }

    private class XmlBreadcrumbsListener
    implements BreadcrumbsListener<Node> {
        private CodePeek _mPeek;
        private Breadcrumb _mPeekCrumb;

        private XmlBreadcrumbsListener() {
        }

        public void breadcrumbClicked(Breadcrumb<Node> crumb) {
            if (!XmlBreadcrumbs.this._mBreadcrumbsModel.isEmptyCrumb(crumb)) {
                XmlBreadcrumbs.this.setSelection((Node)crumb.getUserObject());
            }
        }

        public void showBreadcrumbPeek(Breadcrumb crumb, Rectangle peekLocation) {
            if (crumb == null) {
                if (this._mPeek != null) {
                    this._mPeek.hidePeek();
                }
                return;
            }
            if (crumb == this._mPeekCrumb && this._mPeek.isShowing()) {
                return;
            }
            if (XmlBreadcrumbs.this._mBreadcrumbsModel.isEmptyCrumb(crumb)) {
                return;
            }
            this._mPeekCrumb = crumb;
            if (this._mPeek != null) {
                this._mPeek.hidePeek();
            }
            this._mPeek = new CodePeek((JComponent)XmlBreadcrumbs.this._mBreadcrumbs, XmlBreadcrumbs.this._mXmlView.getContext().getURL().toExternalForm());
            String peekText = ((XmlBreadcrumb)crumb).getPeekText();
            if (this._mPeek != null && !"".equals(peekText)) {
                this._mPeek.setText(peekText);
                this._mPeek.setRectangle(peekLocation);
                this._mPeek.showPeek();
            }
        }

        public void hideBreadcrumbPeek() {
            if (this._mPeek != null) {
                this._mPeek.hidePeek();
            }
        }

        public void separatorClicked(Breadcrumb crumb, Rectangle separatorBounds) {
        }

        public void breadcrumbContextClicked(Breadcrumb crumb, Point p) {
            if (!XmlBreadcrumbs.this._mBreadcrumbsModel.isEmptyCrumb(crumb)) {
                this.breadcrumbClicked((Breadcrumb<Node>)crumb);
                if (XmlBreadcrumbs.this._mXmlListener != null) {
                    XmlBreadcrumbs.this._mXmlListener.contextMenuClicked(p);
                }
            }
        }
    }
}

