/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.ceditor.breadcrumbs;

import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.ceditor.breadcrumbs.JDevXmlCodeEditorBreadcrumbsGui;
import oracle.bali.xml.model.XmlUsage;
import oracle.ide.ceditor.BreadcrumbsPlugin;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.model.Node;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.ui.breadcrumbs.JBreadcrumbs;

public class XMLBreadcrumbsPlugin
extends BreadcrumbsPlugin {
    private MyCodeEditorListener codeEditorListener;
    private JDevXmlCodeEditorBreadcrumbsGui gui;

    public void install(BasicEditorPane editor) {
        CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)editor);
        Node node = codeEditor.getContext().getNode();
        if (node instanceof XMLSourceNode) {
            XMLSourceNode xmlNode = (XMLSourceNode)node;
            JDevXmlContext xmlContext = XMLSourceNode.getXmlContext(codeEditor.getContext());
            XmlGui xmlgui = xmlContext.getGui(XmlUsage.XML_CODE_EDITOR_BREADCRUMBS);
            if (xmlgui instanceof JDevXmlCodeEditorBreadcrumbsGui) {
                this.gui = (JDevXmlCodeEditorBreadcrumbsGui)xmlgui;
                this.gui.setOwningJDevView((View)codeEditor);
                super.install(editor);
                this.codeEditorListener = new MyCodeEditorListener();
                codeEditor.getGUI().addHierarchyListener(this.codeEditorListener);
            }
        }
    }

    protected JBreadcrumbs createBreadcrumbs() {
        return this.gui == null ? null : this.gui.getBreadcrumbs();
    }

    public void deinstall(BasicEditorPane editor) {
        if (this.gui != null) {
            this.gui = null;
            this.breadcrumbs.setModel(null);
            CodeEditor ce = CodeEditor.getCodeEditor((BasicEditorPane)editor);
            ce.getGUI().removeHierarchyListener(this.codeEditorListener);
            this.codeEditorListener = null;
            super.deinstall(editor);
        }
    }

    private class MyCodeEditorListener
    implements HierarchyListener {
        private MyCodeEditorListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() | 4L) > 0L) {
                if (e.getComponent().isShowing()) {
                    XMLBreadcrumbsPlugin.this.gui.shown();
                } else {
                    XMLBreadcrumbsPlugin.this.gui.hidden();
                }
            }
        }
    }
}

