/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.ceditor;

import java.awt.Color;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.gui.GuiXmlContext;
import oracle.bali.xml.gui.GuiXmlContextUtils;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.ceditor.JDevXmlCodeEditorGui;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.XmlUsage;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.tint.AbstractTintPlugin;
import oracle.ide.ceditor.tint.BlockPainter;
import oracle.ide.ceditor.tint.BlockStroke;
import oracle.ide.ceditor.tint.BlockType;
import oracle.ide.ceditor.tint.TintModel;
import oracle.ide.ceditor.tint.TintOptions;
import oracle.ide.config.Preferences;
import oracle.ideimpl.ceditor.tint.DefaultBlockPainter;
import oracle.ideimpl.ceditor.tint.DefaultTintBlock;
import oracle.ideimpl.ceditor.tint.DefaultTintModel;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.ui.ColorUtils2;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class XmlTintPlugin
extends AbstractTintPlugin {
    private XmlTintModel _model = new XmlTintModel();
    private XmlModelListener _xmlModelListener;
    private JDevXmlCodeEditorGui _codeEditorGui;

    XmlTintPlugin() {
    }

    public TintModel createModel() {
        this._codeEditorGui = null;
        CodeEditor ce = CodeEditor.getCodeEditor((BasicEditorPane)this.editor);
        if (ce != null) {
            this._codeEditorGui = XmlTintPlugin._getGui(ce);
        }
        if (this._codeEditorGui != null && TintOptions.getInstance((PropertyStorage)Preferences.getPreferences()).isEnabled()) {
            this._createAndAddModelListener(this._codeEditorGui);
        }
        this._model.rebuild();
        return this._model;
    }

    protected void tintEnabled(boolean tintEnabled) {
        super.tintEnabled(tintEnabled);
        if (this._codeEditorGui != null && this._xmlModelListener != null) {
            this._codeEditorGui.removeModelListener(this._xmlModelListener);
            this._xmlModelListener = null;
        }
        this._codeEditorGui = null;
        CodeEditor ce = CodeEditor.getCodeEditor((BasicEditorPane)this.editor);
        if (ce != null) {
            this._codeEditorGui = XmlTintPlugin._getGui(ce);
        }
        if (tintEnabled && this._codeEditorGui != null && this._xmlModelListener == null) {
            this._createAndAddModelListener(this._codeEditorGui);
        }
    }

    public BlockPainter createPainter() {
        return new XmlTintPainter();
    }

    public void deinstall(BasicEditorPane editor) {
        if (this._xmlModelListener != null && this._codeEditorGui != null) {
            this._codeEditorGui.removeModelListener(this._xmlModelListener);
        }
        this._codeEditorGui = null;
        super.deinstall(editor);
    }

    private static JDevXmlCodeEditorGui _getGui(CodeEditor e) {
        JDevXmlContext xmlContext;
        XmlGui gui;
        Context c = e.getContext();
        if (c != null && (gui = GuiXmlContextUtils.getGui((GuiXmlContext)(xmlContext = JDevXmlContext.getXmlContext(c)), (XmlUsage)XmlUsage.XML_CODE_EDITOR)) instanceof JDevXmlCodeEditorGui) {
            return (JDevXmlCodeEditorGui)gui;
        }
        return null;
    }

    private void _createAndAddModelListener(JDevXmlCodeEditorGui codeEditorGui) {
        this._xmlModelListener = new XmlModelListener(){

            public void listenerAttached(XmlModelEvent event) {
            }

            public void invalidate(XmlModelEvent event) {
            }

            public void modelChanged(XmlModelEvent event) {
                if (!event.isDomTreeChanged()) {
                    return;
                }
                XmlTintPlugin.this._model.rebuild();
            }

            public void noChange(XmlModelEvent event) {
            }

            public void listenerDetached(XmlModelEvent event) {
            }
        };
        codeEditorGui.addModelListener(this._xmlModelListener);
    }

    private class XmlTintModel
    extends DefaultTintModel {
        private XmlTintModel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rebuild() {
            Context ideContext;
            JDevXmlContext context;
            this.dispose();
            this.maxDepth = 0;
            CodeEditor ce = CodeEditor.getCodeEditor((BasicEditorPane)XmlTintPlugin.this.editor);
            if (ce != null && (context = JDevXmlContext.getXmlContext(ideContext = ce.getContext())) != null) {
                XmlModel model = context.getModel();
                DomModel domModel = model.getDomModel();
                domModel.acquireReadLock();
                try {
                    TextBuffer textBuffer = ((BasicDocument)XmlTintPlugin.this.editor.getDocument()).getTextBuffer();
                    Document node = domModel.getDocument();
                    int[] offsets = new int[2];
                    if (node == null) {
                        this.rootBlock = null;
                    } else {
                        domModel.getTextOffsets((Node)node, offsets);
                        DefaultTintBlock block = null;
                        if (offsets[0] != -1 && offsets[1] != -1) {
                            block = new DefaultTintBlock(textBuffer, offsets[0], offsets[1]);
                            block.setBlockType(this.getBlockType(node.getNodeName()));
                        }
                        this.rootBlock = block;
                        if (block != null) {
                            this.addChildren(block, domModel, node, textBuffer, offsets, 0);
                        }
                    }
                }
                finally {
                    domModel.releaseReadLock();
                }
            }
        }

        private void addChildren(DefaultTintBlock block, DomModel domModel, Node node, TextBuffer textBuffer, int[] offsets, int depth) {
            NodeList list = node.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node childNode = list.item(i);
                if (childNode.getNodeType() != 1) continue;
                domModel.getTextOffsets(childNode, offsets);
                if (offsets[0] == -1 || offsets[1] == -1) continue;
                DefaultTintBlock childBlock = new DefaultTintBlock(textBuffer, offsets[0], offsets[1]);
                childBlock.setBlockType(this.getBlockType(childNode.getNodeName()));
                block.addChild(childBlock);
                if (depth > this.maxDepth) {
                    this.maxDepth = depth;
                }
                this.addChildren(childBlock, domModel, childNode, textBuffer, offsets, depth + 1);
            }
        }

        private BlockType getBlockType(String id) {
            Color color;
            Color edgeColor = color = new Color(0, 0, 0, 0);
            if (id != null) {
                color = ColorUtils2.getStringColor((String)id);
                edgeColor = ColorUtils2.shadeColorPercent((Color)color, (double)5.0);
            }
            return new BlockType(id, color, edgeColor, BlockStroke.DASHED_1);
        }
    }

    private static class XmlTintPainter
    extends DefaultBlockPainter {
        private XmlTintPainter() {
        }

        protected boolean isPaintingEnabled() {
            boolean enabled = !TintOptions.getInstance((PropertyStorage)Preferences.getPreferences()).isEnabled();
            return enabled;
        }
    }
}

