/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.ceditor;

import java.awt.Rectangle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import oracle.bali.xml.gui.GuiXmlContext;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.util.JDevUtils;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.util.AbstractTextSelectionSynchronizer;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.javatools.editor.BasicEditorPane;

public class JDevTextSelectionSynchronizer
extends AbstractTextSelectionSynchronizer {
    public static final JDevTextSelectionSynchronizer INSTANCE = new JDevTextSelectionSynchronizer();
    private static final Logger _LOGGER = Logger.getLogger(JDevTextSelectionSynchronizer.class.getName());

    public final void syncTextSelection(Context ideContext) {
        if (JDevXmlContext.hasXmlContextBeenCreated(ideContext)) {
            JDevXmlContext xmlContext = JDevXmlContext.getXmlContext(ideContext);
            if (xmlContext != null) {
                this.syncTextSelection((GuiXmlContext)xmlContext, ideContext.getView());
            } else {
                _LOGGER.finer("XML context == null in syncTextSelection");
            }
        } else {
            _LOGGER.finer("XML context not created in syncTextSelection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncTextSelection(XmlModel model, int startOffset, int endOffset, Object arg) {
        JDevXmlContext xmlContext = (JDevXmlContext)model.getContext();
        CodeEditor codeEditor = arg instanceof CodeEditor ? (CodeEditor)arg : JDevUtils.getCodeEditor(xmlContext);
        if (codeEditor != null) {
            BasicEditorPane pane = codeEditor.getFocusedEditorPane();
            if (pane != null) {
                pane.beginNavigation();
                try {
                    pane.setCaretPosition(endOffset);
                    pane.moveCaretPosition(startOffset);
                    if (_LOGGER.isLoggable(Level.FINER)) {
                        _LOGGER.log(Level.FINER, "Selected {0}-{1} in {2}", new Object[]{startOffset, endOffset, model});
                    }
                    try {
                        Rectangle rect = pane.modelToView(startOffset);
                        if (rect != null) {
                            Rectangle endRect = pane.modelToView(endOffset);
                            if (endRect != null) {
                                rect = rect.union(endRect);
                            }
                            pane.scrollRectToVisible(rect);
                            _LOGGER.log(Level.FINER, "Scrolled to visible: {0}", rect);
                        }
                        _LOGGER.finer("Rect == null in syncTextSelection");
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                finally {
                    pane.endNavigation();
                }
            } else {
                _LOGGER.finer("No editor pane in syncTextSelection");
            }
        } else {
            _LOGGER.finer("No code editor in syncTextSelection");
        }
    }

    private JDevTextSelectionSynchronizer() {
    }
}

