/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.addin.schema;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.share.sort.Sort;
import oracle.bali.xml.addin.SchemaRegistryAddin;
import oracle.bali.xml.addin.XMLEditorAddin;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.addin.schema.AddSchemaPanel;
import oracle.bali.xml.addin.schema.MapSchema;
import oracle.bali.xml.addin.schema.SchemaLoader;
import oracle.bali.xml.addin.schema.SchemaMap;
import oracle.bali.xml.addin.schema.SchemaOptions;
import oracle.bali.xml.addin.schema.SchemaOptionsPrefs;
import oracle.bali.xml.addin.schema.SchemaUtils;
import oracle.bali.xml.addin.schema.URLRenderer;
import oracle.ide.ProductInformation;
import oracle.ide.config.Preferences;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Recognizer;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.plaf.IconicButtonUI;

public final class SchemaOptionsPanel
extends DefaultTraversablePanel
implements ListSelectionListener,
ActionListener,
ItemListener {
    private static final String _KEY_USER_LABEL = "SCHEMAADDIN.OPTIONS_USER_LABEL";
    private static final String _KEY_EXT = "SCHEMAADDIN.EXTENSION_HEADER";
    private static final String _KEY_LOCATION = "SCHEMAADDIN.LOCATION_HEADER";
    private static final String _KEY_UNLOAD = "SCHEMAADDIN.UNLOAD_LABEL";
    private static final String _KEY_ERROR_TITLE = "SCHEMAADDIN.ERROR_LOADING_TITLE";
    private static final String _KEY_INVALID_URL = "SCHEMAADDIN.INVALID_URL";
    private static final String _KEY_IOERROR = "SCHEMAADDIN.IOERROR";
    private static final String _KEY_ERROR_EDITING_TITLE = "SCHEMAADDIN.ERROR_EDITING_TITLE";
    private static final String _KEY_EDITERROR = "SCHEMAADDIN.EDITERROR";
    private static final String _KEY_IGNORE = "SCHEMAADDIN.IGNORE_ERROR";
    private static final String _KEY_EDIT_FILE = "SCHEMAADDIN.EDIT_FILE";
    private static final String _KEY_CHECKBOX_LABEL = "SCHEMAADDIN.CHECKBOX_REMOTE_SCHEMAS_LABEL";
    private static final String _KEY_CHECKBOX_RECOMMENDATION = "SCHEMAADDIN.CHECKBOX_REMOTE_SCHEMAS_RECOMMENDATION_LABEL";
    private static final String _KEY_CHECKBOX_TOOLTIP = "SCHEMAADDIN.CHECKBOX_REMOTE_SCHEMAS_TOOLTIP";
    private static final String _KEY_ADD_TOOLTIP = "SCHEMAADDIN.ADD_SCHEMA_TIP";
    private static final String _KEY_EDIT_TOOLTIP = "SCHEMAADDIN.EDIT_SCHEMA_TIP";
    private static final String _KEY_REMOVE_TOOLTIP = "SCHEMAADDIN.REMOVE_SCHEMA_TIP";
    private static final int _INDEX_URL = 0;
    private static final int _INDEX_EXT = 1;
    private static final String[] _columns = new String[]{SchemaOptionsPanel.getTranslatedString("SCHEMAADDIN.LOCATION_HEADER"), SchemaOptionsPanel.getTranslatedString("SCHEMAADDIN.EXTENSION_HEADER")};
    private JPanel _userPanel;
    private JButton _removeButton;
    private JButton _editButton;
    private NiceTable _userTable;
    private AddSchemaPanel _addPane;
    private SchemaMap _map;
    private boolean _dirty;
    private JScrollPane _userTableScrollPane;
    private TableComponentAdapter _userComponentListener;
    private TableColumnModelListener _userTableColumnModelListener;
    private static int _userFileColumnWidth = -1;
    private static int _userExtColumnWidth = -1;

    public SchemaOptionsPanel() {
        this.setHelpID("f1_prefxmlschemas_html");
        this._init();
    }

    public static String getTranslatedString(String key) {
        return SchemaRegistryAddin.getTranslatedString(key);
    }

    public void onEntry(TraversableContext tc) {
        SchemaOptionsPrefs schemaPrefs = SchemaOptionsPanel.getSchemaPrefs(tc);
        this._load(schemaPrefs);
        this._dirty = false;
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        SchemaOptionsPrefs schemaPrefs = SchemaOptionsPanel.getSchemaPrefs(tc);
        if (schemaPrefs == null || this._map == null) {
            return;
        }
        this._save(schemaPrefs);
        final SchemaMap schemaMap = SchemaRegistryAddin.getSchemaMap();
        if (this._dirty) {
            this._dirty = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (schemaMap != null) {
                        SchemaRegistryAddin.loadSchemasForOpenEditors(schemaMap);
                    }
                }
            });
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this._enableButtons();
    }

    private void _enableButtons() {
        boolean enabled = this._userTable.getSelectedRowCount() > 0 && this._userTable.getModel().getRowCount() > 0;
        this._removeButton.setEnabled(enabled);
        enabled = this._userTable.getSelectedRowCount() > 1 ? false : enabled;
        this._editButton.setEnabled(enabled);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        DefaultTableModel model = (DefaultTableModel)this._userTable.getModel();
        if ("ADD".equals(cmd)) {
            this._showAddDialog(model);
        } else if ("REMOVE".equals(cmd)) {
            int[] rows = this._userTable.getSelectedRows();
            if (rows != null) {
                Sort.qSort((int[])rows, (int)rows.length, (boolean)false);
                HashSet<String> affectedExtensions = new HashSet<String>();
                for (int i = 0; i < rows.length; ++i) {
                    int row = rows[i];
                    URL url = (URL)model.getValueAt(row, 0);
                    String ext = (String)model.getValueAt(row, 1);
                    affectedExtensions.add(ext);
                    this._map.remove(url, ext, true);
                    model.removeRow(row);
                }
                this._enableButtons();
                this._dirty = true;
                Iterator extIter = affectedExtensions.iterator();
                while (extIter.hasNext()) {
                    SchemaRegistryAddin.clearAndReloadOnDemand((String)extIter.next());
                }
            }
        } else if ("UNLOAD".equals(cmd)) {
            this._dirty = true;
            SchemaRegistryAddin.clearAndReloadOnDemand();
        } else if ("EDIT".equals(cmd)) {
            int row = this._userTable.getSelectedRow();
            this._showEditDialog(model, row);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        SchemaOptionsPrefs sop = this.getSchemaPrefs();
        boolean loadRemoteSchemas = false;
        if (e.getStateChange() == 1) {
            loadRemoteSchemas = true;
        }
        sop.setLoadRemoteSchemas(loadRemoteSchemas);
        SchemaUtils.setPrivateLoadRemoteSchemasSystemProperty(loadRemoteSchemas);
    }

    private void _load(SchemaOptionsPrefs schemaPrefs) {
        this._map = SchemaRegistryAddin.getSchemaMap().copy();
        MapSchema[] schemas = this._map.getSchemas();
        int count = schemas == null ? 0 : schemas.length;
        DefaultTableModel userModel = new DefaultTableModel(_columns, 0){

            @Override
            public boolean isCellEditable(int row, int colum) {
                return false;
            }
        };
        Object[] data = new Object[2];
        for (int i = 0; i < count; ++i) {
            String ext = schemas[i].getExtension();
            data[0] = schemas[i].getURL();
            data[1] = ext;
            if (!schemas[i].isUserDefined()) continue;
            userModel.addRow(data);
        }
        this._initTable(this._userTable, userModel);
        this._setColumnPreferredWidths(this._userTable, null);
    }

    private void _initTable(NiceTable table, TableModel model) {
        table.setModel(model);
        TableColumn tc = table.getColumnModel().getColumn(0);
        tc.setCellRenderer(new URLRenderer());
        KeyStroke key = KeyStroke.getKeyStroke(27, 0);
        for (InputMap iMap = table.getInputMap(1); iMap != null; iMap = iMap.getParent()) {
            iMap.remove(key);
        }
    }

    private static int _getColumnSizeToFit(NiceTable table, int columnIndex) {
        int maxWidth = 5;
        TableColumn column = table.getTableHeader().getColumnModel().getColumn(columnIndex);
        TableCellRenderer headerRenderer = null;
        if (headerRenderer == null) {
            headerRenderer = column.getHeaderRenderer();
        }
        if (headerRenderer == null) {
            headerRenderer = column.getCellRenderer();
        }
        if (headerRenderer == null) {
            headerRenderer = table.getTableHeader().getDefaultRenderer();
        }
        if (headerRenderer != null) {
            maxWidth = headerRenderer.getTableCellRendererComponent((JTable)table, column.getHeaderValue(), false, false, 0, 0).getWidth();
        }
        int n = table.getModel().getRowCount();
        TableCellRenderer headerCellRenderer = table.getDefaultRenderer(table.getModel().getColumnClass(columnIndex));
        maxWidth = Math.max(headerCellRenderer.getTableCellRendererComponent((JTable)table, (Object)SchemaOptionsPanel._columns[columnIndex], (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width, maxWidth);
        for (int j = 0; j < n; ++j) {
            Object value = table.getModel().getValueAt(j, columnIndex);
            TableCellRenderer cellRenderer = table.getCellRenderer(j, columnIndex);
            if (cellRenderer == null || value == null) continue;
            maxWidth = Math.max(cellRenderer.getTableCellRendererComponent((JTable)table, (Object)value, (boolean)false, (boolean)false, (int)j, (int)columnIndex).getPreferredSize().width, maxWidth);
        }
        return maxWidth;
    }

    private void _save(SchemaOptionsPrefs schemaPrefs) throws TraversalException {
        SchemaRegistryAddin.setSchemaMap(this._map, schemaPrefs);
        this._map = null;
    }

    private void _init() {
        String userLabelString = SchemaOptionsPanel.getTranslatedString(_KEY_USER_LABEL);
        String unloadLabel = SchemaOptionsPanel.getTranslatedString(_KEY_UNLOAD);
        String checkBoxLabel = SchemaOptionsPanel.getTranslatedString(_KEY_CHECKBOX_LABEL);
        String checkBoxRecommendationLabel = SchemaOptionsPanel.getTranslatedString(_KEY_CHECKBOX_RECOMMENDATION);
        SchemaOptionsPanel panel = this;
        ((Container)((Object)panel)).setLayout(new BorderLayout(3, 18));
        JCheckBox checkBox = new JCheckBox(StringUtils.stripMnemonic((String)checkBoxLabel));
        checkBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)checkBoxLabel));
        checkBox.setSelected(this.getSchemaPrefs().getLoadRemoteSchemas());
        checkBox.setEnabled(this._getEnabledState());
        if (!checkBox.isEnabled()) {
            checkBox.setToolTipText(SchemaOptionsPanel.getTranslatedString(_KEY_CHECKBOX_TOOLTIP));
        }
        JLabel recommendationLabel = new JLabel(checkBoxRecommendationLabel);
        JPanel checkBoxPanel = new JPanel(new BorderLayout(3, 3));
        checkBoxPanel.add("North", checkBox);
        checkBoxPanel.add("West", recommendationLabel);
        ((Container)((Object)panel)).add("North", checkBoxPanel);
        JLabel userLabel = new JLabel(StringUtils.stripMnemonic((String)userLabelString));
        userLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)userLabelString));
        JButton addButton = new JButton();
        addButton.setIcon(OracleIcons.getIcon((String)"add.png"));
        IconicButtonUI.install((AbstractButton)addButton);
        addButton.setToolTipText(SchemaOptionsPanel.getTranslatedString(_KEY_ADD_TOOLTIP));
        userLabel.setLabelFor(addButton);
        JButton editButton = new JButton();
        editButton.setIcon(OracleIcons.getIcon((String)"edit.png"));
        IconicButtonUI.install((AbstractButton)editButton);
        editButton.setToolTipText(SchemaOptionsPanel.getTranslatedString(_KEY_EDIT_TOOLTIP));
        editButton.setEnabled(false);
        JButton removeButton = new JButton();
        removeButton.setIcon(OracleIcons.getIcon((String)"delete.png"));
        IconicButtonUI.install((AbstractButton)removeButton);
        removeButton.setToolTipText(SchemaOptionsPanel.getTranslatedString(_KEY_REMOVE_TOOLTIP));
        removeButton.setEnabled(false);
        JButton unloadButton = new JButton(StringUtils.stripMnemonic((String)unloadLabel));
        unloadButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)unloadLabel));
        JPanel unloadBtnPanel = new JPanel();
        ControlBar cb = new ControlBar();
        cb.add((Component)addButton);
        cb.add((Component)editButton);
        cb.add((Component)removeButton);
        cb.add(Box.createHorizontalStrut(2));
        cb.add((Component)new JSeparator(1));
        cb.add(Box.createHorizontalStrut(1));
        unloadBtnPanel.add(Box.createVerticalStrut(1));
        unloadBtnPanel.add(unloadButton);
        unloadBtnPanel.add(Box.createVerticalStrut(1));
        cb.add((Component)unloadBtnPanel);
        cb.add(Box.createHorizontalStrut(1));
        NiceTable userTable = new NiceTable();
        userTable.setColumnSelectorAvailable(false);
        userTable.setResizeColumnOnDoubleClick(true);
        userTable.setShowToolTips(true);
        userTable.setSelectionMode(2);
        userTable.setCellSelectionEnabled(true);
        userTable.getTableHeader().setReorderingAllowed(false);
        JPanel userPanel = new JPanel(new BorderLayout(3, 3));
        this._userTableScrollPane = new JScrollPane((Component)userTable);
        if (_userFileColumnWidth < 0) {
            this._userComponentListener = new TableComponentAdapter();
            this._userTableScrollPane.addComponentListener(this._userComponentListener);
        }
        ComponentWithTitlebar cwtb = new ComponentWithTitlebar((JComponent)this._userTableScrollPane, userLabel, cb);
        userPanel.add("Center", (Component)cwtb);
        ((Container)((Object)panel)).add("Center", userPanel);
        this._userTable = userTable;
        this._userTable.getSelectionModel().addListSelectionListener(this);
        this._userPanel = userPanel;
        this._removeButton = removeButton;
        this._editButton = editButton;
        checkBox.addItemListener(this);
        editButton.setActionCommand("EDIT");
        editButton.addActionListener(this);
        removeButton.setActionCommand("REMOVE");
        removeButton.addActionListener(this);
        addButton.setActionCommand("ADD");
        addButton.addActionListener(this);
        unloadButton.setActionCommand("UNLOAD");
        unloadButton.addActionListener(this);
    }

    private SchemaOptions _getOptions(TraversableContext tc) {
        return (SchemaOptions)tc.find(SchemaOptions.KEY_SETTINGS);
    }

    private void _showEditDialog(DefaultTableModel model, int rowToEdit) {
        this._showCreatorEditorDialog(model, rowToEdit, true);
    }

    private void _showAddDialog(DefaultTableModel model) {
        this._showCreatorEditorDialog(model, -1, false);
    }

    private void _showCreatorEditorDialog(final DefaultTableModel model, final int rowToEdit, final boolean editing) {
        if (this._addPane == null) {
            this._addPane = new AddSchemaPanel();
        }
        if (editing) {
            String fileText = model.getValueAt(rowToEdit, 0).toString();
            String extText = (String)model.getValueAt(rowToEdit, 1);
            this._addPane.setURL(fileText);
            this._addPane.setExtention(extText);
        } else {
            this._addPane.setURL("");
            this._addPane.setExtention(".xml");
        }
        this._addPane.setEditing(editing);
        if (!this._addPane.showAddDialog((Component)((Object)this))) {
            return;
        }
        Object extension = this._addPane.getExtension();
        if (extension == null || "".equals(extension)) {
            extension = ".xml";
        } else if (!((String)extension).startsWith(".")) {
            extension = "." + (String)extension;
        }
        URL url = this._addPane.getURL();
        if (null == url) {
            String errorTitle = editing ? SchemaOptionsPanel.getTranslatedString(_KEY_ERROR_EDITING_TITLE) : SchemaOptionsPanel.getTranslatedString(_KEY_ERROR_TITLE);
            JOptionPane.showMessageDialog((Component)((Object)this), SchemaOptionsPanel.getTranslatedString(_KEY_INVALID_URL), errorTitle, 0);
            this._showAddDialog(model);
            return;
        }
        if (url != null) {
            final int count = model.getRowCount();
            for (int i = 0; i < count; ++i) {
                URL temp = (URL)model.getValueAt(i, 0);
                String testExt = (String)model.getValueAt(i, 1);
                if (!SchemaMap.equals(temp, url) || !testExt.equals(extension)) continue;
                return;
            }
            final URL localURL = url;
            Object localExtension = extension;
            Runnable success = new Runnable(){
                final /* synthetic */ String val$localExtension;
                {
                    this.val$localExtension = string;
                }

                @Override
                public void run() {
                    int currentRow;
                    if (editing) {
                        currentRow = rowToEdit;
                        URL url = (URL)model.getValueAt(currentRow, 0);
                        String ext = (String)model.getValueAt(currentRow, 1);
                        SchemaOptionsPanel.this._map.remove(url, ext, true);
                        SchemaRegistryAddin.clearAndReloadOnDemand(ext);
                    } else {
                        model.setRowCount(count + 1);
                        currentRow = count;
                    }
                    model.setValueAt(localURL, currentRow, 0);
                    model.setValueAt(this.val$localExtension, currentRow, 1);
                    if (XMLEditorAddin.getClass(this.val$localExtension) == null && Recognizer.getClassForExtension((String)this.val$localExtension) == null) {
                        Recognizer.mapExtensionToClass((String)this.val$localExtension, XMLSourceNode.class);
                        XMLEditorAddin.register(XMLSourceNode.class, this.val$localExtension);
                    }
                    SchemaOptionsPanel.this._map.put(localURL, this.val$localExtension, true);
                    SchemaOptionsPanel.this._dirty = true;
                }
            };
            Runnable editFileRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        Node node = NodeFactory.findOrCreate((URL)localURL);
                        EditorUtil.openExplicitDefaultEditorInFrame((Node)node);
                    }
                    catch (Exception iae) {
                        String text = SchemaOptionsPanel.getTranslatedString(SchemaOptionsPanel._KEY_EDITERROR);
                        String title = editing ? SchemaOptionsPanel.getTranslatedString(SchemaOptionsPanel._KEY_ERROR_EDITING_TITLE) : SchemaOptionsPanel.getTranslatedString(SchemaOptionsPanel._KEY_ERROR_TITLE);
                        MessageFormat mf = new MessageFormat(text);
                        Object[] args = new Object[]{ProductInformation.getProductInformation().getShortName(), localURL};
                        String message = mf.format(args);
                        JOptionPane.showMessageDialog((Component)((Object)SchemaOptionsPanel.this), message, title, 0);
                    }
                }
            };
            Runnable ioError = new Runnable(){

                @Override
                public void run() {
                    try {
                        String text = SchemaOptionsPanel.getTranslatedString(SchemaOptionsPanel._KEY_IOERROR);
                        String title = editing ? SchemaOptionsPanel.getTranslatedString(SchemaOptionsPanel._KEY_ERROR_EDITING_TITLE) : SchemaOptionsPanel.getTranslatedString(SchemaOptionsPanel._KEY_ERROR_TITLE);
                        MessageFormat mf = new MessageFormat(text);
                        Object[] args = new Object[]{ProductInformation.getProductInformation().getShortName(), localURL};
                        String message = mf.format(args);
                        JOptionPane.showMessageDialog((Component)((Object)SchemaOptionsPanel.this), message, title, 0);
                        SchemaOptionsPanel.this._showAddDialog(model);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            String text = SchemaOptionsPanel.getTranslatedString(_KEY_ERROR_TITLE);
            MessageFormat mf = new MessageFormat(text);
            Object[] errorArgs = new Object[]{ProductInformation.getProductInformation().getShortName()};
            String errorTitle = mf.format(errorArgs);
            text = SchemaOptionsPanel.getTranslatedString(_KEY_EDIT_FILE);
            mf = new MessageFormat(text);
            Object[] messageArgs = new Object[]{ProductInformation.getProductInformation().getShortName()};
            String message = mf.format(messageArgs);
            SchemaLoader.validateSchema((Component)((Object)this), url, success, editFileRunnable, ioError, SchemaOptionsPanel.getTranslatedString(_KEY_IGNORE), message, editing ? SchemaOptionsPanel.getTranslatedString(_KEY_ERROR_EDITING_TITLE) : errorTitle);
        }
    }

    private SchemaOptionsPrefs getSchemaPrefs() {
        return SchemaOptionsPrefs.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    private boolean _getEnabledState() {
        return !SchemaUtils.loadRemoteSchemasSystemPropertySet();
    }

    private void _setColumnPreferredWidths(NiceTable table, TableColumnModelListener listener) {
        int width = this._userPanel.getPreferredSize().width;
        int extensionWidth = SchemaOptionsPanel._getColumnSizeToFit(table, 1);
        int urlWidth = width - extensionWidth;
        TableColumnModel columnModel = table.getColumnModel();
        if (listener != null) {
            columnModel.removeColumnModelListener(listener);
        }
        columnModel.getColumn(1).setPreferredWidth(extensionWidth);
        columnModel.getColumn(0).setPreferredWidth(urlWidth);
        if (listener != null) {
            columnModel.addColumnModelListener(listener);
        }
    }

    private static SchemaOptionsPrefs getSchemaPrefs(TraversableContext tc) {
        return SchemaOptionsPrefs.getInstance(tc.getPropertyStorage());
    }

    private class TableComponentAdapter
    extends ComponentAdapter {
        private TableColumnModelListener _theListener;

        private TableComponentAdapter() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.setColumnWidthsToFit((JScrollPane)e.getComponent());
        }

        public void setTableColumnModelListener(TableColumnModelListener theListener) {
            this._theListener = theListener;
        }

        public void setColumnWidthsToFit(JScrollPane scrollPane) {
            JViewport viewPort = scrollPane.getViewport();
            NiceTable theTable = (NiceTable)viewPort.getView();
            TableColumnModel columnModel = theTable.getColumnModel();
            SchemaOptionsPanel.this._setColumnPreferredWidths(theTable, this._theListener);
        }
    }

    private class AbstractTableColumnModelListener
    implements TableColumnModelListener {
        private AbstractTableColumnModelListener() {
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }
}

