/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.file;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import oracle.ide.Ide;
import oracle.ide.controls.StatusBar;
import oracle.ide.controls.Toolbar;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ideimpl.file.FileSystemMonitor;
import oracle.ideimpl.file.res.FileChangeBundle;
import oracle.javatools.icons.OracleIcons;

public final class FileSystemActivityIndicator
implements ActionListener {
    private static final Icon OFF_ICON = OracleIcons.getIcon((String)"disabledbreakpoint.png");
    private static final Icon ACTIVITY_ICON = FileSystemActivityIndicator.getAccessIcon();
    private static final Icon EVENT_THREAD_ACTIVITY_ICON = OracleIcons.getIcon((String)"unverifiedbreakpoint.png");
    private static final String DEFAULT_TOOLTIP = FileChangeBundle.get("FILE_SYSTEM_ACTIVITY_TOOLTIP");
    private static final String THREAD_ACTIVITY_PATTERN = FileChangeBundle.get("FILE_SYSTEM_ACTIVITY_ON_THREAD");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final AtomicInteger counter = new AtomicInteger();
    private final AtomicLong lastThreadDump = new AtomicLong(-1L);
    private final ConcurrentMap<Thread, FileSystemActivityIndicator> threads = new ConcurrentHashMap<Thread, FileSystemActivityIndicator>();
    private final JButton button;
    private final Timer timer;
    private volatile boolean isEventThreadActivity;
    private String lastThreadName;
    private Icon lastIcon;

    public static void install() {
        FileSystemActivityIndicator.install(Arrays.asList("file", "jar"));
    }

    private static void install(Collection<String> protocols) {
        FileSystemActivityIndicator indicator = new FileSystemActivityIndicator();
        for (String protocol : protocols) {
            URLFileSystemHelper oldHelper = URLFileSystem.findHelper((String)protocol);
            URLFileSystem.registerHelper((String)protocol, (URLFileSystemHelper)new FileSystemMonitor(oldHelper, indicator));
        }
    }

    private static Icon getAccessIcon() {
        URL url = FileSystemMonitor.class.getResource("res/activity.png");
        Image image = Toolkit.getDefaultToolkit().getImage(url);
        if (image != null) {
            return new ImageIcon(image);
        }
        return OracleIcons.getIcon((String)"unverifiedbreakpoint.png");
    }

    private static Logger getLogger() {
        return Logger.getLogger(FileSystemActivityIndicator.class.getName());
    }

    public FileSystemActivityIndicator() {
        if (Ide.getIdeArgs().getCreateUI()) {
            Toolbar toolbar;
            this.button = new JButton();
            this.button.setIcon(OFF_ICON);
            this.button.setFocusable(false);
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileSystemActivityIndicator.this.dumpThreads();
                }
            });
            this.timer = new Timer(200, this);
            this.timer.setRepeats(false);
            StatusBar statusBar = Ide.getStatusBar();
            if (statusBar != null && (toolbar = statusBar.getToolbar()) != null) {
                toolbar.add((Component)this.button);
                this.button.setToolTipText(DEFAULT_TOOLTIP);
                toolbar.add(Box.createRigidArea(new Dimension(7, 0)));
                statusBar.getGUI().validate();
            }
        } else {
            this.button = null;
            this.timer = null;
        }
    }

    void on() {
        boolean isEventThread = EventQueue.isDispatchThread();
        if (isEventThread) {
            this.isEventThreadActivity = true;
        }
        this.threads.put(Thread.currentThread(), this);
        if ((this.counter.incrementAndGet() == 1 || isEventThread) && this.button != null) {
            long elapsed;
            this.update();
            long lastDump = this.lastThreadDump.getAndSet(-1L);
            if (lastDump != -1L && (elapsed = System.nanoTime() - lastDump) < 500000000L) {
                this.dumpThreads();
            }
        }
    }

    void off() {
        this.threads.remove(Thread.currentThread());
        this.counter.decrementAndGet();
        if (EventQueue.isDispatchThread()) {
            this.isEventThreadActivity = false;
        }
        if (this.timer != null) {
            this.timer.restart();
        }
    }

    private void update() {
        final Icon icon = this.isEventThreadActivity ? EVENT_THREAD_ACTIVITY_ICON : (this.counter.get() > 0 ? ACTIVITY_ICON : OFF_ICON);
        Iterator iterator = this.threads.keySet().iterator();
        final String threadName = iterator.hasNext() ? ((Thread)iterator.next()).getName() : null;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (threadName != FileSystemActivityIndicator.this.lastThreadName) {
                    FileSystemActivityIndicator.this.lastThreadName = threadName;
                    String tooltip = threadName == null ? DEFAULT_TOOLTIP : MessageFormat.format(THREAD_ACTIVITY_PATTERN, threadName);
                    FileSystemActivityIndicator.this.button.setToolTipText(tooltip);
                }
                if (icon != FileSystemActivityIndicator.this.lastIcon) {
                    FileSystemActivityIndicator.this.lastIcon = icon;
                    FileSystemActivityIndicator.this.button.setIcon(icon);
                    FileSystemActivityIndicator.this.button.paintImmediately(0, 0, FileSystemActivityIndicator.this.button.getWidth(), FileSystemActivityIndicator.this.button.getHeight());
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private void dumpThreads() {
        StringBuilder builder = new StringBuilder();
        for (Thread thread : this.threads.keySet()) {
            builder.append(MessageFormat.format(THREAD_ACTIVITY_PATTERN, thread.getName()));
            builder.append(LINE_SEPARATOR);
            for (StackTraceElement element : thread.getStackTrace()) {
                builder.append("\tat ");
                builder.append(element);
                builder.append(LINE_SEPARATOR);
            }
        }
        String dump = builder.toString();
        if (!dump.isEmpty()) {
            FileSystemActivityIndicator.getLogger().info(builder.toString());
        } else {
            this.lastThreadDump.set(System.nanoTime());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.update();
    }
}

