/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.file;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;
import oracle.ide.file.FileSet;
import oracle.ide.file.FileSetFilter;
import oracle.ide.file.FileSetFilters;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.util.NullArgumentException;

@NotThreadSafe
public final class Path
extends ArrayList<FileSet> {
    private final Set<FileSet> fileSets;

    public static Path getInstance() {
        return new Path();
    }

    public static Path getInstance(int capacity) {
        return new Path(capacity);
    }

    public static Path getInstance(FileSet ... fileSets) {
        for (FileSet fileSet : fileSets) {
            if (fileSet != null) continue;
            throw new NullArgumentException("null file set");
        }
        return new Path(fileSets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path getInstance(URLPath urlPath) {
        if (urlPath == null) {
            throw new NullArgumentException("null url path");
        }
        Object object = urlPath.iteratorLock();
        synchronized (object) {
            Path path = new Path(urlPath.size());
            for (URL url : urlPath) {
                path.add(FileSet.getInstance(url));
            }
            return path;
        }
    }

    public static Path getInstance(Collection<FileSet> fileSets) {
        if (fileSets == null) {
            throw new NullArgumentException("null fileSets");
        }
        for (FileSet fileSet : fileSets) {
            if (fileSet != null) continue;
            throw new NullArgumentException("null file set");
        }
        return new Path(fileSets);
    }

    public static Path getPath(String propertyName) {
        String property = System.getProperty(propertyName);
        return property == null ? new Path() : Path.toPath(property);
    }

    public static Path getPath(String propertyName, char separator) {
        String property = System.getProperty(propertyName);
        return property == null ? new Path() : Path.toPath(property, separator);
    }

    public static Path toPath(String path) {
        if (path == null) {
            throw new NullArgumentException("null path");
        }
        return Path.toPathImpl(path, File.pathSeparator);
    }

    public static Path toPath(String path, char separator) {
        if (path == null) {
            throw new NullArgumentException("null path");
        }
        return Path.toPathImpl(path, "" + separator);
    }

    private static Path toPathImpl(String path, String separator) {
        Path p = new Path();
        String[] entries = path.split(separator);
        if (entries != null && entries.length > 0) {
            for (String entry : entries) {
                if (entry.trim().isEmpty()) continue;
                File f = new File(entry);
                URL url = JarUtil.isArchive((String)entry) ? URLFactory.newJarURL((File)f, null) : URLFactory.newDirURL((File)f);
                url = URLFileSystem.canonicalize((URL)url);
                p.add(FileSet.getInstance(URLFactory.newJarURL((URL)url, null)));
            }
        }
        return p;
    }

    private Path() {
        this.fileSets = new HashSet<FileSet>();
    }

    private Path(int capacity) {
        super(capacity);
        this.fileSets = new HashSet<FileSet>(capacity);
    }

    private Path(FileSet ... fileSets) {
        super(fileSets.length);
        this.fileSets = new HashSet<FileSet>(fileSets.length);
        for (FileSet fileSet : fileSets) {
            this.add(fileSet);
        }
    }

    private Path(Collection<FileSet> fileSets) {
        super(fileSets.size());
        this.fileSets = new HashSet<FileSet>(fileSets.size());
        for (FileSet fileSet : fileSets) {
            this.add(fileSet);
        }
    }

    public boolean contains(URL url) {
        for (FileSet fileSet : this) {
            if (!fileSet.contains(url)) continue;
            return true;
        }
        return false;
    }

    public String toRelativePath(URL url) {
        for (FileSet fileSet : this) {
            String relativePath = fileSet.getRelativePath(url);
            if (relativePath == null) continue;
            return relativePath;
        }
        return null;
    }

    public URLPath toURLPath() {
        URLPath path = new URLPath();
        for (FileSet fileSet : this) {
            FileSetFilter filter = fileSet.getFilter();
            if (filter != null && filter != FileSetFilters.getAcceptAllFilter()) {
                throw new IllegalStateException("path contains filter");
            }
            path.add(fileSet.getRoot());
        }
        return path;
    }

    @Override
    public boolean add(FileSet fileSet) {
        if (fileSet == null) {
            throw new NullArgumentException("null file set");
        }
        if (this.fileSets.add(fileSet)) {
            return super.add(fileSet);
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            throw new NullArgumentException("null object");
        }
        if (this.fileSets.remove(o)) {
            return super.remove(o);
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            throw new NullArgumentException("null object");
        }
        return this.fileSets.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c == null) {
            throw new NullArgumentException("null collection");
        }
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends FileSet> c) {
        if (c == null) {
            throw new NullArgumentException("null collection");
        }
        boolean changed = false;
        for (FileSet fileSet : c) {
            changed = this.add(fileSet) || changed;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c == null) {
            throw new NullArgumentException("null collection");
        }
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c == null) {
            throw new NullArgumentException("null collection");
        }
        return super.retainAll(c);
    }

    @Override
    public void clear() {
        super.clear();
        this.fileSets.clear();
    }

    @Override
    public void add(int index, FileSet element) {
        if (element == null) {
            throw new NullArgumentException("null file set");
        }
        if (!this.fileSets.add(element)) {
            throw new IllegalArgumentException("attempt to add duplicate file set");
        }
        super.add(index, element);
    }

    @Override
    public FileSet remove(int index) {
        FileSet removed = (FileSet)super.remove(index);
        if (removed != null) {
            this.fileSets.remove(removed);
        }
        return removed;
    }

    @Override
    public boolean addAll(int index, Collection<? extends FileSet> c) {
        if (c == null) {
            throw new NullArgumentException("null collection");
        }
        boolean changed = false;
        for (FileSet fileSet : c) {
            if (fileSet == null) {
                throw new NullArgumentException("null file set");
            }
            this.add(index++, fileSet);
            changed = true;
        }
        return changed;
    }

    @Override
    public FileSet set(int index, FileSet element) {
        int i;
        if (element == null) {
            throw new NullArgumentException("null file set");
        }
        if (!this.fileSets.add(element) && (i = this.indexOf(element)) != -1 && i != index) {
            throw new IllegalArgumentException("attempt to add duplicate file set");
        }
        FileSet old = super.set(index, element);
        if (old != null) {
            this.fileSets.remove(old);
        }
        return old;
    }
}

