/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.file;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Timer;
import net.jcip.annotations.GuardedBy;
import oracle.ide.Ide;
import oracle.ide.IdeActivationEvent;
import oracle.ide.IdeActivationListener;
import oracle.ide.IdeMainWindow;
import oracle.ide.file.ContentSetRoot;
import oracle.ide.file.FileSet;
import oracle.ide.file.FileSetFilters;
import oracle.ide.file.FileSetTable;
import oracle.ide.file.FileTable;
import oracle.ide.file.ProjectCache;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLKey;
import oracle.ide.persistence.Storage;
import oracle.ide.persistence.Storages;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;

final class IdeEventListener
extends NodeListener
implements IdeActivationListener {
    private static final int BUFFER_EVENT_DELAY = 200;
    private static IdeEventListener INSTANCE;
    @GuardedBy(value="itself")
    private static final Map<ProjectListenerKey, ProjectListener> projectListeners;
    @GuardedBy(value="itself")
    private static final Map<Workspace, WorkspaceListener> workspaceListeners;
    private static final Observer reloadProjectListener;
    @GuardedBy(value="itself")
    private static final Map<Workspace, Storage> applicationStorages;
    private final Timer bufferEventTimer;
    private final ConcurrentMap<URLKey, URLKey> bufferEvents = new ConcurrentHashMap<URLKey, URLKey>();

    static void install() {
        IdeEventListener.getInstance(true);
    }

    public static void processBufferEvents() {
        IdeEventListener instance = IdeEventListener.getInstance(false);
        if (instance != null) {
            instance.processBufferEventsImpl();
        }
    }

    private void processBufferEventsImpl() {
        if (this.bufferEvents.isEmpty()) {
            return;
        }
        Iterator iterator = this.bufferEvents.keySet().iterator();
        while (iterator.hasNext()) {
            URL url = ((URLKey)iterator.next()).toURL();
            iterator.remove();
            if (!FileSetFilters.getGlobalFilter().acceptFile(url.getPath())) continue;
            FileTable.invalidateFile(url, true);
        }
    }

    static void processBufferEvents(FileTable table) {
        IdeEventListener instance = IdeEventListener.getInstance(false);
        if (instance != null) {
            instance.processBufferEventsImpl(table);
        }
    }

    private void processBufferEventsImpl(FileTable table) {
        for (URLKey key : this.bufferEvents.keySet()) {
            URL url = key.toURL();
            if (!FileSetFilters.getGlobalFilter().acceptFile(url.getPath()) || !table.contains(url)) continue;
            table.invalidateFileImpl(url, true);
        }
    }

    private void bufferChanged(URL url) {
        URLKey key = URLKey.getInstance((URL)url);
        this.bufferEvents.put(key, key);
        this.bufferEventTimer.restart();
    }

    private static synchronized IdeEventListener getInstance(boolean create) {
        if (INSTANCE == null && create) {
            INSTANCE = new IdeEventListener();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void shutdown() {
        IdeEventListener instance = IdeEventListener.getInstance(false);
        if (instance != null) {
            Iterator iterator = NodeFactory.getOpenNodes();
            while (iterator.hasNext()) {
                instance.nodeWillClose((Node)iterator.next());
            }
        }
        Map<Workspace, Storage> map = applicationStorages;
        synchronized (map) {
            for (Map.Entry<Workspace, Storage> entry : applicationStorages.entrySet()) {
                entry.getValue().unpin();
            }
            applicationStorages.clear();
        }
    }

    private IdeEventListener() {
        IdeMainWindow mainWindow;
        this.bufferEventTimer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IdeEventListener.this.processBufferEventsImpl();
            }
        });
        this.bufferEventTimer.setRepeats(false);
        if (Ide.getIdeArgs().getCreateUI() && (mainWindow = Ide.getMainWindow()) != null) {
            mainWindow.addIdeActivationListener((IdeActivationListener)this);
        }
        Node.addNodeListenerForTypeHierarchy(Node.class, (NodeListener)this);
        class NodeRunnable
        implements Runnable {
            private Node node;

            NodeRunnable() {
            }

            @Override
            public void run() {
                if (this.node.isOpen()) {
                    IdeEventListener.this.nodeOpened(this.node);
                }
            }
        }
        NodeRunnable r = new NodeRunnable();
        Iterator iterator = NodeFactory.getOpenNodes();
        while (iterator.hasNext()) {
            r.node = (Node)iterator.next();
            r.node.runUnderReadLock((Runnable)r);
        }
    }

    public void nodeOpened(NodeEvent e) {
        if (IdeEventListener.isEnabled()) {
            this.nodeOpened(e.getNode());
        }
    }

    public void nodeDeleted(NodeEvent e) {
        URL nodeURL;
        URL parent;
        if (IdeEventListener.isEnabled() && (parent = URLFileSystem.getParent((URL)(nodeURL = e.getNodeURL()))) != null) {
            FileTable.invalidateDirectory(parent, false);
        }
    }

    public void nodeRenamed(NodeEvent e, URL oldURL, URL newURL) {
        if (IdeEventListener.isEnabled()) {
            URL oldParent = URLFileSystem.getParent((URL)oldURL);
            URL newParent = URLFileSystem.getParent((URL)newURL);
            if (oldParent != null) {
                FileTable.invalidateDirectory(oldParent, oldURL, newURL);
            }
            if (newParent != null && !URLFileSystem.equals((URL)oldParent, (URL)newParent)) {
                FileTable.invalidateDirectory(newParent, newURL, oldURL);
            }
        }
    }

    public void nodeReverted(NodeEvent e) {
        if (IdeEventListener.isEnabled()) {
            this.nodeReverted(e.getNode());
        }
    }

    public void nodeWillClose(NodeEvent e) {
        if (IdeEventListener.isEnabled()) {
            this.nodeWillClose(e.getNode());
        }
    }

    public void nodeClosed(NodeEvent e) {
        if (IdeEventListener.isEnabled()) {
            this.nodeClosed(e.getNode());
        }
    }

    public void activated(IdeActivationEvent e) {
        FileTable.invalidateAllJars();
    }

    public void deactivated(IdeActivationEvent e) {
    }

    private void nodeOpened(Node node) {
        if (node instanceof Project) {
            this.projectOpened((Project)node);
        }
        if (node instanceof Workspace) {
            this.workspaceOpened((Workspace)node);
        }
        if (node instanceof TextNode) {
            this.textNodeOpened((TextNode)node);
        }
        IdeEventListener.invalidateNode(node, false);
    }

    private void nodeReverted(Node node) {
        if (node instanceof Project) {
            this.projectReverted((Project)node);
        } else {
            IdeEventListener.invalidateNode(node, false);
        }
    }

    private void nodeWillClose(Node node) {
        if (node.isDirty()) {
            this.nodeReverted(node);
        }
        if (node instanceof Workspace) {
            this.workspaceWillClose((Workspace)node);
        }
    }

    private void nodeClosed(Node node) {
        if (node instanceof Project) {
            this.projectClosed((Project)node);
        }
        if (node instanceof Workspace) {
            this.workspaceClosed((Workspace)node);
        }
    }

    private void textNodeOpened(TextNode node) {
        TextBufferTracker tracker = new TextBufferTracker(node);
        node.addTextBufferListener((TextBufferListener)tracker);
        node.addNodeListener((NodeListener)tracker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void projectOpened(Project project) {
        Workspace workspace = project.getWorkspace();
        if (workspace != null) {
            Storage storage = IdeEventListener.getStorage(workspace, project);
            Map<ProjectListenerKey, ProjectListener> map = projectListeners;
            synchronized (map) {
                ProjectListenerKey key = new ProjectListenerKey(workspace, project);
                ProjectListener projectListener = projectListeners.get(key);
                if (projectListener == null) {
                    projectListener = new ProjectListener(storage, project);
                    projectListeners.put(key, projectListener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void projectClosed(Project project) {
        Map<ProjectListenerKey, ProjectListener> map = projectListeners;
        synchronized (map) {
            Workspace workspace = project.getWorkspace();
            if (workspace != null) {
                ProjectListenerKey key = new ProjectListenerKey(workspace, project);
                ProjectListener projectListener = projectListeners.remove(key);
                if (projectListener != null) {
                    projectListener.dispose();
                }
            } else {
                Iterator<Map.Entry<ProjectListenerKey, ProjectListener>> iterator = projectListeners.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<ProjectListenerKey, ProjectListener> entry = iterator.next();
                    if (entry.getKey().project != project) continue;
                    entry.getValue().dispose();
                    iterator.remove();
                }
            }
        }
    }

    private void projectReverted(Project project) {
        ProjectCache.invalidate(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void workspaceOpened(Workspace workspace) {
        Map<Workspace, Object> map = applicationStorages;
        synchronized (map) {
            Storage storage = Storages.getApplicationStorage((Workspace)workspace);
            storage.pin();
            applicationStorages.put(workspace, storage);
        }
        map = workspaceListeners;
        synchronized (map) {
            WorkspaceListener listener = new WorkspaceListener(workspace);
            workspaceListeners.put(workspace, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void workspaceWillClose(Workspace workspace) {
        Map<ProjectListenerKey, ProjectListener> map = projectListeners;
        synchronized (map) {
            for (Project project : workspace.projects()) {
                ProjectListenerKey key = new ProjectListenerKey(workspace, project);
                ProjectListener projectListener = projectListeners.remove(key);
                if (projectListener == null) continue;
                projectListener.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void workspaceClosed(Workspace workspace) {
        WorkspaceListener listener = workspaceListeners.remove(workspace);
        if (listener != null) {
            listener.detach();
        }
        FileTable.detachFileChangeListeners(workspace);
        Map<Workspace, Storage> map = applicationStorages;
        synchronized (map) {
            Storage storage = applicationStorages.remove(workspace);
            if (storage != null) {
                FileSetTable.uncache(storage);
                storage.unpin();
            }
        }
    }

    private static boolean isEnabled() {
        return !Boolean.getBoolean("jbo.kava");
    }

    private static void invalidateNode(Node node, boolean isBufferChange) {
        URL url = node.getURL();
        if (url != null && FileSetFilters.getGlobalFilter().acceptFile(url.getPath())) {
            FileTable.invalidateFile(url, isBufferChange);
        }
    }

    private static Storage getStorage(Workspace workspace, Project project) {
        return workspace == null ? Storages.getProjectStorage((Project)project) : Storages.getApplicationStorage((Workspace)workspace);
    }

    static {
        projectListeners = new HashMap<ProjectListenerKey, ProjectListener>();
        workspaceListeners = new HashMap<Workspace, WorkspaceListener>();
        reloadProjectListener = new ReloadProjectListener();
        applicationStorages = new HashMap<Workspace, Storage>();
    }

    private class TextBufferTracker
    extends NodeListener
    implements TextBufferListener {
        private URL url;
        private boolean inCompoundEdit;
        private boolean reloading;

        public TextBufferTracker(TextNode node) {
            this.url = node.getURL();
        }

        public void nodeRenamed(NodeEvent e, URL oldURL, URL newURL) {
            this.url = newURL;
        }

        public void nodeClosed(NodeEvent e) {
            ((TextNode)e.getNode()).removeTextBufferListener((TextBufferListener)this);
            e.getNode().removeNodeListener((NodeListener)this);
        }

        public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
            if (!this.reloading && !this.inCompoundEdit) {
                IdeEventListener.this.bufferChanged(this.url);
            }
        }

        public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removedData) {
            if (!this.reloading && !this.inCompoundEdit) {
                IdeEventListener.this.bufferChanged(this.url);
            }
        }

        public void attributeUpdate(TextBuffer buffer, int attribute) {
            switch (attribute) {
                case 3: {
                    this.reloading = true;
                    break;
                }
                case 4: {
                    this.reloading = false;
                    IdeEventListener.this.bufferChanged(this.url);
                    break;
                }
                case 6: {
                    this.inCompoundEdit = true;
                    break;
                }
                case 7: {
                    this.inCompoundEdit = false;
                    IdeEventListener.this.bufferChanged(this.url);
                }
            }
        }
    }

    private static final class ProjectListenerKey {
        private final Workspace workspace;
        private final Project project;

        ProjectListenerKey(Workspace workspace, Project project) {
            this.workspace = workspace;
            this.project = project;
        }

        public int hashCode() {
            int hash = this.project.hashCode();
            return this.workspace == null ? hash : hash * 31 + this.workspace.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProjectListenerKey)) {
                return false;
            }
            ProjectListenerKey other = (ProjectListenerKey)o;
            return (this.workspace == null ? other.workspace == null : this.workspace.equals((Object)other.workspace)) && other.project.equals((Object)this.project);
        }
    }

    private static final class ProjectListener
    implements Observer {
        private final Storage storage;
        private final Project project;
        @GuardedBy(value="this")
        private final Set<ContentSetRoot> activeRoots = new HashSet<ContentSetRoot>();

        public ProjectListener(Storage storage, Project project) {
            this.storage = storage;
            this.project = project;
            project.attach((Observer)this);
            this.updateRoots();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispose() {
            projectListeners.remove(this.project);
            this.project.detach((Observer)this);
            ProjectListener projectListener = this;
            synchronized (projectListener) {
                for (ContentSetRoot root : this.activeRoots) {
                    FileSetTable table = FileSetTable.getInstance(this.storage, root.asFileSet());
                    table.deactivate();
                    ContentSetRoot.removeOpenProjectRoot(root);
                }
                this.activeRoots.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(Object observed, UpdateMessage change) {
            int id = change.getMessageID();
            if (id == UpdateMessage.CHILD_ADDED || id == UpdateMessage.CHILD_REMOVED) {
                List list = id == UpdateMessage.CHILD_ADDED ? change.getAddObjects() : change.getRemoveObjects();
                for (Object o : list) {
                    Node node;
                    URL dir;
                    if (!(o instanceof Node) || (dir = URLFileSystem.getParent((URL)(node = (Node)o).getURL())) == null || !FileSetFilters.getGlobalFilter().acceptDirectory(dir.getPath())) continue;
                    for (ContentSetRoot root : ContentSetRoot.getContentSetRootsContaining(this.project, dir)) {
                        FileSetTable table = FileSetTable.getInstance(this.storage, root.asFileSet());
                        table.invalidateDirectoryImpl(dir, false, node.getURL(), null);
                    }
                }
            } else if (id == UpdateMessage.PROPERTY_SET) {
                if (change.containsProperty("contentProvidersPath")) {
                    Map<ProjectListenerKey, ProjectListener> map = projectListeners;
                    synchronized (map) {
                        this.updateRoots();
                    }
                }
                ProjectCache.invalidate(this.project);
            } else if (id == UpdateMessage.STRUCTURE_CHANGED) {
                if (change.getModifyObjects().isEmpty()) {
                    for (ContentSetRoot root : ContentSetRoot.getContentSetRoots(this.project)) {
                        FileSetTable.getInstance(this.storage, root.asFileSet()).invalidate();
                    }
                }
                Map<ProjectListenerKey, ProjectListener> map = projectListeners;
                synchronized (map) {
                    this.updateRoots();
                }
                ProjectCache.invalidate(this.project);
            }
        }

        private synchronized void updateRoots() {
            Collection<ContentSetRoot> newRoots = ContentSetRoot.getContentSetRoots(this.project);
            ArrayList<ContentSetRoot> oldRoots = new ArrayList<ContentSetRoot>(this.activeRoots);
            for (ContentSetRoot root : newRoots) {
                if (oldRoots.contains(root)) continue;
                FileSet fileSet = root.asFileSet().intern();
                FileSetTable table = FileSetTable.getInstance(this.storage, fileSet);
                table.activate();
                ContentSetRoot interned = ContentSetRoot.getInstance(this.project, fileSet);
                ContentSetRoot.addOpenProjectRoot(interned);
                this.activeRoots.add(interned);
            }
            for (ContentSetRoot root : oldRoots) {
                if (newRoots.contains(root)) continue;
                FileSetTable table = FileSetTable.getInstance(this.storage, root.asFileSet());
                table.deactivate();
                ContentSetRoot.removeOpenProjectRoot(root);
                this.activeRoots.remove(root);
            }
        }
    }

    private static final class WorkspaceListener
    implements Observer {
        private final Workspace workspace;
        private final Set<Project> projects = Collections.synchronizedSet(new HashSet());

        public WorkspaceListener(Workspace workspace) {
            this.workspace = workspace;
            workspace.attach((Observer)this);
            this.attachProjectListeners();
        }

        public void detach() {
            this.workspace.detach((Observer)this);
            this.detachProjectListeners();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void attachProjectListeners() {
            Collection attachTo = this.workspace.projects();
            Set<Project> set = this.projects;
            synchronized (set) {
                for (Project project : attachTo) {
                    if (!this.projects.add(project)) continue;
                    project.attach(reloadProjectListener);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void detachProjectListeners() {
            Set<Project> set = this.projects;
            synchronized (set) {
                for (Project project : this.projects) {
                    project.detach(reloadProjectListener);
                }
                this.projects.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(Object observed, UpdateMessage change) {
            int id = change.getMessageID();
            if (id == UpdateMessage.CHILD_ADDED) {
                for (Object o : change.getAddObjects()) {
                    Project project;
                    if (!(o instanceof Project) || !this.projects.add(project = (Project)o)) continue;
                    project.attach(reloadProjectListener);
                    Workspace workspace = (Workspace)observed;
                    Storage storage = IdeEventListener.getStorage(workspace, project);
                    Map<ProjectListenerKey, ProjectListener> map = projectListeners;
                    synchronized (map) {
                        ProjectListenerKey key = new ProjectListenerKey(workspace, project);
                        ProjectListener projectListener = projectListeners.get(key);
                        if (projectListener == null) {
                            projectListener = new ProjectListener(storage, project);
                            projectListeners.put(key, projectListener);
                        }
                    }
                }
            } else if (id == UpdateMessage.CHILD_REMOVED) {
                for (Object o : change.getRemoveObjects()) {
                    Project project;
                    if (!(o instanceof Project) || !this.projects.remove(project = (Project)o)) continue;
                    project.detach(reloadProjectListener);
                }
            }
            if (id == UpdateMessage.OBJECT_RELOADED) {
                this.detachProjectListeners();
                this.attachProjectListeners();
            }
        }
    }

    private static final class ReloadProjectListener
    implements Observer {
        private ReloadProjectListener() {
        }

        public void update(Object observed, UpdateMessage change) {
            int id = change.getMessageID();
            if (id == UpdateMessage.OBJECT_RELOADED) {
                ProjectCache.invalidate((Project)observed);
            }
        }
    }
}

