/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.validation;

import oracle.dbtools.common.service.model.Property;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.rt.validation.ConstraintValidator;
import oracle.dbtools.rt.validation.ValidEmail;

@Service(properties={@Property(name="oracle.dbtools.rt.validator.supportedConstraint", value="oracle.dbtools.rt.validation.ValidEmail")})
public class EmailValidator
implements ConstraintValidator<ValidEmail, String> {
    private static final char[] VALID_USERID_SYMBOLS = new char[]{'.', '-', '!', '#', '$', '%', '&', '*', '+', '/', '=', '?', '^', '_', '{', '|', '}', '~'};

    @Override
    public void initialize(ValidEmail validEmail) {
    }

    @Override
    public boolean isValid(String value) {
        boolean validUserId;
        if (value == null) {
            return false;
        }
        int length = value.length();
        int at = value.indexOf("@");
        if (at != -1 && at < length - 3 && (validUserId = this.validUserId(value, 0, at - 1))) {
            boolean validDomain = false;
            String[] segments = value.substring(at + 1, length).split("\\.");
            if (segments.length >= 2) {
                for (String segment : segments) {
                    if (this.validDomainSegment(segment)) continue;
                    return false;
                }
                validDomain = true;
            }
            return validDomain;
        }
        return false;
    }

    private boolean validDomainSegment(String domainSegment) {
        if (domainSegment.length() > 0 && Character.isLetter(domainSegment.charAt(0))) {
            for (int i = 1; i < domainSegment.length(); ++i) {
                char c = domainSegment.charAt(i);
                if (Character.isLetterOrDigit(c) || '-' == c) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean validUserId(String value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (Character.isLetterOrDigit(c) || this.isValidUserIdSymbol(c)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidUserIdSymbol(char c) {
        for (char valid : VALID_USERID_SYMBOLS) {
            if (valid != c) continue;
            return true;
        }
        return false;
    }
}

