/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.tenants;

import java.io.Serializable;
import java.security.Principal;
import oracle.dbtools.common.identifiers.NumericIdentifiers;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.home.tenants.NoTenantPrincipal;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;

public abstract class TenantPrincipal
implements Principal,
Serializable {
    private final Number id;
    private final String name;
    private static final long serialVersionUID = -1395141724085420572L;

    protected TenantPrincipal(String name, Number id) {
        this.name = name;
        this.id = NumericIdentifiers.identifier((Number)id);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TenantPrincipal)) {
            return false;
        }
        TenantPrincipal other = (TenantPrincipal)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equalsIgnoreCase(other.name));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public abstract String string(TenantIdentifier var1);

    public boolean canAccessSchema(String schemaName) {
        if (schemaName == null) {
            return true;
        }
        return this.name.equalsIgnoreCase(schemaName);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TenantPrincipal [name=");
        builder.append(this.name);
        builder.append("]");
        return builder.toString();
    }

    public abstract TenantIdentifier valueOf(String var1);

    protected Number id() {
        return this.id;
    }

    boolean hasTenant() {
        return NoTenantPrincipal.hasTenant(this);
    }

    public static boolean hasTenant(TenantPrincipal tenant) {
        if (tenant == null) {
            return false;
        }
        return tenant.hasTenant();
    }

    public static Number id(TenantPrincipal tenant) {
        if (tenant == null) {
            return NoTenantPrincipal.instance().id();
        }
        return tenant.id;
    }

    public static TenantPrincipal noTenant() {
        return NoTenantPrincipal.instance();
    }

    public static TenantPrincipal tenant(Principal principal) {
        TenantPrincipal tenant = null;
        if (principal instanceof TenantPrincipal) {
            tenant = (TenantPrincipal)principal;
        } else if (principal instanceof CompoundPrincipal) {
            tenant = (TenantPrincipal)((CompoundPrincipal)principal).principal(TenantPrincipal.class);
        }
        return tenant;
    }
}

