/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.cache.sync;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

final class NamedThreadFactory
implements ThreadFactory {
    private final String namePrefix;
    private final ThreadFactory target;

    NamedThreadFactory(String namePrefix) {
        this.namePrefix = namePrefix;
        this.target = Executors.defaultThreadFactory();
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = this.target.newThread(r);
        String existing = thread.getName();
        String modified = this.namePrefix + "-" + existing;
        thread.setName(modified);
        thread.setDaemon(true);
        return thread;
    }
}

