/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.security.Principal;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.rt.resource.templates.cache.MetadataCache;
import oracle.dbtools.rt.resource.templates.cache.MetadataCacheIdentifier;
import oracle.dbtools.rt.resource.templates.cache.MetadataCacheLoader;
import oracle.dbtools.rt.resource.templates.cache.MetadataCaches;
import oracle.dbtools.rt.resource.templates.cache.sync.MetadataCacheSynchronization;
import oracle.dbtools.rt.tenants.TenantPrincipal;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

@Service
public class MetadataCachesProvider
implements MetadataCaches {
    private volatile LoadingCache<MetadataCacheIdentifier, MetadataCache> metadataCaches;
    private static final Log LOG = Log.get(MetadataCachesProvider.class);

    @Override
    public MetadataCache get(CompoundPrincipal principal) {
        TenantPrincipal tenant = TenantPrincipal.tenant((Principal)principal);
        if (TenantPrincipal.hasTenant(tenant)) {
            try {
                MetadataCacheIdentifier key = new MetadataCacheIdentifier(principal);
                MetadataCache cache = (MetadataCache)this.metadataCaches.get((Object)key);
                MetadataCacheSynchronization sync = (MetadataCacheSynchronization)ServiceLocator.acquire(MetadataCacheSynchronization.class);
                if (sync != null) {
                    sync.track(principal, cache.created());
                }
                return cache;
            }
            catch (ExecutionException e) {
                throw WebException.internalError(e, new Reason[0]);
            }
        }
        return null;
    }

    @Override
    public MetadataCache getIfPresent(CompoundPrincipal requestPrincipal) {
        MetadataCacheIdentifier key = new MetadataCacheIdentifier(requestPrincipal);
        return (MetadataCache)this.metadataCaches.getIfPresent((Object)key);
    }

    @Override
    public void invalidateCache(CompoundPrincipal principal) {
        LOG.severe("invalidating: " + principal);
    }

    protected void activate(ServiceProperties properties) throws Exception {
        LOG.info("Enabling metadata cache");
        this.metadataCaches = CacheBuilder.newBuilder().build((CacheLoader)new MetadataCacheLoader());
    }

    protected void deactivate(ServiceProperties properties) throws Exception {
        this.metadataCaches.invalidateAll();
        this.metadataCaches.cleanUp();
    }
}

