/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import oracle.dbtools.auth.AuthenticationResult;
import oracle.dbtools.auth.AuthenticatorBase;
import oracle.dbtools.auth.domain.IdentityDomain;
import oracle.dbtools.auth.domain.IdentityDomainCallback;
import oracle.dbtools.auth.principal.PartyType;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.rt.authentication.Authenticates;
import oracle.dbtools.rt.authentication.AuthenticationRealm;
import oracle.dbtools.rt.authentication.RealmAuthenticator;
import oracle.dbtools.rt.oauth.CompoundPrincipalCallback;
import oracle.dbtools.rt.oauth.OAuthException;
import oracle.dbtools.rt.oauth.client.Clients;

@Service
@Authenticates(value=AuthenticationRealm.OAUTH_CLIENT)
public class OAuthClientAuthenticator
extends AuthenticatorBase
implements RealmAuthenticator {
    private static final Log LOG = Log.get(OAuthClientAuthenticator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationResult authenticate(CallbackHandler callbackHandler) {
        Clients clients;
        NameCallback n = new NameCallback("username");
        PasswordCallback p = new PasswordCallback("password", false);
        CompoundPrincipalCallback cp = new CompoundPrincipalCallback();
        IdentityDomainCallback i = new IdentityDomainCallback();
        Callback[] callbacks = new Callback[]{n, p, cp, i};
        try {
            callbackHandler.handle(callbacks);
        }
        catch (IOException e) {
            throw this.wrap(e);
        }
        catch (UnsupportedCallbackException e) {
            throw this.wrap(e);
        }
        String name = n.getName();
        CompoundPrincipal requestPrincipal = cp.getPrincipal();
        char[] pwd = p.getPassword();
        IdentityDomain identityDomain = i.getIdentityDomain();
        boolean verified = false;
        if (name != null && requestPrincipal != null && pwd != null && (clients = (Clients)ServiceLocator.acquire(Clients.class)) != null) {
            Transaction txn = null;
            try {
                txn = clients.newTransaction(requestPrincipal);
                verified = clients.verify(txn, requestPrincipal, name, pwd);
            }
            catch (Throwable t) {
                LOG.finest(t);
            }
            finally {
                Closeables.close((Object)txn);
            }
        }
        if (verified) {
            return AuthenticationResult.valid((String)name).partyType(PartyType.CLIENT_APPLICATION).identityDomain(identityDomain).build();
        }
        throw OAuthException.error(OAuthException.Error.INVALID_CLIENT);
    }
}

