/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth;

import oracle.dbtools.rt.oauth.AccessTokenStatus;

public class BearerTokenVerification {
    private final AccessTokenStatus status;
    private final String user;
    private static final BearerTokenVerification UNKNOWN = new BearerTokenVerification(null, AccessTokenStatus.UNKNOWN);

    private BearerTokenVerification(String user, AccessTokenStatus status) {
        this.user = user;
        this.status = status;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BearerTokenVerification other = (BearerTokenVerification)obj;
        if (this.status != other.status) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean isUnknown() {
        return this.status == AccessTokenStatus.UNKNOWN;
    }

    public AccessTokenStatus status() {
        return this.status;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BearerTokenVerification [status=");
        builder.append((Object)this.status);
        builder.append(", user=");
        builder.append(this.user);
        builder.append("]");
        return builder.toString();
    }

    public String user() {
        return this.user;
    }

    public static BearerTokenVerification unknown() {
        return UNKNOWN;
    }

    public static BearerTokenVerification verification(String user, AccessTokenStatus status) {
        if (status == AccessTokenStatus.UNKNOWN) {
            return BearerTokenVerification.unknown();
        }
        return new BearerTokenVerification(user, status);
    }
}

