/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.jdbc.entity;

import java.util.Iterator;
import oracle.dbtools.common.identifiers.NumericIdentifiers;
import oracle.dbtools.common.stmt.ParameterAccess;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.rt.home.tenants.TenantEntityAccess;
import oracle.dbtools.rt.jdbc.JDBCKey;
import oracle.dbtools.rt.jdbc.entity.JDBCEntityMetaData;

public class JDBCEntityStatementBuilder {
    private final StatementBuilder stmt;
    private static Transform<String, String> AS_BIND = new Transform<String, String>(){

        public String apply(String x) {
            StringBuilder b = new StringBuilder(x.length() + 1);
            b.append(':');
            if ("security_group_id".equals(x)) {
                x = "tenant_id";
            }
            b.append(x);
            return b.toString();
        }
    };
    private static final Transform<JDBCEntityMetaData.Table, String> LABELLED_TABLE = new Transform<JDBCEntityMetaData.Table, String>(){

        public String apply(JDBCEntityMetaData.Table x) {
            StringBuilder b = new StringBuilder(x.name());
            b.append(' ');
            b.append(x.label());
            return b.toString();
        }
    };

    private JDBCEntityStatementBuilder(StatementBuilder stmt) {
        this.stmt = stmt;
    }

    public Statement build() {
        return this.stmt.build();
    }

    public JDBCEntityStatementBuilder defaultOrdering(JDBCEntityMetaData.Table t) {
        if (t.naturalKey() == null) {
            return this.orderByIdDesc(t);
        }
        return this.orderByNaturalKey(t);
    }

    public Statement delete(JDBCEntityMetaData.Table t) {
        this.delete().from(t).whereIdEquals(t);
        return this.build();
    }

    public Statement entities(JDBCEntityMetaData.Table t) {
        this.selectFrom(t);
        this.where(t, new Condition[0]);
        this.defaultOrdering(t);
        return this.build();
    }

    public Statement entity(JDBCEntityMetaData.Table t) {
        this.selectFrom(t).whereIdEquals(t);
        return this.build();
    }

    public JDBCEntityStatementBuilder from(JDBCEntityMetaData.Table ... tables) {
        this.stmt.append((CharSequence)" from ");
        this.stmt.append((CharSequence)Iterables.join((Iterable)Iterables.transform((Iterable)Iterables.iterable((Object[])tables), LABELLED_TABLE), (String)", "));
        return this;
    }

    public Statement insert(JDBCEntityMetaData.Table t) {
        Iterable<String> all = JDBCEntityMetaData.allInsertColumns(t.columnNames());
        this.stmt.append((CharSequence)"insert into ");
        this.stmt.append((CharSequence)t.name());
        this.stmt.append((CharSequence)" (");
        this.stmt.append((CharSequence)Iterables.join(all, (String)", "));
        this.stmt.append((CharSequence)") values (");
        this.stmt.append((CharSequence)Iterables.join((Iterable)Iterables.transform(all, AS_BIND), (String)", "));
        this.stmt.append((CharSequence)")");
        for (String name : all) {
            JDBCEntityMetaData.Column column = t.column(name);
            if ("security_group_id".equals(name)) {
                name = "tenant_id";
            }
            this.stmt.parameter(name, column.type(), ParameterAccess.IN);
        }
        return this.build();
    }

    public JDBCEntityStatementBuilder orderBy(JDBCEntityMetaData.Table t, String ... columns) {
        this.stmt.append((CharSequence)" order by ");
        for (int i = 0; i < columns.length; ++i) {
            String column = columns[i];
            boolean descending = false;
            if (column.endsWith("<")) {
                column = column.substring(0, column.length() - 1);
                descending = true;
            }
            this.stmt.append((CharSequence)t.label());
            this.stmt.append((CharSequence)".");
            this.stmt.append((CharSequence)column);
            if (descending) {
                this.stmt.append((CharSequence)" desc");
            }
            if (i >= columns.length - 1) continue;
            this.stmt.append((CharSequence)", ");
        }
        return this;
    }

    public JDBCEntityStatementBuilder orderByIdDesc(JDBCEntityMetaData.Table t) {
        return this.orderBy(t, "id<");
    }

    public JDBCEntityStatementBuilder orderByNaturalKey(JDBCEntityMetaData.Table t) {
        return this.orderBy(t, t.naturalKey().column());
    }

    public JDBCEntityStatementBuilder project(JDBCEntityMetaData.TableProjection ... projections) {
        for (int i = 0; i < projections.length; ++i) {
            this.project(this.stmt, projections[i]);
            if (i >= projections.length - 1) continue;
            this.stmt.append((CharSequence)", ");
        }
        return this;
    }

    public JDBCEntityStatementBuilder select() {
        this.stmt.append((CharSequence)"select ");
        return this;
    }

    public JDBCEntityStatementBuilder selectFrom(JDBCEntityMetaData.Table t) {
        return this.select().project(t.all()).from(t);
    }

    public String toString() {
        return this.stmt.toString();
    }

    public Statement update(JDBCEntityMetaData.Table t) {
        Iterable<String> all = JDBCEntityMetaData.allUpdateColumns(t.columnNames());
        LabelledUpdateColumn labelledColumn = new LabelledUpdateColumn(t.label());
        this.stmt.append((CharSequence)"update ");
        this.stmt.append((CharSequence)LABELLED_TABLE.apply((Object)t));
        this.stmt.append((CharSequence)" set ");
        this.stmt.append((CharSequence)Iterables.join((Iterable)Iterables.transform(all, (Transform)labelledColumn), (String)", "));
        this.whereIdEquals(t);
        for (String name : all) {
            JDBCEntityMetaData.Column column = t.column(name);
            this.stmt.parameter(name, column.type(), ParameterAccess.IN);
        }
        return this.build();
    }

    public JDBCEntityStatementBuilder where(JDBCEntityMetaData.Table t, TenantEntityAccess access, Condition ... conditions) {
        this.stmt.append((CharSequence)" where ");
        boolean isRead = Statement.Type.QUERY == this.stmt.type();
        Condition whereClause = JDBCEntityStatementBuilder.tenantEquals(t);
        if (TenantEntityAccess.CREATOR == access) {
            whereClause = JDBCEntityStatementBuilder.tenantAndCreator(t);
        } else if (isRead && TenantEntityAccess.READ_INTERNAL == access) {
            whereClause = JDBCEntityStatementBuilder.tenantOrInternalEquals(t);
        }
        whereClause.visit(this.stmt);
        if (conditions.length > 0) {
            Operator.AND.visit(this.stmt);
        }
        if (conditions.length > 1) {
            this.stmt.append((CharSequence)"(");
        }
        for (int i = 0; i < conditions.length; ++i) {
            Condition condition = conditions[i];
            condition.visit(this.stmt);
            if (i >= conditions.length - 1) continue;
            this.stmt.append((CharSequence)" and ");
        }
        if (conditions.length > 1) {
            this.stmt.append((CharSequence)")");
        }
        return this;
    }

    public JDBCEntityStatementBuilder where(JDBCEntityMetaData.Table t, Condition ... conditions) {
        return this.where(t, t.access(), conditions);
    }

    public JDBCEntityStatementBuilder whereIdEquals(JDBCEntityMetaData.Table t) {
        this.where(t, JDBCEntityStatementBuilder.eq(JDBCEntityStatementBuilder.column(t, "id"), JDBCEntityStatementBuilder.parameter("id", JDBCKey.class, ParameterAccess.IN)));
        return this;
    }

    public JDBCEntityStatementBuilder delete() {
        this.stmt.append((CharSequence)"delete");
        return this;
    }

    private void project(StatementBuilder stmt, JDBCEntityMetaData.TableProjection projection) {
        String label = projection.label();
        stmt.append((CharSequence)Iterables.join((Iterable)Iterables.transform(projection.columns(), (Transform)new LabelColumn(label)), (String)", "));
    }

    public static Condition and(Condition ... conditions) {
        return new AndCondition(conditions);
    }

    public static JDBCEntityStatementBuilder call() {
        return new JDBCEntityStatementBuilder(StatementBuilder.call());
    }

    public static ColumnExpression column(JDBCEntityMetaData.Table t, String column) {
        return new ColumnExpression(t, column);
    }

    public static Condition eq(Expression left, Expression right) {
        return new BinaryCondition(Operator.EQ, left, right);
    }

    public static Condition in(Expression left, Expression ... expressions) {
        return new BinaryCondition(Operator.IN, left, new Expressions(expressions));
    }

    public static ParameterExpression parameter(String name, Class<?> type, ParameterAccess access) {
        return new ParameterExpression(name, type, access);
    }

    public static JDBCEntityStatementBuilder query() {
        return new JDBCEntityStatementBuilder(StatementBuilder.query());
    }

    public static Condition tenantOrInternalEquals(JDBCEntityMetaData.Table t) {
        return JDBCEntityStatementBuilder.in(JDBCEntityStatementBuilder.column(t, "security_group_id"), JDBCEntityStatementBuilder.literal(JDBCEntityMetaData.internalTenantId()), JDBCEntityStatementBuilder.parameter("tenant_id", NumericIdentifiers.NUMERIC_IDENTIFIER_TYPE, ParameterAccess.IN));
    }

    private static Condition creatorEquals(JDBCEntityMetaData.Table t) {
        return JDBCEntityStatementBuilder.eq(JDBCEntityStatementBuilder.column(t, "created_by"), JDBCEntityStatementBuilder.parameter("created_by", String.class, ParameterAccess.IN));
    }

    private static LiteralExpression literal(Object value) {
        return new LiteralExpression(value);
    }

    private static Condition tenantAndCreator(JDBCEntityMetaData.Table t) {
        return JDBCEntityStatementBuilder.and(JDBCEntityStatementBuilder.tenantEquals(t), JDBCEntityStatementBuilder.creatorEquals(t));
    }

    private static Condition tenantEquals(JDBCEntityMetaData.Table t) {
        return JDBCEntityStatementBuilder.eq(JDBCEntityStatementBuilder.column(t, "security_group_id"), JDBCEntityStatementBuilder.parameter("tenant_id", NumericIdentifiers.NUMERIC_IDENTIFIER_TYPE, ParameterAccess.IN));
    }

    private static interface StatementVisitor {
        public void visit(StatementBuilder var1);
    }

    private static final class LabelledUpdateColumn
    implements Transform<String, String> {
        private final String label;

        private LabelledUpdateColumn(String label) {
            this.label = label;
        }

        public String apply(String x) {
            StringBuilder b = new StringBuilder();
            b.append(this.label);
            b.append('.');
            b.append(x);
            b.append(" = :");
            b.append(x);
            return b.toString();
        }
    }

    private static final class LabelColumn
    implements Transform<String, String> {
        private final String label;

        private LabelColumn(String label) {
            this.label = label;
        }

        public String apply(String x) {
            StringBuilder b = new StringBuilder();
            b.append(this.label);
            b.append('.');
            b.append(x);
            return b.toString();
        }
    }

    protected static class LogicalCondition
    implements Condition {
        private final Iterable<Condition> conditions;
        private final Operator operator;

        protected LogicalCondition(Operator operator, Condition ... conditions) {
            this.conditions = Iterables.iterable((Object[])conditions);
            this.operator = operator;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            Iterator<Condition> values = this.conditions.iterator();
            while (values.hasNext()) {
                Condition value = values.next();
                builder.append(value);
                if (!values.hasNext()) continue;
                builder.append(this.operator.text);
            }
            return builder.toString();
        }

        @Override
        public void visit(StatementBuilder stmt) {
            Iterator<Condition> values = this.conditions.iterator();
            while (values.hasNext()) {
                Condition value = values.next();
                value.visit(stmt);
                if (!values.hasNext()) continue;
                this.operator.visit(stmt);
            }
        }
    }

    public static class ParameterExpression
    implements Expression {
        private final ParameterAccess access;
        private final String name;
        private final Class<?> type;

        private ParameterExpression(String name, Class<?> type, ParameterAccess access) {
            this.name = name;
            this.type = type;
            this.access = access;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(":");
            builder.append(this.name);
            return builder.toString();
        }

        @Override
        public void visit(StatementBuilder stmt) {
            stmt.parameter(this.name, this.type, this.access);
            stmt.append((CharSequence)":");
            stmt.append((CharSequence)this.name);
        }
    }

    public static enum Operator implements StatementVisitor
    {
        AND(" and "),
        EQ(" = "),
        IN(" in ");

        private final String text;

        private Operator(String text) {
            this.text = text;
        }

        @Override
        public void visit(StatementBuilder stmt) {
            stmt.append((CharSequence)this.text);
        }
    }

    public static class LiteralExpression
    implements Expression {
        private final Object value;

        private LiteralExpression(Object value) {
            this.value = value;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.value == null) {
                builder.append("null");
            }
            boolean isText = this.value instanceof CharSequence;
            String text = this.value.toString();
            if (isText) {
                builder.append("'");
            }
            builder.append(text);
            if (isText) {
                builder.append("'");
            }
            return builder.toString();
        }

        @Override
        public void visit(StatementBuilder stmt) {
            if (this.value == null) {
                stmt.append((CharSequence)"null");
            }
            boolean isText = this.value instanceof CharSequence;
            String text = this.value.toString();
            if (isText) {
                stmt.append((CharSequence)"'");
            }
            stmt.append((CharSequence)text);
            if (isText) {
                stmt.append((CharSequence)"'");
            }
        }
    }

    public static class Expressions
    implements Expression {
        private final Iterable<Expression> values;

        private Expressions(Expression ... values) {
            this.values = Iterables.iterable((Object[])values);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("(");
            Iterator<Expression> values = this.values.iterator();
            while (values.hasNext()) {
                Expression value = values.next();
                builder.append(value);
                if (!values.hasNext()) continue;
                builder.append(",");
            }
            builder.append(")");
            return builder.toString();
        }

        @Override
        public void visit(StatementBuilder stmt) {
            stmt.append((CharSequence)"(");
            Iterator<Expression> values = this.values.iterator();
            while (values.hasNext()) {
                Expression value = values.next();
                value.visit(stmt);
                if (!values.hasNext()) continue;
                stmt.append((CharSequence)",");
            }
            stmt.append((CharSequence)")");
        }
    }

    public static interface Expression
    extends StatementVisitor {
    }

    public static interface Condition
    extends StatementVisitor {
    }

    public static class ColumnExpression
    implements Expression {
        private final String column;
        private final JDBCEntityMetaData.Table table;

        private ColumnExpression(JDBCEntityMetaData.Table t, String column) {
            this.table = t;
            this.column = column;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.table.label());
            builder.append(".");
            builder.append(this.column);
            return builder.toString();
        }

        @Override
        public void visit(StatementBuilder stmt) {
            stmt.append((CharSequence)this.table.label());
            stmt.append((CharSequence)".");
            stmt.append((CharSequence)this.column);
        }
    }

    public static class BinaryCondition
    implements Condition {
        private final Expression left;
        private final Operator operator;
        private final Expression right;

        BinaryCondition(Operator operator, Expression left, Expression right) {
            this.operator = operator;
            this.left = left;
            this.right = right;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.left);
            builder.append(this.operator.text);
            builder.append(this.right);
            return builder.toString();
        }

        @Override
        public void visit(StatementBuilder stmt) {
            this.left.visit(stmt);
            this.operator.visit(stmt);
            this.right.visit(stmt);
        }

        Expression left() {
            return this.left;
        }

        Operator operator() {
            return this.operator;
        }

        Expression right() {
            return this.right;
        }
    }

    public static class AndCondition
    extends LogicalCondition {
        public AndCondition(Condition ... conditions) {
            super(Operator.AND, conditions);
        }
    }
}

