/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.filtering;

import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.QueryString;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.filtering.Filtering;
import oracle.dbtools.rt.web.ReTargetingDispatcher;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.ResourceDispatcher;

@Service(provides={ResourceDispatcher.class})
public class FilterDispatcher
extends ReTargetingDispatcher<FilterTarget> {
    @Override
    protected FilterTarget target(RequestEntity request) {
        Pair<QueryString, String> filter;
        if (Requests.isRead(request) && (filter = FilterDispatcher.extractFilter(request.path())) != null) {
            String newPath = ((QueryString)filter.first()).toString();
            if (!request.path().equals(newPath)) {
                return new FilterTarget(newPath, (String)filter.second());
            }
        }
        return null;
    }

    @Override
    protected EntityHeaders modifyRequestHeaders(FilterTarget target, RequestEntity request) {
        return Entities.headers("X-APEX-QUERY_FILTER", target.queryFilter);
    }

    static Pair<QueryString, String> extractFilter(String path) {
        QueryString existing;
        QueryString withoutFilter = existing = QueryString.parse((String)path);
        String filter = (String)existing.get((Object)Filtering.filterParameter());
        if (filter != null) {
            withoutFilter = existing.remove(Filtering.filterParameter(), filter);
        }
        return Pair.pair((Object)withoutFilter, (Object)filter);
    }

    class FilterTarget
    extends ReTargetingDispatcher.Target {
        private final String queryFilter;

        FilterTarget(String target, String queryFilter) {
            super(target);
            this.queryFilter = queryFilter;
        }
    }
}

