/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication.apex;

import java.security.Principal;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import oracle.dbtools.auth.AuthenticationResult;
import oracle.dbtools.auth.HeaderCallback;
import oracle.dbtools.auth.SessionAuthenticatorBase;
import oracle.dbtools.auth.domain.IdentityDomain;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.rt.authentication.Principals;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.oauth.CompoundPrincipalCallback;
import oracle.dbtools.rt.oauth.ScopeAuthorizationPolicies;

public abstract class SessionVerifierBase
extends SessionAuthenticatorBase {
    protected SessionVerifierBase() {
    }

    protected AuthenticationResult authorize(CallbackHandler callbackHandler, IdentityDomain identityDomain, String user, String ... roles) {
        Iterable authenticatedUser;
        if (roles == null) {
            roles = new String[]{};
        }
        if (this.authorize(callbackHandler, authenticatedUser = Iterables.iterable((Object[])Principals.principals(user, roles)))) {
            return AuthenticationResult.valid((String)user).identityDomain(identityDomain).add(roles).build();
        }
        return AuthenticationResult.invalid();
    }

    protected boolean authorize(CallbackHandler callbackHandler, Iterable<Principal> authenticatedUser) {
        CompoundPrincipalCallback cp = new CompoundPrincipalCallback();
        HeaderCallback p = new HeaderCallback((CharSequence)"X-APEX-PATH");
        this.callback(callbackHandler, new Callback[]{p, cp});
        CompoundPrincipal principal = cp.getPrincipal();
        String path = p.getValue();
        TenantIdentifier scopeId = ScopeAuthorizationPolicies.scope(callbackHandler);
        if (scopeId == null) {
            return true;
        }
        CompoundPrincipal authenticated = principal.identifiedAs(authenticatedUser);
        boolean authorized = ScopeAuthorizationPolicies.authorizeScope(authenticated, scopeId);
        return authorized;
    }
}

