/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import oracle.dbtools.auth.AuthenticationResult;
import oracle.dbtools.auth.HttpServletRequestCallback;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.http.servlet.UriRequest;
import oracle.dbtools.rt.authentication.Authenticates;
import oracle.dbtools.rt.authentication.AuthenticationRealm;
import oracle.dbtools.rt.authentication.RealmAuthenticator;
import oracle.dbtools.rt.authentication.SessionVerifierBase;

@Service
@Authenticates(value=AuthenticationRealm.RESOURCE_TEMPLATES)
public class ResourceTemplatesCookieAuthenticator
extends SessionVerifierBase
implements RealmAuthenticator {
    @Override
    public AuthenticationResult verify(CallbackHandler callbackHandler) {
        HttpServletRequestCallback request = new HttpServletRequestCallback();
        Callback[] callbacks = new Callback[]{request};
        try {
            callbackHandler.handle(callbacks);
            HttpServletRequest req = request.getRequest();
            if (req != null && this.checkOrigin(req)) {
                return super.verify(callbackHandler);
            }
            return AuthenticationResult.unknown();
        }
        catch (IOException e) {
            throw this.wrap(e);
        }
        catch (UnsupportedCallbackException e) {
            throw this.wrap(e);
        }
    }

    private String requestOrigin(HttpServletRequest req) {
        String requestOrigin = UriRequest.uriRequest((HttpServletRequest)req).getOrigin();
        return requestOrigin;
    }

    private boolean checkOrigin(HttpServletRequest req) {
        String origin = req.getHeader("Origin");
        String requestOrigin = this.requestOrigin(req);
        return origin == null || requestOrigin.equals(origin);
    }
}

