/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.client;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Set;
import java.util.TreeSet;
import oracle.spatial.rdf.client.CompiledSPARQL;
import oracle.spatial.rdf.client.RDFModelMetadata;
import oracle.spatial.rdf.client.SPARQLFeatureConfig;
import oracle.spatial.rdf.server.LogUtils;
import oracle.spatial.rdf.server.OraBindValueInfo;
import oracle.spatial.rdf.server.OracleDatabaseVersion;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.RDFLogger;
import oracle.spatial.rdf.server.SPARQLEngine;
import oracle.spatial.rdf.server.SPMComponents;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.TranslateEngine;
import oracle.spatial.rdf.server.URIset;
import oracle.spatial.rdf.server.UpdateEngine;
import oracle.spatial.rdf.server.parser.sparql.ParseException;

public final class SPARQLClientUtils {
    private static final String NULL_MODEL_MSG = "Model names parameter is null.";
    private static final String NULL_SPARQL_MSG = "SPARQL string is null or empty.";
    private static final String MODEL_NOT_EXIST_MSG = "Unable to retrieve model.";
    private static final String ENTAILMENT_NOT_EXIST_MSG = "We do not have a rules index with the specified status for this Model-Rulebase combination.";
    private static final String CLASS_LOG_PFX = "oracle.spatial.rdf.client.SPARQLClientUtils: ";
    private static final String DEFAULT_RULES_INDEX_STATUS = "INVALID";
    private static final String UNABLE_TO_READ_ERR = "Unable to read column %s from table %s.%s";
    private static final String REPLACE_SQL_RES_WORDS_FLAG = "REPLACE_SQL_RES_WORDS=T";
    private static final String INS_BATCH_SIZE = "INS_BATCH_SIZE";
    private static final int VALUE_CHUNK_SIZE = 10;

    public static RDFModelMetadata populateRDFModelMetadata(Connection connection, String string, String string2, String string3) throws SQLException, RDFException {
        return SPARQLClientUtils.populateRDFModelMetadata(connection, string, string2, string3, null);
    }

    public static RDFModelMetadata populateRDFModelMetadata(Connection connection, String string, String string2, String string3, RDFLogger rDFLogger) throws SQLException, RDFException {
        Objects.requireNonNull(string, NULL_MODEL_MSG);
        String[] stringArray = new String[]{string};
        String[] stringArray2 = new String[]{};
        String string4 = null;
        return SPARQLClientUtils.populateRDFModelMetadata(connection, stringArray, stringArray2, string4, string2, string3, rDFLogger);
    }

    public static RDFModelMetadata populateRDFModelMetadata(Connection connection, String[] stringArray, String[] stringArray2, String string, String string2, String string3, RDFLogger rDFLogger) throws SQLException, RDFException {
        int n;
        Objects.requireNonNull(stringArray, NULL_MODEL_MSG);
        if (stringArray.length == 0) {
            throw new RDFException(NULL_MODEL_MSG);
        }
        String string4 = SPARQLClientUtils.getCurrentSchema(connection, rDFLogger);
        String string5 = SPARQLClientUtils.getCurrentUser(connection, rDFLogger);
        int n2 = stringArray.length;
        int n3 = stringArray2 == null ? 0 : stringArray2.length;
        String[] stringArray3 = new String[n2];
        String[] stringArray4 = new String[n3];
        String string6 = QueryUtils.validateStatus((String)string);
        for (n = 0; n < n2; ++n) {
            stringArray3[n] = QueryUtils.validateRDFObjName((String)stringArray[n]);
        }
        for (n = 0; n < n3; ++n) {
            stringArray4[n] = QueryUtils.validateRDFObjName((String)stringArray2[n]);
        }
        String string7 = QueryUtils.getNetworkOwnerOrMdsys((String)string2);
        String string8 = QueryUtils.getNetworkNameOrEmptyString((String)string3);
        String string9 = QueryUtils.getNetworkNamePfx((String)string8);
        String string10 = QueryUtils.validateAndGetPfxForRdfObjName((String)string2, (String)string3);
        long[] lArray = new long[n2];
        String[] stringArray5 = new String[n2];
        String[] stringArray6 = new String[n2];
        String[] stringArray7 = new String[n2];
        String[] stringArray8 = new String[n2];
        String[] stringArray9 = new String[1];
        String[] stringArray10 = new String[1];
        boolean[] blArray = new boolean[1];
        SPARQLClientUtils.getModelInfo(connection, stringArray3, string6, lArray, stringArray5, stringArray6, stringArray7, stringArray8, stringArray9, stringArray10, blArray, string7, string8, rDFLogger);
        String[] stringArray11 = new String[n2 - 1];
        long[] lArray2 = new long[n2 - 1];
        for (int i = 1; i < n2; ++i) {
            stringArray11[i - 1] = stringArray3[i];
            lArray2[i - 1] = lArray[i];
        }
        String string11 = null;
        if (stringArray4.length > 0) {
            string11 = SPARQLClientUtils.getEntailmentInfo(connection, stringArray3, stringArray4, string6, string7, string8, rDFLogger);
        }
        boolean bl = QueryUtils.matViewsPresentForModel((Connection)connection, (String)stringArray10[0], (String[])new String[]{stringArray3[0]}, (String)string7, (String)string8);
        String string12 = QueryUtils.getNetworkStorageForm((Connection)connection, (String)string10);
        String string13 = SPARQLClientUtils.getNetTablespace(connection, string7, string8, rDFLogger);
        boolean bl2 = true;
        int n4 = QueryUtils.getNetworkMaxStringSize((Connection)connection, (String)string10);
        String string14 = QueryUtils.getSvpTabPrefix((String)stringArray3[0], (String)string8);
        String string15 = QueryUtils.getMvpTabPrefix((String)stringArray3[0], (String)string8);
        String string16 = QueryUtils.getPcnTabPrefix((String)stringArray3[0], (String)string8);
        Map map = QueryUtils.getSPMTabsInfo((Connection)connection, (String)string7, (String)string14, (String)string15, (String)string16);
        boolean[] blArray2 = new boolean[1];
        long[] lArray3 = new long[1];
        String[] stringArray12 = new String[1];
        String[] stringArray13 = new String[1];
        String[] stringArray14 = new String[1];
        long[] lArray4 = new long[2];
        String[] stringArray15 = new String[3];
        QueryUtils.getNetworkSpatialInfo((Connection)connection, (boolean[])blArray2, (long[])lArray3, (String[])stringArray12, (String[])stringArray13, (String[])stringArray14, (boolean)false, (String)string7, (String)string8);
        boolean[] blArray3 = new boolean[1];
        boolean[] blArray4 = new boolean[1];
        QueryUtils.getSdoRdfPPFuncInfo((Connection)connection, (boolean[])blArray3, (boolean[])blArray4);
        RDFModelMetadata rDFModelMetadata = new RDFModelMetadata();
        rDFModelMetadata.currSchema = string4;
        rDFModelMetadata.currUser = string5;
        rDFModelMetadata.networkOwner = string7;
        rDFModelMetadata.networkName = string8;
        rDFModelMetadata.networkStorageForm = string12;
        rDFModelMetadata.networkTablespace = string13;
        rDFModelMetadata.orderColsPopulated = bl2;
        rDFModelMetadata.networkMaxStringSize = n4;
        rDFModelMetadata.srid = lArray3[0];
        rDFModelMetadata.hasMatSpaIdx = blArray2[0];
        rDFModelMetadata.geoColumn = stringArray12[0];
        rDFModelMetadata.geoTolerance = stringArray13[0];
        rDFModelMetadata.geoDimension = stringArray14[0];
        rDFModelMetadata.modelName = stringArray3[0];
        rDFModelMetadata.modelId = lArray[0];
        rDFModelMetadata.modelOwner = stringArray5[0];
        rDFModelMetadata.modelType = stringArray6[0];
        rDFModelMetadata.appTabName = stringArray7[0];
        rDFModelMetadata.tripleColName = stringArray8[0];
        rDFModelMetadata.usesIMVC = blArray[0];
        rDFModelMetadata.usesMV = bl;
        rDFModelMetadata.spmTabColMap = map;
        rDFModelMetadata.attachedModelNames = stringArray11;
        rDFModelMetadata.attachedModelIds = lArray2;
        rDFModelMetadata.precompIndexName = string11;
        rDFModelMetadata.idxStatus = string6;
        rDFModelMetadata.uniqueViewName = stringArray9[0];
        rDFModelMetadata.dupViewName = stringArray10[0];
        rDFModelMetadata.sdoRdfPPExists = blArray3[0];
        rDFModelMetadata.sdoRdfPPRangeEnabled = blArray4[0];
        LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: \nReturning RDFModelMetadata:\n" + rDFModelMetadata.toString()), (RDFLogger)rDFLogger);
        return rDFModelMetadata;
    }

    public static CompiledSPARQL compileSPARQL(Connection connection, String string, String string2, String string3, String[] stringArray, String[] stringArray2, String string4, String string5, RDFLogger rDFLogger) throws SQLException, RDFException {
        return SPARQLClientUtils.compileSPARQL(connection, string, string2, string3, stringArray, stringArray2, string4, string5, rDFLogger, null);
    }

    public static CompiledSPARQL compileSPARQL(Connection connection, String string, String string2, String string3, String[] stringArray, String[] stringArray2, String string4, String string5, RDFLogger rDFLogger, SPARQLFeatureConfig sPARQLFeatureConfig) throws SQLException, RDFException {
        RDFModelMetadata rDFModelMetadata = SPARQLClientUtils.populateRDFModelMetadata(connection, string2, string4, string5, rDFLogger);
        return SPARQLClientUtils.compileSPARQL(string, rDFModelMetadata, string3, stringArray, stringArray2, rDFLogger, sPARQLFeatureConfig);
    }

    public static CompiledSPARQL compileSPARQL(String string, RDFModelMetadata rDFModelMetadata, String string2, String[] stringArray, String[] stringArray2, RDFLogger rDFLogger) throws SQLException, RDFException {
        return SPARQLClientUtils.compileSPARQL(string, rDFModelMetadata, string2, stringArray, stringArray2, rDFLogger, null);
    }

    public static CompiledSPARQL compileSPARQL(String string, RDFModelMetadata rDFModelMetadata, String string2, String[] stringArray, String[] stringArray2, RDFLogger rDFLogger, SPARQLFeatureConfig sPARQLFeatureConfig) throws SQLException, RDFException {
        return new CompiledSPARQL(string, rDFModelMetadata, string2, stringArray, stringArray2, rDFLogger, sPARQLFeatureConfig);
    }

    public static String sparqlToSql(Connection connection, String string, String string2, String string3, String[] stringArray, String[] stringArray2, Map<String, String> map, String string4, String string5) throws SQLException, RDFException, ParseException {
        return SPARQLClientUtils.sparqlToSql(connection, string, string2, string3, stringArray, stringArray2, map, string4, string5, null);
    }

    public static String sparqlToSql(Connection connection, String string, String string2, String string3, String[] stringArray, String[] stringArray2, Map<String, String> map, String string4, String string5, RDFLogger rDFLogger) throws SQLException, RDFException, ParseException {
        return SPARQLClientUtils.sparqlToSql(connection, string, string2, string3, stringArray, stringArray2, map, string4, string5, rDFLogger, null);
    }

    public static String sparqlToSql(Connection connection, String string, String string2, String string3, String[] stringArray, String[] stringArray2, Map<String, String> map, String string4, String string5, RDFLogger rDFLogger, SPARQLFeatureConfig sPARQLFeatureConfig) throws SQLException, RDFException, ParseException {
        RDFModelMetadata rDFModelMetadata = SPARQLClientUtils.populateRDFModelMetadata(connection, string2, string4, string5, rDFLogger);
        return SPARQLClientUtils.sparqlToSql(connection, string, rDFModelMetadata, string3, stringArray, stringArray2, map, rDFLogger, sPARQLFeatureConfig);
    }

    public static String sparqlToSql(Connection connection, String string, RDFModelMetadata rDFModelMetadata, String string2, String[] stringArray, String[] stringArray2, Map<String, String> map, RDFLogger rDFLogger) throws SQLException, RDFException, ParseException {
        return SPARQLClientUtils.sparqlToSql(connection, string, rDFModelMetadata, string2, stringArray, stringArray2, map, rDFLogger, null);
    }

    public static String sparqlToSql(Connection connection, String string, RDFModelMetadata rDFModelMetadata, String string2, String[] stringArray, String[] stringArray2, Map<String, String> map, RDFLogger rDFLogger, SPARQLFeatureConfig sPARQLFeatureConfig) throws SQLException, RDFException, ParseException {
        return SPARQLClientUtils.sparqlToSql(connection, string, rDFModelMetadata, string2, stringArray, stringArray2, map, null, rDFLogger, sPARQLFeatureConfig, null);
    }

    public static String sparqlToSql(Connection connection, String string, String[] stringArray, String[] stringArray2, String string2, String string3, String[] stringArray3, String[] stringArray4, Map<String, String> map, String string4, String string5) throws SQLException, RDFException, ParseException {
        return SPARQLClientUtils.sparqlToSql(connection, string, stringArray, stringArray2, string2, string3, stringArray3, stringArray4, map, string4, string5, null);
    }

    public static String sparqlToSql(Connection connection, String string, String[] stringArray, String[] stringArray2, String string2, String string3, String[] stringArray3, String[] stringArray4, Map<String, String> map, String string4, String string5, RDFLogger rDFLogger) throws SQLException, RDFException, ParseException {
        return SPARQLClientUtils.sparqlToSql(connection, string, stringArray, stringArray2, string2, string3, stringArray3, stringArray4, map, string4, string5, rDFLogger, null);
    }

    public static String sparqlToSql(Connection connection, String string, String[] stringArray, String[] stringArray2, String string2, String string3, String[] stringArray3, String[] stringArray4, Map<String, String> map, String string4, String string5, RDFLogger rDFLogger, SPARQLFeatureConfig sPARQLFeatureConfig) throws SQLException, RDFException, ParseException {
        RDFModelMetadata rDFModelMetadata = SPARQLClientUtils.populateRDFModelMetadata(connection, stringArray, stringArray2, string2, string4, string5, rDFLogger);
        return SPARQLClientUtils.sparqlToSql(connection, string, rDFModelMetadata, string3, stringArray3, stringArray4, map, null, rDFLogger, sPARQLFeatureConfig, null);
    }

    static String sparqlToSql(Connection connection, String string, RDFModelMetadata rDFModelMetadata, String string2, String[] stringArray, String[] stringArray2, Map<String, String> map, SPMComponents sPMComponents, RDFLogger rDFLogger, SPARQLFeatureConfig sPARQLFeatureConfig, OraBindValueInfo oraBindValueInfo) throws SQLException, RDFException, ParseException {
        Objects.requireNonNull(string, NULL_SPARQL_MSG);
        Objects.requireNonNull(rDFModelMetadata, NULL_MODEL_MSG);
        Objects.requireNonNull(rDFModelMetadata.modelName, NULL_MODEL_MSG);
        String string3 = rDFModelMetadata.networkOwner;
        String string4 = rDFModelMetadata.networkName;
        String string5 = "";
        if (string2 != null && !string2.trim().isEmpty()) {
            string5 = " " + string2.trim() + " ";
        }
        if (map != null && !string5.contains(REPLACE_SQL_RES_WORDS_FLAG)) {
            string5 = string5 + " REPLACE_SQL_RES_WORDS=T ";
        }
        if (sPARQLFeatureConfig == null) {
            sPARQLFeatureConfig = SPARQLFeatureConfig.getDefaultConfig();
        }
        StringBuffer stringBuffer = new StringBuffer().append("\n").append("----------------- sparqlToSql ----------------\n").append("query=[" + string + "]\n").append("model=[" + rDFModelMetadata.modelName + "]\n").append("options=[" + string5 + "]\n").append("defaultUris=").append(Arrays.toString(stringArray)).append("\n").append("ngUris=[").append(Arrays.toString(stringArray2)).append("\n").append("sfConfig=[").append("\n").append(sPARQLFeatureConfig.toString()).append("\n]\n").append("networkOwner=[").append(string3).append("]\n").append("networkName=[").append(string4).append("]\n").append("----------------------------------------------\n");
        LogUtils.debug((String)(CLASS_LOG_PFX + stringBuffer.toString()), (RDFLogger)rDFLogger);
        int n = 5;
        TranslateEngine translateEngine = new TranslateEngine(n, connection);
        translateEngine.setOptions(string5);
        String string6 = rDFModelMetadata.modelName;
        long l = rDFModelMetadata.modelId;
        String string7 = rDFModelMetadata.modelOwner;
        String string8 = rDFModelMetadata.modelType;
        String string9 = rDFModelMetadata.appTabName;
        String string10 = rDFModelMetadata.tripleColName;
        String string11 = rDFModelMetadata.uniqueViewName;
        String string12 = rDFModelMetadata.dupViewName;
        boolean bl = rDFModelMetadata.usesIMVC;
        String[] stringArray3 = rDFModelMetadata.attachedModelNames;
        long[] lArray = rDFModelMetadata.attachedModelIds;
        String string13 = rDFModelMetadata.precompIndexName;
        String string14 = rDFModelMetadata.idxStatus;
        String string15 = "";
        if (string5 != null) {
            string15 = string5.toUpperCase();
        }
        String string16 = SPARQLClientUtils.getVmViewName(rDFModelMetadata, string15);
        int n2 = 0;
        int[] nArray = new int[]{0};
        if (string8.equals("D") && !string15.contains("RDB2RDF_METADATA=T")) {
            n2 = 1;
            nArray[0] = 1;
        }
        HashMap hashMap = SPARQLEngine.setupNamespaceMap();
        long[][] lArrayArray = new long[1][];
        long[][] lArrayArray2 = new long[1][];
        String string17 = SPARQLClientUtils.addPfxForRdfObjName("RDF_VALUE$", string3, string4);
        SPARQLClientUtils.populateGraphIds(connection, string, translateEngine, hashMap, stringArray, stringArray2, string17, lArrayArray, lArrayArray2);
        long[] lArray2 = lArrayArray[0];
        long[] lArray3 = lArrayArray2[0];
        int[] nArray2 = null;
        String[] stringArray4 = new String[]{string6};
        int n3 = stringArray3.length;
        String[] stringArray5 = Arrays.copyOf(stringArray3, n3 + 1);
        System.arraycopy(stringArray4, 0, stringArray5, n3, 1);
        long l2 = 0L;
        long[] lArray4 = new long[]{};
        Object[] objectArray = new String[]{};
        String[][] stringArray6 = new String[1][];
        int[] nArray3 = new int[1];
        ArrayList arrayList = new ArrayList();
        String[] stringArray7 = new String[1];
        String string18 = "\nCalling translateQueryPattern:\n            plist=" + Arrays.toString(nArray2) + "\n            query=[" + string + "]\n precompIndexName=[" + string13 + "]\n     precompIdxID=[" + l2 + "]\n        idxStatus=[" + string14 + "]\n            dGIDs=" + Arrays.toString(lArray2) + "\n            nGIDs=" + Arrays.toString(lArray3) + "\n            dMIDs=" + Arrays.toString(lArray4) + "\n          dModels=" + Arrays.toString(objectArray) + "\n       vmViewName=[" + string16 + "]\n      model_types=" + Arrays.toString(nArray) + "\n     isRdfVWModel=[" + n2 + "]";
        LogUtils.debug((String)(CLASS_LOG_PFX + string18), (RDFLogger)rDFLogger);
        SQLGenContext sQLGenContext = SPARQLClientUtils.buildSqlGenCtxFromRDFMdata(rDFModelMetadata);
        SPARQLClientUtils.setEnabledFeaturesInCtx(sPARQLFeatureConfig, sQLGenContext);
        sQLGenContext.bvInfo = oraBindValueInfo;
        String string19 = translateEngine.translateQueryPattern(nArray2, string, stringArray5, string13, l2, string14, lArray2, lArray3, lArray4, (String[])objectArray, hashMap, string16, stringArray6, nArray3, arrayList, stringArray7, nArray, n2, map, sPMComponents, sQLGenContext, string3, string4);
        return string19;
    }

    public static boolean executeSparqlUpdate(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7) throws SQLException, RDFException, ParseException {
        return SPARQLClientUtils.executeSparqlUpdate(connection, string, string2, string3, string4, string5, string6, string7, null);
    }

    public static boolean executeSparqlUpdate(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7, RDFLogger rDFLogger) throws SQLException, RDFException, ParseException {
        return SPARQLClientUtils.executeSparqlUpdate(connection, string, string2, string3, string4, string5, string6, string7, rDFLogger, null);
    }

    public static boolean executeSparqlUpdate(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7, RDFLogger rDFLogger, Observable observable) throws SQLException, RDFException, ParseException {
        RDFModelMetadata rDFModelMetadata = SPARQLClientUtils.populateRDFModelMetadata(connection, string2, string6, string7, rDFLogger);
        RDFModelMetadata rDFModelMetadata2 = null;
        if (string3 != null) {
            rDFModelMetadata2 = SPARQLClientUtils.populateRDFModelMetadata(connection, string3, string6, string7, rDFLogger);
        }
        return SPARQLClientUtils.executeSparqlUpdate(connection, string, rDFModelMetadata, rDFModelMetadata2, string4, string5, rDFLogger, observable);
    }

    public static boolean executeSparqlUpdate(Connection connection, String string, String string2, String[] stringArray, String[] stringArray2, String string3, String string4, String string5, String string6, String string7) throws SQLException, RDFException, ParseException {
        return SPARQLClientUtils.executeSparqlUpdate(connection, string, string2, stringArray, stringArray2, string3, string4, string5, string6, string7, null);
    }

    public static boolean executeSparqlUpdate(Connection connection, String string, String string2, String[] stringArray, String[] stringArray2, String string3, String string4, String string5, String string6, String string7, RDFLogger rDFLogger) throws SQLException, RDFException, ParseException {
        return SPARQLClientUtils.executeSparqlUpdate(connection, string, string2, stringArray, stringArray2, string3, string4, string5, string6, string7, rDFLogger, null);
    }

    public static boolean executeSparqlUpdate(Connection connection, String string, String string2, String[] stringArray, String[] stringArray2, String string3, String string4, String string5, String string6, String string7, RDFLogger rDFLogger, Observable observable) throws SQLException, RDFException, ParseException {
        RDFModelMetadata rDFModelMetadata = SPARQLClientUtils.populateRDFModelMetadata(connection, string2, string6, string7, rDFLogger);
        RDFModelMetadata rDFModelMetadata2 = null;
        if (stringArray != null) {
            rDFModelMetadata2 = SPARQLClientUtils.populateRDFModelMetadata(connection, stringArray, stringArray2, string3, string6, string7, rDFLogger);
        }
        return SPARQLClientUtils.executeSparqlUpdate(connection, string, rDFModelMetadata, rDFModelMetadata2, string4, string5, rDFLogger, observable);
    }

    public static boolean executeSparqlUpdate(Connection connection, String string, RDFModelMetadata rDFModelMetadata, RDFModelMetadata rDFModelMetadata2, String string2, String string3, RDFLogger rDFLogger) throws SQLException, RDFException, ParseException {
        return SPARQLClientUtils.executeSparqlUpdate(connection, string, rDFModelMetadata, rDFModelMetadata2, string2, string3, rDFLogger, null);
    }

    public static boolean executeSparqlUpdate(Connection connection, String string, RDFModelMetadata rDFModelMetadata, RDFModelMetadata rDFModelMetadata2, String string2, String string3, RDFLogger rDFLogger, Observable observable) throws SQLException, RDFException, ParseException {
        Objects.requireNonNull(string, NULL_SPARQL_MSG);
        Objects.requireNonNull(rDFModelMetadata, NULL_MODEL_MSG);
        Objects.requireNonNull(rDFModelMetadata.modelName, NULL_MODEL_MSG);
        String string4 = rDFModelMetadata.networkOwner;
        String string5 = rDFModelMetadata.networkName;
        long l = System.currentTimeMillis();
        LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: SPARQL update params: network owner [" + string4 + "], network name [" + string5 + "], model [" + rDFModelMetadata.modelName + "]"), (RDFLogger)rDFLogger);
        LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: SPARQL update: " + string), (RDFLogger)rDFLogger);
        String string6 = rDFModelMetadata.modelName;
        RDFModelMetadata rDFModelMetadata3 = rDFModelMetadata;
        if (rDFModelMetadata2 != null) {
            rDFModelMetadata3 = rDFModelMetadata2;
        }
        String[] stringArray = new String[]{rDFModelMetadata3.modelName};
        int n = rDFModelMetadata3.attachedModelNames.length;
        String[] stringArray2 = Arrays.copyOf(rDFModelMetadata3.attachedModelNames, n + 1);
        System.arraycopy(stringArray, 0, stringArray2, n, 1);
        LogUtils.debug((String)"oracle.spatial.rdf.client.SPARQLClientUtils: getting row source info for apply model", (RDFLogger)rDFLogger);
        long l2 = rDFModelMetadata.modelId;
        String string7 = rDFModelMetadata.modelOwner;
        String string8 = rDFModelMetadata.modelType;
        String string9 = rDFModelMetadata.appTabName;
        String string10 = rDFModelMetadata.tripleColName;
        String string11 = rDFModelMetadata.uniqueViewName;
        String string12 = rDFModelMetadata.dupViewName;
        boolean bl = rDFModelMetadata.usesIMVC;
        long l3 = rDFModelMetadata3.modelId;
        String string13 = rDFModelMetadata3.modelOwner;
        String string14 = rDFModelMetadata3.modelType;
        String string15 = rDFModelMetadata3.appTabName;
        String string16 = rDFModelMetadata3.tripleColName;
        String string17 = rDFModelMetadata3.uniqueViewName;
        String string18 = rDFModelMetadata3.dupViewName;
        boolean bl2 = rDFModelMetadata3.usesIMVC;
        String string19 = rDFModelMetadata3.idxStatus;
        String string20 = rDFModelMetadata3.precompIndexName;
        String string21 = "";
        if (string2 != null) {
            string21 = " " + string2.toUpperCase() + " ";
        }
        if (!string21.contains(REPLACE_SQL_RES_WORDS_FLAG)) {
            string21 = string21 + " REPLACE_SQL_RES_WORDS=T ";
        }
        String string22 = "";
        if (string3 != null) {
            string22 = string3;
        }
        String string23 = SPARQLClientUtils.getVmViewName(rDFModelMetadata3, string21);
        int n2 = 0;
        if (string14.equals("D") && !string21.contains("RDB2RDF_METADATA=T")) {
            n2 = 1;
        }
        String string24 = rDFModelMetadata.networkTablespace;
        String string25 = rDFModelMetadata.currSchema;
        String string26 = rDFModelMetadata.currUser;
        long l4 = System.currentTimeMillis();
        LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: time to get metadata information (ms): " + (l4 - l)), (RDFLogger)rDFLogger);
        SQLGenContext sQLGenContext = SPARQLClientUtils.buildSqlGenCtxFromRDFMdata(rDFModelMetadata3);
        UpdateEngine updateEngine = new UpdateEngine(connection, string6, l2, string7, string9, string10, stringArray2, string20, 0L, string19, string23, n2, string21, string22, string25, string26, string24, 0, true, sQLGenContext, observable, string4, string5);
        long l5 = System.currentTimeMillis();
        LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Time to initialize update engine (ms): " + (l5 - l4)), (RDFLogger)rDFLogger);
        updateEngine.doUpdate(string);
        long l6 = System.currentTimeMillis();
        LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Time to execute SPARQL update (ms): " + (l6 - l5)), (RDFLogger)rDFLogger);
        LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Total time for SPARQL update (ms): " + (l6 - l)), (RDFLogger)rDFLogger);
        return true;
    }

    private static String getVmViewName(RDFModelMetadata rDFModelMetadata, String string) throws SQLException {
        String string2 = null;
        if (rDFModelMetadata.modelType.equals("V")) {
            string2 = string.contains("ALLOW_DUP=T") ? rDFModelMetadata.networkOwner + "." + QueryUtils.simpleSQLName((String)rDFModelMetadata.dupViewName, (int)128) : rDFModelMetadata.networkOwner + "." + QueryUtils.simpleSQLName((String)rDFModelMetadata.uniqueViewName, (int)128);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getModelInfo(Connection connection, String[] stringArray, String string, long[] lArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6, String[] stringArray7, boolean[] blArray, String string2, String string3, RDFLogger rDFLogger) throws SQLException, RDFException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Object object;
            block53: {
                String string4 = SPARQLClientUtils.addPfxForRdfObjName("RDF_MODEL$", string2, string3);
                String string5 = SPARQLClientUtils.addPfxForRdfObjName("SEM_VMODEL_INFO", string2, string3);
                OracleDatabaseVersion oracleDatabaseVersion = QueryUtils.getDatabaseVersion((Connection)connection);
                String string6 = "";
                if (oracleDatabaseVersion.isCompatible(OracleDatabaseVersion.V_18c)) {
                    string6 = ", m.inmemory ";
                }
                if (stringArray.length == 1) {
                    object = "SELECT m.model_id, m.owner, m.model_type, m.table_name, m.column_name, v.unique_view_name, v.duplicate_view_name, v.status" + string6 + "FROM " + string4 + " m, " + string5 + " v WHERE m.model_name = v.virtual_model_name(+) AND m.model_name = ?";
                    try {
                        statement = connection.prepareStatement((String)object);
                        statement.setString(1, stringArray[0]);
                        LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: RowSourceInfo SQL: " + (String)object), (RDFLogger)rDFLogger);
                        String string7 = null;
                        resultSet = statement.executeQuery();
                        if (resultSet.next()) {
                            lArray[0] = resultSet.getLong(1);
                            stringArray2[0] = resultSet.getString(2);
                            stringArray3[0] = resultSet.getString(3);
                            stringArray4[0] = resultSet.getString(4);
                            stringArray5[0] = resultSet.getString(5);
                            stringArray6[0] = resultSet.getString(6);
                            stringArray7[0] = resultSet.getString(7);
                            string7 = resultSet.getString(8);
                            blArray[0] = false;
                            if (oracleDatabaseVersion.isCompatible(OracleDatabaseVersion.V_18c)) {
                                blArray[0] = "T".equals(resultSet.getString(9));
                            }
                        } else {
                            LogUtils.error((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Unable to find models: " + Arrays.toString(stringArray)), (RDFLogger)rDFLogger);
                            throw new RDFException(MODEL_NOT_EXIST_MSG);
                        }
                        String string8 = QueryUtils.validateStatus((String)string);
                        if (lArray[0] < 0L && QueryUtils.decodeStatusLevel((String)string8) > QueryUtils.decodeStatusLevel((String)string7)) {
                            LogUtils.error((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Virtual model entailment status mismatch: found " + string7 + " but required " + string8), (RDFLogger)rDFLogger);
                            throw new RDFException(ENTAILMENT_NOT_EXIST_MSG);
                        }
                        break block53;
                    }
                    finally {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing rs:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
                        }
                        try {
                            if (statement != null) {
                                statement.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing ps:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
                        }
                    }
                }
                object = new HashMap<String, Integer>();
                for (int i = 0; i < stringArray.length; ++i) {
                    ((HashMap)object).put(stringArray[i], i);
                }
                String string9 = "SELECT m.model_name, m.model_id, m.owner, m.model_type, m.table_name, m.column_name FROM " + string4 + " m WHERE m.model_name IN (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                try {
                    int n = stringArray.length;
                    int n2 = n / 10 + (n % 10 > 0 ? 1 : 0);
                    for (int i = 0; i < n2; ++i) {
                        int n3;
                        int n4;
                        statement = connection.prepareStatement(string9);
                        int n5 = i * 10;
                        int n6 = n4 = n5 + 10;
                        if (n < n4 - 1) {
                            n4 = n;
                        }
                        int n7 = 1;
                        for (n3 = n5; n3 < n4; ++n3) {
                            statement.setString(n7, stringArray[n3]);
                            ++n7;
                        }
                        while (n3 < n6) {
                            statement.setString(n7, null);
                            ++n7;
                            ++n3;
                        }
                        LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: RowSourceInfo SQL: " + string9), (RDFLogger)rDFLogger);
                        stringArray6[0] = null;
                        stringArray7[0] = null;
                        blArray[0] = false;
                        resultSet = statement.executeQuery();
                        if (resultSet.next()) {
                            do {
                                String string10 = resultSet.getString(1);
                                int n8 = (Integer)((HashMap)object).get(string10);
                                lArray[n8] = resultSet.getLong(2);
                                stringArray2[n8] = resultSet.getString(3);
                                stringArray3[n8] = resultSet.getString(4);
                                stringArray4[n8] = resultSet.getString(5);
                                stringArray5[n8] = resultSet.getString(6);
                            } while (resultSet.next());
                        } else {
                            LogUtils.error((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Unable to find models: " + Arrays.toString(stringArray)), (RDFLogger)rDFLogger);
                            throw new RDFException(MODEL_NOT_EXIST_MSG);
                        }
                        statement.close();
                        resultSet.close();
                    }
                }
                finally {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing rs:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
                    }
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing ps:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
                    }
                }
            }
            object = "\n---------------- Row Source Info -----------------\n  modelNames=[" + Arrays.toString(stringArray) + "]\n    modelIds=[" + Arrays.toString(lArray) + "]\n modelOwners=[" + Arrays.toString(stringArray2) + "]\n  modelTypes=[" + Arrays.toString(stringArray3) + "]\n  tableNames=[" + Arrays.toString(stringArray4) + "]\n columnNames=[" + Arrays.toString(stringArray5) + "]\n    usesIMVC=[" + blArray[0] + "]\nvmUniqueView=[" + stringArray6[0] + "]\n   vmDupView=[" + stringArray7[0] + "]\n--------------------------------------------------";
            LogUtils.debug((String)(CLASS_LOG_PFX + (String)object), (RDFLogger)rDFLogger);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing rs:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing ps:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getEntailmentInfo(Connection connection, String[] stringArray, String[] stringArray2, String string, String string2, String string3, RDFLogger rDFLogger) throws SQLException, RDFException {
        String string4;
        block17: {
            ResultSet resultSet = null;
            PreparedStatement preparedStatement = null;
            int n = stringArray.length;
            int n2 = stringArray2.length;
            int n3 = n + n2;
            int n4 = n3 <= 10 ? 10 : n3;
            String[] stringArray3 = Arrays.copyOf(stringArray, n3);
            System.arraycopy(stringArray2, 0, stringArray3, n, n2);
            String string5 = "?,?,?,?,?,?,?,?,?,?";
            for (int i = 10; i < n4; ++i) {
                string5 = string5 + ",?";
            }
            String string6 = SPARQLClientUtils.addPfxForRdfObjName("SEM_RULES_INDEX_INFO", string2, string3);
            String string7 = SPARQLClientUtils.addPfxForRdfObjName("SEM_RULES_INDEX_DATASETS", string2, string3);
            String string8 = "select rii.index_name from   " + string6 + " rii,   (select index_name, sum(case when data_type = 'MODEL' then 1 else 0 end) model_count, sum(case when data_type = 'RULEBASE' then 1 else 0 end) rb_count    from " + string7 + "   where data_name in (" + string5 + ")    group by index_name) rid where rii.index_name = rid.index_name and rii.model_count = rid.model_count and rii.rulebase_count = rid.rb_count       and (rii.model_count + rii.rulebase_count) = ?       and rii.status <> 'INPROGRESS' and rii.status <> 'FAILED'       and decode(upper(?),'INVALID',0,'INCOMPLETE',1,'VALID',2) <= decode(rii.status,'INVALID',0,'INCOMPLETE',1,'VALID',2) ";
            string4 = null;
            try {
                int n5;
                preparedStatement = connection.prepareStatement(string8);
                for (n5 = 1; n5 <= n3; ++n5) {
                    preparedStatement.setString(n5, stringArray3[n5 - 1]);
                }
                while (n5 <= n4) {
                    preparedStatement.setString(n5, null);
                    ++n5;
                }
                preparedStatement.setInt(n4 + 1, n3);
                preparedStatement.setString(n4 + 2, string);
                LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: EntailmentInfo SQL: " + string8), (RDFLogger)rDFLogger);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    string4 = resultSet.getString(1);
                    break block17;
                }
                LogUtils.error((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Unable to find models: " + Arrays.toString(stringArray)), (RDFLogger)rDFLogger);
                throw new RDFException(ENTAILMENT_NOT_EXIST_MSG);
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing rs:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing ps:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
                }
            }
        }
        return string4;
    }

    private static void populateGraphIds(Connection connection, String string, TranslateEngine translateEngine, HashMap hashMap, String[] stringArray, String[] stringArray2, String string2, long[][] lArray, long[][] lArray2) throws SQLException, RDFException, ParseException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add("<" + stringArray[i] + ">");
            }
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                arrayList2.add("<" + stringArray2[i] + ">");
            }
        }
        translateEngine.getSources(string, hashMap, arrayList, arrayList2);
        URIset uRIset = new URIset();
        for (String string3 : arrayList) {
            uRIset.put(string3.substring(1, string3.length() - 1));
        }
        for (String string3 : arrayList2) {
            uRIset.put(string3.substring(1, string3.length() - 1));
        }
        uRIset.resolve(connection, string2);
        Object object = new long[arrayList.size()];
        int n = 0;
        for (String object2 : arrayList) {
            String string3 = uRIset.get(object2.substring(1, object2.length() - 1));
            object[n] = string3 != null ? (Object)Long.parseLong(string3) : (Object)0L;
            ++n;
        }
        Object object3 = new long[arrayList2.size()];
        n = 0;
        for (String string3 : arrayList2) {
            String string4 = uRIset.get(string3.substring(1, string3.length() - 1));
            object3[n] = string4 != null ? (Object)Long.parseLong(string4) : (Object)0L;
            ++n;
        }
        lArray[0] = (long[])object;
        lArray2[0] = (long[])object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCurrentSchema(Connection connection, RDFLogger rDFLogger) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            String string2 = "select sys_context('userenv','current_schema') from sys.dual";
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                string = resultSet.getString(1);
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing rs:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing stmt:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCurrentUser(Connection connection, RDFLogger rDFLogger) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            String string2 = "select sys_context('userenv','current_user') from sys.dual";
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                string = resultSet.getString(1);
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing rs:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing stmt:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getNetTablespace(Connection connection, String string, String string2, RDFLogger rDFLogger) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string3 = null;
        String string4 = QueryUtils.getNetworkNamePfx((String)string2) + "RDF_VALUE$";
        String string5 = QueryUtils.getNetworkOwnerOrMdsys((String)string);
        try {
            String string6 = "select /*+ result_cache dynamic_sampling(0) parallel(1) */ tablespace_name from sys.all_tables where table_name=? and owner=?";
            preparedStatement = connection.prepareStatement(string6);
            preparedStatement.setString(1, string4);
            preparedStatement.setString(2, QueryUtils.checkRemoveEnclosingQuotes((String)string5));
            resultSet = preparedStatement.executeQuery();
            String string7 = null;
            if (resultSet.next()) {
                string7 = resultSet.getString(1);
            }
            string3 = QueryUtils.enquoteNameSQLName(string7);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing rs:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing ps:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
        }
        return string3;
    }

    static String addPfxForRdfObjName(String string, String string2, String string3) throws SQLException {
        String string4 = QueryUtils.validateAndGetPfxForRdfObjName((String)string2, (String)string3);
        return string4 + QueryUtils.simpleSQLName((String)string, (int)30);
    }

    private static SQLGenContext buildSqlGenCtxFromRDFMdata(RDFModelMetadata rDFModelMetadata) {
        SQLGenContext sQLGenContext = null;
        if (rDFModelMetadata != null) {
            sQLGenContext = new SQLGenContext();
            sQLGenContext.clnNetworkOwner = rDFModelMetadata.networkOwner;
            sQLGenContext.clnNetworkName = rDFModelMetadata.networkName;
            sQLGenContext.networkStorageForm = rDFModelMetadata.networkStorageForm;
            sQLGenContext.orderColsPopulated = rDFModelMetadata.orderColsPopulated;
            sQLGenContext.networkMaxStringSize = rDFModelMetadata.networkMaxStringSize;
            sQLGenContext.srid = rDFModelMetadata.srid;
            sQLGenContext.matSpaIdx = rDFModelMetadata.hasMatSpaIdx;
            sQLGenContext.geoColumn = rDFModelMetadata.geoColumn;
            sQLGenContext.geoTolerance = rDFModelMetadata.geoTolerance;
            sQLGenContext.geoDimension = rDFModelMetadata.geoDimension;
            if (rDFModelMetadata.usesIMVC || rDFModelMetadata.usesMV) {
                sQLGenContext.contextFlags |= 8;
            }
            sQLGenContext.spmTabColMap = rDFModelMetadata.spmTabColMap;
            sQLGenContext.lateralPPOptEnabled = rDFModelMetadata.sdoRdfPPExists;
            sQLGenContext.lateralPPRangeOptEnabled = rDFModelMetadata.sdoRdfPPRangeEnabled;
            sQLGenContext.setModelMetadataInited(true);
        }
        return sQLGenContext;
    }

    private static void setEnabledFeaturesInCtx(SPARQLFeatureConfig sPARQLFeatureConfig, SQLGenContext sQLGenContext) {
        sQLGenContext.udfEnabled = sPARQLFeatureConfig.udfEnabled;
        sQLGenContext.overloadedServiceEnabled = sPARQLFeatureConfig.overloadedServiceEnabled;
    }

    public static void analyzeSPARQLWorkloadForSPM(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, RDFLogger rDFLogger) throws SQLException, RDFException, ParseException {
        Object object;
        Object object22;
        String string11;
        Object object3;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Object var14_14 = null;
        String string12 = null;
        String string13 = null;
        String string14 = null;
        String string15 = null;
        String string16 = null;
        String string17 = null;
        string12 = QueryUtils.validateSQLName((String)string, (boolean)false, (int)128);
        string13 = QueryUtils.validateSQLName((String)string2, (boolean)false, (int)128);
        string14 = QueryUtils.validateSQLName((String)string3, (boolean)false, (int)128);
        string15 = QueryUtils.validateSQLName((String)string4, (boolean)false, (int)128);
        string16 = QueryUtils.validateSQLName((String)string5, (boolean)false, (int)128);
        string17 = QueryUtils.validateSQLName((String)string6, (boolean)true, (int)124);
        String string18 = "SELECT " + string14 + " FROM " + string12 + "." + string13;
        SPMComponents sPMComponents = new SPMComponents();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        RDFModelMetadata rDFModelMetadata = SPARQLClientUtils.populateRDFModelMetadata(connection, string7, string9, string10, rDFLogger);
        try {
            preparedStatement = connection.prepareStatement(string18);
            resultSet = preparedStatement.executeQuery();
            string8 = string8 + " STREE_MERGE_OPT=T ";
            int n = 1;
            while (resultSet.next()) {
                object3 = resultSet.getString(1);
                try {
                    string11 = SPARQLClientUtils.sparqlToSql(connection, (String)object3, rDFModelMetadata, string8, new String[0], new String[0], hashMap, sPMComponents, rDFLogger, null, null);
                }
                catch (RDFException rDFException) {
                    String string19 = "Error with query number " + n + "\nQuery: " + (String)object3 + "\nError: " + ((Object)((Object)rDFException)).getClass().toString() + ": " + rDFException.getMessage();
                    throw new RDFException(string19, (Throwable)rDFException);
                }
                ++n;
                LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: SPARQL:" + (String)object3), (RDFLogger)rDFLogger);
                LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: svpClusters:" + sPMComponents.getSvpClusters()), (RDFLogger)rDFLogger);
            }
        }
        catch (SQLException sQLException) {
            String string20 = String.format(UNABLE_TO_READ_ERR, string14, string12, string13);
            throw new RDFException(string20, (Throwable)sQLException);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing rs:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing ps:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
        }
        String string21 = "SELECT PRED_NAME FROM " + string15 + "." + string16 + " WHERE max_cnt = 1 AND p_value_id > 0";
        object3 = SPARQLClientUtils.getSVPPredicates(connection, string21, string15, string16, rDFLogger);
        string11 = "SELECT PRED_NAME FROM " + string15 + "." + string16 + " WHERE max_cnt = 1 AND p_value_id < 0";
        Set<String> set = SPARQLClientUtils.getSVPPredicates(connection, string11, string15, string16, rDFLogger);
        HashMap hashMap2 = new HashMap();
        for (Object object22 : sPMComponents.getSvpClusters()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = object22.iterator();
            while (iterator.hasNext()) {
                String string22 = (String)iterator.next();
                if ((!QueryUtils.isReversePred((String)string22) || !set.contains(QueryUtils.removeSpmPfxFromPred((String)string22))) && (QueryUtils.isReversePred((String)string22) || !object3.contains(string22))) continue;
                arrayList.add(string22);
            }
            int n = arrayList.size();
            if (n <= 1) continue;
            object = new ArrayList();
            long l = (long)Math.pow(2.0, n);
            for (long i = 0L; i < l; ++i) {
                int n2;
                TreeSet treeSet = new TreeSet();
                for (n2 = 0; n2 < n; ++n2) {
                    if ((i & 1L << n2) <= 0L) continue;
                    if (treeSet.contains(arrayList.get(n2))) {
                        treeSet.clear();
                        break;
                    }
                    treeSet.add(arrayList.get(n2));
                }
                if (treeSet.size() <= 1) continue;
                if (!hashMap2.containsKey(treeSet)) {
                    hashMap2.put(treeSet, 1);
                    continue;
                }
                n2 = (Integer)hashMap2.get(treeSet);
                hashMap2.put(treeSet, n2 + 1);
            }
        }
        LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: svpClusters updated:" + sPMComponents.getSvpClusters()), (RDFLogger)rDFLogger);
        LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Count Clusters:" + hashMap2), (RDFLogger)rDFLogger);
        int n = 500;
        for (String string23 : string8.split(" ")) {
            if (!string23.contains(INS_BATCH_SIZE)) continue;
            object = string23.split("=")[1];
            try {
                n = Integer.parseInt((String)object);
                break;
            }
            catch (NumberFormatException numberFormatException) {
                String string24 = "Invalid INS_BATCH_SIZE option value: " + (String)object;
                throw new RDFException(string24, (Throwable)numberFormatException);
            }
        }
        SPARQLClientUtils.populateResultsTable(connection, string17, hashMap2, "SVP", n, rDFLogger);
        object22 = new HashMap();
        for (List list : sPMComponents.getPcnSequences()) {
            if (!((HashMap)object22).containsKey(list)) {
                ((HashMap)object22).put(list, 1);
                continue;
            }
            int n3 = (Integer)((HashMap)object22).get(list);
            ((HashMap)object22).put(list, n3 + 1);
        }
        LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Count Sequences:" + object22), (RDFLogger)rDFLogger);
        SPARQLClientUtils.populateResultsTable(connection, string17, (HashMap<? extends Collection<String>, Integer>)object22, "PCN", n, rDFLogger);
    }

    private static Set<String> getSVPPredicates(Connection connection, String string, String string2, String string3, RDFLogger rDFLogger) throws SQLException, RDFException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        HashSet<String> hashSet = new HashSet<String>();
        try {
            preparedStatement = connection.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string4 = resultSet.getString(1);
                hashSet.add(string4);
                LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Pred with max_cnt = 1:" + string4), (RDFLogger)rDFLogger);
            }
        }
        catch (SQLException sQLException) {
            String string5 = String.format(UNABLE_TO_READ_ERR, "PRED_NAME", string2, string3);
            throw new RDFException(string5, (Throwable)sQLException);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing rs:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing ps:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
        }
        return hashSet;
    }

    private static void populateResultsTable(Connection connection, String string, HashMap<? extends Collection<String>, Integer> hashMap, String string2, int n, RDFLogger rDFLogger) throws SQLException, RDFException, ParseException {
        Statement statement = null;
        Statement statement2 = null;
        String string3 = string2.equals("SVP") ? "SVP" : "PCN";
        String string4 = string + "_" + string3;
        String string5 = string2.equals("SVP") ? "svp_cluster" : "pcn_sequence";
        String string6 = "CREATE TABLE " + string4 + "(" + string5 + " varchar2(4000), occ_count number)";
        try {
            statement = connection.createStatement();
            statement.executeUpdate(string6);
            String string7 = "INSERT INTO " + string4 + " VALUES (?, ?)";
            LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Insert statement:" + string7), (RDFLogger)rDFLogger);
            statement2 = connection.prepareStatement(string7);
            int n2 = hashMap.size();
            Iterator<Map.Entry<? extends Collection<String>, Integer>> iterator = hashMap.entrySet().iterator();
            int n3 = 0;
            while (iterator.hasNext()) {
                Map.Entry<? extends Collection<String>, Integer> entry = iterator.next();
                int n4 = entry.getValue();
                String string8 = String.join((CharSequence)",", (Iterable<? extends CharSequence>)entry.getKey());
                statement2.setString(1, string8);
                statement2.setInt(2, n4);
                statement2.addBatch();
                if (n3 != 0 && n3 % n == 0 || n3 == n2 - 1) {
                    statement2.executeBatch();
                }
                ++n3;
            }
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 955) {
                String string9 = string4 + " already exists. Drop this table or use a different name.";
                throw new RDFException(string9, (Throwable)sQLException);
            }
            throw sQLException;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing stmt:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
            try {
                if (statement2 != null) {
                    statement2.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing ps:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
        }
    }
}

