/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.wls;

import java.io.File;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.as.jmx.framework.wls.spi.ComponentMBeans;
import oracle.as.jmx.framework.wls.spi.ServerLifeCycleListener;
import oracle.jrf.InternalJrfUtils;
import oracle.jrf.JrfUtils;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.ServerPlatformSupportFactory;
import oracle.jrf.i18n.JRFMessageBundleHelper;
import oracle.jrf.wls.JRFServerLifeCycleListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JRFStartup {
    private static String DOMAIN_CONFIG_XML = "config/config.xml";
    private static String DOMAIN_CONFIG_SERVERS_DIR = "config/fmwconfig/servers";

    public static void main(String[] args) throws PortabilityLayerException {
        try {
            JRFStartup.registerMBeanServerListener();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        File oracleHomeDir = new File(JrfUtils.getCommonComponentsHome());
        File domainDir = new File(JrfUtils.getDomainHome());
        File domainConfigDir = new File(ServerPlatformSupportFactory.getInstance().getDomainConfigDirectory());
        if (ServerPlatformSupportFactory.getInstance().isAdminServer()) {
            try {
                JRFStartup.initNewServersConfigDirs(oracleHomeDir, domainDir, domainConfigDir);
            }
            catch (PortabilityLayerException ex) {
                throw ex;
            }
            catch (Exception e) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10016", new String[]{oracleHomeDir.getAbsolutePath(), domainDir.getAbsolutePath(), e.getMessage()}), e);
            }
            ComponentMBeans.addServerLifeCycleListener((ServerLifeCycleListener)new JRFServerLifeCycleListener(domainConfigDir, oracleHomeDir), (int)0);
        } else {
            String serverName = ServerPlatformSupportFactory.getInstance().getServerName();
            File serverConfigDir = new File(domainDir, DOMAIN_CONFIG_SERVERS_DIR + "/" + serverName);
            try {
                InternalJrfUtils.copyServerConfigTemplateToServerDir(domainConfigDir, oracleHomeDir, serverConfigDir);
            }
            catch (Exception e) {
                throw new PortabilityLayerException(e);
            }
        }
    }

    private static void initNewServersConfigDirs(File oraHomeDir, File domainDir, File domainConfigDir) throws Exception {
        File configXml = new File(domainDir, DOMAIN_CONFIG_XML);
        File serversConfigDir = new File(domainDir, DOMAIN_CONFIG_SERVERS_DIR);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setNamespaceAware(true);
        JrfUtils.disableXXEOnDocumentBuilderFactory(dbf);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document dom = db.parse(configXml);
        Element docEle = dom.getDocumentElement();
        NodeList serverList = docEle.getElementsByTagName("server");
        if (serverList != null) {
            for (int i = 0; i < serverList.getLength(); ++i) {
                Element server = (Element)serverList.item(i);
                String nameStr = null;
                NodeList nameList = server.getElementsByTagName("name");
                if (nameList == null || nameList.getLength() <= 0) continue;
                Element name = (Element)nameList.item(0);
                nameStr = name.getFirstChild().getNodeValue().trim();
                File serverSubDir = new File(serversConfigDir, nameStr);
                InternalJrfUtils.copyServerConfigTemplateToServerDir(domainConfigDir, oraHomeDir, serverSubDir);
                InternalJrfUtils.mergeLoggersFromDir(domainConfigDir, serverSubDir, new File(serverSubDir, "logging.xml"));
            }
        }
    }

    private static void registerMBeanServerListener() throws Exception {
        MBeanServer server = JRFStartup.getRuntimeMBeanServer();
        if (server != null) {
            MBeanServerNotificationListener listener = new MBeanServerNotificationListener();
            ObjectName delegate = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            server.addNotificationListener(delegate, listener, null, null);
        }
    }

    private static MBeanServer getRuntimeMBeanServer() throws NamingException {
        InitialContext ctx = new InitialContext();
        MBeanServer server = null;
        try {
            server = (MBeanServer)ctx.lookup("java:comp/env/jmx/runtime");
        }
        catch (NoInitialContextException e) {
            if (System.getProperty("weblogic.AdminServerName") != null) {
                return null;
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (server == null) {
            server = (MBeanServer)ctx.lookup("java:comp/jmx/runtime");
        }
        return server;
    }

    private static class MBeanServerNotificationListener
    implements NotificationListener {
        Logger logger = Logger.getLogger(JrfUtils.JRF_LOGGER);

        private MBeanServerNotificationListener() {
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            if (notification instanceof MBeanServerNotification) {
                MBeanServerNotification msnotification = (MBeanServerNotification)notification;
                String nType = msnotification.getType();
                ObjectName mbn = msnotification.getMBeanName();
                String mbnType = mbn.getKeyProperty("Type");
                if (nType.equals("JMX.mbean.unregistered") && this.isSupportMbeanType(mbnType)) {
                    this.releaseApacheLog(Thread.currentThread().getContextClassLoader());
                }
            }
        }

        private boolean isSupportMbeanType(String mbnType) {
            return "ApplicationRuntime".equals(mbnType) || "EJBComponentRuntime".equals(mbnType) || "WebAppComponentRuntime".equals(mbnType) || "ServletRuntime".equals(mbnType);
        }

        private void releaseApacheLog(ClassLoader aClassloader) {
            Class<?> logFactoryClass = null;
            try {
                logFactoryClass = aClassloader.loadClass("org.apache.commons.logging.LogFactory");
            }
            catch (ClassNotFoundException e) {
                return;
            }
            try {
                Method releaseMethod = logFactoryClass.getMethod("release", ClassLoader.class);
                releaseMethod.invoke(null, aClassloader);
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "Apache LogFactory released " + aClassloader);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }
}

