/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.runner;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.RunProcessLifecycleEvent;
import oracle.ide.runner.RunProcessLifecycleListener;
import oracle.ide.runner.Runner;
import oracle.ideimpl.runner.RunnerBundle;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Log;

public class TerminateRunProcessButtons
implements Controller,
RunProcessLifecycleListener {
    private static final String TERMINATE_RUN_PROCESS_CMD_PREFIX = "TerminateRunProcessButtonsCommand";
    private static int cmdCount = 0;
    private static TerminateRunProcessButtons instance;
    private static Map<TerminateButton, Integer> terminateButtons;
    private static final Log logger;

    private TerminateRunProcessButtons() {
        Runner.getRunner().addLifecycleListener(this);
    }

    private static synchronized TerminateRunProcessButtons getInstance() {
        if (instance == null) {
            instance = new TerminateRunProcessButtons();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JComponent getTerminateRunProcessButton(RunProcess runProcess, IdeAction terminateAction) {
        TerminateRunProcessButtons currentInstance = TerminateRunProcessButtons.getInstance();
        IdeAction defaultTerminateAction = null;
        defaultTerminateAction = terminateAction == null || runProcess.canContainRunProcesses() ? currentInstance.createTerminateAction(runProcess) : terminateAction;
        defaultTerminateAction.putValue(TERMINATE_RUN_PROCESS_CMD_PREFIX, (Object)System.identityHashCode(runProcess));
        if (runProcess.canContainRunProcesses()) {
            TerminateFamilyButton button = new TerminateFamilyButton(RunnerBundle.get("TERMINATE"), OracleIcons.getIcon((String)"terminate.png"), runProcess, defaultTerminateAction);
            Map<TerminateButton, Integer> map = terminateButtons;
            synchronized (map) {
                terminateButtons.put(button, null);
            }
            return button;
        }
        ToolButton toolButton = new ToolButton((Action)defaultTerminateAction);
        if (terminateAction != defaultTerminateAction) {
            toolButton.setIcon(OracleIcons.getIcon((String)"terminate.png"));
            toolButton.setToolTipText(RunnerBundle.get("TERMINATE"));
        }
        return toolButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JComponent getTerminateRunProcessesButton(boolean singleProcessOnly) {
        TerminateRunProcessButtons.getInstance();
        if (singleProcessOnly) {
            TerminateOneButton button = new TerminateOneButton(RunnerBundle.get("TERMINATE"), OracleIcons.getIcon((String)"terminate.png"));
            Map<TerminateButton, Integer> map = terminateButtons;
            synchronized (map) {
                terminateButtons.put(button, null);
            }
            return button;
        }
        TerminateAllButton button = new TerminateAllButton(RunnerBundle.get("TERMINATE"), OracleIcons.getIcon((String)"terminate.png"));
        Map<TerminateButton, Integer> map = terminateButtons;
        synchronized (map) {
            terminateButtons.put(button, null);
        }
        return button;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        RunProcess runProcess = TerminateRunProcessButtons.actionToRunProcess((Action)action);
        if (runProcess != null) {
            runProcess.terminate();
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        RunProcess runProcess = TerminateRunProcessButtons.actionToRunProcess((Action)action);
        if (runProcess != null) {
            action.setEnabled(runProcess.canTerminate());
            return true;
        }
        return false;
    }

    @Override
    public void preparing(RunProcessLifecycleEvent event, boolean userCanTerminate) {
        if (!userCanTerminate) {
            return;
        }
        final RunProcess runProcess = event.getRunProcess();
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map<TerminateButton, Integer> map = terminateButtons;
                synchronized (map) {
                    Set<TerminateButton> currentButtons = terminateButtons.keySet();
                    for (TerminateButton button : currentButtons) {
                        if (button == null) continue;
                        button.processPreparingToStart(runProcess);
                    }
                }
            }
        });
    }

    @Override
    public void finishedPreparing(RunProcessLifecycleEvent event) {
        final RunProcess runProcess = event.getRunProcess();
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map<TerminateButton, Integer> map = terminateButtons;
                synchronized (map) {
                    Set<TerminateButton> currentButtons = terminateButtons.keySet();
                    for (TerminateButton button : currentButtons) {
                        if (button == null) continue;
                        button.processFinishedPreparing(runProcess);
                    }
                }
            }
        });
    }

    @Override
    public void started(RunProcessLifecycleEvent event, boolean userCanTerminate) {
        if (!userCanTerminate) {
            return;
        }
        final RunProcess runProcess = event.getRunProcess();
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map<TerminateButton, Integer> map = terminateButtons;
                synchronized (map) {
                    Set<TerminateButton> currentButtons = terminateButtons.keySet();
                    for (TerminateButton button : currentButtons) {
                        if (button == null) continue;
                        button.processStarted(runProcess);
                    }
                }
            }
        });
    }

    @Override
    public void finished(RunProcessLifecycleEvent event) {
        final RunProcess runProcess = event.getRunProcess();
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map<TerminateButton, Integer> map = terminateButtons;
                synchronized (map) {
                    Set<TerminateButton> currentButtons = terminateButtons.keySet();
                    for (TerminateButton button : currentButtons) {
                        if (button == null) continue;
                        button.processFinished(runProcess);
                    }
                }
            }
        });
    }

    private static synchronized String getUniqueCommandString() {
        return TERMINATE_RUN_PROCESS_CMD_PREFIX + cmdCount++;
    }

    private IdeAction createTerminateAction(RunProcess runProcess) {
        String cmdString = TerminateRunProcessButtons.getUniqueCommandString();
        int cmdId = Ide.findOrCreateCmdID((String)cmdString);
        IdeAction terminateAction = IdeAction.get((int)cmdId, null, (String)runProcess.getShortLabel(), null, null, (Icon)runProcess.getIcon(), null, (boolean)true);
        terminateAction.addController((Controller)this);
        return terminateAction;
    }

    private static RunProcess actionToRunProcess(Action action) {
        Object processID;
        if (action != null && (processID = action.getValue(TERMINATE_RUN_PROCESS_CMD_PREFIX)) instanceof Integer) {
            return TerminateRunProcessButtons.idToRunProcess((Integer)processID);
        }
        return null;
    }

    private static RunProcess idToRunProcess(int runProcessID) {
        RunProcess[] runProcesses;
        for (RunProcess runProcess : runProcesses = Runner.getRunner().getRunProcesses()) {
            if (runProcessID != System.identityHashCode(runProcess)) continue;
            return runProcess;
        }
        return null;
    }

    private static IdeAction createAction(RunProcess runProcess) {
        IdeAction newAction = TerminateRunProcessButtons.getInstance().createTerminateAction(runProcess);
        newAction.putValue(TERMINATE_RUN_PROCESS_CMD_PREFIX, (Object)System.identityHashCode(runProcess));
        return newAction;
    }

    static {
        terminateButtons = new WeakHashMap<TerminateButton, Integer>();
        logger = new Log("TRPB");
    }

    private static class TerminateFamilyButton
    extends TerminateAllButton {
        private TerminateFamilyButton(String toolTipText, Icon icon, RunProcess runProcess, IdeAction terminateAction) {
            super(toolTipText, icon);
            this.addProcess(runProcess, terminateAction);
        }

        @Override
        protected void sortActions(List<Action> currentActions) {
            Collections.sort(currentActions, new Comparator<Action>(){

                @Override
                public int compare(Action o1, Action o2) {
                    RunProcess runProcess1 = TerminateRunProcessButtons.actionToRunProcess(o1);
                    RunProcess runProcess2 = TerminateRunProcessButtons.actionToRunProcess(o2);
                    if (runProcess1 == null || runProcess2 == null) {
                        return 0;
                    }
                    if (runProcess1.canContainRunProcesses() != runProcess2.canContainRunProcesses()) {
                        if (runProcess1.canContainRunProcesses()) {
                            return 1;
                        }
                        return -1;
                    }
                    return runProcess1.getShortLabel().compareTo(runProcess2.getShortLabel());
                }
            });
        }

        @Override
        public synchronized void processPreparingToStart(RunProcess newProcess) {
            if (newProcess.getContainer() != null && this.runProcessIDs.contains(System.identityHashCode(newProcess.getContainer()))) {
                this.addProcess(newProcess, null);
                logger.trace("TerminateFamilyButton sees " + newProcess.getShortLabel() + " preparing; runProccessIDs size " + this.runProcessIDs.size());
            }
        }

        @Override
        public synchronized void processStarted(RunProcess newProcess) {
            if (newProcess.getContainer() != null && this.runProcessIDs.contains(System.identityHashCode(newProcess.getContainer()))) {
                this.addProcess(newProcess, null);
                logger.trace("TerminateFamilyButton sees " + newProcess.getShortLabel() + " started; runProccessIDs size " + this.runProcessIDs.size());
            }
        }

        @Override
        protected boolean shouldShow() {
            boolean shouldShow = this.listActions().size() > 0;
            logger.trace("TerminateFamilyButton sets visibility " + shouldShow);
            return shouldShow;
        }
    }

    private static class TerminateOneButton
    extends ToolButton
    implements TerminateButton {
        private Set<Integer> runProcessIDs = new HashSet<Integer>();
        private boolean isPreparing;

        private TerminateOneButton(String toolTipText, Icon icon) {
            super(null);
            this.setVisible(false);
            this.setIcon(icon);
            this.setToolTipText(toolTipText);
        }

        @Override
        public synchronized void processPreparingToStart(RunProcess runProcess) {
            Integer processID = System.identityHashCode(runProcess);
            this.runProcessIDs.add(processID);
            this.isPreparing = true;
            logger.trace("TerminateOneButton sees " + runProcess.getShortLabel() + " preparing; runProccessIDs size " + this.runProcessIDs.size());
            this.showButton();
        }

        @Override
        public synchronized void processFinishedPreparing(RunProcess runProcess) {
            Integer processID = System.identityHashCode(runProcess);
            this.runProcessIDs.remove(processID);
            this.isPreparing = false;
            logger.trace("TerminateOneButton sees " + runProcess.getShortLabel() + " finished preparing; runProccessIDs size " + this.runProcessIDs.size());
            this.showButton();
        }

        @Override
        public synchronized void processStarted(RunProcess runProcess) {
            Integer processID = System.identityHashCode(runProcess);
            this.runProcessIDs.add(processID);
            logger.trace("TerminateOneButton sees " + runProcess.getShortLabel() + " started; runProccessIDs size " + this.runProcessIDs.size());
            this.showButton();
        }

        @Override
        public synchronized void processFinished(RunProcess runProcess) {
            Integer processID = System.identityHashCode(runProcess);
            this.runProcessIDs.remove(processID);
            logger.trace("TerminateOneButton sees " + runProcess.getShortLabel() + " finished; runProccessIDs size " + this.runProcessIDs.size());
            this.showButton();
        }

        private void showButton() {
            RunProcess runProcess;
            if (this.runProcessIDs.size() == 1 && (runProcess = TerminateRunProcessButtons.idToRunProcess(this.runProcessIDs.iterator().next())) != null && !runProcess.canContainRunProcesses()) {
                IdeAction action = TerminateRunProcessButtons.createAction(runProcess);
                this.setAction((Action)action);
                String template = RunnerBundle.get("TERMINATE_PROCESS");
                String toolTip = MessageFormat.format(template, runProcess.getShortLabel());
                this.setToolTipText(toolTip);
                this.setIcon(OracleIcons.getIcon((String)"terminate.png"));
                this.setVisible(true);
                logger.trace("TerminateOneButton visibility true (single run process without children)");
                return;
            }
            this.setVisible(false);
            logger.trace("TerminateOneButton visibility false (multiple run processes, or one with children)");
        }
    }

    private static class TerminateAllButton
    extends MenuToolButton
    implements TerminateButton {
        protected Set<Integer> runProcessIDs = new HashSet<Integer>();
        private String toolTipText;
        private boolean isPreparing = false;

        private TerminateAllButton(String toolTipText, Icon icon) {
            super((ToggleAction)((IdeAction)null));
            this.toolTipText = toolTipText.replace('&', ' ');
            this.setVisible(false);
            this.setIcon(icon);
            this.setToolTipText(toolTipText);
        }

        public void setToolTipText(String text) {
            String tip = this.toolTipText != null ? this.toolTipText : text;
            tip = tip.replace('&', ' ');
            super.setToolTipText(tip);
        }

        protected void sortActions(List<Action> currentActions) {
            Collections.sort(currentActions, new Comparator<Action>(){

                @Override
                public int compare(Action o1, Action o2) {
                    RunProcess runProcess1 = TerminateRunProcessButtons.actionToRunProcess(o1);
                    RunProcess runProcess2 = TerminateRunProcessButtons.actionToRunProcess(o2);
                    if (runProcess1 == null || runProcess2 == null) {
                        return 0;
                    }
                    return runProcess1.getShortLabel().compareTo(runProcess2.getShortLabel());
                }
            });
        }

        private void setActions() {
            List<Action> currentActions = this.listActions();
            this.sortActions(currentActions);
            this.removeAllPopupItems();
            for (Action action : currentActions) {
                this.addPopupItem((ToggleAction)action);
            }
        }

        public Action[] getActions() {
            List<Action> actions = this.listActions();
            return actions.toArray(new Action[actions.size()]);
        }

        protected List<Action> listActions() {
            ArrayList<Action> actions = new ArrayList<Action>();
            JPopupMenu popup = this.getPopupMenu();
            MenuElement[] elements = popup.getSubElements();
            for (int i = 0; i < elements.length; ++i) {
                JMenuItem item;
                Action itemAction;
                Component c = elements[i].getComponent();
                if (!(c instanceof JMenuItem) || (itemAction = (item = (JMenuItem)c).getAction()) == null) continue;
                actions.add(itemAction);
            }
            return actions;
        }

        protected boolean shouldShow() {
            RunProcess runProcess;
            if (this.runProcessIDs.size() > 1) {
                logger.trace("TerminateAllButton visibility = true (multiple run processes)");
                return true;
            }
            if (this.runProcessIDs.size() == 1 && ((runProcess = TerminateRunProcessButtons.idToRunProcess(this.runProcessIDs.iterator().next())) == null || runProcess.canContainRunProcesses())) {
                logger.trace("TerminateAllButton visibility = true (single run process with children)");
                return true;
            }
            logger.trace("TerminateAllButton visibility = false (single run process with no children)");
            return false;
        }

        protected synchronized void addProcess(RunProcess runProcess, IdeAction action) {
            if (this.runProcessIDs.isEmpty()) {
                this.removeAllPopupItems();
            }
            this.runProcessIDs.add(System.identityHashCode(runProcess));
            IdeAction newAction = action;
            if (newAction == null) {
                newAction = TerminateRunProcessButtons.createAction(runProcess);
            }
            this.addPopupItem((ToggleAction)newAction);
            this.setActions();
            this.setVisible(this.shouldShow());
        }

        @Override
        public synchronized void processPreparingToStart(RunProcess newProcess) {
            this.isPreparing = true;
            this.addProcess(newProcess, null);
            logger.trace("TerminateAllButton sees " + newProcess.getShortLabel() + " preparing; runProccessIDs size " + this.runProcessIDs.size());
        }

        public synchronized void removeAction(Integer finishedProcessID) {
            List<Action> currentActions = this.listActions();
            logger.trace("TerminateAllButton before removing completed process has " + currentActions.size() + " actions");
            for (Action currentAction : currentActions) {
                int commandId;
                String commandName;
                if (!finishedProcessID.equals(currentAction.getValue(TerminateRunProcessButtons.TERMINATE_RUN_PROCESS_CMD_PREFIX))) continue;
                IdeAction currentIdeAction = (IdeAction)currentAction;
                this.removePopupItem((ToggleAction)currentIdeAction);
                logger.trace("TerminateAllButton finds and removes " + currentIdeAction.getCommand() + " from action list");
                JPopupMenu popup = this.getPopupMenu();
                if (popup.getComponentCount() <= 1) {
                    popup.setVisible(false);
                }
                if ((commandName = Ide.findCmdName((int)(commandId = currentIdeAction.getCommandId()))) != null && commandName.startsWith(TerminateRunProcessButtons.TERMINATE_RUN_PROCESS_CMD_PREFIX)) {
                    currentIdeAction.removeController((Controller)TerminateRunProcessButtons.getInstance());
                    IdeAction.remove((int)commandId);
                }
                this.setVisible(this.shouldShow());
                if (this.shouldShow() || popup == null) break;
                popup.setVisible(false);
                break;
            }
        }

        @Override
        public synchronized void processFinishedPreparing(RunProcess newProcess) {
            Integer processID = System.identityHashCode(newProcess);
            this.runProcessIDs.remove(processID);
            this.isPreparing = false;
            logger.trace("TerminateAllButton sees " + newProcess.getShortLabel() + " finished preparing; runProccessIDs size " + this.runProcessIDs.size());
            this.removeAction(processID);
        }

        @Override
        public synchronized void processStarted(RunProcess newProcess) {
            this.addProcess(newProcess, null);
            logger.trace("TerminateAllButton sees " + newProcess.getShortLabel() + " started; runProccessIDs size " + this.runProcessIDs.size());
        }

        @Override
        public synchronized void processFinished(RunProcess finishedProcess) {
            Integer finishedProcessID = System.identityHashCode(finishedProcess);
            if (this.runProcessIDs.contains(finishedProcessID)) {
                this.runProcessIDs.remove(finishedProcessID);
                logger.trace("TerminateAllButton sees " + finishedProcess.getShortLabel() + " finished; runProccessIDs size " + this.runProcessIDs.size());
                this.removeAction(finishedProcessID);
            }
        }
    }

    private static interface TerminateButton {
        public void processPreparingToStart(RunProcess var1);

        public void processFinishedPreparing(RunProcess var1);

        public void processStarted(RunProcess var1);

        public void processFinished(RunProcess var1);
    }
}

