/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.runner;

public class SmartExpression {
    private String expression;
    private StringBuilder expressionBuilder;
    private boolean isDeclaration;

    public SmartExpression(String expression) {
        this.expression = expression;
        this.expressionBuilder = null;
        this.isDeclaration = false;
    }

    public SmartExpression(StringBuilder expressionBuilder) {
        this.expression = null;
        this.expressionBuilder = expressionBuilder;
        this.isDeclaration = false;
    }

    protected SmartExpression() {
    }

    public String getExpression() {
        if (this.expression != null) {
            return this.expression;
        }
        if (this.expressionBuilder != null) {
            return this.expressionBuilder.toString();
        }
        return null;
    }

    public StringBuilder getExpressionBuilder() {
        if (this.expressionBuilder == null) {
            if (this.expression == null) {
                this.expressionBuilder = new StringBuilder();
            } else {
                this.expressionBuilder = new StringBuilder(this.expression.toString());
                this.expression = null;
            }
        }
        return this.expressionBuilder;
    }

    public boolean isDeclaration() {
        return this.isDeclaration;
    }

    public void setDeclaration(boolean isDeclaration) {
        this.isDeclaration = isDeclaration;
    }

    public String toString() {
        return this.getExpression();
    }

    public int hashCode() {
        return this.getExpression().hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof SmartExpression) {
            SmartExpression otherExp = (SmartExpression)other;
            if (this.getExpression() == null) {
                return otherExp.getExpression() == null;
            }
            return this.getExpression().equals(otherExp.getExpression());
        }
        return false;
    }
}

