/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.runner;

import java.io.File;
import java.net.URL;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.RunMgrArb;
import oracle.ide.runner.RunLogPage;
import oracle.ide.runner.RunProcess;
import oracle.ide.util.Assert;
import oracle.ide.util.ExecUtil;

public class Starter {
    protected RunProcess runProcess;
    protected Process process;
    protected Exception startException;
    private volatile ShutdownHookThread shutdownHookThread;
    private Thread waitForProcess;
    private volatile Integer exitCode;
    private volatile boolean terminated;

    protected Starter(RunProcess runProcess) {
        this.runProcess = runProcess;
    }

    public String[] getStartEnvironmentParams() {
        return this.runProcess.getStartEnvironmentParams();
    }

    public String[] getTerminateEnvironmentParams() {
        return null;
    }

    public File getStartDirectory() {
        return this.runProcess.getStartDirectory();
    }

    public String[] getStartCommand() {
        return this.runProcess.getStartCommand();
    }

    public Boolean reuseLogPage(RunLogPage runLogPage) {
        return null;
    }

    public boolean canStart(List errors) {
        Project project = this.runProcess.getProject();
        if (project == null || project == Ide.getDefaultProject()) {
            String error = RunMgrArb.getString((int)2);
            errors.add(error);
            return false;
        }
        File dir = this.getStartDirectory();
        if (!(dir == null || dir.isDirectory() && dir.exists())) {
            String error = RunMgrArb.format((int)3, (Object)dir.toString());
            errors.add(error);
            return false;
        }
        return true;
    }

    public boolean mustPrepareToStart() {
        return false;
    }

    public boolean prepareToStart() {
        return true;
    }

    private File getStartDirectoryOrProjectDirectory() {
        File dir = this.getStartDirectory();
        if (dir == null && !this.runProcess.suppressDirectoryDefault()) {
            try {
                URL parentURL;
                URL projectURL;
                Project project = this.runProcess.getProject();
                if (project != null && (projectURL = project.getURL()) != null && projectURL.getProtocol().equals("file") && (parentURL = URLFileSystem.getParent((URL)projectURL)) != null) {
                    dir = new File(parentURL.getPath());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dir;
    }

    public boolean start() {
        Assert.check((this.process == null ? 1 : 0) != 0, (String)"Process already started");
        this.startException = null;
        String[] command = this.getStartCommand();
        if (command != null && command.length > 0) {
            command = ExecUtil.cleanUpCommand((String[])command);
            this.runProcess.logStartDirectory();
            this.runProcess.logCommandString(command);
            for (int i = 0; i < command.length; ++i) {
                command[i] = ExecUtil.adjustArgument((String)command[i]);
            }
            command = ExecUtil.cleanUpCommand((String[])command);
            if (this.runProcess.showStartStatus()) {
                String status = RunMgrArb.format((int)6, (Object)this.runProcess.getShortLabel());
                Ide.getStatusBar().setText(status);
                this.runProcess.updateProgressHandle(status);
            }
            Runtime runtime = Runtime.getRuntime();
            try {
                try {
                    this.process = runtime.exec(command, this.getStartEnvironmentParams(), this.getStartDirectoryOrProjectDirectory());
                }
                catch (NoSuchMethodError e) {
                    this.process = runtime.exec(command);
                }
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
                this.startException = e;
                String error = RunMgrArb.format((int)5, (Object)this.runProcess.getShortLabel(), (Object)e.toString());
                this.runProcess.log(error);
            }
            if (this.process != null) {
                this.shutdownHookThread = new ShutdownHookThread();
                try {
                    runtime.addShutdownHook(this.shutdownHookThread);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                this.runProcess.redirectOutput(this.process.getInputStream(), this.process.getErrorStream());
                this.runProcess.redirectInput(this.process.getOutputStream());
                this.waitForProcess = new Thread("WaitForProcess"){

                    @Override
                    public void run() {
                        try {
                            Starter.this.exitCode = Starter.this.process.waitFor();
                            if (Starter.this.shutdownHookThread != null) {
                                Starter.this.shutdownHookThread.clear();
                            }
                            Starter.this.runProcess.finishRedirectOutput();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    Starter.this.runProcess.finished();
                                    Starter.this.finished();
                                    if (Starter.this.runProcess.showStartStatus()) {
                                        String status = RunMgrArb.format((int)21, (Object)Starter.this.runProcess.getShortLabel());
                                        Ide.getStatusBar().setText(status);
                                        if (Starter.this.runProcess.isProgressHandleActive()) {
                                            Starter.this.runProcess.updateProgressHandle(status);
                                            Starter.this.runProcess.finishProgressHandle();
                                        }
                                    }
                                }
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                this.waitForProcess.start();
            }
        }
        return this.process != null;
    }

    public int waitForProcess() {
        if (this.waitForProcess != null) {
            try {
                this.waitForProcess.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.exitCode != null) {
            return this.exitCode;
        }
        return -1;
    }

    public Integer getExitCode() {
        if (!this.terminated) {
            return this.exitCode;
        }
        return null;
    }

    public Process getProcess() {
        return this.process;
    }

    public Exception getStartException() {
        return this.startException;
    }

    public String[] getTerminateCommand() {
        return this.runProcess.getTerminateCommand();
    }

    public boolean canTerminateGracefully() {
        return false;
    }

    public void terminateGracefully() {
        Assert.check((this.process != null ? 1 : 0) != 0, (String)"Process not yet started");
        this.startException = null;
        String[] command = this.getTerminateCommand();
        if (command != null && command.length > 0) {
            command = ExecUtil.cleanUpCommand((String[])command);
            this.runProcess.logStartDirectory();
            this.runProcess.logCommandString(command);
            for (int i = 0; i < command.length; ++i) {
                command[i] = ExecUtil.adjustArgument((String)command[i]);
            }
            command = ExecUtil.cleanUpCommand((String[])command);
            if (this.runProcess.showStartStatus()) {
                String status = RunMgrArb.format((int)20, (Object)this.runProcess.getShortLabel());
                Ide.getStatusBar().setText(status);
                if (this.runProcess.isProgressHandleActive()) {
                    this.runProcess.updateProgressHandle(status);
                    this.runProcess.finishProgressHandle();
                }
            }
            Runtime runtime = Runtime.getRuntime();
            try {
                Process termProcess;
                try {
                    termProcess = runtime.exec(command, this.getTerminateEnvironmentParams(), this.getStartDirectoryOrProjectDirectory());
                }
                catch (NoSuchMethodError e) {
                    termProcess = runtime.exec(command);
                }
                if (termProcess != null) {
                    this.runProcess.redirectOutput(termProcess.getInputStream(), termProcess.getErrorStream());
                    this.runProcess.redirectInput(termProcess.getOutputStream());
                }
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
                this.startException = e;
            }
        }
    }

    public boolean canTerminate() {
        return this.process != null;
    }

    public void terminate() {
        if (this.process != null) {
            this.terminated = true;
            this.process.destroy();
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    this.waitForProcess.join();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void finished() {
    }

    public boolean isStartOnly() {
        return false;
    }

    public boolean canContainRunProcesses() {
        return false;
    }

    private class ShutdownHookThread
    extends Thread {
        ShutdownHookThread() {
            super("RunnerShutdownHook");
        }

        @Override
        public void run() {
            Process p;
            Starter.this.shutdownHookThread = null;
            if (Starter.this.exitCode == null && (p = Starter.this.process) != null) {
                p.destroy();
            }
        }

        private void clear() {
            try {
                Runtime.getRuntime().removeShutdownHook(Starter.this.shutdownHookThread);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.start();
        }
    }
}

