/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.proxy;

import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.Deque;
import java.util.EmptyStackException;
import java.util.logging.Level;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import oracle.dbtools.raptor.proxy.ProxyLogger;
import oracle.dbtools.raptor.proxy.ProxyUtils;

public class MethodTracker {
    private static EventListenerList listenerList = new EventListenerList();
    private static final ThreadLocal<MethodTracker> instance = new ThreadLocal<MethodTracker>(){

        @Override
        protected MethodTracker initialValue() {
            return new MethodTracker();
        }
    };
    private final Deque<CallMetrics> tstack = new ArrayDeque<CallMetrics>();

    private MethodTracker() {
    }

    public static MethodTracker getInstance() {
        return instance.get();
    }

    public static void addChangeListener(ProxyLogger proxyLogger) {
        listenerList.add(ProxyLogger.class, proxyLogger);
    }

    public static void removeChangeListener(ProxyLogger proxyLogger) {
        listenerList.remove(ProxyLogger.class, proxyLogger);
    }

    public static ChangeListener[] getChangeListeners() {
        return (ChangeListener[])listenerList.getListeners(ChangeListener.class);
    }

    private static void fireStateChanged(ChangeEvent changeEvent) {
        Object[] objectArray = listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ProxyLogger.class) continue;
            ((ProxyLogger)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    public CallMetrics methodCalled(Method method, Object object, Object[] objectArray) {
        return this.methodCalled(Action.CREATE, method, object, objectArray);
    }

    public CallMetrics methodCalledQuiet(Method method, Object object, Object[] objectArray) {
        return this.methodCalled(Action.CREATE_QUIET, method, object, objectArray);
    }

    protected CallMetrics methodCalled(Action action, Method method, Object object, Object[] objectArray) {
        CallMetrics callMetrics = this.getCallMetrics(method, action);
        callMetrics.setMethod(method);
        callMetrics.setReceiver(object);
        callMetrics.setArgs(objectArray);
        callMetrics.setState(State.CALLED);
        return callMetrics;
    }

    public CallMetrics methodReturned(Method method, Object object, Throwable throwable) {
        long l = new Date().getTime();
        return this.methodReturned(method, object, throwable, l);
    }

    public CallMetrics methodReturned(Method method, Object object, Throwable throwable, long l) {
        CallMetrics callMetrics = this.getCallMetrics(method, Action.POLL);
        if (callMetrics != null) {
            callMetrics.setEndTime(l);
            callMetrics.setResult(object);
            callMetrics.setException(throwable);
            callMetrics.setState(State.RETURNED);
        }
        return callMetrics;
    }

    protected CallMetrics getCallMetrics(Method method, Action action) {
        CallMetrics callMetrics = null;
        boolean bl = false;
        switch (action) {
            case CREATE_QUIET: {
                bl = true;
            }
            case CREATE: {
                CallMetrics callMetrics2;
                if (this.tstack.size() != 0 && (callMetrics2 = this.tstack.getFirst()) != null) {
                    callMetrics2.setAtomic(false);
                }
                callMetrics = new CallMetrics(bl);
                this.tstack.push(callMetrics);
                break;
            }
            case PEEK: {
                try {
                    callMetrics = this.tstack.peek();
                }
                catch (EmptyStackException emptyStackException) {}
                break;
            }
            case POLL: {
                try {
                    callMetrics = this.tstack.poll();
                    if (callMetrics.getMethod() == method) break;
                    this.tstack.push(callMetrics);
                    callMetrics = null;
                    break;
                }
                catch (EmptyStackException emptyStackException) {
                    // empty catch block
                }
            }
        }
        return callMetrics;
    }

    public static enum Action {
        PEEK,
        POLL,
        CREATE,
        CREATE_QUIET;

    }

    public static class CallMetrics {
        private final boolean quiet;
        private State state;
        private Long startTime;
        private Long endTime;
        private Method m;
        private Object receiver;
        private Object[] args;
        private Object result;
        private Throwable ex;
        private Level logLevel;
        private boolean atomic;
        private StackTraceElement[] stackTrace;
        private StackTraceElement significantCaller;

        private CallMetrics(boolean bl) {
            this.quiet = bl;
            this.state = null;
            this.startTime = null;
            this.endTime = null;
            this.m = null;
            this.receiver = null;
            this.args = null;
            this.result = null;
            this.logLevel = ProxyLogger.DEFAULT_LOG_LEVEL;
            this.ex = null;
            this.atomic = true;
            this.stackTrace = null;
            this.significantCaller = null;
        }

        public boolean getQuiet() {
            return this.quiet;
        }

        public State getState() {
            return this.state;
        }

        private void setState(State state) {
            if (this.state != state) {
                this.state = state;
                if (!this.quiet) {
                    MethodTracker.fireStateChanged(new ChangeEvent(this));
                }
            }
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long l) {
            this.startTime = l;
        }

        public long getEndTime() {
            return this.endTime;
        }

        private void setEndTime(long l) {
            this.endTime = l;
        }

        public long getElapsed() {
            return this.getEndTime() - this.getStartTime();
        }

        public long getElapsed(long l) {
            return l - this.getStartTime();
        }

        private void setMethod(Method method) {
            this.m = method;
        }

        public Method getMethod() {
            return this.m;
        }

        private void setReceiver(Object object) {
            this.receiver = object;
        }

        public Object getReceiver() {
            return this.receiver;
        }

        private void setArgs(Object[] objectArray) {
            this.args = objectArray;
        }

        public Object[] getArgs() {
            return this.args;
        }

        private void setResult(Object object) {
            this.result = object;
        }

        public Object getResult() {
            return this.result;
        }

        private void setException(Throwable throwable) {
            this.ex = throwable;
        }

        public Throwable getException() {
            return this.ex;
        }

        private void setLogLevel(Level level) {
            this.logLevel = level;
        }

        public Level getLogLevel() {
            return this.logLevel;
        }

        public void setAtomic(boolean bl) {
            if (this.atomic != this.atomic) {
                this.atomic = bl;
                if (!this.quiet) {
                    MethodTracker.fireStateChanged(new ChangeEvent(this));
                }
            }
        }

        public boolean getAtomic() {
            return this.atomic;
        }

        public void setStackTrace(StackTraceElement[] stackTraceElementArray) {
            this.stackTrace = stackTraceElementArray;
        }

        public StackTraceElement[] getStackTrace() {
            return this.stackTrace;
        }

        public StackTraceElement getSignificantCaller() {
            if (this.significantCaller == null) {
                this.significantCaller = ProxyUtils.getSignificantCaller(this.stackTrace);
            }
            return this.significantCaller;
        }
    }

    public static enum State {
        CALLED,
        STARTED,
        COMPLETED,
        RETURNED;

    }
}

