/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.samples;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class RSSReader {
    public static void main(String[] stringArray) {
        RSSReader rSSReader = new RSSReader();
        try {
            XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
            XmlPullParser xmlPullParser = xmlPullParserFactory.newPullParser();
            String string = stringArray[0];
            InputStreamReader inputStreamReader = new InputStreamReader(new URL(string).openStream());
            xmlPullParser.setInput(inputStreamReader);
            XmlSerializer xmlSerializer = xmlPullParserFactory.newSerializer();
            xmlSerializer.setOutput(new OutputStreamWriter(System.out));
            rSSReader.convertRSSToHtml(xmlPullParser, xmlSerializer);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void convertRSSToHtml(XmlPullParser xmlPullParser, XmlSerializer xmlSerializer) throws IOException, XmlPullParserException {
        if (xmlPullParser.nextTag() == 2 && xmlPullParser.getName().equals("rss")) {
            xmlSerializer.startTag(null, "html");
            if (xmlPullParser.nextTag() == 2 && xmlPullParser.getName().equals("channel")) {
                this.convertChannelToHtml(xmlPullParser, xmlSerializer);
                xmlPullParser.require(3, null, "channel");
            } else {
                new RuntimeException("expectd channel start tag not " + xmlPullParser.getPositionDescription());
            }
        } else {
            throw new RuntimeException("expectd an RSS document at" + xmlPullParser.getPositionDescription());
        }
        xmlPullParser.nextTag();
        xmlPullParser.require(3, null, "rss");
        xmlSerializer.endTag(null, "html");
        xmlSerializer.flush();
    }

    public void convertChannelToHtml(XmlPullParser xmlPullParser, XmlSerializer xmlSerializer) throws IOException, XmlPullParserException {
        boolean bl = false;
        while (xmlPullParser.nextTag() != 3) {
            if (xmlPullParser.getName().equals("title") && !bl) {
                xmlSerializer.startTag(null, "head");
                xmlSerializer.startTag(null, "title").text(xmlPullParser.nextText()).endTag(null, "title");
                xmlSerializer.endTag(null, "head");
                continue;
            }
            if (xmlPullParser.getName().equals("item")) {
                if (!bl) {
                    xmlSerializer.startTag(null, "body");
                    bl = true;
                }
                this.convertItemToHtml(xmlPullParser, xmlSerializer);
                continue;
            }
            int n = 1;
            while (n > 0) {
                switch (xmlPullParser.next()) {
                    case 2: {
                        ++n;
                        break;
                    }
                    case 3: {
                        --n;
                    }
                }
            }
        }
        if (bl) {
            xmlSerializer.endTag(null, "body");
        }
    }

    public void convertItemToHtml(XmlPullParser xmlPullParser, XmlSerializer xmlSerializer) throws IOException, XmlPullParserException {
        xmlSerializer.startTag(null, "p");
        String string = null;
        String string2 = null;
        String string3 = null;
        while (xmlPullParser.nextTag() != 3) {
            if (xmlPullParser.getName().equals("title")) {
                string = xmlPullParser.nextText();
                continue;
            }
            if (xmlPullParser.getName().equals("link")) {
                string2 = xmlPullParser.nextText();
                continue;
            }
            if (!xmlPullParser.getName().equals("description")) continue;
            string3 = xmlPullParser.nextText();
        }
        xmlSerializer.startTag(null, "a");
        xmlSerializer.attribute(null, "href", string2);
        if (string != null) {
            xmlSerializer.text(string);
        } else {
            xmlSerializer.text(string2);
        }
        xmlSerializer.endTag(null, "a");
        xmlSerializer.startTag(null, "br").endTag(null, "br");
        if (string3 != null) {
            xmlSerializer.text(string3);
        }
        xmlSerializer.endTag(null, "p");
    }
}

