/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.samples;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class BestDeal {
    protected static final String MESSAGE = "The best deal is proposed by {0}. A(n) {1} delivered in {2,number,integer} days for {3,number,currency}";
    protected static final String NAMESPACE_URI = "http://www.psol.com/xbe2/listing8.3";
    public double price = Double.MAX_VALUE;
    public int delivery = Integer.MAX_VALUE;
    public String product = null;
    public String vendor = null;
    protected int targetDelivery;

    public BestDeal(int n) {
        this.targetDelivery = n;
    }

    public void update(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        xmlPullParser.require(0, null, null);
        xmlPullParser.nextTag();
        xmlPullParser.require(2, NAMESPACE_URI, "price-list");
        xmlPullParser.nextTag();
        xmlPullParser.require(2, NAMESPACE_URI, "name");
        this.product = xmlPullParser.nextText();
        xmlPullParser.require(3, NAMESPACE_URI, "name");
        while (xmlPullParser.nextTag() == 2) {
            this.checkVendor(xmlPullParser);
        }
        xmlPullParser.require(3, NAMESPACE_URI, "price-list");
        xmlPullParser.next();
        xmlPullParser.require(1, null, null);
    }

    public void checkVendor(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        xmlPullParser.require(2, NAMESPACE_URI, "vendor");
        String string = null;
        while (xmlPullParser.nextTag() == 2) {
            xmlPullParser.require(2, NAMESPACE_URI, null);
            String string2 = xmlPullParser.getName();
            if (string2.equals("name")) {
                string = xmlPullParser.nextText();
            } else if (string2.equals("price-quote")) {
                int n = Integer.parseInt(xmlPullParser.getAttributeValue("", "delivery"));
                double d = Double.parseDouble(xmlPullParser.nextText());
                if (n < this.targetDelivery && d < this.price) {
                    this.vendor = string;
                    this.price = d;
                    this.delivery = n;
                }
            } else {
                System.out.println("trying to skip unknwon element: " + string2);
                String string3 = xmlPullParser.nextText();
                System.out.println("skipped element content:" + string3);
            }
            xmlPullParser.require(3, NAMESPACE_URI, string2);
        }
        xmlPullParser.require(3, NAMESPACE_URI, "vendor");
    }

    public static void main(String[] stringArray) throws IOException, XmlPullParserException {
        if (stringArray.length < 2) {
            System.out.println("BestDeal <file> <delivery>");
            return;
        }
        BestDeal bestDeal = new BestDeal(Integer.parseInt(stringArray[1]));
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
        xmlPullParserFactory.setNamespaceAware(true);
        XmlPullParser xmlPullParser = xmlPullParserFactory.newPullParser();
        FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
        xmlPullParser.setInput(fileInputStream, null);
        bestDeal.update(xmlPullParser);
        ((InputStream)fileInputStream).close();
        Object[] objectArray = new Object[]{bestDeal.vendor, bestDeal.product, new Integer(bestDeal.delivery), new Double(bestDeal.price)};
        System.out.println(MessageFormat.format(MESSAGE, objectArray));
    }
}

