/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.engine;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.TopicTree;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;
import oracle.help.engine.DataEngine;
import oracle.help.library.Book;

public class TOCEngine
extends DataEngine {
    private static final String TOC_LINE_BRANCH = "BRANCH";
    private static final String TOC_LINE_LEAF = "LEAF";
    private Book _book = null;
    private View _view = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object createDataObject(View view, String basePath, URL url, String encoding) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("Null parameter passed to DataEngine constructor");
        }
        BufferedReader r = this._getBufferedReader(url, encoding);
        Object dataObject = null;
        try {
            dataObject = this.createDataObject(view, basePath, r);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (Exception exception) {}
        }
        return dataObject;
    }

    public Object createDataObject(View view, String basePath, BufferedReader reader) throws IOException {
        Book book = null;
        if (view != null) {
            book = view.getBook();
        }
        TopicTree tree = new TopicTree(book, basePath);
        TopicTreeNode parent = tree.getRoot();
        this.parseTOC(book, view, reader, parent);
        return tree;
    }

    protected void parseTOC(Book book, View view, BufferedReader reader, TopicTreeNode parent) {
        int level = 0;
        int oldlevel = 0;
        String line = "";
        this._book = book;
        this._view = view;
        while (true) {
            try {
                line = reader.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
                line = null;
            }
            if (line == null) break;
            if (line.equals("") || line.charAt(0) == '#') continue;
            StringTokenizer st = new StringTokenizer(line, "|", true);
            try {
                level = Integer.parseInt(st.nextToken().trim());
                if (!st.nextToken().trim().equals("|")) {
                }
            }
            catch (Exception e2) {}
            continue;
            TopicTreeNode node = this._parseLine(st, level);
            if (node == null) continue;
            if (oldlevel == 0 && level != 1) {
                oldlevel = level;
            }
            if (level == oldlevel) {
                parent.addChild(node);
            } else if (level == oldlevel + 1) {
                if (parent.getNumChildren() > 0) {
                    parent = parent.getChildByIndex(parent.getNumChildren() - 1);
                }
                parent.addChild(node);
            } else {
                if (level >= oldlevel) continue;
                for (int i = oldlevel; i > level; --i) {
                    parent = parent.getParent();
                }
                parent.addChild(node);
            }
            oldlevel = level;
        }
    }

    private TopicTreeNode _parseLine(StringTokenizer st, int level) {
        TopicTreeNode node = null;
        try {
            String lineType = st.nextToken().trim();
            if (!st.nextToken().trim().equals("|")) {
                return null;
            }
            if (lineType.equals(TOC_LINE_BRANCH)) {
                node = this._parseBranch(st, level);
                if (node == null) {
                    return null;
                }
            } else if (lineType.equals(TOC_LINE_LEAF)) {
                node = this._parseLeaf(st, level);
                if (node == null) {
                    return null;
                }
            } else {
                node = null;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            node = null;
        }
        return node;
    }

    private TopicTreeNode _parseBranch(StringTokenizer st, int level) {
        TopicTreeNode node = null;
        SimpleTopic topic = null;
        SimpleURLTarget target = null;
        String length = st.nextToken().trim();
        if (!length.equals("|") && !st.nextToken().trim().equals("|")) {
            return null;
        }
        String branchName = st.nextToken().trim();
        topic = new SimpleTopic(branchName);
        if (st.hasMoreTokens() && st.nextToken().trim().equals("|") && st.hasMoreTokens()) {
            String fileName = st.nextToken().trim();
            target = new SimpleURLTarget(this._view, fileName);
            topic.setTarget(target);
        }
        node = new TopicTreeNode(this._view, topic);
        return node;
    }

    private TopicTreeNode _parseLeaf(StringTokenizer st, int level) {
        TopicTreeNode node = null;
        SimpleTopic topic = null;
        SimpleURLTarget target = null;
        String leafName = "";
        String leafUrl = "";
        String length = st.nextToken().trim();
        if (!length.equals("|") && !st.nextToken().trim().equals("|")) {
            return null;
        }
        leafName = st.nextToken().trim();
        if (!st.nextToken().trim().equals("|")) {
            return null;
        }
        leafUrl = st.nextToken().trim();
        topic = new SimpleTopic(leafName);
        target = new SimpleURLTarget(this._view, leafUrl);
        topic.setTarget(target);
        node = new TopicTreeNode(this._view, topic);
        return node;
    }
}

