/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import oracle.adfdtinternal.model.dvt.util.gui.LightWeightComboBox;
import oracle.hcs.util.HyperComboRenderer;
import oracle.hcs.util.HyperLinkControl;
import oracle.hcs.util.HyperParamActionListener;
import oracle.hcs.util.HyperParamColoringHelper;
import oracle.hcs.util.HyperUtil;
import oracle.hcs.util.MouseEventForwarder;

public class HyperLinkCombo
extends LightWeightComboBox
implements HyperLinkControl,
HyperParamColoringHelper,
HyperParamActionListener {
    private boolean m_blnIsHyperLink;
    private boolean m_blnSilent = false;
    private boolean m_blnNotifyListeners = true;
    private HyperLinkComboUI m_hyperLinkComboUI;
    private HyperCursorListener m_hyperCursorListener;
    private int m_intPreviousSelectedIndex;
    private Vector m_disabledItems = new Vector();
    private List<MouseEventForwarder> mouseEventFwdList;

    public HyperLinkCombo() {
        this.initHyperLinkCombo();
    }

    public HyperLinkCombo(ComboBoxModel comboBoxModel) {
        super(comboBoxModel);
        this.initHyperLinkCombo();
    }

    public HyperLinkCombo(Object[] objectArray) {
        super(objectArray);
        this.initHyperLinkCombo();
    }

    public HyperLinkCombo(Vector vector) {
        super(vector);
        this.initHyperLinkCombo();
    }

    public int mouseEventForwarderCount() {
        return this.mouseEventFwdList.size();
    }

    public void disableItem(Object object) {
        int n = HyperUtil.indexOf((JComboBox)((Object)this), object);
        if (n != -1 && !this.m_disabledItems.contains(object)) {
            this.m_disabledItems.addElement(object);
        }
    }

    public void addMouseEventForwarder(MouseEventForwarder mouseEventForwarder) {
        this.mouseEventFwdList.add(mouseEventForwarder);
    }

    public void enableItem(Object object) {
        int n = HyperUtil.indexOf((JComboBox)((Object)this), object);
        if (n != -1) {
            this.m_disabledItems.removeElement(object);
        }
    }

    public Vector getDisabledItems() {
        return this.m_disabledItems;
    }

    @Override
    public void setHyperLink(boolean bl) {
        if (this.m_blnIsHyperLink != bl) {
            if (bl) {
                this.setUI(this.m_hyperLinkComboUI);
                this.addMouseListener(this.m_hyperCursorListener);
            } else {
                this.updateUI();
                this.removeMouseListener(this.m_hyperCursorListener);
            }
            this.m_blnIsHyperLink = bl;
        }
    }

    @Override
    public boolean isHyperLink() {
        return this.m_blnIsHyperLink;
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        super.setModel(comboBoxModel);
        this.updateModel();
    }

    protected void updateModel() {
        ComboBoxModel comboBoxModel = this.getModel();
        this.updateEnabled();
        if (comboBoxModel != null) {
            comboBoxModel.addListDataListener(new ListDataListener(){

                @Override
                public void intervalAdded(ListDataEvent listDataEvent) {
                    HyperLinkCombo.this.updateEnabled();
                }

                @Override
                public void intervalRemoved(ListDataEvent listDataEvent) {
                    HyperLinkCombo.this.updateEnabled();
                }

                @Override
                public void contentsChanged(ListDataEvent listDataEvent) {
                    HyperLinkCombo.this.updateEnabled();
                }
            });
            if (!this.isEnabled()) {
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        this.forwardMouseEvent(mouseEvent);
                    }

                    @Override
                    public void mouseReleased(MouseEvent mouseEvent) {
                        this.forwardMouseEvent(mouseEvent);
                    }

                    private void forwardMouseEvent(MouseEvent mouseEvent) {
                        for (MouseEventForwarder mouseEventForwarder : HyperLinkCombo.this.mouseEventFwdList) {
                            mouseEventForwarder.notifyForwardMouseEvent();
                            mouseEventForwarder.forwardMouseEvent(mouseEvent);
                        }
                    }
                });
            }
        }
    }

    public void setItems(Vector vector) {
        this.setSilent(true);
        super.setModel(new DefaultComboBoxModel(vector));
        this.setSilent(false);
    }

    public void setItems(Object[] objectArray) {
        super.setModel(new DefaultComboBoxModel<Object>(objectArray));
    }

    public void setSelectedIndexSilently(int n) {
        this.m_blnNotifyListeners = false;
        super.setSelectedIndex(n);
        this.m_blnNotifyListeners = true;
    }

    public void restore() {
        this.setSelectedIndex(this.m_intPreviousSelectedIndex);
    }

    public void restoreSilently() {
        this.setSelectedIndexSilently(this.m_intPreviousSelectedIndex);
    }

    public void setSilent(boolean bl) {
        this.m_blnSilent = bl;
    }

    public boolean isSilent() {
        return this.m_blnSilent;
    }

    public void setSelectedIndex(int n) {
        if (!this.m_disabledItems.contains(this.getModel().getElementAt(n))) {
            if (this.m_blnNotifyListeners) {
                this.m_intPreviousSelectedIndex = this.getSelectedIndex();
                this.selectedItemReminder = this.getModel().getSelectedItem();
            }
            super.setSelectedIndex(n);
        }
    }

    public void setSelectedItem(Object object) {
        if (this.m_blnNotifyListeners) {
            this.m_intPreviousSelectedIndex = this.getSelectedIndex();
            this.selectedItemReminder = this.getModel().getSelectedItem();
        }
        super.setSelectedItem(object);
    }

    public void setSelectedItemSilently(Object object) {
        this.m_blnNotifyListeners = false;
        super.setSelectedItem(object);
        this.m_blnNotifyListeners = true;
    }

    protected void selectedItemChanged() {
        Object object = this.getSelectedItem();
        if (object != null && object.equals("|")) {
            this.setSelectedItemSilently(this.selectedItemReminder);
        } else {
            this.revalidate();
            if (this.m_blnNotifyListeners) {
                super.selectedItemChanged();
            }
        }
    }

    private void initHyperLinkCombo() {
        this.setRenderer(new HyperComboRenderer(this));
        this.m_hyperLinkComboUI = new HyperLinkComboUI();
        this.m_hyperCursorListener = new HyperCursorListener();
        this.mouseEventFwdList = new Vector<MouseEventForwarder>();
        this.setHyperLink(true);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("model".equals(propertyChangeEvent.getPropertyName())) {
                    HyperLinkCombo.this.updateModel();
                }
            }
        });
    }

    private void updateEnabled() {
        this.setEnabled(this.getModel().getSize() > 1);
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.m_hyperLinkComboUI.setBackgroundColor(color);
    }

    @Override
    public void actionPerformed() {
        if (this.m_hyperLinkComboUI != null) {
            this.m_hyperLinkComboUI.showComboBoxPopup();
        }
    }

    protected class HyperLinkComboUI
    extends BasicComboBoxUI {
        protected final int POPUP_PADDING = 15;
        protected final int PREF_HEIGHT = 15;
        private Color background = UIManager.getColor("Label.background");

        protected HyperLinkComboUI() {
        }

        @Override
        protected ComboPopup createPopup() {
            HyperComboPopup hyperComboPopup = new HyperComboPopup(this.comboBox);
            hyperComboPopup.getAccessibleContext().setAccessibleParent(this.comboBox);
            String string = UIManager.getLookAndFeel().getClass().getName();
            if (string.equals("oracle.bali.ewt.olaf.OracleLookAndFeel")) {
                hyperComboPopup.setBorder(UIManager.getBorder("PopupMenu.border"));
            }
            return hyperComboPopup;
        }

        public void showComboBoxPopup() {
            this.comboBox.showPopup();
        }

        public int getItemCount() {
            return this.comboBox.getSelectedIndex();
        }

        @Override
        protected void installComponents() {
            this.comboBox.add(this.currentValuePane);
        }

        @Override
        protected JButton createArrowButton() {
            return null;
        }

        @Override
        protected Dimension getDefaultSize() {
            return new Dimension(0, 0);
        }

        protected int getPopupWidth() {
            Dimension dimension;
            Dimension dimension2 = new Dimension(0, 0);
            Dimension dimension3 = new Dimension();
            ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
            ComboBoxModel comboBoxModel = this.comboBox.getModel();
            if (listCellRenderer != null && comboBoxModel.getSize() > 0) {
                int n = comboBoxModel.getSize();
                for (int i = 0; i < n; ++i) {
                    Component component = listCellRenderer.getListCellRendererComponent(this.listBox, comboBoxModel.getElementAt(i), i, false, false);
                    component.setFont(this.comboBox.getFont());
                    Dimension dimension4 = component.getPreferredSize();
                    dimension3.width = Math.max(dimension3.width, dimension4.width);
                    dimension3.height = Math.max(dimension3.height, dimension4.height);
                }
                dimension2.setSize(dimension3.width, dimension3.height);
                dimension = dimension3;
            } else {
                dimension = this.getDefaultSize();
            }
            int n = dimension.width + 15;
            return n;
        }

        @Override
        protected Dimension getDisplaySize() {
            ListCellRenderer<Object> listCellRenderer = this.comboBox.getRenderer();
            Dimension dimension = this.getDefaultSize();
            if (listCellRenderer != null && this.comboBox.isVisible()) {
                Component component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
                this.currentValuePane.add(component);
                component.setFont(this.comboBox.getFont());
                dimension = new Dimension(component.getPreferredSize().width, 15);
                this.currentValuePane.remove(component);
            }
            return dimension;
        }

        @Override
        public Dimension getMinimumSize(JComponent jComponent) {
            return this.getDisplaySize();
        }

        @Override
        public Dimension getPreferredSize(JComponent jComponent) {
            return this.getDisplaySize();
        }

        @Override
        public Dimension getMaximumSize(JComponent jComponent) {
            return this.getDisplaySize();
        }

        @Override
        protected Rectangle rectangleForCurrentValue() {
            int n = this.comboBox.getWidth();
            int n2 = this.comboBox.getHeight();
            return new Rectangle(0, 0, n, n2);
        }

        public void setBackgroundColor(Color color) {
            this.background = color;
        }

        @Override
        public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl) {
            ListCellRenderer<Object> listCellRenderer = this.comboBox.getRenderer();
            if (this.comboBox.getSelectedIndex() == -1) {
                return;
            }
            boolean bl2 = bl && !this.isPopupVisible(this.comboBox);
            HyperComboRenderer hyperComboRenderer = (HyperComboRenderer)listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, bl2, false);
            hyperComboRenderer.setFont(this.comboBox.getFont());
            hyperComboRenderer.setUnderlined(this.comboBox.isEnabled());
            hyperComboRenderer.setBorder(null);
            if (bl2) {
                hyperComboRenderer.setForeground(this.listBox.getSelectionForeground());
                hyperComboRenderer.setBackground(this.listBox.getSelectionBackground());
            } else {
                hyperComboRenderer.setBackground(this.background);
                if (this.comboBox.isEnabled()) {
                    hyperComboRenderer.setForeground(Color.blue);
                } else {
                    hyperComboRenderer.setForeground(UIManager.getColor("Label.foreground"));
                }
            }
            this.currentValuePane.paintComponent(graphics, hyperComboRenderer, this.comboBox, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        @Override
        protected void installDefaults() {
            LookAndFeel.installColorsAndFont(this.comboBox, "ComboBox.background", "ComboBox.foreground", "ComboBox.font");
        }

        @Override
        protected void installKeyboardActions() {
            super.installKeyboardActions();
            final JComboBox jComboBox = this.comboBox;
            AbstractAction abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HyperLinkComboUI.this.selectNextPossibleValue();
                }

                @Override
                public boolean isEnabled() {
                    return jComboBox.isEnabled() && jComboBox.isPopupVisible();
                }
            };
            this.comboBox.registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke(40, 0), 1);
            AbstractAction abstractAction2 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HyperLinkComboUI.this.selectPreviousPossibleValue();
                }

                @Override
                public boolean isEnabled() {
                    return jComboBox.isEnabled() && jComboBox.isPopupVisible();
                }
            };
            this.comboBox.registerKeyboardAction(abstractAction2, KeyStroke.getKeyStroke(38, 0), 1);
        }

        @Override
        protected void uninstallKeyboardActions() {
            super.uninstallKeyboardActions();
            this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 0));
            this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 0));
        }
    }

    private class HyperCursorListener
    extends MouseAdapter {
        private HyperCursorListener() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (HyperLinkCombo.this.isEnabled()) {
                HyperLinkCombo.this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                HyperLinkCombo.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            HyperLinkCombo.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected class HyperComboPopup
    extends BasicComboPopup {
        public HyperComboPopup(JComboBox jComboBox) {
            super(jComboBox);
        }

        @Override
        protected Rectangle computePopupBounds(int n, int n2, int n3, int n4) {
            HyperLinkComboUI hyperLinkComboUI = (HyperLinkComboUI)this.comboBox.getUI();
            int n5 = hyperLinkComboUI.getPopupWidth();
            return super.computePopupBounds(n, n2, n5, n4);
        }

        protected void syncWithComboBoxSelection() {
            int n = this.comboBox.getSelectedIndex();
            if (n == -1) {
                this.list.clearSelection();
            } else {
                this.list.setSelectedIndex(n);
            }
        }
    }
}

