/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.templateview;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import oracle.hcs.db.IdentifierElement;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.model.DimensionAttribute;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.hcs.templates.syntaxparser.ParseNode;
import oracle.hcs.templates.templateview.TemplateHyperParamCombo;

public class TemplateHyperParamAttribute
extends TemplateHyperParamCombo
implements PropertyChangeListener {
    private static final String paramName = "attribute";
    private static Logger LOG = Logger.getLogger(TemplateHyperParamAttribute.class.getName());
    private AttributeDimension dimension;
    private static final ParseNode pattern = new ParseNode("attribute", HCSSyntaxType.STRING.toString(), ParseNode.PatternType.NONE);

    @Override
    public boolean setValue(Object object) {
        if (object instanceof ParseNode) {
            String string = ((ParseNode)object).getValue();
            if (string != null && string.charAt(0) == '\'') {
                string = string.substring(1, string.length() - 1);
            }
            IdentifierElement identifierElement = new IdentifierElement(string);
            String string2 = identifierElement.get(identifierElement.getCount() - 1);
            for (int i = 0; i < this.getComboBoxModel().getSize(); ++i) {
                DimensionAttribute dimensionAttribute = (DimensionAttribute)this.getComboBoxModel().getElementAt(i);
                if (!dimensionAttribute.getName().equals(string2)) continue;
                return this.setValue(dimensionAttribute);
            }
        }
        return super.setValue(object);
    }

    public TemplateHyperParamAttribute() {
        final ListCellRenderer listCellRenderer = this.hyperCombo.getRenderer();
        this.hyperCombo.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                return listCellRenderer.getListCellRendererComponent(jList, TemplateHyperParamAttribute.this.uiValue(object), n, bl, bl2);
            }
        });
    }

    protected String uiValue(Object object) {
        if (object != null) {
            if (object instanceof String) {
                return (String)object;
            }
            return ((DimensionAttribute)object).getName();
        }
        return null;
    }

    @Override
    public int getPixelSize(int n) {
        return this.hyperCombo.getFontMetrics(this.hyperCombo.getFont()).stringWidth(this.uiValue(this.getValue()));
    }

    @Override
    public ParseNode getPattern() {
        return pattern;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getNewValue();
        if (object instanceof AttributeDimension) {
            this.setDimension((AttributeDimension)object);
        }
    }

    private void setDimension(AttributeDimension attributeDimension) {
        this.removeAllElements();
        this.dimension = attributeDimension;
        boolean bl = this.isValid();
        if (attributeDimension != null) {
            DimensionAttribute[] dimensionAttributeArray = attributeDimension.getAttributes();
            if (dimensionAttributeArray.length == 0) {
                this.setVisible(false);
            } else {
                this.setVisible(true);
            }
            for (DimensionAttribute dimensionAttribute : dimensionAttributeArray) {
                this.addElement(dimensionAttribute);
            }
        }
        if (bl != this.isValid()) {
            this.firePropertyChangeEvent(new PropertyChangeEvent(this, "VALID_PROPERTY", bl, this.isValid()));
        }
    }

    @Override
    public Object getValue() {
        return this.getSelectedElement();
    }

    @Override
    public String getExpression() {
        Object object = this.getSelectedElement();
        if (object instanceof String) {
            return "";
        }
        DimensionAttribute dimensionAttribute = (DimensionAttribute)object;
        if (this.getTemplateContext().isAV()) {
            return String.format("%s.%s", dimensionAttribute.getDimension().getName(), dimensionAttribute.getName());
        }
        return dimensionAttribute.getName();
    }
}

