/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.syntaxparser;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import oracle.hcs.templates.syntaxparser.FlatNode;
import oracle.hcs.templates.syntaxparser.ParseNode;
import oracle.hcs.templates.templateview.TemplateHyperParam;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class ChoiceNode
extends FlatNode {
    private static final Logger LOG = Logger.getLogger(ChoiceNode.class.getName());
    protected FlatNode[] branches;
    protected FlatNode[] cursors;
    protected MatchState[] candidates;
    protected int currentBranch = 0;
    private FlatNode nextLoad;

    ChoiceNode(ParseNode parseNode, ParseNode parseNode2) {
        super(parseNode, parseNode2.getParamName());
        this.branches = new FlatNode[parseNode2.getEnd()];
        this.cursors = new FlatNode[parseNode2.getEnd()];
        this.candidates = new MatchState[parseNode2.getEnd()];
        this.currentBranch = parseNode2.getOffset();
    }

    FlatNode setBranch(FlatNode flatNode, int n) {
        if (this.branches[n] instanceof ChoiceNode) {
            return ((ChoiceNode)this.branches[n]).setBranch(flatNode, n);
        }
        this.branches[n] = flatNode;
        return this.branches[n];
    }

    @Override
    int matches(ParseNode parseNode) {
        int n = 0;
        int n2 = -1;
        for (int i = 0; i < this.branches.length; ++i) {
            if (this.candidates[i] == MatchState.CANDIDATE) {
                if (this.cursors[i] == this) {
                    if (n == 0) {
                        this.candidates[i] = MatchState.MATCH;
                        if (n2 != -1) {
                            this.candidates[n2] = MatchState.DISCARDED;
                        }
                        n2 = i;
                        continue;
                    }
                    this.candidates[i] = MatchState.DISCARDED;
                    continue;
                }
                int n3 = this.cursors[i].matches(parseNode);
                if (n3 == 0) {
                    if (this.cursors[i].getSpecial() != null) {
                        this.cursors[i] = this.cursors[i].getSpecial();
                        return this.matches(parseNode);
                    }
                    this.candidates[i] = MatchState.DISCARDED;
                    continue;
                }
                n = n3;
                this.nextLoad = this.cursors[i];
                this.cursors[i] = this.cursors[i].nextMatch();
                if (n2 == -1) continue;
                this.candidates[n2] = MatchState.DISCARDED;
                n2 = -1;
                continue;
            }
            if (this.candidates[i] != MatchState.MATCH) continue;
            this.candidates[i] = MatchState.DISCARDED;
        }
        if (n2 != -1) {
            this.special = this.getNext();
        }
        return n;
    }

    @Override
    public FlatNode nextMatch() {
        return this;
    }

    private void resetCursors() {
        for (int i = 0; i < this.cursors.length; ++i) {
            this.cursors[i] = this.branches[i];
            this.candidates[i] = MatchState.CANDIDATE;
        }
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int n) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder("Choice[");
        Object object = "  ";
        for (n2 = 0; n2 < n; ++n2) {
            object = (String)object + (String)object;
        }
        for (n2 = 0; n2 < this.branches.length; ++n2) {
            stringBuilder.append("\n");
            stringBuilder.append((String)object);
            stringBuilder.append(n2);
            stringBuilder.append("= ");
            FlatNode flatNode = this.branches[n2];
            if (flatNode == null || flatNode == this) continue;
            stringBuilder.append(flatNode.toString(n + 1));
            for (flatNode = flatNode.getNext(); flatNode != null && flatNode != this; flatNode = flatNode.getNext()) {
                stringBuilder.append('\n');
                stringBuilder.append((String)object);
                stringBuilder.append(flatNode.toString(n + 1));
            }
        }
        stringBuilder.append((String)object);
        stringBuilder.append("\n]:");
        stringBuilder.append(this.paramName);
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    @Override
    public Element marshall(Document document, Element element) {
        Element element2 = super.marshall(document, element);
        for (int i = 0; i < this.branches.length; ++i) {
            Element element3 = document.createElement("Branch");
            element2.appendChild(element3);
            element3.setAttribute("index", String.valueOf(i));
            for (FlatNode flatNode = this.branches[i]; flatNode != null && flatNode != this; flatNode = flatNode.getNext()) {
                flatNode.marshall(document, element3);
            }
        }
        return element2;
    }

    @Override
    public boolean tryLoad(List<TemplateHyperParam> list, ParseNode parseNode) {
        int n = 0;
        int n2 = -1;
        boolean bl = false;
        TemplateHyperParam templateHyperParam = null;
        for (TemplateHyperParam templateHyperParam2 : list) {
            if (!templateHyperParam2.getName().equals(this.getParamName())) continue;
            templateHyperParam = templateHyperParam2;
            break;
        }
        if (parseNode == null) {
            for (int i = 0; i < this.branches.length; ++i) {
                if (this.candidates[i] != MatchState.MATCH && this.candidates[i] != MatchState.CANDIDATE) continue;
                if (this.cursors[i] == this) {
                    n2 = i;
                    n = 1;
                    i = this.branches.length;
                    continue;
                }
                ++n;
                n2 = i;
            }
            if (n == 1) {
                ParseNode parseNode2 = new ParseNode(this.paramName, null, ParseNode.PatternType.OPTION);
                parseNode2.setOffset(n2);
                if (templateHyperParam != null) {
                    templateHyperParam.setValue(parseNode2);
                    list.remove(templateHyperParam);
                    list.removeAll(this.getFullOptionalList(new LinkedList<TemplateHyperParam>(), templateHyperParam));
                    bl = true;
                }
            }
        }
        if (this.nextLoad != null && this.nextLoad != this) {
            LinkedList<TemplateHyperParam> linkedList = this.getFullOptionalList(new LinkedList<TemplateHyperParam>(), templateHyperParam);
            int n3 = 20;
            int n4 = 0;
            while (this.nextLoad.tryLoad((List<TemplateHyperParam>)linkedList, parseNode) && n4++ < n3) {
                bl = true;
            }
        }
        return bl;
    }

    public LinkedList<TemplateHyperParam> getFullOptionalList(LinkedList<TemplateHyperParam> linkedList, TemplateHyperParam templateHyperParam) {
        if (templateHyperParam != null) {
            for (TemplateHyperParam templateHyperParam2 : templateHyperParam.getOptionalHyperParams()) {
                linkedList.add(templateHyperParam2);
                this.getFullOptionalList(linkedList, templateHyperParam2);
            }
        }
        return linkedList;
    }

    protected FlatNode getBranch() {
        return this.branches[this.currentBranch];
    }

    public FlatNode getBranch(int n) {
        return this.branches[n];
    }

    @Override
    public void restartMatch() {
        for (int i = 0; i < this.branches.length; ++i) {
            FlatNode flatNode = this.branches[i];
            if (flatNode == null) {
                this.branches[i] = this;
                flatNode = this;
            }
            while (flatNode != this) {
                FlatNode flatNode2 = flatNode;
                flatNode2.restartMatch();
                if ((flatNode = flatNode.getNext()) != null) continue;
                flatNode2.linkNext(this);
                flatNode = this;
            }
        }
        this.special = null;
        this.nextLoad = null;
        this.resetCursors();
    }

    protected static enum MatchState {
        CANDIDATE,
        DISCARDED,
        MATCH;

    }
}

