/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import oracle.hcs.syntax.RowExpression;
import oracle.hcs.syntax.SyntaxObject;
import oracle.hcs.syntax.SyntaxObjectVisitor;
import oracle.hcs.syntax.SyntaxPrintingContext;
import oracle.hcs.syntax.TypedExpression;
import oracle.hcs.syntax.ValidationContext;

public final class UnaryOperatorExpression
extends RowExpression {
    public static final String MINUS = "-";
    static final String[] ALL_OPERATORS = new String[]{"-"};
    private String m_Operator;
    private TypedExpression m_BaseExpression;

    private void setBaseExpression(TypedExpression typedExpression) {
        this.m_BaseExpression = typedExpression;
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append(this.getOperator());
        syntaxPrintingContext.print(this.getBaseExpression());
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        this.setBaseExpression(validationContext.validateExp(this.getBaseExpression()));
        validationContext.pop();
        this.getBaseExpression().validateType(3);
        this.setDataType(this.getBaseExpression().getDataType());
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return this.getBaseExpression().isDefinitionComplete();
    }

    public UnaryOperatorExpression(String string, TypedExpression typedExpression) {
        this.m_Operator = UnaryOperatorExpression.validateEnum(string, ALL_OPERATORS);
        UnaryOperatorExpression.validateValue(typedExpression);
        this.setBaseExpression(typedExpression);
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitUnaryOperatorExpression(this, object);
    }

    @Override
    public String getOperator() {
        return this.m_Operator;
    }

    public TypedExpression getBaseExpression() {
        return this.m_BaseExpression;
    }
}

