/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import java.util.ArrayList;
import java.util.List;
import oracle.hcs.syntax.DataObject;
import oracle.hcs.syntax.LiteralExpression;
import oracle.hcs.syntax.Qualifier;
import oracle.hcs.syntax.SyntaxObjectVisitor;
import oracle.hcs.syntax.SyntaxPrintingContext;
import oracle.hcs.syntax.UnresolvedMetadataObjectReference;

public class HierarchyQualifierArgument
extends DataObject {
    private UnresolvedMetadataObjectReference m_level;
    private List<UnresolvedMetadataObjectReference> m_attrs;
    private List<LiteralExpression> m_literalExpressions;
    private List<Qualifier> m_qualifiers = new ArrayList<Qualifier>();
    private static final String ALL = "ALL";

    public HierarchyQualifierArgument() {
        this.m_literalExpressions = new ArrayList<LiteralExpression>();
        this.m_attrs = new ArrayList<UnresolvedMetadataObjectReference>();
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitHierarchyQualifierArgument(this, object);
    }

    public String getLevelID() {
        return this.m_level.getIdentifier().toString();
    }

    public void setLevel(UnresolvedMetadataObjectReference unresolvedMetadataObjectReference) {
        this.m_level = unresolvedMetadataObjectReference;
    }

    public void addAttribute(UnresolvedMetadataObjectReference unresolvedMetadataObjectReference) {
        this.m_attrs.add(unresolvedMetadataObjectReference);
    }

    public List<LiteralExpression> getLiteralExpressions() {
        return this.m_literalExpressions;
    }

    public void addLiteralExpression(LiteralExpression literalExpression) {
        this.m_literalExpressions.add(literalExpression);
    }

    public void addQualifier(Qualifier qualifier) {
        this.m_qualifiers.add(qualifier);
    }

    public void add(Qualifier qualifier) {
        this.m_qualifiers.add(qualifier);
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        if (this.m_level.getIdentifier().toString().equalsIgnoreCase(ALL)) {
            syntaxPrintingContext.append(this.m_level.getIdentifier().toString());
        } else {
            this.m_level.toSyntax(syntaxPrintingContext);
            if (this.m_qualifiers != null) {
                for (Qualifier iterator : this.m_qualifiers) {
                    syntaxPrintingContext.print(iterator);
                    syntaxPrintingContext.append(" ,");
                }
                syntaxPrintingContext.append("[");
                if (this.m_attrs.size() > 0) {
                    int n = 0;
                    for (UnresolvedMetadataObjectReference unresolvedMetadataObjectReference : this.m_attrs) {
                        if (n != 0) {
                            syntaxPrintingContext.append(", ");
                        }
                        unresolvedMetadataObjectReference.toSyntax(syntaxPrintingContext);
                        syntaxPrintingContext.append("=");
                        LiteralExpression literalExpression = this.m_literalExpressions.get(n);
                        syntaxPrintingContext.print(literalExpression);
                        ++n;
                    }
                } else {
                    int n = 0;
                    for (LiteralExpression literalExpression : this.m_literalExpressions) {
                        if (n != 0) {
                            syntaxPrintingContext.append(", ");
                        }
                        syntaxPrintingContext.print(literalExpression);
                        ++n;
                    }
                }
                syntaxPrintingContext.append("]");
            }
        }
    }
}

