/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.metadata;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AVCalculatedMeasure;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.av.model.cache.AVCacheLevelGroup;
import oracle.hcs.av.model.cache.AVCacheLevelGroupDimHierLevel;
import oracle.hcs.av.model.cache.AVCacheMeasureGroup;
import oracle.hcs.av.model.cache.AVCacheMeasureGroupMeasure;
import oracle.hcs.av.model.cache.AVCacheMeasureProviderContext;
import oracle.hcs.db.Database;
import oracle.hcs.db.DatabaseImpl;
import oracle.hcs.db.IdentifierElement;
import oracle.hcs.db.model.AbstractChildObjectWithDesc;
import oracle.hcs.db.model.AbstractMappableSchemaObjectWithDesc;
import oracle.hcs.db.model.AbstractSchemaObjectWithDesc;
import oracle.hcs.db.model.Classification;
import oracle.hcs.db.model.Descriptions;
import oracle.hcs.db.model.LanguageDescription;
import oracle.hcs.db.model.NamedObject;
import oracle.hcs.db.model.StatefulDescriptions;
import oracle.hcs.db.source.DatabaseSource;
import oracle.hcs.db.source.Synonym;
import oracle.hcs.db.source.Table;
import oracle.hcs.db.source.View;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.model.DimensionAttribute;
import oracle.hcs.dimension.model.DimensionLevel;
import oracle.hcs.dimension.model.OrderByClause;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.hierarchy.model.HierarchyAttribute;
import oracle.hcs.hierarchy.model.HierarchyLevel;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.table.Queries;
import oracle.hcs.util.HCSObjectsTimestamps;
import oracle.hcs.util.JavaXMLBind;
import oracle.javatools.db.AbstractChildDBObject;

public class HCSMetadataReader {
    private Connection conn;
    private DBUtil dbUtil;
    private HCSSchema schema;
    private static Queries queries;
    private static final String XMLFILE = "hcsmetadata.xml";
    private boolean loadAttributeVisibility;
    private boolean skipAVViewColumns;
    private boolean skipDimensionality;
    private static final String DIMENSION_NAME = "dimension_name";
    private static final String ANALYTIC_VIEW_NAME = "analytic_view_name";
    private static final String HIERARCHY_NAME = "hier_name";
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String CAPTION = "CAPTION";
    private static final String METADATA_LINK = "METADATA LINK";
    private static final String DATA_LINK = "DATA LINK";
    private static final String METADATA = "metadata";
    private static final String OBJECT = "object";
    private static final String NONE = "NONE";
    private final String VALID = "VALID";
    private static final Logger LOG;
    private static boolean DEBUG;

    public HCSMetadataReader(Database database, HCSSchema hCSSchema) {
        this.conn = database.getConnection();
        this.schema = hCSSchema;
        this.dbUtil = DBUtil.getInstance((Connection)this.conn);
    }

    private String getQuery(String string) {
        if (queries == null) {
            try {
                String string2 = "oracle.hcs.table";
                String string3 = JavaXMLBind.LoadDocument(this.getClass(), XMLFILE);
                JavaXMLBind.BindToJavaStr(string3, string2, this);
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, exception.getLocalizedMessage(), exception);
            }
        }
        return queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        HCSMetadataReader.queries = queries;
    }

    public void setLoadAttributeVisibility(boolean bl) {
        this.loadAttributeVisibility = bl;
    }

    public void setSkipDimensionality(boolean bl) {
        this.skipDimensionality = bl;
    }

    public void setSkipAVViewColumns(boolean bl) {
        this.skipAVViewColumns = bl;
    }

    public boolean isSkipAVViewColumns() {
        return this.skipAVViewColumns;
    }

    public void loadMetadata() throws SQLException, IOException {
        if (!this.schema.isLoaded()) {
            long l = System.currentTimeMillis();
            this.loadAttributeDimensions();
            LOG.finest(String.format("attribute dimensions load: %s%n", System.currentTimeMillis() - l));
            l = System.currentTimeMillis();
            this.loadHierarchies();
            LOG.finest(String.format("hierarchies load: %s%n", System.currentTimeMillis() - l));
            l = System.currentTimeMillis();
            this.loadAnalyticViews();
            LOG.finest(String.format("analytic views load: %s%n", System.currentTimeMillis() - l));
            this.updateCacheLevelGroupNames();
            this.schema.setLoaded(true);
        }
    }

    public void loadAttributeDimensions() throws SQLException, IOException {
        this.loadAttributeDimensions(null);
    }

    public void loadAttributeDimensions(List<String> list) throws SQLException, IOException {
        block116: {
            Object object;
            Object object2;
            Object object3;
            String string;
            Object object4;
            Object object5;
            Object object6;
            ResultSet resultSet;
            String string2;
            ArrayList<String> arrayList;
            String string3;
            block115: {
                block114: {
                    block113: {
                        Object object7;
                        Object object8;
                        block112: {
                            Object object9;
                            int n;
                            Object object10;
                            block111: {
                                block110: {
                                    block109: {
                                        block108: {
                                            block107: {
                                                block106: {
                                                    string3 = this.getNameCondition(DIMENSION_NAME, list);
                                                    arrayList = new ArrayList<String>(Arrays.asList(this.schema.getName()));
                                                    string2 = String.format(this.getQuery("dimensions"), string3);
                                                    Connections.getInstance().lock(this.conn);
                                                    resultSet = this.dbUtil.executeQuery(string2, arrayList);
                                                    try {
                                                        if (resultSet != null) {
                                                            while (resultSet.next()) {
                                                                object6 = resultSet.getString(1);
                                                                object10 = resultSet.getString(2);
                                                                String string4 = resultSet.getString(3);
                                                                object5 = resultSet.getString(4);
                                                                object4 = resultSet.getString(5);
                                                                string = resultSet.getString(6);
                                                                object3 = resultSet.getString(7);
                                                                object2 = new AttributeDimension(this.schema, (String)object6, (String)object10);
                                                                ((AbstractMappableSchemaObjectWithDesc)object2).setTimestamp(HCSObjectsTimestamps.getTimestamp(string));
                                                                if (string4 != null) {
                                                                    ((AttributeDimension)object2).setAllMemberName(string4);
                                                                }
                                                                if (object5 != null) {
                                                                    ((AttributeDimension)object2).setAllMemberCaption((String)object5);
                                                                }
                                                                if (object4 != null) {
                                                                    ((AttributeDimension)object2).setAllMemberDescription((String)object4);
                                                                }
                                                                ((AbstractMappableSchemaObjectWithDesc)object2).setValid(((String)object3).equals("VALID"));
                                                                this.schema.addDimension((AttributeDimension)object2);
                                                            }
                                                            break block106;
                                                        }
                                                        throw this.dbUtil.getLastException();
                                                    }
                                                    catch (SQLException sQLException) {
                                                        LOG.severe(sQLException.getMessage());
                                                        throw sQLException;
                                                    }
                                                    finally {
                                                        DBUtil.closeResultSet((ResultSet)resultSet);
                                                        Connections.getInstance().unlock(this.conn);
                                                    }
                                                }
                                                object6 = null;
                                                object10 = null;
                                                n = 0;
                                                string2 = String.format(this.getQuery("dimension_classifications"), string3);
                                                Connections.getInstance().lock(this.conn);
                                                resultSet = this.dbUtil.executeQuery(string2, arrayList);
                                                try {
                                                    if (resultSet != null) {
                                                        while (resultSet.next()) {
                                                            object5 = resultSet.getString(1);
                                                            object4 = resultSet.getString(2);
                                                            string = resultSet.getString(3);
                                                            object3 = resultSet.getString(4);
                                                            object6 = this.schema.findDimension((String)object5);
                                                            if (object3 == null) {
                                                                if (((String)object4).equalsIgnoreCase(CAPTION) || ((String)object4).equalsIgnoreCase(DESCRIPTION)) {
                                                                    HCSMetadataReader.setDescription((Descriptions)object6, (String)object4, this.getDescObjectValue(string));
                                                                    continue;
                                                                }
                                                                this.removeObjectClassification((Descriptions)object6, (String)object4);
                                                                object2 = new Classification((String)object4, this.getDescObjectValue(string), (String)object3);
                                                                ((AbstractMappableSchemaObjectWithDesc)object6).addClassification((Classification)((Object)object2));
                                                                continue;
                                                            }
                                                            if (object10 == null) {
                                                                object10 = new LanguageDescription();
                                                                ((LanguageDescription)object10).setLanguage((String)object3);
                                                            }
                                                            if (((LanguageDescription)object10).getLanguage().equalsIgnoreCase((String)object3)) {
                                                                this.setLanguageDescription((LanguageDescription)object10, (String)object4, string);
                                                                ++n;
                                                            } else {
                                                                object10 = new LanguageDescription();
                                                                ((LanguageDescription)object10).setLanguage((String)object3);
                                                                this.setLanguageDescription((LanguageDescription)object10, (String)object4, string);
                                                                ++n;
                                                            }
                                                            if (n != 2) continue;
                                                            n = 0;
                                                            ((AbstractSchemaObjectWithDesc)object6).addLanguageDescription((LanguageDescription)object10);
                                                            object10 = null;
                                                        }
                                                        break block107;
                                                    }
                                                    throw this.dbUtil.getLastException();
                                                }
                                                catch (SQLException sQLException) {
                                                    LOG.severe(sQLException.getMessage());
                                                    throw sQLException;
                                                }
                                                finally {
                                                    DBUtil.closeResultSet((ResultSet)resultSet);
                                                    Connections.getInstance().unlock(this.conn);
                                                }
                                            }
                                            string2 = String.format(this.getQuery("dimension_attributes"), string3);
                                            Connections.getInstance().lock(this.conn);
                                            resultSet = this.dbUtil.executeQuery(string2, arrayList);
                                            try {
                                                if (resultSet != null) {
                                                    while (resultSet.next()) {
                                                        object5 = resultSet.getString(1);
                                                        object4 = resultSet.getString(2);
                                                        string = resultSet.getString(3);
                                                        object3 = resultSet.getString(4);
                                                        object6 = this.schema.findDimension((String)object5);
                                                        object2 = ((AttributeDimension)object6).findAttribute((String)object4);
                                                        if (object2 != null) continue;
                                                        object2 = new DimensionAttribute((String)object4);
                                                        ((DimensionAttribute)object2).setMapExpression((String)object3);
                                                        ((DimensionAttribute)object2).setAlias(string);
                                                        ((AttributeDimension)object6).addAttribute((DimensionAttribute)object2);
                                                    }
                                                    break block108;
                                                }
                                                throw this.dbUtil.getLastException();
                                            }
                                            catch (SQLException sQLException) {
                                                LOG.severe(sQLException.getMessage());
                                                throw sQLException;
                                            }
                                            finally {
                                                DBUtil.closeResultSet((ResultSet)resultSet);
                                                Connections.getInstance().unlock(this.conn);
                                            }
                                        }
                                        n = 0;
                                        string2 = String.format(this.getQuery("dimension_attribute_classifications"), string3);
                                        Connections.getInstance().lock(this.conn);
                                        resultSet = this.dbUtil.executeQuery(string2, arrayList);
                                        try {
                                            if (resultSet != null) {
                                                while (resultSet.next()) {
                                                    object5 = resultSet.getString(1);
                                                    object4 = resultSet.getString(2);
                                                    string = resultSet.getString(3);
                                                    object3 = resultSet.getString(4);
                                                    object2 = resultSet.getString(5);
                                                    object6 = this.schema.findDimension((String)object5);
                                                    object = ((AttributeDimension)object6).findAttribute((String)object4);
                                                    if (object == null) continue;
                                                    if (object2 == null) {
                                                        if (string.equalsIgnoreCase(CAPTION) || string.equalsIgnoreCase(DESCRIPTION)) {
                                                            HCSMetadataReader.setDescription((Descriptions)object, string, this.getDescObjectValue((String)object3));
                                                            continue;
                                                        }
                                                        this.removeObjectClassification((Descriptions)object, string);
                                                        object9 = new Classification(string, this.getDescObjectValue((String)object3), (String)object2);
                                                        ((AbstractChildObjectWithDesc)object).addClassification((Classification)((Object)object9));
                                                        continue;
                                                    }
                                                    if (object10 == null) {
                                                        object10 = new LanguageDescription();
                                                        ((LanguageDescription)object10).setLanguage((String)object2);
                                                    }
                                                    if (((LanguageDescription)object10).getLanguage().equalsIgnoreCase((String)object2)) {
                                                        this.setLanguageDescription((LanguageDescription)object10, string, (String)object3);
                                                        ++n;
                                                    } else {
                                                        object10 = new LanguageDescription();
                                                        ((LanguageDescription)object10).setLanguage((String)object2);
                                                        this.setLanguageDescription((LanguageDescription)object10, string, (String)object3);
                                                        ++n;
                                                    }
                                                    if (n != 2) continue;
                                                    n = 0;
                                                    ((AbstractChildObjectWithDesc)object).addLanguageDescription((LanguageDescription)object10);
                                                    object10 = null;
                                                }
                                                break block109;
                                            }
                                            throw this.dbUtil.getLastException();
                                        }
                                        catch (SQLException sQLException) {
                                            LOG.severe(sQLException.getMessage());
                                            throw sQLException;
                                        }
                                        finally {
                                            DBUtil.closeResultSet((ResultSet)resultSet);
                                            Connections.getInstance().unlock(this.conn);
                                        }
                                    }
                                    string2 = String.format(this.getQuery("dimension_levels"), string3);
                                    Connections.getInstance().lock(this.conn);
                                    resultSet = this.dbUtil.executeQuery(string2, arrayList);
                                    try {
                                        if (resultSet != null) {
                                            while (resultSet.next()) {
                                                object5 = resultSet.getString(1);
                                                object4 = resultSet.getString(2);
                                                string = resultSet.getString(3);
                                                object3 = resultSet.getString(4);
                                                object2 = resultSet.getString(5);
                                                object = resultSet.getString(6);
                                                object9 = resultSet.getString(7);
                                                object8 = resultSet.getString(8);
                                                object6 = this.schema.findDimension((String)object5);
                                                object7 = ((AttributeDimension)object6).findLevel((String)object4);
                                                if (object7 != null) continue;
                                                object7 = new DimensionLevel((AttributeDimension)object6, (String)object4);
                                                ((DimensionLevel)object7).setLevelType((String)object3);
                                                ((DimensionLevel)object7).setLevelMemberName((String)object2);
                                                ((DimensionLevel)object7).setLevelMemberCaption((String)object);
                                                ((DimensionLevel)object7).setLevelMemberDescription((String)object9);
                                                ((DimensionLevel)object7).setLevelOrder(string);
                                                boolean bl = ((String)object8).equals("Y");
                                                ((DimensionLevel)object7).setLevelSkipNullValues(bl);
                                                ((AttributeDimension)object6).addLevel((DimensionLevel)object7);
                                            }
                                            break block110;
                                        }
                                        throw this.dbUtil.getLastException();
                                    }
                                    catch (SQLException sQLException) {
                                        LOG.severe(sQLException.getMessage());
                                        throw sQLException;
                                    }
                                    finally {
                                        DBUtil.closeResultSet((ResultSet)resultSet);
                                        Connections.getInstance().unlock(this.conn);
                                    }
                                }
                                string2 = String.format(this.getQuery("dimension_levels_order"), string3);
                                Connections.getInstance().lock(this.conn);
                                resultSet = this.dbUtil.executeQuery(string2, arrayList);
                                try {
                                    if (resultSet != null) {
                                        while (resultSet.next()) {
                                            object5 = resultSet.getString(1);
                                            object4 = resultSet.getString(2);
                                            string = resultSet.getString(3);
                                            object3 = resultSet.getString(4);
                                            object2 = resultSet.getString(5);
                                            object = resultSet.getString(6);
                                            object6 = this.schema.findDimension((String)object5);
                                            if (object6 == null || (object9 = ((AttributeDimension)object6).findLevel((String)object4)) == null) continue;
                                            object8 = new OrderByClause();
                                            ((OrderByClause)((Object)object8)).setAggregation(string);
                                            ((OrderByClause)((Object)object8)).setCriteria((String)object2);
                                            ((OrderByClause)((Object)object8)).setNullsPosition((String)object);
                                            ((OrderByClause)((Object)object8)).setOrderByKey((String)object3);
                                            ((DimensionLevel)object9).addLevelOrderByClause((OrderByClause)((Object)object8));
                                        }
                                        break block111;
                                    }
                                    throw this.dbUtil.getLastException();
                                }
                                catch (SQLException sQLException) {
                                    LOG.severe(sQLException.getMessage());
                                    throw sQLException;
                                }
                                finally {
                                    DBUtil.closeResultSet((ResultSet)resultSet);
                                    Connections.getInstance().unlock(this.conn);
                                }
                            }
                            n = 0;
                            string2 = String.format(this.getQuery("dimension_level_classifications"), string3);
                            Connections.getInstance().lock(this.conn);
                            resultSet = this.dbUtil.executeQuery(string2, arrayList);
                            try {
                                if (resultSet != null) {
                                    while (resultSet.next()) {
                                        object5 = resultSet.getString(1);
                                        object4 = resultSet.getString(2);
                                        string = resultSet.getString(3);
                                        object3 = resultSet.getString(4);
                                        object2 = resultSet.getString(5);
                                        object6 = this.schema.findDimension((String)object5);
                                        object = ((AttributeDimension)object6).findLevel((String)object4);
                                        if (object == null) continue;
                                        if (object2 == null) {
                                            if (string.equalsIgnoreCase(CAPTION) || string.equalsIgnoreCase(DESCRIPTION)) {
                                                HCSMetadataReader.setDescription((Descriptions)object, string, this.getDescObjectValue((String)object3));
                                                continue;
                                            }
                                            this.removeObjectClassification((Descriptions)object, string);
                                            object9 = new Classification(string, this.getDescObjectValue((String)object3), (String)object2);
                                            ((AbstractChildObjectWithDesc)object).addClassification((Classification)((Object)object9));
                                            continue;
                                        }
                                        if (object10 == null) {
                                            object10 = new LanguageDescription();
                                            ((LanguageDescription)object10).setLanguage((String)object2);
                                        }
                                        if (((LanguageDescription)object10).getLanguage().equalsIgnoreCase((String)object2)) {
                                            this.setLanguageDescription((LanguageDescription)object10, string, (String)object3);
                                            ++n;
                                        } else {
                                            object10 = new LanguageDescription();
                                            ((LanguageDescription)object10).setLanguage((String)object2);
                                            this.setLanguageDescription((LanguageDescription)object10, string, (String)object3);
                                            ++n;
                                        }
                                        if (n != 2) continue;
                                        n = 0;
                                        ((AbstractChildObjectWithDesc)object).addLanguageDescription((LanguageDescription)object10);
                                        object10 = null;
                                    }
                                    break block112;
                                }
                                throw this.dbUtil.getLastException();
                            }
                            catch (SQLException sQLException) {
                                LOG.severe(sQLException.getMessage());
                                throw sQLException;
                            }
                            finally {
                                DBUtil.closeResultSet((ResultSet)resultSet);
                                Connections.getInstance().unlock(this.conn);
                            }
                        }
                        string2 = String.format(this.getQuery("dimension_level_keys"), string3);
                        Connections.getInstance().lock(this.conn);
                        resultSet = this.dbUtil.executeQuery(string2, arrayList);
                        try {
                            if (resultSet != null) {
                                object5 = new HashMap();
                                object4 = null;
                                while (resultSet.next()) {
                                    String string5;
                                    string = resultSet.getString(1);
                                    object3 = resultSet.getString(2);
                                    object2 = resultSet.getString(3);
                                    object = resultSet.getString(4);
                                    int n = resultSet.getInt(5);
                                    object6 = this.schema.findDimension(string);
                                    if (object4 == null) {
                                        object4 = object6;
                                    } else if (object4 != object6) {
                                        object8 = object5.keySet();
                                        object7 = object8.iterator();
                                        while (object7.hasNext()) {
                                            string5 = (String)object7.next();
                                            DimensionLevel dimensionLevel = ((AttributeDimension)object4).findLevel(string5);
                                            List list2 = (List)object5.get(string5);
                                            if (list2.size() <= 0) continue;
                                            String[] stringArray = list2.toArray(new String[list2.size()]);
                                            dimensionLevel.setLevelAlternateKeys(stringArray);
                                        }
                                        object5.clear();
                                        object4 = object6;
                                    }
                                    object8 = ((AttributeDimension)object6).findLevel((String)object3);
                                    if (((String)object).equals("N")) {
                                        if (n > 0) {
                                            object7 = ((DimensionLevel)object8).getLevelKey();
                                            ((DimensionLevel)object8).setLevelKey((String)object7 + "," + (String)object2);
                                            continue;
                                        }
                                        ((DimensionLevel)object8).setLevelKey((String)object2);
                                        continue;
                                    }
                                    if (n > 0) {
                                        if (!object5.containsKey(object3) || (object7 = (List)object5.get(object3)).size() <= 0) continue;
                                        string5 = (String)object7.get(object7.size() - 1);
                                        object7.set(object7.size() - 1, string5 + "," + (String)object2);
                                        continue;
                                    }
                                    if (object5.containsKey(object3)) {
                                        object7 = (List)object5.get(object3);
                                        object7.add(object2);
                                        continue;
                                    }
                                    object7 = new ArrayList();
                                    object7.add(object2);
                                    object5.put(object3, object7);
                                }
                                break block113;
                            }
                            throw this.dbUtil.getLastException();
                        }
                        catch (SQLException sQLException) {
                            LOG.severe(sQLException.getMessage());
                            throw sQLException;
                        }
                        finally {
                            DBUtil.closeResultSet((ResultSet)resultSet);
                            Connections.getInstance().unlock(this.conn);
                        }
                    }
                    string2 = String.format(this.getQuery("dimension_level_determines"), string3);
                    Connections.getInstance().lock(this.conn);
                    resultSet = this.dbUtil.executeQuery(string2, new ArrayList<String>(Arrays.asList(this.schema.getName(), this.schema.getName())));
                    try {
                        if (resultSet != null) {
                            while (resultSet.next()) {
                                object5 = resultSet.getString(1);
                                object4 = resultSet.getString(2);
                                string = resultSet.getString(3);
                                object6 = this.schema.findDimension((String)object5);
                                object3 = ((AttributeDimension)object6).findLevel((String)object4);
                                object2 = ((DimensionLevel)object3).getLevelDeterminesKeys();
                                if (object2 == null || ((Object)object2).length == 0) {
                                    object2 = new String[]{string};
                                } else {
                                    object2 = (String[])Arrays.copyOf(object2, ((Object)object2).length + 1);
                                    object2[((Object)object2).length - 1] = string;
                                }
                                ((DimensionLevel)object3).setLevelDeterminesKeys((String[])object2);
                            }
                            break block114;
                        }
                        throw this.dbUtil.getLastException();
                    }
                    catch (SQLException sQLException) {
                        LOG.severe(sQLException.getMessage());
                        throw sQLException;
                    }
                    finally {
                        DBUtil.closeResultSet((ResultSet)resultSet);
                        Connections.getInstance().unlock(this.conn);
                    }
                }
                string2 = this.getQuery("dimension_sharing");
                Connections.getInstance().lock(this.conn);
                resultSet = this.dbUtil.executeQuery(string2, new ArrayList<String>(Arrays.asList(this.schema.getName())));
                try {
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            object5 = resultSet.getString(1);
                            object4 = resultSet.getString(2);
                            object6 = this.schema.findDimension((String)object5);
                            if (object6 == null) continue;
                            ((AbstractMappableSchemaObjectWithDesc)object6).setSharing(this.getSharing((String)object4));
                        }
                        break block115;
                    }
                    throw this.dbUtil.getLastException();
                }
                catch (SQLException sQLException) {
                    LOG.severe(sQLException.getMessage());
                    throw sQLException;
                }
                finally {
                    DBUtil.closeResultSet((ResultSet)resultSet);
                    Connections.getInstance().unlock(this.conn);
                }
            }
            string2 = String.format(this.getQuery("dimension_source"), string3);
            Connections.getInstance().lock(this.conn);
            resultSet = this.dbUtil.executeQuery(string2, arrayList);
            try {
                if (resultSet != null) {
                    while (resultSet.next()) {
                        object5 = resultSet.getString(1);
                        object4 = resultSet.getString(2);
                        string = resultSet.getString(3);
                        object3 = resultSet.getString(4);
                        object2 = resultSet.getString(5);
                        object6 = this.schema.findDimension((String)object5);
                        object = null;
                        if (((String)object4).equals(string)) {
                            string = null;
                        }
                        object = object2 == null ? new Table((String)object3, (String)object4, string) : (((String)object2).equalsIgnoreCase("TABLE") ? new Table((String)object3, (String)object4, string) : (((String)object2).equalsIgnoreCase("VIEW") ? new View((String)object3, (String)object4, string) : new Synonym((String)object3, (String)object4, string)));
                        if (object6 == null) continue;
                        ((AttributeDimension)object6).addSource((DatabaseSource)object);
                    }
                    break block116;
                }
                throw this.dbUtil.getLastException();
            }
            catch (SQLException sQLException) {
                LOG.severe(sQLException.getMessage());
                throw sQLException;
            }
            finally {
                DBUtil.closeResultSet((ResultSet)resultSet);
                Connections.getInstance().unlock(this.conn);
            }
        }
    }

    public void loadHierarchies() throws SQLException, IOException {
        this.loadHierarchies(null);
    }

    public void loadHierarchies(List<String> list) throws SQLException, IOException {
        block58: {
            Object object;
            Object object2;
            Object object3;
            ResultSet resultSet;
            String string;
            block57: {
                AbstractChildDBObject abstractChildDBObject;
                StatefulDescriptions statefulDescriptions;
                Object object4;
                String string2;
                Object object5;
                ArrayList<String> arrayList;
                block56: {
                    block55: {
                        String string3;
                        block54: {
                            Object object6;
                            block53: {
                                string3 = this.getNameCondition(HIERARCHY_NAME, null, list);
                                string = String.format(this.getQuery("hierarchies"), string3);
                                arrayList = new ArrayList<String>(Arrays.asList(this.schema.getName()));
                                Connections.getInstance().lock(this.conn);
                                resultSet = this.dbUtil.executeQuery(string, arrayList);
                                try {
                                    if (resultSet != null) {
                                        while (resultSet.next()) {
                                            object6 = resultSet.getString(1);
                                            String string4 = resultSet.getString(2);
                                            object3 = resultSet.getString(3);
                                            object2 = resultSet.getString(4);
                                            object = new Hierarchy(this.schema, (String)object6, string4);
                                            ((AbstractMappableSchemaObjectWithDesc)object).setTimestamp(HCSObjectsTimestamps.getTimestamp((String)object3));
                                            ((AbstractMappableSchemaObjectWithDesc)object).setValid(((String)object2).equals("VALID"));
                                            this.schema.addHierarchy((Hierarchy)object);
                                            object5 = this.schema.findDimension(string4);
                                            ((Hierarchy)object).setDimension((AttributeDimension)object5);
                                        }
                                        break block53;
                                    }
                                    throw this.dbUtil.getLastException();
                                }
                                catch (SQLException sQLException) {
                                    LOG.severe(sQLException.getMessage());
                                    throw sQLException;
                                }
                                finally {
                                    DBUtil.closeResultSet((ResultSet)resultSet);
                                    Connections.getInstance().unlock(this.conn);
                                }
                            }
                            object6 = null;
                            int n = 0;
                            object3 = null;
                            string = String.format(this.getQuery("hierarchy_classifications"), string3);
                            Connections.getInstance().lock(this.conn);
                            resultSet = this.dbUtil.executeQuery(string, arrayList);
                            try {
                                if (resultSet != null) {
                                    while (resultSet.next()) {
                                        object2 = resultSet.getString(1);
                                        object = resultSet.getString(2);
                                        object5 = resultSet.getString(3);
                                        string2 = resultSet.getString(4);
                                        object3 = this.schema.findHierarchy((String)object2);
                                        if (string2 == null) {
                                            if (((String)object).equalsIgnoreCase(CAPTION) || ((String)object).equalsIgnoreCase(DESCRIPTION)) {
                                                HCSMetadataReader.setDescription((Descriptions)object3, (String)object, this.getDescObjectValue((String)object5));
                                                continue;
                                            }
                                            this.removeObjectClassification((Descriptions)object3, (String)object);
                                            object4 = new Classification((String)object, this.getDescObjectValue((String)object5), string2);
                                            ((AbstractMappableSchemaObjectWithDesc)object3).addClassification((Classification)((Object)object4));
                                            continue;
                                        }
                                        if (object6 == null) {
                                            object6 = new LanguageDescription();
                                            ((LanguageDescription)object6).setLanguage(string2);
                                        }
                                        if (((LanguageDescription)object6).getLanguage().equalsIgnoreCase(string2)) {
                                            this.setLanguageDescription((LanguageDescription)object6, (String)object, (String)object5);
                                            ++n;
                                        } else {
                                            object6 = new LanguageDescription();
                                            ((LanguageDescription)object6).setLanguage(string2);
                                            this.setLanguageDescription((LanguageDescription)object6, (String)object, (String)object5);
                                            ++n;
                                        }
                                        if (n != 2) continue;
                                        n = 0;
                                        ((AbstractSchemaObjectWithDesc)object3).addLanguageDescription((LanguageDescription)object6);
                                        object6 = null;
                                    }
                                    break block54;
                                }
                                throw this.dbUtil.getLastException();
                            }
                            catch (SQLException sQLException) {
                                LOG.severe(sQLException.getMessage());
                                throw sQLException;
                            }
                            finally {
                                DBUtil.closeResultSet((ResultSet)resultSet);
                                Connections.getInstance().unlock(this.conn);
                            }
                        }
                        string = String.format(this.getQuery("hierarchy_levels"), string3);
                        Connections.getInstance().lock(this.conn);
                        resultSet = this.dbUtil.executeQuery(string, arrayList);
                        try {
                            if (resultSet != null) {
                                object2 = "";
                                object = new ArrayList<HierarchyLevel>();
                                while (resultSet.next()) {
                                    object5 = resultSet.getString(1);
                                    if (((String)object2).isEmpty()) {
                                        object2 = object5;
                                    }
                                    if (!((String)object2).equalsIgnoreCase((String)object5)) {
                                        this.setHierarchyLevelsToHierarchy((Hierarchy)object3, (List<HierarchyLevel>)object);
                                    }
                                    string2 = resultSet.getString(2);
                                    object3 = this.schema.findHierarchy((String)object5);
                                    object4 = ((Hierarchy)object3).getDimensionName();
                                    statefulDescriptions = this.schema.findDimension((String)object4);
                                    abstractChildDBObject = ((Hierarchy)object3).findHierarchyLevel(string2);
                                    if (abstractChildDBObject == null && statefulDescriptions != null) {
                                        DimensionLevel dimensionLevel = ((AttributeDimension)statefulDescriptions).findLevel(string2);
                                        if (dimensionLevel == null) {
                                            dimensionLevel = new DimensionLevel((AttributeDimension)statefulDescriptions, string2);
                                        }
                                        abstractChildDBObject = new HierarchyLevel((Hierarchy)object3, dimensionLevel);
                                        object.add(abstractChildDBObject);
                                    }
                                    object2 = object5;
                                }
                                if (!object.isEmpty()) {
                                    this.setHierarchyLevelsToHierarchy((Hierarchy)object3, (List<HierarchyLevel>)object);
                                }
                                break block55;
                            }
                            throw this.dbUtil.getLastException();
                        }
                        catch (SQLException sQLException) {
                            LOG.severe(sQLException.getMessage());
                            throw sQLException;
                        }
                        finally {
                            DBUtil.closeResultSet((ResultSet)resultSet);
                            Connections.getInstance().unlock(this.conn);
                        }
                    }
                    string = this.getQuery("hierarchy_attributes");
                    Connections.getInstance().lock(this.conn);
                    resultSet = this.dbUtil.executeQuery(string, arrayList);
                    try {
                        if (resultSet != null) {
                            while (resultSet.next()) {
                                object2 = resultSet.getString(1);
                                object = resultSet.getString(2);
                                object5 = resultSet.getString(3);
                                string2 = resultSet.getString(4);
                                object3 = this.schema.findHierarchy((String)object2);
                                object4 = ((Hierarchy)object3).findHierAttribute((String)object);
                                if (object4 != null) continue;
                                statefulDescriptions = new HierarchyAttribute();
                                ((HierarchyAttribute)statefulDescriptions).setName((String)object);
                                ((HierarchyAttribute)statefulDescriptions).setExpression((String)object5);
                                ((HierarchyAttribute)statefulDescriptions).setOrder(string2);
                                ((Hierarchy)object3).addHierAttribute((HierarchyAttribute)statefulDescriptions);
                            }
                            break block56;
                        }
                        throw this.dbUtil.getLastException();
                    }
                    catch (SQLException sQLException) {
                        LOG.severe(sQLException.getMessage());
                        throw sQLException;
                    }
                    finally {
                        DBUtil.closeResultSet((ResultSet)resultSet);
                        Connections.getInstance().unlock(this.conn);
                    }
                }
                object3 = null;
                string = this.getQuery("hierarchy_attribute_classifications");
                Connections.getInstance().lock(this.conn);
                resultSet = this.dbUtil.executeQuery(string, arrayList);
                try {
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            object2 = resultSet.getString(1);
                            object = resultSet.getString(2);
                            object5 = resultSet.getString(3);
                            string2 = resultSet.getString(4);
                            object4 = resultSet.getString(5);
                            object3 = this.schema.findHierarchy((String)object2);
                            statefulDescriptions = ((Hierarchy)object3).findHierAttribute((String)object);
                            if (statefulDescriptions == null) continue;
                            if (((String)object5).equalsIgnoreCase(CAPTION) || ((String)object5).equalsIgnoreCase(DESCRIPTION)) {
                                HCSMetadataReader.setDescription(statefulDescriptions, (String)object5, this.getDescObjectValue(string2));
                                continue;
                            }
                            this.removeObjectClassification(statefulDescriptions, (String)object5);
                            abstractChildDBObject = new Classification((String)object5, this.getDescObjectValue(string2), (String)object4);
                            ((HierarchyAttribute)statefulDescriptions).addClassification((Classification)abstractChildDBObject);
                        }
                        break block57;
                    }
                    throw this.dbUtil.getLastException();
                }
                catch (SQLException sQLException) {
                    LOG.severe(sQLException.getMessage());
                    throw sQLException;
                }
                finally {
                    DBUtil.closeResultSet((ResultSet)resultSet);
                    Connections.getInstance().unlock(this.conn);
                }
            }
            string = this.getQuery("hierarchy_sharing");
            Connections.getInstance().lock(this.conn);
            resultSet = this.dbUtil.executeQuery(string, new ArrayList<String>(Arrays.asList(this.schema.getName())));
            try {
                if (resultSet != null) {
                    while (resultSet.next()) {
                        object2 = resultSet.getString(1);
                        object = resultSet.getString(2);
                        object3 = this.schema.findHierarchy((String)object2);
                        if (object3 == null) continue;
                        ((AbstractMappableSchemaObjectWithDesc)object3).setSharing(this.getSharing((String)object));
                    }
                    break block58;
                }
                throw this.dbUtil.getLastException();
            }
            catch (SQLException sQLException) {
                LOG.severe(sQLException.getMessage());
                throw sQLException;
            }
            finally {
                DBUtil.closeResultSet((ResultSet)resultSet);
                Connections.getInstance().unlock(this.conn);
            }
        }
    }

    private void setHierarchyLevelsToHierarchy(Hierarchy hierarchy, List<HierarchyLevel> list) {
        if (list.size() > 0) {
            HierarchyLevel[] hierarchyLevelArray = list.toArray(new HierarchyLevel[list.size()]);
            hierarchy.setHierarchyLevels(hierarchyLevelArray);
            list.clear();
        }
    }

    private void setLanguageDescription(LanguageDescription languageDescription, String string, String string2) {
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase(DESCRIPTION)) {
            languageDescription.setDescription(string2);
            if (languageDescription.getDescription() == null) {
                languageDescription.setDescription("");
            }
        } else if (string.equalsIgnoreCase(CAPTION)) {
            languageDescription.setCaption(string2);
            if (languageDescription.getCaption() == null) {
                languageDescription.setCaption("");
            }
        }
    }

    public void loadAnalyticViews() throws SQLException, IOException {
        this.loadAnalyticViews(null);
    }

    public void loadAnalyticView(String string) throws SQLException, IOException {
        if (!this.schema.isLoaded()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            this.loadAnalyticViews(arrayList);
        }
    }

    public void loadAnalyticViews(List<String> list) throws SQLException, IOException {
        long l;
        block93: {
            Object object;
            Object object2;
            Object object3;
            ResultSet resultSet;
            String string;
            block92: {
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                int n;
                Object object8;
                String string2;
                ArrayList<String> arrayList;
                block91: {
                    block90: {
                        StatefulDescriptions statefulDescriptions;
                        block89: {
                            NamedObject namedObject;
                            block88: {
                                AbstractChildDBObject abstractChildDBObject;
                                Object object9;
                                block87: {
                                    Object object10;
                                    Object object11;
                                    block86: {
                                        String string3;
                                        block85: {
                                            l = System.currentTimeMillis();
                                            arrayList = new ArrayList<String>(Arrays.asList(this.schema.getName()));
                                            string2 = this.getNameCondition(ANALYTIC_VIEW_NAME, list);
                                            string = String.format(this.getQuery("analytic_views"), string2);
                                            Connections.getInstance().lock(this.conn);
                                            resultSet = this.dbUtil.executeQuery(string, arrayList);
                                            try {
                                                if (resultSet != null) {
                                                    while (resultSet.next()) {
                                                        object8 = resultSet.getString(1);
                                                        String string4 = resultSet.getString(2);
                                                        string3 = resultSet.getString(3);
                                                        object11 = resultSet.getString(4);
                                                        object10 = resultSet.getString(5);
                                                        object9 = resultSet.getString(6);
                                                        object3 = resultSet.getString(7);
                                                        object2 = new AnalyticView(this.schema, (String)object8, string4, string3, (String)object11);
                                                        object2.setConsistentSolveSpec((String)object10);
                                                        object2.setTimestamp(HCSObjectsTimestamps.getTimestamp((String)object9));
                                                        object2.setValid(((String)object3).equals("VALID"));
                                                        this.schema.addAnalyticView((AnalyticView)object2);
                                                    }
                                                    break block85;
                                                }
                                                throw this.dbUtil.getLastException();
                                            }
                                            catch (SQLException sQLException) {
                                                LOG.severe(sQLException.getMessage());
                                                throw sQLException;
                                            }
                                            finally {
                                                DBUtil.closeResultSet((ResultSet)resultSet);
                                                Connections.getInstance().unlock(this.conn);
                                            }
                                        }
                                        object8 = null;
                                        n = 0;
                                        string = String.format(this.getQuery("av_classifications"), string2);
                                        Connections.getInstance().lock(this.conn);
                                        resultSet = this.dbUtil.executeQuery(string, arrayList);
                                        try {
                                            if (resultSet != null) {
                                                while (resultSet.next()) {
                                                    string3 = resultSet.getString(1);
                                                    object11 = resultSet.getString(2);
                                                    object10 = resultSet.getString(3);
                                                    object9 = resultSet.getString(4);
                                                    object3 = this.schema.findAV(string3);
                                                    if (object9 == null) {
                                                        if (((String)object11).equalsIgnoreCase(CAPTION) || ((String)object11).equalsIgnoreCase(DESCRIPTION)) {
                                                            HCSMetadataReader.setDescription((Descriptions)object3, (String)object11, this.getDescObjectValue((String)object10));
                                                            continue;
                                                        }
                                                        this.removeObjectClassification((Descriptions)object3, (String)object11);
                                                        object2 = new Classification((String)object11, this.getDescObjectValue((String)object10), (String)object9);
                                                        ((AbstractMappableSchemaObjectWithDesc)object3).addClassification((Classification)((Object)object2));
                                                        continue;
                                                    }
                                                    if (object8 == null) {
                                                        object8 = new LanguageDescription();
                                                        ((LanguageDescription)object8).setLanguage((String)object9);
                                                    }
                                                    if (((LanguageDescription)object8).getLanguage().equalsIgnoreCase((String)object9)) {
                                                        this.setLanguageDescription((LanguageDescription)object8, (String)object11, (String)object10);
                                                        ++n;
                                                    } else {
                                                        object8 = new LanguageDescription();
                                                        ((LanguageDescription)object8).setLanguage((String)object9);
                                                        this.setLanguageDescription((LanguageDescription)object8, (String)object11, (String)object10);
                                                        ++n;
                                                    }
                                                    if (n != 2) continue;
                                                    n = 0;
                                                    ((AbstractSchemaObjectWithDesc)object3).addLanguageDescription((LanguageDescription)object8);
                                                    object8 = null;
                                                }
                                                break block86;
                                            }
                                            throw this.dbUtil.getLastException();
                                        }
                                        catch (SQLException sQLException) {
                                            LOG.severe(sQLException.getMessage());
                                            throw sQLException;
                                        }
                                        finally {
                                            DBUtil.closeResultSet((ResultSet)resultSet);
                                            Connections.getInstance().unlock(this.conn);
                                        }
                                    }
                                    boolean bl = true;
                                    object11 = new ArrayList();
                                    object10 = new HashMap();
                                    this.skipDimensionality = false;
                                    object9 = this.getNameCondition("DTY.analytic_view_name", list);
                                    string = String.format(this.getQuery("av_dimension_keys"), object9);
                                    Connections.getInstance().lock(this.conn);
                                    resultSet = this.dbUtil.executeQuery(string, arrayList);
                                    try {
                                        if (resultSet != null) {
                                            while (resultSet.next()) {
                                                object3 = resultSet.getString(1);
                                                object2 = resultSet.getString(2);
                                                object = resultSet.getString(3);
                                                object7 = resultSet.getString(4);
                                                object6 = resultSet.getString(5);
                                                object5 = resultSet.getString(6);
                                                namedObject = this.schema.findAV((String)object3);
                                                object4 = (ArrayList)((HashMap)object10).get(object3);
                                                if (object4 == null) {
                                                    object4 = new ArrayList();
                                                    ((HashMap)object10).put(object3, object4);
                                                }
                                                statefulDescriptions = this.schema.findDimension((String)object2);
                                                abstractChildDBObject = null;
                                                if (statefulDescriptions == null) {
                                                    abstractChildDBObject = new AVDimensionality();
                                                    abstractChildDBObject.setDimensionalityName((String)object2);
                                                } else {
                                                    abstractChildDBObject = ((AnalyticView)namedObject).findDimensionalityForAlias((String)object);
                                                    if (abstractChildDBObject == null) {
                                                        abstractChildDBObject = new AVDimensionality((AttributeDimension)statefulDescriptions);
                                                    }
                                                }
                                                if (((AnalyticView)namedObject).findDimensionalityForAlias((String)object) != null) {
                                                    abstractChildDBObject.addMapExpression((String)object6);
                                                    abstractChildDBObject.addMappedDimension((String)object5);
                                                    continue;
                                                }
                                                abstractChildDBObject.setDimensionAlias((String)object);
                                                abstractChildDBObject.setMapExpressions(new String[]{object6});
                                                abstractChildDBObject.setMappedDimensions(new String[]{object5});
                                                ((AnalyticView)namedObject).addDimensionality((AVDimensionality)abstractChildDBObject);
                                            }
                                            break block87;
                                        }
                                        throw this.dbUtil.getLastException();
                                    }
                                    catch (SQLException sQLException) {
                                        LOG.severe(sQLException.getMessage());
                                        throw sQLException;
                                    }
                                    finally {
                                        DBUtil.closeResultSet((ResultSet)resultSet);
                                        Connections.getInstance().unlock(this.conn);
                                    }
                                }
                                object9 = new HashMap();
                                string = String.format(this.getQuery("av_hierarchies"), string2);
                                Connections.getInstance().lock(this.conn);
                                resultSet = this.dbUtil.executeQuery(string, arrayList);
                                try {
                                    if (resultSet != null) {
                                        while (resultSet.next()) {
                                            object3 = resultSet.getString(1);
                                            object2 = resultSet.getString(2);
                                            object = resultSet.getString(3);
                                            object7 = resultSet.getString(4);
                                            object6 = resultSet.getString(5);
                                            object5 = resultSet.getString(6);
                                            namedObject = this.schema.findAV((String)object3);
                                            object4 = ((AnalyticView)namedObject).findDimensionalityForAlias((String)object2);
                                            statefulDescriptions = this.schema.findHierarchy((String)object7);
                                            abstractChildDBObject = null;
                                            if (statefulDescriptions != null) {
                                                abstractChildDBObject = new AVHierarchy((Hierarchy)statefulDescriptions);
                                            } else {
                                                abstractChildDBObject = new AVHierarchy();
                                                abstractChildDBObject.setName((String)object7);
                                                abstractChildDBObject.setHierarchyName((String)object7);
                                            }
                                            abstractChildDBObject.setHierarchyAlias((String)object6);
                                            Boolean bl = Boolean.FALSE;
                                            if (((String)object5).equalsIgnoreCase("Y")) {
                                                bl = Boolean.TRUE;
                                            }
                                            abstractChildDBObject.setHierarchyDefault(bl);
                                            abstractChildDBObject.setHierarchyIncluded(Boolean.TRUE);
                                            ((AVDimensionality)object4).addHierarchy((AVHierarchy)abstractChildDBObject);
                                        }
                                        break block88;
                                    }
                                    throw this.dbUtil.getLastException();
                                }
                                catch (SQLException sQLException) {
                                    LOG.severe(sQLException.getMessage());
                                    throw sQLException;
                                }
                                finally {
                                    DBUtil.closeResultSet((ResultSet)resultSet);
                                    Connections.getInstance().unlock(this.conn);
                                }
                            }
                            string = String.format(this.getQuery("av_dimensionality_classifications"), string2);
                            Connections.getInstance().lock(this.conn);
                            resultSet = this.dbUtil.executeQuery(string, arrayList);
                            try {
                                if (resultSet != null) {
                                    while (resultSet.next()) {
                                        object3 = resultSet.getString(1);
                                        object2 = resultSet.getString(2);
                                        object = resultSet.getString(3);
                                        object7 = resultSet.getString(4);
                                        object6 = resultSet.getString(5);
                                        object5 = this.schema.findAV((String)object3);
                                        namedObject = ((AnalyticView)object5).findDimensionalityForAlias((String)object2);
                                        if (namedObject == null) continue;
                                        if (((String)object).equalsIgnoreCase(CAPTION) || ((String)object).equalsIgnoreCase(DESCRIPTION)) {
                                            HCSMetadataReader.setDescription((Descriptions)((Object)namedObject), (String)object, (String)object7);
                                            continue;
                                        }
                                        object4 = new Classification((String)object, (String)object7, (String)object6);
                                        ((AVDimensionality)namedObject).addClassification((Classification)((Object)object4));
                                    }
                                    break block89;
                                }
                                throw this.dbUtil.getLastException();
                            }
                            catch (SQLException sQLException) {
                                LOG.severe(sQLException.getMessage());
                                throw sQLException;
                            }
                            finally {
                                DBUtil.closeResultSet((ResultSet)resultSet);
                                Connections.getInstance().unlock(this.conn);
                            }
                        }
                        string = String.format(this.getQuery("av_measures"), string2);
                        Connections.getInstance().lock(this.conn);
                        resultSet = this.dbUtil.executeQuery(string, arrayList);
                        try {
                            if (resultSet != null) {
                                while (resultSet.next()) {
                                    object3 = resultSet.getString(1);
                                    object2 = resultSet.getString(2);
                                    object = resultSet.getString(3);
                                    object7 = resultSet.getString(4);
                                    object6 = resultSet.getString(5);
                                    object5 = resultSet.getString(6);
                                    int n2 = resultSet.getInt(7);
                                    if (object5 == null) {
                                        object5 = "NUMBER";
                                    }
                                    if ((statefulDescriptions = ((AnalyticView)(object4 = this.schema.findAV((String)object3))).findMeasure((String)object2)) == null) {
                                        statefulDescriptions = ((AnalyticView)object4).addMeasure((String)object2);
                                    }
                                    ((AVMeasure)statefulDescriptions).setMapExpression((String)object7);
                                    ((AVMeasure)statefulDescriptions).setConsistentSolveSpec((String)object6);
                                    ((AVMeasure)statefulDescriptions).setMeasureOrder(Integer.toString(n2));
                                    if (!((String)object5).equals("NUMBER")) continue;
                                    ((AVBaseMeasure)statefulDescriptions).setNumeric(true);
                                }
                                break block90;
                            }
                            throw this.dbUtil.getLastException();
                        }
                        catch (SQLException sQLException) {
                            LOG.severe(sQLException.getMessage());
                            throw sQLException;
                        }
                        finally {
                            DBUtil.closeResultSet((ResultSet)resultSet);
                            Connections.getInstance().unlock(this.conn);
                        }
                    }
                    string = String.format(this.getQuery("av_calculated_measures"), string2);
                    Connections.getInstance().lock(this.conn);
                    resultSet = this.dbUtil.executeQuery(string, arrayList);
                    try {
                        if (resultSet != null) {
                            while (resultSet.next()) {
                                object3 = resultSet.getString(1);
                                object2 = resultSet.getString(2);
                                object = resultSet.getString(3);
                                object7 = this.schema.findAV((String)object3);
                                object6 = ((AnalyticView)object7).findCalculatedMeasure((String)object2);
                                if (object6 == null) {
                                    object6 = new AVCalculatedMeasure((String)object2);
                                    ((AnalyticView)object7).addCalculatedMeasure((AVCalculatedMeasure)object6);
                                }
                                ((AVCalculatedMeasure)object6).setMeasureExpression((String)object);
                            }
                            break block91;
                        }
                        throw this.dbUtil.getLastException();
                    }
                    catch (SQLException sQLException) {
                        LOG.severe(sQLException.getMessage());
                        throw sQLException;
                    }
                    finally {
                        DBUtil.closeResultSet((ResultSet)resultSet);
                        Connections.getInstance().unlock(this.conn);
                    }
                }
                n = 0;
                string = String.format(this.getQuery("av_measure_classifications"), string2);
                Connections.getInstance().lock(this.conn);
                resultSet = this.dbUtil.executeQuery(string, arrayList);
                try {
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            object3 = resultSet.getString(1);
                            object2 = resultSet.getString(2);
                            object = resultSet.getString(3);
                            object7 = resultSet.getString(4);
                            object6 = resultSet.getString(5);
                            object5 = this.schema.findAV((String)object3);
                            AVBaseMeasure aVBaseMeasure = ((AnalyticView)object5).findBaseMeasure((String)object2);
                            if (aVBaseMeasure == null) continue;
                            if (object6 == null) {
                                if (((String)object).equalsIgnoreCase(CAPTION) || ((String)object).equalsIgnoreCase(DESCRIPTION)) {
                                    HCSMetadataReader.setDescription(aVBaseMeasure, (String)object, this.getDescObjectValue((String)object7));
                                    continue;
                                }
                                this.removeObjectClassification(aVBaseMeasure, (String)object);
                                object4 = new Classification((String)object, this.getDescObjectValue((String)object7), (String)object6);
                                aVBaseMeasure.addClassification((Classification)((Object)object4));
                                continue;
                            }
                            if (object8 == null) {
                                object8 = new LanguageDescription();
                                ((LanguageDescription)object8).setLanguage((String)object6);
                            }
                            if (((LanguageDescription)object8).getLanguage().equalsIgnoreCase((String)object6)) {
                                this.setLanguageDescription((LanguageDescription)object8, (String)object, (String)object7);
                                ++n;
                            } else {
                                object8 = new LanguageDescription();
                                ((LanguageDescription)object8).setLanguage((String)object6);
                                this.setLanguageDescription((LanguageDescription)object8, (String)object, (String)object7);
                                ++n;
                            }
                            if (n != 2) continue;
                            n = 0;
                            aVBaseMeasure.addLanguageDescription((LanguageDescription)object8);
                            object8 = null;
                        }
                        break block92;
                    }
                    throw this.dbUtil.getLastException();
                }
                catch (SQLException sQLException) {
                    LOG.severe(sQLException.getMessage());
                    throw sQLException;
                }
                finally {
                    DBUtil.closeResultSet((ResultSet)resultSet);
                    Connections.getInstance().unlock(this.conn);
                }
            }
            string = this.getQuery("av_sharing");
            Connections.getInstance().lock(this.conn);
            resultSet = this.dbUtil.executeQuery(string, new ArrayList<String>(Arrays.asList(this.schema.getName())));
            try {
                if (resultSet != null) {
                    while (resultSet.next()) {
                        object3 = resultSet.getString(1);
                        object2 = resultSet.getString(2);
                        object = this.schema.findAV((String)object3);
                        if (object == null) continue;
                        ((AbstractMappableSchemaObjectWithDesc)object).setSharing(this.getSharing((String)object2));
                    }
                    break block93;
                }
                throw this.dbUtil.getLastException();
            }
            catch (SQLException sQLException) {
                LOG.severe(sQLException.getMessage());
                throw sQLException;
            }
            finally {
                DBUtil.closeResultSet((ResultSet)resultSet);
                Connections.getInstance().unlock(this.conn);
            }
        }
        this.loadAVCacheMeasureGroups(list);
        long l2 = System.currentTimeMillis() - l;
        LOG.finest(String.format("analytic views loaded: %s%n", l2));
    }

    /*
     * WARNING - void declaration
     */
    private void loadAVCacheMeasureGroups(List<String> list) throws SQLException {
        block41: {
            String string = this.getNameCondition(ANALYTIC_VIEW_NAME, list);
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(this.schema.getName()));
            String string2 = String.format(this.getQuery("av_cache_measure_groups"), string);
            Connections.getInstance().lock(this.conn);
            ResultSet resultSet = this.dbUtil.executeQuery(string2, arrayList);
            AnalyticView analyticView = null;
            boolean bl = true;
            String string3 = null;
            boolean bl2 = false;
            boolean bl3 = false;
            AVCacheMeasureGroup[] aVCacheMeasureGroupArray = null;
            int n = 0;
            ArrayList<AVCacheMeasureGroup> arrayList2 = null;
            AVCacheMeasureGroup aVCacheMeasureGroup = null;
            ArrayList<String> arrayList3 = null;
            ArrayList<String> arrayList4 = null;
            ArrayList<LevelNameAndState> arrayList5 = null;
            try {
                if (resultSet != null) {
                    while (resultSet.next()) {
                        AVCacheMeasureGroup[] aVCacheMeasureGroupArray2;
                        String string42;
                        String string5 = resultSet.getString(1);
                        if (bl) {
                            analyticView = this.schema.findAV(string5);
                            bl = false;
                            string3 = string5;
                            bl2 = false;
                            bl3 = false;
                            aVCacheMeasureGroupArray = null;
                            n = 0;
                            arrayList2 = new ArrayList<AVCacheMeasureGroup>();
                            aVCacheMeasureGroup = null;
                            arrayList3 = new ArrayList<String>();
                            arrayList4 = new ArrayList<String>();
                            arrayList5 = new ArrayList<LevelNameAndState>();
                        }
                        if (string3 != null && !string5.equalsIgnoreCase(string3)) {
                            if (bl2) {
                                void var22_38;
                                if (!bl3) {
                                    bl3 = true;
                                    this.addMeasuresToCacheMeasureGroup((List<String>)arrayList4, aVCacheMeasureGroup, false);
                                } else {
                                    boolean bl4 = false;
                                    if (arrayList3.size() != arrayList4.size()) {
                                        bl4 = true;
                                    } else {
                                        for (String string42 : arrayList4) {
                                            if (arrayList3.contains(string42)) continue;
                                            bl4 = true;
                                            break;
                                        }
                                    }
                                    if (bl4) {
                                        aVCacheMeasureGroup = new AVCacheMeasureGroup();
                                        arrayList2.add(aVCacheMeasureGroup);
                                        this.addMeasuresToCacheMeasureGroup(arrayList4, aVCacheMeasureGroup, false);
                                    }
                                }
                                this.addLevelsToCacheMeasureGroup((String)aVCacheMeasureGroupArray, (List<LevelNameAndState>)arrayList5, aVCacheMeasureGroup);
                                aVCacheMeasureGroupArray2 = arrayList2.toArray(new AVCacheMeasureGroup[0]);
                                analyticView.setCacheMeasureGroups(aVCacheMeasureGroupArray2);
                                AVCacheMeasureGroup[] aVCacheMeasureGroupArray3 = aVCacheMeasureGroupArray2;
                                int n2 = aVCacheMeasureGroupArray3.length;
                                boolean bl4 = false;
                                while (var22_38 < n2) {
                                    AVCacheMeasureGroup aVCacheMeasureGroup2 = aVCacheMeasureGroupArray3[var22_38];
                                    if (analyticView.getMeasures().length == aVCacheMeasureGroup2.getCacheMeasureGroupMeasures().length) {
                                        arrayList4.clear();
                                        arrayList4.add("ALL");
                                        this.addMeasuresToCacheMeasureGroup(arrayList4, aVCacheMeasureGroup2, true);
                                    }
                                    ++var22_38;
                                }
                            }
                            analyticView = this.schema.findAV(string5);
                            string3 = string5;
                            bl2 = false;
                            bl3 = false;
                            aVCacheMeasureGroupArray = null;
                            n = 0;
                            arrayList2 = new ArrayList();
                            aVCacheMeasureGroup = null;
                            arrayList3 = new ArrayList();
                            arrayList4 = new ArrayList();
                            arrayList5 = new ArrayList();
                        }
                        aVCacheMeasureGroupArray2 = resultSet.getString(2);
                        aVCacheMeasureGroupArray2 = "MATERIALIZED";
                        String object3 = resultSet.getString(3);
                        string42 = resultSet.getString(4);
                        String string6 = resultSet.getString(5);
                        String string7 = resultSet.getString(6);
                        int n3 = resultSet.getInt(7);
                        if (!bl2) {
                            bl2 = true;
                            n = n3;
                            aVCacheMeasureGroupArray = aVCacheMeasureGroupArray2;
                            aVCacheMeasureGroup = new AVCacheMeasureGroup();
                            arrayList2.add(aVCacheMeasureGroup);
                        }
                        if (n == n3) {
                            if (string6 == null || string6.isEmpty()) {
                                arrayList4.add(string7);
                                continue;
                            }
                            if (string42 == null || string42.isEmpty()) {
                                arrayList5.add(new LevelNameAndState(string6, 3));
                                continue;
                            }
                            if (object3 == null || object3.isEmpty()) {
                                arrayList5.add(new LevelNameAndState(string42 + "." + string6, 2));
                                continue;
                            }
                            arrayList5.add(new LevelNameAndState(object3 + "." + string42 + "." + string6, 1));
                            continue;
                        }
                        if (!bl3) {
                            bl3 = true;
                            this.addMeasuresToCacheMeasureGroup(arrayList4, aVCacheMeasureGroup, false);
                        } else {
                            boolean bl5 = false;
                            if (arrayList3.size() != arrayList4.size()) {
                                bl5 = true;
                            } else {
                                for (String string8 : arrayList4) {
                                    if (arrayList3.contains(string8)) continue;
                                    bl5 = true;
                                    break;
                                }
                            }
                            if (bl5) {
                                aVCacheMeasureGroup = new AVCacheMeasureGroup();
                                arrayList2.add(aVCacheMeasureGroup);
                                this.addMeasuresToCacheMeasureGroup(arrayList4, aVCacheMeasureGroup, false);
                            }
                        }
                        arrayList3.clear();
                        for (String string9 : arrayList4) {
                            arrayList3.add(string9);
                        }
                        this.addLevelsToCacheMeasureGroup((String)aVCacheMeasureGroupArray, arrayList5, aVCacheMeasureGroup);
                        arrayList4.clear();
                        arrayList5.clear();
                        n = n3;
                        aVCacheMeasureGroupArray = aVCacheMeasureGroupArray2;
                        if (string6 == null || string6.isEmpty()) {
                            arrayList4.add(string7);
                            continue;
                        }
                        if (string42 == null || string42.isEmpty()) {
                            arrayList5.add(new LevelNameAndState(string6, 3));
                            continue;
                        }
                        if (object3 == null || object3.isEmpty()) {
                            arrayList5.add(new LevelNameAndState(string42 + "." + string6, 2));
                            continue;
                        }
                        arrayList5.add(new LevelNameAndState(object3 + "." + string42 + "." + string6, 1));
                    }
                    if (bl2) {
                        if (!bl3) {
                            bl3 = true;
                            this.addMeasuresToCacheMeasureGroup((List<String>)arrayList4, aVCacheMeasureGroup, false);
                        } else {
                            boolean bl6 = false;
                            if (arrayList3.size() != arrayList4.size()) {
                                bl6 = true;
                            } else {
                                for (String string10 : arrayList4) {
                                    if (arrayList3.contains(string10)) continue;
                                    bl6 = true;
                                    break;
                                }
                            }
                            if (bl6) {
                                aVCacheMeasureGroup = new AVCacheMeasureGroup();
                                arrayList2.add(aVCacheMeasureGroup);
                                this.addMeasuresToCacheMeasureGroup((List<String>)arrayList4, aVCacheMeasureGroup, false);
                            }
                        }
                        this.addLevelsToCacheMeasureGroup((String)aVCacheMeasureGroupArray, (List<LevelNameAndState>)arrayList5, aVCacheMeasureGroup);
                        AVCacheMeasureGroup[] aVCacheMeasureGroupArray3 = arrayList2.toArray(new AVCacheMeasureGroup[0]);
                        analyticView.setCacheMeasureGroups(aVCacheMeasureGroupArray3);
                        for (AVCacheMeasureGroup aVCacheMeasureGroup3 : aVCacheMeasureGroupArray3) {
                            if (analyticView.getMeasures().length != aVCacheMeasureGroup3.getCacheMeasureGroupMeasures().length) continue;
                            arrayList4.clear();
                            arrayList4.add("ALL");
                            this.addMeasuresToCacheMeasureGroup(arrayList4, aVCacheMeasureGroup3, true);
                        }
                    }
                    break block41;
                }
                throw this.dbUtil.getLastException();
            }
            catch (SQLException sQLException) {
                LOG.severe(sQLException.getMessage());
                throw sQLException;
            }
            finally {
                DBUtil.closeResultSet((ResultSet)resultSet);
                Connections.getInstance().unlock(this.conn);
            }
        }
    }

    private void addMeasuresToCacheMeasureGroup(List<String> list, AVCacheMeasureGroup aVCacheMeasureGroup, boolean bl) {
        ArrayList<AVCacheMeasureGroupMeasure> arrayList = new ArrayList<AVCacheMeasureGroupMeasure>();
        for (String string : list) {
            AVCacheMeasureGroupMeasure aVCacheMeasureGroupMeasure = new AVCacheMeasureGroupMeasure(string);
            if (bl) {
                aVCacheMeasureGroupMeasure.setCacheMeasureGroupAllActive(true);
                aVCacheMeasureGroup.setCacheMeasureGroupAllSelected(true);
            } else {
                aVCacheMeasureGroupMeasure.setCacheMeasureGroupAllActive(false);
                aVCacheMeasureGroup.setCacheMeasureGroupAllSelected(false);
            }
            arrayList.add(aVCacheMeasureGroupMeasure);
        }
        aVCacheMeasureGroup.setCacheMeasureGroupMeasures(arrayList.toArray(new AVCacheMeasureGroupMeasure[0]));
    }

    private void addLevelsToCacheMeasureGroup(String string, List<LevelNameAndState> list, AVCacheMeasureGroup aVCacheMeasureGroup) {
        AVCacheLevelGroup aVCacheLevelGroup = new AVCacheLevelGroup();
        aVCacheLevelGroup.setCacheLevelGroupProcessMode(string);
        ArrayList<AVCacheLevelGroupDimHierLevel> arrayList = new ArrayList<AVCacheLevelGroupDimHierLevel>();
        for (LevelNameAndState levelNameAndState : list) {
            AVCacheLevelGroupDimHierLevel aVCacheLevelGroupDimHierLevel = new AVCacheLevelGroupDimHierLevel(levelNameAndState.name, levelNameAndState.state);
            arrayList.add(aVCacheLevelGroupDimHierLevel);
        }
        aVCacheLevelGroup.setCacheLevelGroupHierLevels(arrayList.toArray(new AVCacheLevelGroupDimHierLevel[0]));
        aVCacheMeasureGroup.addCacheLevelGroup(aVCacheLevelGroup);
    }

    private void updateCacheLevelGroupNames() {
        AVCacheMeasureProviderContext aVCacheMeasureProviderContext = AVCacheMeasureProviderContext.getInstance();
        List<AnalyticView> list = this.schema.getAnalyticViews();
        for (AnalyticView analyticView : list) {
            AVCacheMeasureGroup[] aVCacheMeasureGroupArray;
            for (AVCacheMeasureGroup aVCacheMeasureGroup : aVCacheMeasureGroupArray = analyticView.getCacheMeasureGroups()) {
                AVCacheLevelGroup[] aVCacheLevelGroupArray;
                for (AVCacheLevelGroup aVCacheLevelGroup : aVCacheLevelGroupArray = aVCacheMeasureGroup.getCacheLevelGroups()) {
                    AVCacheLevelGroupDimHierLevel[] aVCacheLevelGroupDimHierLevelArray;
                    for (AVCacheLevelGroupDimHierLevel aVCacheLevelGroupDimHierLevel : aVCacheLevelGroupDimHierLevelArray = aVCacheLevelGroup.getCacheLevelGroupHierLevels()) {
                        Object object;
                        Object object2;
                        String string;
                        if (aVCacheLevelGroupDimHierLevel.getCacheLevelGroupDimHierLevelState() == 3) {
                            string = aVCacheLevelGroupDimHierLevel.getName();
                            object2 = this.findDimensionAndHierarchyAliasFromLevelName(this.schema, analyticView, string);
                            object = object2[0] + "." + (String)object2[1] + "." + string;
                            aVCacheLevelGroupDimHierLevel.setName((String)object);
                            continue;
                        }
                        if (aVCacheLevelGroupDimHierLevel.getCacheLevelGroupDimHierLevelState() != 2) continue;
                        string = aVCacheLevelGroupDimHierLevel.getName();
                        object2 = new IdentifierElement(string);
                        object = ((IdentifierElement)object2).getFirst();
                        String string2 = ((IdentifierElement)object2).getSecond();
                        String string3 = this.findDimensionAliasFromHierarchyAliasAndLevelName(this.schema, analyticView, (String)object, string2);
                        String string4 = string3 + "." + (String)object + "." + string2;
                        aVCacheLevelGroupDimHierLevel.setName(string4);
                    }
                }
            }
        }
    }

    private String[] findDimensionAndHierarchyAliasFromLevelName(HCSSchema hCSSchema, AnalyticView analyticView, String string) {
        AVDimensionality[] aVDimensionalityArray;
        String[] stringArray = new String[2];
        for (AVDimensionality aVDimensionality : aVDimensionalityArray = analyticView.getDimensions()) {
            AVHierarchy[] aVHierarchyArray;
            String string2 = aVDimensionality.getDimensionAlias();
            for (AVHierarchy aVHierarchy : aVHierarchyArray = aVDimensionality.getHierarchies()) {
                String string3 = aVHierarchy.getHierarchyAlias();
                String string4 = aVHierarchy.getHierarchyName();
                Hierarchy hierarchy = hCSSchema.findHierarchy(string4);
                if (hierarchy == null) continue;
                for (HierarchyLevel hierarchyLevel : hierarchy.getHierarchyLevels()) {
                    if (!hierarchyLevel.getLevelName().equals(string)) continue;
                    stringArray[0] = string2;
                    stringArray[1] = string3;
                    return stringArray;
                }
            }
        }
        return stringArray;
    }

    private String findDimensionAliasFromHierarchyAliasAndLevelName(HCSSchema hCSSchema, AnalyticView analyticView, String string, String string2) {
        AVDimensionality[] aVDimensionalityArray;
        String string3 = null;
        for (AVDimensionality aVDimensionality : aVDimensionalityArray = analyticView.getDimensions()) {
            AVHierarchy[] aVHierarchyArray;
            String string4 = aVDimensionality.getDimensionAlias();
            for (AVHierarchy aVHierarchy : aVHierarchyArray = aVDimensionality.getHierarchies()) {
                Hierarchy hierarchy;
                String string5 = aVHierarchy.getHierarchyAlias();
                String string6 = aVHierarchy.getHierarchyName();
                if (!string5.equals(string) || (hierarchy = hCSSchema.findHierarchy(string6)) == null) continue;
                for (HierarchyLevel hierarchyLevel : hierarchy.getHierarchyLevels()) {
                    if (!hierarchyLevel.getLevelName().equals(string2)) continue;
                    return string4;
                }
            }
        }
        return string3;
    }

    private String getNameCondition(String string, List<String> list) {
        return this.getNameCondition(string, null, list);
    }

    private String getNameCondition(String string, String string2, List<String> list) {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = "";
        if (list != null) {
            for (String string4 : list) {
                stringBuffer.append(String.format("q'[%s]',", string4));
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
                string3 = string2 == null ? String.format(" and %s in (%s)", string, stringBuffer) : String.format(" and %s.%s in (%s)", string2, string, stringBuffer);
            }
        }
        return string3;
    }

    private String getNameCondition(String string, String string2) {
        String string3 = "";
        if (string2 != null) {
            string3 = String.format(" and %s = %s", string, string2);
        }
        return string3;
    }

    public void reloadMeasures(AnalyticView analyticView, List<String> list) throws SQLException, IOException {
        String string;
        long l;
        block32: {
            Object object;
            String string2;
            String string3;
            Object object2;
            String string4;
            ArrayList<String> arrayList;
            Object object3;
            String string5;
            block31: {
                Object object4;
                block30: {
                    l = System.currentTimeMillis();
                    string5 = this.getQuery("av_measures");
                    string = this.getNameCondition(ANALYTIC_VIEW_NAME, "'" + analyticView.getName() + "'");
                    string5 = String.format(string5, string);
                    for (String object42 : list) {
                        object3 = analyticView.findMeasure(object42);
                        if (object3 != null) {
                            analyticView.removeMeasure((AVMeasure)object3);
                        }
                        if ((object4 = analyticView.findCalculatedMeasure(object42)) == null) continue;
                        analyticView.removeCalculatedMeasure((AVCalculatedMeasure)object4);
                    }
                    arrayList = new ArrayList<String>(Arrays.asList(this.schema.getName()));
                    Connections.getInstance().lock(this.conn);
                    ResultSet resultSet = this.dbUtil.executeQuery(string5, (List)arrayList);
                    try {
                        if (resultSet != null) {
                            while (resultSet.next()) {
                                object3 = resultSet.getString(1);
                                object4 = resultSet.getString(2);
                                string4 = resultSet.getString(3);
                                object2 = resultSet.getString(4);
                                string3 = resultSet.getString(5);
                                string2 = resultSet.getString(6);
                                if (!((String)object3).equals(analyticView.getName())) continue;
                                object = analyticView.findMeasure((String)object4);
                                if (object == null) {
                                    object = analyticView.addMeasure((String)object4);
                                    ((AVBaseMeasure)object).setAV(analyticView);
                                }
                                ((AVMeasure)object).setMapExpression((String)object2);
                                ((AVMeasure)object).setConsistentSolveSpec(string3);
                                if (!string2.equals("NUMBER")) continue;
                                ((AVBaseMeasure)object).setNumeric(true);
                            }
                            break block30;
                        }
                        throw this.dbUtil.getLastException();
                    }
                    catch (SQLException sQLException) {
                        LOG.severe(sQLException.getMessage());
                        throw sQLException;
                    }
                    finally {
                        DBUtil.closeResultSet((ResultSet)resultSet);
                        Connections.getInstance().unlock(this.conn);
                    }
                }
                string5 = String.format(this.getQuery("av_calculated_measures"), string);
                Connections.getInstance().lock(this.conn);
                ResultSet resultSet = this.dbUtil.executeQuery(string5, (List)arrayList);
                try {
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            object3 = resultSet.getString(1);
                            object4 = resultSet.getString(2);
                            string4 = resultSet.getString(3);
                            if (!((String)object3).equals(analyticView.getName())) continue;
                            object2 = analyticView.findCalculatedMeasure((String)object4);
                            if (object2 == null) {
                                object2 = new AVCalculatedMeasure((String)object4);
                                ((AVBaseMeasure)object2).setAV(analyticView);
                                analyticView.addCalculatedMeasure((AVCalculatedMeasure)object2);
                            }
                            ((AVCalculatedMeasure)object2).setMeasureExpression(string4);
                        }
                        break block31;
                    }
                    throw this.dbUtil.getLastException();
                }
                catch (SQLException sQLException) {
                    LOG.severe(sQLException.getMessage());
                    throw sQLException;
                }
                finally {
                    DBUtil.closeResultSet((ResultSet)resultSet);
                    Connections.getInstance().unlock(this.conn);
                }
            }
            object3 = null;
            int n = 0;
            string5 = String.format(this.getQuery("av_measure_classifications"), string);
            Connections.getInstance().lock(this.conn);
            ResultSet resultSet = this.dbUtil.executeQuery(string5, (List)arrayList);
            try {
                if (resultSet != null) {
                    while (resultSet.next()) {
                        string4 = resultSet.getString(1);
                        object2 = resultSet.getString(2);
                        string3 = resultSet.getString(3);
                        string2 = resultSet.getString(4);
                        object = resultSet.getString(5);
                        AVBaseMeasure aVBaseMeasure = analyticView.findBaseMeasure((String)object2);
                        if (aVBaseMeasure == null) continue;
                        if (object == null) {
                            if (string3.equalsIgnoreCase(CAPTION) || string3.equalsIgnoreCase(DESCRIPTION)) {
                                HCSMetadataReader.setDescription(aVBaseMeasure, string3, string2);
                                continue;
                            }
                            this.removeObjectClassification(aVBaseMeasure, string3);
                            Classification classification = new Classification(string3, this.getDescObjectValue(string2), (String)object);
                            aVBaseMeasure.addClassification(classification);
                            continue;
                        }
                        if (object3 == null) {
                            object3 = new LanguageDescription();
                            ((LanguageDescription)object3).setLanguage((String)object);
                        }
                        if (((LanguageDescription)object3).getLanguage().equalsIgnoreCase((String)object)) {
                            this.setLanguageDescription((LanguageDescription)object3, string3, string2);
                            ++n;
                        } else {
                            object3 = new LanguageDescription();
                            ((LanguageDescription)object3).setLanguage((String)object);
                            this.setLanguageDescription((LanguageDescription)object3, string3, string2);
                            ++n;
                        }
                        if (n != 2) continue;
                        n = 0;
                        aVBaseMeasure.addLanguageDescription((LanguageDescription)object3);
                        object3 = null;
                    }
                    break block32;
                }
                throw this.dbUtil.getLastException();
            }
            catch (SQLException sQLException) {
                LOG.severe(sQLException.getMessage());
                throw sQLException;
            }
            finally {
                DBUtil.closeResultSet((ResultSet)resultSet);
                Connections.getInstance().unlock(this.conn);
            }
        }
        long l2 = System.currentTimeMillis() - l;
        LOG.finest(String.format("measures for %s reloaded: %s%n", string, l2));
    }

    private void removeObjectClassification(Descriptions descriptions, String string) {
        Classification classification = descriptions.findClassification(string);
        if (classification != null) {
            descriptions.removeClassifications(classification);
        }
    }

    private String getDescObjectValue(String string) {
        return string == null ? "" : string;
    }

    public void reloadAnalyticViews(List<String> list, boolean bl) throws SQLException, IOException {
        this.schema.setLoaded(false);
        for (String string : list) {
            AnalyticView analyticView = this.schema.findAV(string);
            if (analyticView == null) continue;
            this.schema.getAnalyticViews().remove(analyticView);
        }
        this.loadAnalyticViews(list);
        this.schema.setLoaded(true);
    }

    public void reloadDimensions(List<String> list) throws SQLException, IOException {
        this.schema.setLoaded(false);
        for (String string : list) {
            AttributeDimension attributeDimension = this.schema.findDimension(string);
            if (attributeDimension == null) continue;
            this.schema.getDimensions().remove(attributeDimension);
        }
        this.loadAttributeDimensions(list);
        this.schema.setLoaded(true);
    }

    public void reloadHierarchies(List<String> list) throws SQLException, IOException {
        this.schema.setLoaded(false);
        for (String string : list) {
            Hierarchy hierarchy = this.schema.findHierarchy(string);
            if (hierarchy == null) continue;
            this.schema.getHierarchies().remove(hierarchy);
        }
        this.loadHierarchies(list);
        this.schema.setLoaded(true);
    }

    public static void setDescription(Descriptions descriptions, String string, String string2) {
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase(DESCRIPTION)) {
            descriptions.setDescription(string2);
            String string3 = descriptions.getCaption();
            if (string3 == null) {
                descriptions.setCaption(string2);
            }
        }
        if (string.equalsIgnoreCase(CAPTION)) {
            descriptions.setCaption(string2);
        }
    }

    public List<String> getAVsWithDimensionName(String string) throws SQLException, IOException {
        ArrayList<String> arrayList;
        block7: {
            arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(this.schema.getName()));
            String string2 = this.getQuery("avs_including_dimension_name");
            Connections.getInstance().lock(this.conn);
            ResultSet resultSet = this.dbUtil.executeQuery(string2, arrayList2);
            try {
                if (resultSet != null) {
                    while (resultSet.next()) {
                        arrayList.add(resultSet.getString(1));
                    }
                    break block7;
                }
                throw this.dbUtil.getLastException();
            }
            catch (SQLException sQLException) {
                LOG.severe(sQLException.getMessage());
                throw sQLException;
            }
            finally {
                DBUtil.closeResultSet((ResultSet)resultSet);
                Connections.getInstance().unlock(this.conn);
            }
        }
        return arrayList;
    }

    private String getSharing(String string) {
        if (string.equals(METADATA_LINK)) {
            return METADATA;
        }
        if (string.equals(DATA_LINK)) {
            return OBJECT;
        }
        return NONE;
    }

    private static void logSql(String string, Map<String, ?> map) {
        String string2 = string;
        if (map != null) {
            for (String string3 : map.keySet()) {
                string2 = string2.replaceAll(string3, String.format("'%s'", map.get(string3).toString()));
            }
        }
        if (DEBUG) {
            System.out.println(string2);
        }
    }

    private static void logTime(String string, long l) {
        if (DEBUG) {
            float f = (float)l / 1000.0f;
            System.out.println(string + f + " seconds");
        }
    }

    public static void main(String[] stringArray) {
        DatabaseImpl databaseImpl = new DatabaseImpl();
        try {
            databaseImpl.getConnection("global", "global", "localhost:1521:view");
            HCSSchema hCSSchema = new HCSSchema("GLOBAL");
            HCSMetadataReader hCSMetadataReader = new HCSMetadataReader(databaseImpl, hCSSchema);
            hCSMetadataReader.loadMetadata();
            List<AttributeDimension> list2 = hCSSchema.getDimensions();
            System.out.println("Dimension size =" + list2.size());
            for (AttributeDimension list3 : list2) {
                System.out.println(list3.toString());
                System.out.println("attributes:");
                for (DimensionAttribute dimensionAttribute : list3.getAttributes()) {
                    System.out.println("\t " + dimensionAttribute.toString());
                }
                System.out.println("levels:");
                for (DimensionLevel dimensionLevel : list3.getLevels()) {
                    System.out.println("\t " + dimensionLevel.toString());
                }
            }
            List<Hierarchy> list4 = hCSSchema.getHierarchies();
            System.out.println("Hierarchies size =" + list4.size());
            Iterator iterator = list4.iterator();
            while (iterator.hasNext()) {
                Hierarchy hierarchy = (Hierarchy)iterator.next();
                System.out.println(hierarchy.toString());
                System.out.println("levels:");
                for (HierarchyLevel hierarchyLevel : hierarchy.getHierarchyLevels()) {
                    System.out.println("\t " + hierarchyLevel.toString());
                }
            }
            List<AnalyticView> list = hCSSchema.getAnalyticViews();
            System.out.println("Analytic Views size =" + list.size());
            for (AnalyticView analyticView : list) {
                System.out.println(analyticView.toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        LOG = Logger.getLogger(HCSMetadataReader.class.getName());
    }

    private static class LevelNameAndState {
        public String name;
        public int state;

        public LevelNameAndState(String string, int n) {
            this.name = string;
            this.state = n;
        }
    }
}

