/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.hierarchyviewer;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.hierarchy.model.HierarchyLevel;
import oracle.hcs.table.Queries;
import oracle.hcs.templates.stringexpr.ParamProperty;
import oracle.hcs.templates.stringexpr.ParamStringExpr;
import oracle.hcs.templates.stringexpr.ParamValue;
import oracle.hcs.templates.templateview.ItemElement;
import oracle.hcs.templates.templateview.Member;
import oracle.hcs.templates.templateview.QDRData;
import oracle.hcs.tree.loader.TreeLoaderBreadthFirst;
import oracle.hcs.tree.model.DefaultNode;
import oracle.hcs.tree.model.HierarchyNodeData;
import oracle.hcs.tree.model.Tree;
import oracle.hcs.util.JavaXMLBind;

public class HierarchyLoader
extends TreeLoaderBreadthFirst
implements ParamValue,
ParamProperty {
    private int rowNum;
    private Hierarchy dimensionHierarchy;
    private DBUtil dbUtil;
    private Connection connection;
    private String viewName;
    private String column;
    private boolean useDescription;
    private QDRData[] qdrs;
    private List<QDRData> hierarchyMembers;
    private List<QDRData> hierarchyParentMembers;
    private List<String> memberLevelKeyColumnNames;
    private ParamStringExpr paramStringExpr;
    private static Queries queries;
    private static final String XMLFILE = "hierarchyloaderqueries.xml";
    private static final Logger LOG;
    final String DEPTH = "depth";
    final String KEY = "key";
    final String PARENT = "parent";
    final String DESCRIPTION = "description";
    final String MEMBER_CAPTION = "member_caption";
    final String MEMBER_DESCRIPTION = "member_description";
    final String MEMBER_UNIQUE_NAME = "member_unique_name";
    final String LEVEL_NAME = "level_name";
    final String ALL_LEVEL = "ALL";
    final int MEMBER_CAPTION_CASE = 0;
    final int MEMBER_DESCRIPTION_CASE = 1;
    final int MEMBER_UNIQUE_NAME_CASE = 2;
    private int parameter;

    public HierarchyLoader(Connection connection, Hierarchy hierarchy) throws SQLException {
        super(new Tree());
        this.dbUtil = DBUtil.getInstance((Connection)connection);
        this.viewName = hierarchy.getName();
        this.connection = connection;
        this.getTree().setTreeLoader(this);
        this.dimensionHierarchy = hierarchy;
        this.rowNum = 1;
        this.paramStringExpr = ParamStringExpr.getInstance();
    }

    private String getQuery(String string) {
        if (queries == null) {
            try {
                String string2 = "oracle.hcs.table";
                String string3 = JavaXMLBind.LoadDocument(this.getClass(), XMLFILE);
                JavaXMLBind.BindToJavaStr(string3, string2, this);
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, exception.getLocalizedMessage(), exception);
            }
        }
        return queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        HierarchyLoader.queries = queries;
    }

    @Override
    public void loadData() throws SQLException, IOException {
        this.column = this.checkAttributes();
        if (this.column != null) {
            this.useDescription = true;
        }
        this.loadData1();
    }

    public void loadData(QDRData[] qDRDataArray) throws SQLException, IOException {
        this.column = this.checkAttributes();
        if (this.column != null) {
            this.useDescription = true;
        }
        this.loadData1(qDRDataArray);
    }

    String checkAttributes() throws SQLException, IOException {
        String string = null;
        string = "MEMBER_CAPTION";
        return string;
    }

    private void loadData1() throws SQLException {
        this.loadData1(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadData1(QDRData[] qDRDataArray) throws SQLException {
        Object object;
        Object object2;
        this.qdrs = qDRDataArray;
        this.setLoadingState(true);
        String string = null;
        String string2 = null;
        String string3 = "$oexpr[loop({hierarchyLevels}, {levelKeyColumn})]$";
        Object object3 = null;
        try {
            object3 = this.paramStringExpr.evaluateObjectExprs(string3, this);
        }
        catch (IOException iOException) {
            oracle.dbtools.util.Logger.warn(HierarchyLoader.class, (Throwable)iOException);
        }
        this.memberLevelKeyColumnNames = new ArrayList<String>();
        if (object3 != null && object3 instanceof List) {
            this.memberLevelKeyColumnNames = (List)object3;
        }
        if (qDRDataArray != null) {
            block27: {
                this.hierarchyMembers = new ArrayList<QDRData>();
                for (QDRData qDRData : qDRDataArray) {
                    if (this.hierarchyMembers.contains(qDRData)) continue;
                    this.hierarchyMembers.add(qDRData);
                }
                object2 = null;
                try {
                    QDRData qDRData;
                    object = null;
                    String string4 = null;
                    qDRData = null;
                    Connections.getInstance().lock(this.connection);
                    boolean bl = this.dimensionHierarchy.isLevelBased();
                    if (bl) {
                        string4 = this.getQuery("member_key_level_lineage");
                        object = this.paramStringExpr.getExpression(string4, this, this, null, null, null);
                        object2 = this.dbUtil.executeQuery((String)object, (Map)((Object)qDRData));
                        object2.setFetchSize(3000);
                        while (object2.next()) {
                            for (String string5 : this.memberLevelKeyColumnNames) {
                                String string6 = object2.getString(string5 = string5.replaceAll("\"", ""));
                                if (string6 == null) continue;
                                String string7 = this.getMemberUniqueName(string5, string6);
                                boolean bl2 = false;
                                for (QDRData qDRData2 : this.hierarchyMembers) {
                                    if (qDRData2.additionalMembers != null) {
                                        for (Member member : qDRData2.additionalMembers) {
                                            String string8 = member.getMemberKey();
                                            if (!string8.equalsIgnoreCase(string7)) continue;
                                            bl2 = true;
                                        }
                                        continue;
                                    }
                                    String string9 = qDRData2.getMemberKey();
                                    if (!string9.equalsIgnoreCase(string7)) continue;
                                    bl2 = true;
                                }
                                if (bl2) continue;
                                QDRData qDRData3 = new QDRData(this.dimensionHierarchy, string7, "");
                                this.hierarchyMembers.add(qDRData3);
                            }
                        }
                        break block27;
                    }
                    string4 = this.getQuery("member_key_parentage");
                    object = this.paramStringExpr.getExpression(string4, this, this, null, null, null);
                    boolean bl3 = true;
                    while (bl3) {
                        object2 = this.dbUtil.executeQuery((String)object, (Map)((Object)qDRData));
                        object2.setFetchSize(3000);
                        this.hierarchyParentMembers = new ArrayList<QDRData>();
                        while (object2.next()) {
                            String string10 = object2.getString("parent");
                            if (string10 == null) continue;
                            boolean bl4 = false;
                            for (QDRData qDRData4 : this.hierarchyMembers) {
                                if (qDRData4.additionalMembers != null) {
                                    for (Member member : qDRData4.additionalMembers) {
                                        String string11 = member.getMemberKey();
                                        if (!string11.equalsIgnoreCase(string10)) continue;
                                        bl4 = true;
                                    }
                                    continue;
                                }
                                String string12 = qDRData4.getMemberKey();
                                if (!string12.equalsIgnoreCase(string10)) continue;
                                bl4 = true;
                            }
                            if (bl4) continue;
                            QDRData qDRData5 = new QDRData(this.dimensionHierarchy, string10, "");
                            this.hierarchyMembers.add(qDRData5);
                            this.hierarchyParentMembers.add(qDRData5);
                        }
                        if (this.hierarchyParentMembers.size() == 0) {
                            bl3 = false;
                            continue;
                        }
                        string4 = this.getQuery("parent_member_key_parentage");
                        object = this.paramStringExpr.getExpression(string4, this, this, null, null, null);
                    }
                }
                catch (Exception exception) {
                    oracle.dbtools.util.Logger.warn(HierarchyLoader.class, (Throwable)exception);
                }
                finally {
                    DBUtil.closeResultSet((ResultSet)object2);
                    Connections.getInstance().unlock(this.connection);
                }
            }
            string2 = this.useDescription ? this.getQuery("selected_member_keys_with_descriptions") : this.getQuery("selected_member_keys");
        } else {
            string2 = this.useDescription ? this.getQuery("all_member_keys_with_descriptions") : this.getQuery("all_member_keys");
        }
        try {
            string = this.paramStringExpr.getExpression(string2, this, this, null, null, null);
        }
        catch (Exception exception) {
            oracle.dbtools.util.Logger.warn(HierarchyLoader.class, (Throwable)exception);
        }
        object2 = string;
        object = new Runnable(){
            final /* synthetic */ String val$sql;
            {
                this.val$sql = string;
            }

            @Override
            public void run() {
                try {
                    HierarchyLoader.this.loadTree(this.val$sql);
                }
                catch (Throwable throwable) {
                    oracle.dbtools.util.Logger.severe(HierarchyLoader.class, (Throwable)throwable);
                }
                finally {
                    HierarchyLoader.this.setLoadingState(false);
                }
            }
        };
        Thread thread = new Thread((Runnable)object);
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            oracle.dbtools.util.Logger.warn(HierarchyLoader.class, (Throwable)interruptedException);
        }
    }

    private String getMemberUniqueName(String string, String string2) {
        HierarchyLevel[] hierarchyLevelArray;
        String string3 = null;
        for (HierarchyLevel hierarchyLevel : hierarchyLevelArray = this.dimensionHierarchy.getHierarchyLevels()) {
            String string4 = hierarchyLevel.getLevelKeyColumn();
            if (!(string4 = string4.replaceAll("\"", "")).equalsIgnoreCase(string)) continue;
            string3 = String.format("[%s].&[%s]", hierarchyLevel.getHierarchyLevelName(), string2);
        }
        return string3;
    }

    private void loadTree(String string) throws SQLException {
        Map map = null;
        ResultSet resultSet = null;
        try {
            Connections.getInstance().lock(this.connection);
            resultSet = this.dbUtil.executeQuery(string, map);
            if (resultSet != null) {
                resultSet.setFetchSize(3000);
                int n = -1;
                int n2 = -1;
                while (resultSet.next()) {
                    HierarchyNodeData hierarchyNodeData = new HierarchyNodeData(this.getTree());
                    hierarchyNodeData.dimKey = resultSet.getString("key");
                    hierarchyNodeData.parent = resultSet.getString("parent");
                    String string2 = resultSet.getString("level_name");
                    hierarchyNodeData.setProperty(hierarchyNodeData.LEVEL_NAME, string2);
                    String string3 = null;
                    if (string2.equals("ALL")) {
                        string3 = "1";
                    } else {
                        String string4 = this.getMemberLevelKeyColumn(string2);
                        string3 = resultSet.getString(string4);
                    }
                    hierarchyNodeData.setProperty(hierarchyNodeData.LEVEL_KEY, string3);
                    n2 = resultSet.getInt("depth");
                    if (this.useDescription) {
                        hierarchyNodeData.memberCaption = resultSet.getString("member_caption") == null ? resultSet.getString("key") : resultSet.getString("member_caption");
                        hierarchyNodeData.memberDesc = resultSet.getString("member_description") == null ? resultSet.getString("key") : resultSet.getString("member_description");
                        switch (this.parameter) {
                            case 1: {
                                hierarchyNodeData.desc = hierarchyNodeData.memberDesc;
                                break;
                            }
                            case 2: {
                                hierarchyNodeData.desc = resultSet.getString("key");
                                break;
                            }
                            default: {
                                hierarchyNodeData.desc = hierarchyNodeData.memberCaption;
                            }
                        }
                    }
                    this.load(hierarchyNodeData, hierarchyNodeData, n2);
                    ++this.rowNum;
                    if (n2 == n) continue;
                    this.setFinishedLoadingDepth(n);
                    n = n2;
                }
            }
        }
        catch (SQLException sQLException) {
            try {
                throw sQLException;
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(resultSet);
                Connections.getInstance().unlock(this.connection);
                throw throwable;
            }
        }
        DBUtil.closeResultSet((ResultSet)resultSet);
        Connections.getInstance().unlock(this.connection);
        this.getTree().setCount(this.rowNum);
    }

    private String getMemberLevelKeyColumn(String string) {
        HierarchyLevel[] hierarchyLevelArray;
        String string2 = null;
        for (HierarchyLevel hierarchyLevel : hierarchyLevelArray = this.dimensionHierarchy.getHierarchyLevels()) {
            String string3 = hierarchyLevel.getHierarchyLevelName();
            if (!string3.equalsIgnoreCase(string)) continue;
            string2 = hierarchyLevel.getLevelKeyColumn();
            string2 = string2.replaceAll("\"", "");
        }
        return string2;
    }

    @Override
    public void loadChildren(Object object) {
        if (object instanceof DefaultNode) {
            Object object2;
            this.setLoadingState(true);
            DefaultNode defaultNode = (DefaultNode)object;
            String string = null;
            if (defaultNode.getUserObject() instanceof String) {
                string = (String)defaultNode.getUserObject();
            } else {
                object2 = (HierarchyNodeData)defaultNode.getUserObject();
                string = ((HierarchyNodeData)object2).getName();
            }
            object2 = null;
            String string2 = null;
            string2 = this.useDescription ? String.format(this.getQuery("child_member_keys_with_descriptions"), string) : String.format(this.getQuery("child_member_keys"), string);
            try {
                object2 = this.paramStringExpr.getExpression(string2, this, this, null, null, null);
            }
            catch (Exception exception) {
                oracle.dbtools.util.Logger.warn(HierarchyLoader.class, (Throwable)exception);
            }
            HierarchyNodeData hierarchyNodeData = object2;
            Runnable runnable = new Runnable(){
                final /* synthetic */ String val$sql;
                {
                    this.val$sql = string;
                }

                @Override
                public void run() {
                    try {
                        HierarchyLoader.this.loadChildrenData(this.val$sql);
                    }
                    catch (SQLException sQLException) {
                        oracle.dbtools.util.Logger.severe(HierarchyLoader.class, (Throwable)sQLException);
                    }
                    finally {
                        HierarchyLoader.this.setLoadingState(false);
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                oracle.dbtools.util.Logger.warn(HierarchyLoader.class, (Throwable)interruptedException);
            }
        }
    }

    public void loadChildrenData(String string) throws SQLException {
        Map map = null;
        ResultSet resultSet = null;
        try {
            Connections.getInstance().lock(this.connection);
            resultSet = this.dbUtil.executeQuery(string, map);
            SQLException sQLException = this.dbUtil.getLastException();
            if (sQLException != null) {
                throw sQLException;
            }
            resultSet.setFetchSize(3000);
            int n = -1;
            while (resultSet.next()) {
                HierarchyNodeData hierarchyNodeData = new HierarchyNodeData(this.getTree());
                hierarchyNodeData.dimKey = resultSet.getString("key");
                hierarchyNodeData.parent = resultSet.getString("parent");
                n = resultSet.getInt("depth");
                String string2 = resultSet.getString("level_name");
                hierarchyNodeData.setProperty(hierarchyNodeData.LEVEL_NAME, string2);
                String string3 = null;
                if (string2.equals("ALL")) {
                    string3 = "1";
                } else {
                    String string4 = this.getMemberLevelKeyColumn(string2);
                    string3 = resultSet.getString(string4);
                }
                hierarchyNodeData.setProperty(hierarchyNodeData.LEVEL_KEY, string3);
                if (this.useDescription) {
                    hierarchyNodeData.memberCaption = resultSet.getString("member_caption") == null ? resultSet.getString("key") : resultSet.getString("member_caption");
                    hierarchyNodeData.memberDesc = resultSet.getString("member_description") == null ? resultSet.getString("key") : resultSet.getString("member_description");
                    switch (this.parameter) {
                        case 1: {
                            hierarchyNodeData.desc = hierarchyNodeData.memberDesc;
                            break;
                        }
                        case 2: {
                            hierarchyNodeData.desc = resultSet.getString("key");
                            break;
                        }
                        default: {
                            hierarchyNodeData.desc = hierarchyNodeData.memberCaption;
                        }
                    }
                }
                this.load(hierarchyNodeData, hierarchyNodeData, n);
                ++this.rowNum;
            }
        }
        catch (SQLException sQLException) {
            try {
                throw sQLException;
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(resultSet);
                Connections.getInstance().unlock(this.connection);
                throw throwable;
            }
        }
        DBUtil.closeResultSet((ResultSet)resultSet);
        Connections.getInstance().unlock(this.connection);
        this.getTree().setCount(this.rowNum);
    }

    @Override
    public Object getValue(String string) throws SQLException, IOException {
        Object object = null;
        if (string.equalsIgnoreCase("hierarchyLevels")) {
            object = this.dimensionHierarchy.getHierarchyLevels();
        }
        if (string.equalsIgnoreCase("hierarchy_members")) {
            object = this.hierarchyMembers;
        }
        if (string.equalsIgnoreCase("hierarchy_parent_members")) {
            object = this.hierarchyParentMembers;
        }
        return object;
    }

    @Override
    public String getParamPropertyValue(String string, String string2, AVBaseMeasure aVBaseMeasure, ItemElement itemElement, HashMap<String, String> hashMap) throws SQLException, IOException {
        Object object = this.getMetadataProperty(string, string2);
        String string3 = object != null ? object.toString() : null;
        return string3;
    }

    private Object getMetadataProperty(String string, String string2) {
        Object object = null;
        if (string.equalsIgnoreCase("hierarchy")) {
            if (string2.equalsIgnoreCase("displayColumnName")) {
                object = this.column;
            } else {
                try {
                    object = this.dimensionHierarchy.getValue(string2);
                }
                catch (Exception exception) {
                    LOG.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        }
        return object;
    }

    @Override
    public void changeDisplayColumn(int n) {
        super.changeDisplayColumn(n);
        this.parameter = n;
    }

    static {
        LOG = Logger.getLogger(HierarchyLoader.class.getName());
    }
}

