/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.dimension;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBException;
import oracle.hcs.db.model.AbstractAVDBObjectBuilder;
import oracle.hcs.db.source.DatabaseSource;
import oracle.hcs.db.source.Source;
import oracle.hcs.db.source.Synonym;
import oracle.hcs.db.source.Table;
import oracle.hcs.db.source.View;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.model.DimensionAttribute;
import oracle.hcs.dimension.model.DimensionLevel;
import oracle.hcs.dimension.model.JoinPath;
import oracle.hcs.dimension.model.OrderByClause;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class DimensionBuilder
extends AbstractAVDBObjectBuilder<AttributeDimension> {
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String CAPTION = "CAPTION";
    private String schemaName;

    public DimensionBuilder(OracleDatabaseImpl oracleDatabaseImpl) {
        super((AbstractDBObjectProvider)oracleDatabaseImpl, "ATTRIBUTE DIMENSION");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    public AttributeDimension createObject(String string, Schema schema, DBObjectID dBObjectID) {
        AttributeDimension attributeDimension = new AttributeDimension();
        this.schemaName = schema.getName();
        attributeDimension.setName(string);
        attributeDimension.setSchema(schema);
        attributeDimension.setID(dBObjectID);
        return attributeDimension;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"caption", "dimensionType", "levels", "attributes", "hierarchyDefault", "allMemberCaption", "allMemberDescription", "allMemberName", "sharing"})
    public void buildDetails(AttributeDimension attributeDimension) throws DBException, SQLException, IOException, JAXBException {
        Database database = (Database)this.getProvider();
        attributeDimension.removeAllAttributes();
        attributeDimension.removeAllLevels();
        this.build(attributeDimension);
    }

    public void build(final AttributeDimension attributeDimension) throws DBException, SQLException {
        Database database = (Database)this.getProvider();
        attributeDimension.removeAllAttributes();
        attributeDimension.removeAllLevels();
        attributeDimension.setForceCreate(true);
        final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getProvider(), "select dimension_type, all_member_name, all_member_caption, all_member_description from all_attribute_dimensions  where dimension_name = ? and owner = ?", new Object[]{attributeDimension.getName(), attributeDimension.getSchema()});
        final QueryWrapper queryWrapper2 = new QueryWrapper((Database)this.getProvider(), "select adt.table_owner, adt.table_name, adt.table_alias, ao.object_type from all_attribute_dim_tables adt, all_objects ao where ao.object_type(+) in ('TABLE', 'VIEW', 'SYNONYM') and  adt.table_owner = ao.owner(+) and adt.table_name = ao.object_name(+) and  adt.dimension_name = ? and adt.owner = ? order by adt.order_num", new Object[]{attributeDimension.getName(), attributeDimension.getSchema()});
        final QueryWrapper queryWrapper3 = new QueryWrapper((Database)this.getProvider(), "select ahdl.level_name, skip_when_null, level_type, member_name_expr, member_caption_expr, member_description_expr, agg_func as aggregation, attribute_name as order_by_attr, criteria, nulls_position,ahdl.order_num from all_attribute_dim_levels ahdl join all_attribute_dim_order_attrs ahdoa on ahdl.dimension_name = ahdoa.dimension_name and ahdl.level_name = ahdoa.level_name  where ahdl.dimension_name = ? and ahdl.owner = ? order by ahdl.order_num", new Object[]{attributeDimension.getName(), attributeDimension.getSchema()});
        final QueryWrapper queryWrapper4 = new QueryWrapper((Database)this.getProvider(), "select level_name, attribute_name, key_order_num, attr_order_num from all_attribute_dim_keys  where dimension_name = ? and owner = ? and is_alternate='N' order by level_name, key_order_num, attr_order_num", new Object[]{attributeDimension.getName(), attributeDimension.getSchema()});
        final QueryWrapper queryWrapper5 = new QueryWrapper((Database)this.getProvider(), "select level_name, attribute_name, key_order_num, attr_order_num from all_attribute_dim_keys  where dimension_name = ? and owner = ? and is_alternate='Y' order by level_name, key_order_num, attr_order_num", new Object[]{attributeDimension.getName(), attributeDimension.getSchema()});
        final QueryWrapper queryWrapper6 = new QueryWrapper((Database)this.getProvider(), "select level_name, attribute_name from all_attribute_dim_level_attrs where dimension_name = ? and owner = ? and is_minimal_dtm = 'Y' minus select level_name, attribute_name from all_attribute_dim_keys where dimension_name = ? and owner = ?", new Object[]{attributeDimension.getName(), attributeDimension.getSchema(), attributeDimension.getName(), attributeDimension.getSchema()});
        final QueryWrapper queryWrapper7 = new QueryWrapper((Database)this.getProvider(), "select attribute_name, table_alias, column_name from all_attribute_dim_attrs  where dimension_name = ? and owner = ? order by order_num", new Object[]{attributeDimension.getName(), attributeDimension.getSchema()});
        final QueryWrapper queryWrapper8 = new QueryWrapper((Database)this.getProvider(), "select classification, value, language from all_attribute_dim_class  where dimension_name = ? and owner = ? order by language,classification", new Object[]{attributeDimension.getName(), attributeDimension.getSchema()});
        final QueryWrapper queryWrapper9 = new QueryWrapper((Database)this.getProvider(), "select attribute_name, classification, value, language from all_attribute_dim_attr_class  where dimension_name = ? and owner = ? order by attribute_name,language,classification", new Object[]{attributeDimension.getName(), attributeDimension.getSchema()});
        final QueryWrapper queryWrapper10 = new QueryWrapper((Database)this.getProvider(), "select level_name, classification, value, language from all_attribute_dim_lvl_class  where dimension_name = ? and owner = ? order by level_name,language,classification", new Object[]{attributeDimension.getName(), attributeDimension.getSchema()});
        final QueryWrapper queryWrapper11 = new QueryWrapper((Database)this.getProvider(), "select join_path_name, on_condition from all_attribute_dim_join_paths where dimension_name = ? and owner = ? order by order_num", new Object[]{attributeDimension.getName(), attributeDimension.getSchema()});
        final QueryWrapper queryWrapper12 = new QueryWrapper((Database)this.getProvider(), " select sharing from all_objects  where object_type = ? and object_name = ? and owner = ?", new Object[]{attributeDimension.getType(), attributeDimension.getName(), attributeDimension.getSchema()});
        queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = String.format("%s", resultSet.getString(2));
                        String string3 = resultSet.getString(3);
                        String string4 = resultSet.getString(4);
                        attributeDimension.setDimensionType(string);
                        if (string2 != null) {
                            attributeDimension.setAllMemberName(string2);
                        }
                        attributeDimension.setAllMemberCaption(string3);
                        attributeDimension.setAllMemberDescription(string4);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)attributeDimension, sQLException);
                }
            }
        });
        queryWrapper2.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string;
                        String string2 = resultSet.getString(1);
                        String string3 = resultSet.getString(2);
                        if (string3.equals(string = resultSet.getString(3))) {
                            string = null;
                        }
                        String string4 = resultSet.getString(4);
                        Source source = null;
                        source = string4 == null ? (DimensionBuilder.this.schemaName.equals(string2) ? new Table(string2, string3, string) : new Synonym(string2, string3, string)) : (string4.equalsIgnoreCase("TABLE") ? new Table(string2, string3, string) : (string4.equalsIgnoreCase("VIEW") ? new View(string2, string3, string) : new Synonym(string2, string3, string)));
                        attributeDimension.addSource(source);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper2.throwDBException((DBObject)attributeDimension, sQLException);
                }
            }
        });
        queryWrapper3.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        String string3 = resultSet.getString(3);
                        String string4 = resultSet.getString(4);
                        String string5 = resultSet.getString(5);
                        String string6 = resultSet.getString(6);
                        String string7 = resultSet.getString(7);
                        String string8 = resultSet.getString(8);
                        String string9 = resultSet.getString(9);
                        String string10 = resultSet.getString(10);
                        String string11 = resultSet.getString(11);
                        DimensionLevel dimensionLevel = attributeDimension.findLevel(string);
                        if (dimensionLevel == null) {
                            dimensionLevel = new DimensionLevel(attributeDimension, string);
                            dimensionLevel.setLevelMemberName(string4);
                            dimensionLevel.setLevelMemberCaption(string5);
                            dimensionLevel.setLevelMemberDescription(string6);
                            boolean bl = string2.equalsIgnoreCase("Y");
                            dimensionLevel.setLevelSkipNullValues(bl);
                            dimensionLevel.setLevelType(string3);
                            dimensionLevel.setLevelOrder(string11);
                            attributeDimension.addLevel(dimensionLevel);
                        }
                        OrderByClause orderByClause = new OrderByClause();
                        orderByClause.setAggregation(string7);
                        orderByClause.setOrderByKey(string8);
                        orderByClause.setCriteria(string9);
                        orderByClause.setNullsPosition(string10);
                        dimensionLevel.addLevelOrderByClause(orderByClause);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper3.throwDBException((DBObject)attributeDimension, sQLException);
                }
            }
        });
        queryWrapper4.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    String string = null;
                    while (resultSet.next()) {
                        string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        int n = resultSet.getInt(3);
                        int n2 = resultSet.getInt(4);
                        DimensionLevel dimensionLevel = attributeDimension.findLevel(string);
                        if (n2 > 0) {
                            String string3 = dimensionLevel.getLevelKey();
                            dimensionLevel.setLevelKey(string3 + "," + string2);
                            continue;
                        }
                        dimensionLevel.setLevelKey(string2);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper4.throwDBException((DBObject)attributeDimension, sQLException);
                }
            }
        });
        queryWrapper5.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    Object object;
                    List<CallSite> list;
                    Object object2;
                    Object object3;
                    HashMap<Object, List<CallSite>> hashMap = new HashMap<Object, List<CallSite>>();
                    while (resultSet.next()) {
                        object3 = resultSet.getString(1);
                        object2 = resultSet.getString(2);
                        int n = resultSet.getInt(3);
                        int n2 = resultSet.getInt(4);
                        if (n2 > 0) {
                            if (!hashMap.containsKey(object3) || (list = (List)hashMap.get(object3)).size() <= 0) continue;
                            object = (String)list.get(list.size() - 1);
                            list.set(list.size() - 1, (CallSite)((Object)((String)object + "," + (String)object2)));
                            continue;
                        }
                        if (hashMap.containsKey(object3)) {
                            list = (List)hashMap.get(object3);
                            list.add((CallSite)object2);
                            continue;
                        }
                        list = new ArrayList();
                        list.add((CallSite)object2);
                        hashMap.put(object3, list);
                    }
                    object3 = hashMap.keySet();
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        String string = (String)object2.next();
                        DimensionLevel dimensionLevel = attributeDimension.findLevel(string);
                        list = (ArrayList)hashMap.get(string);
                        if (list.size() <= 0) continue;
                        object = list.toArray(new String[list.size()]);
                        dimensionLevel.setLevelAlternateKeys((String[])object);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper5.throwDBException((DBObject)attributeDimension, sQLException);
                }
            }
        });
        queryWrapper6.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    Object object;
                    Object object2;
                    Object object3;
                    HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
                    while (resultSet.next()) {
                        object3 = resultSet.getString(1);
                        object2 = resultSet.getString(2);
                        if (hashMap.containsKey(object3)) {
                            object = (List)hashMap.get(object3);
                            object.add(object2);
                            continue;
                        }
                        object = new ArrayList();
                        object.add(object2);
                        hashMap.put(object3, object);
                    }
                    object3 = hashMap.keySet();
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        object = (String)object2.next();
                        DimensionLevel dimensionLevel = attributeDimension.findLevel((String)object);
                        List list = (List)hashMap.get(object);
                        if (list.size() <= 0) continue;
                        String[] stringArray = list.toArray(new String[list.size()]);
                        dimensionLevel.setLevelDeterminesKeys(stringArray);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper6.throwDBException((DBObject)attributeDimension, sQLException);
                }
            }
        });
        queryWrapper7.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    for (DatabaseSource object : attributeDimension.getSources()) {
                        hashMap.put(object.getAlias(), object.getName());
                    }
                    DatabaseSource[] databaseSourceArray = null;
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        String string3 = resultSet.getString(3);
                        DimensionAttribute dimensionAttribute = new DimensionAttribute(string);
                        if (hashMap.get(string2) != null && !((String)hashMap.get(string2)).equals(string2)) {
                            dimensionAttribute.setAlias(string2);
                        }
                        dimensionAttribute.setOriginalAttributeName(string);
                        dimensionAttribute.setMapExpression(string3);
                        attributeDimension.addAttribute(dimensionAttribute);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper7.throwDBException((DBObject)attributeDimension, sQLException);
                }
            }
        });
        queryWrapper8.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    DimensionBuilder.this.processClassificationsResultSet(attributeDimension, attributeDimension, resultSet);
                }
                catch (SQLException sQLException) {
                    queryWrapper8.throwDBException((DBObject)attributeDimension, sQLException);
                }
            }
        });
        queryWrapper9.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    AbstractAVDBObjectBuilder.LanguageDescriptionsCount languageDescriptionsCount = new AbstractAVDBObjectBuilder.LanguageDescriptionsCount();
                    languageDescriptionsCount.setDescriptionsCount(0);
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        String string3 = resultSet.getString(3);
                        String string4 = resultSet.getString(4);
                        DimensionAttribute dimensionAttribute = attributeDimension.findAttribute(string);
                        if (dimensionAttribute == null) continue;
                        if (string2.equalsIgnoreCase(DimensionBuilder.CAPTION) || string2.equalsIgnoreCase(DimensionBuilder.DESCRIPTION) || string4 != null) {
                            DimensionBuilder.this.processLanguageDescriptions(languageDescriptionsCount, string4, string2, string3, dimensionAttribute, dimensionAttribute);
                            continue;
                        }
                        DimensionBuilder.this.setClassification(dimensionAttribute, string2, string3, string4);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper9.throwDBException((DBObject)attributeDimension, sQLException);
                }
            }
        });
        queryWrapper10.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    AbstractAVDBObjectBuilder.LanguageDescriptionsCount languageDescriptionsCount = new AbstractAVDBObjectBuilder.LanguageDescriptionsCount();
                    languageDescriptionsCount.setDescriptionsCount(0);
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        String string3 = resultSet.getString(3);
                        String string4 = resultSet.getString(4);
                        DimensionLevel dimensionLevel = attributeDimension.findLevel(string);
                        if (dimensionLevel == null) continue;
                        if (string2.equalsIgnoreCase(DimensionBuilder.CAPTION) || string2.equalsIgnoreCase(DimensionBuilder.DESCRIPTION) || string4 != null) {
                            DimensionBuilder.this.processLanguageDescriptions(languageDescriptionsCount, string4, string2, string3, dimensionLevel, dimensionLevel);
                            continue;
                        }
                        DimensionBuilder.this.setClassification(dimensionLevel, string2, string3, string4);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper10.throwDBException((DBObject)attributeDimension, sQLException);
                }
            }
        });
        queryWrapper11.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    ArrayList<JoinPath> arrayList = new ArrayList<JoinPath>();
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        JoinPath joinPath = new JoinPath(string, string2);
                        arrayList.add(joinPath);
                    }
                    if (arrayList.size() > 0) {
                        attributeDimension.setJoinPaths(arrayList.toArray(new JoinPath[arrayList.size()]));
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper11.throwDBException((DBObject)attributeDimension, sQLException);
                }
            }
        });
        queryWrapper12.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        attributeDimension.setSharing(DimensionBuilder.this.getSharing(string));
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper12.throwDBException((DBObject)attributeDimension, sQLException);
                }
            }
        });
    }

    public static String getRootDataType(String string) {
        StringBuffer stringBuffer = new StringBuffer(64);
        if (string.startsWith("TIMESTAMP") || string.startsWith("INTERVAL")) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (!Character.isLetter(c) && !Character.isSpaceChar(c)) continue;
                stringBuffer.append(c);
            }
        } else {
            stringBuffer = new StringBuffer(string);
        }
        return stringBuffer.toString();
    }
}

