/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.db.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.share.nls.StringUtils;
import oracle.hcs.HCSArb;
import oracle.i18n.util.OraLocaleInfo;
import oracle.ide.help.HelpSystem;

public class LanguagesSelectorDialog
extends JDialog {
    private Shuttle shuttle;
    private JButton okBtn;
    private JButton cancelBtn;
    private JButton helpBtn;
    private DefaultListModel selectedLanguagesListModel;
    private DefaultListModel allLanguagesListModel;
    private boolean clickedOk;
    private String defaultLanguage;

    public LanguagesSelectorDialog(Frame frame, String string, DefaultListModel defaultListModel, String string2) {
        super(frame, string);
        this.selectedLanguagesListModel = defaultListModel;
        this.defaultLanguage = string2;
        this.initComponents();
        this.layoutComponents();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(600, 400));
        this.setLocationRelativeTo(frame);
        this.setModal(true);
    }

    private void initComponents() {
        this.okBtn = new JButton(HCSArb.getString("DIALOG_OK_BUTTON_TEXT"));
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (LanguagesSelectorDialog.this.allLanguagesListModel.contains(LanguagesSelectorDialog.this.defaultLanguage)) {
                    JOptionPane.showMessageDialog(LanguagesSelectorDialog.this, HCSArb.getString("LANGUAGES_SELECTOR_DIALOG_CANNOT_REMOVE_DEFAULT_LANGUAGE"), LanguagesSelectorDialog.this.getTitle(), 0);
                    LanguagesSelectorDialog.this.clickedOk = false;
                    LanguagesSelectorDialog.this.allLanguagesListModel.removeElement(LanguagesSelectorDialog.this.defaultLanguage);
                    LanguagesSelectorDialog.this.selectedLanguagesListModel.add(0, LanguagesSelectorDialog.this.defaultLanguage);
                    return;
                }
                LanguagesSelectorDialog.this.clickedOk = true;
                LanguagesSelectorDialog.this.close();
            }
        });
        this.cancelBtn = new JButton(HCSArb.getString("DIALOG_CANCEL_BUTTON_TEXT"));
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LanguagesSelectorDialog.this.clickedOk = false;
                LanguagesSelectorDialog.this.close();
            }
        });
        this.helpBtn = new JButton(StringUtils.stripMnemonic((String)HCSArb.getString("DIALOG_HELP_BUTTON_TEXT")));
        this.helpBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpSystem.getHelpSystem().showHelp((JComponent)LanguagesSelectorDialog.this.shuttle);
            }
        });
        this.initShuttle();
    }

    private void initShuttle() {
        this.shuttle = new Shuttle();
        this.shuttle.setName("shuttle");
        this.shuttle.setButtonsShown(5);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.shuttle, "av_modify_languages");
        this.allLanguagesListModel = new DefaultListModel();
        this.populateAvailableLanguages();
        JList jList = new JList(this.allLanguagesListModel);
        JList jList2 = new JList(this.selectedLanguagesListModel);
        ListPicker listPicker = new ListPicker(jList2);
        this.shuttle.setToPicker((ItemPicker)listPicker);
        ListPicker listPicker2 = new ListPicker(jList);
        this.shuttle.setFromPicker((ItemPicker)listPicker2);
        this.shuttle.add((Component)new JLabel(HCSArb.getString("LANGUAGES_SELECTOR_DIALOG_AVAILABLE_LANGUAGES_LABEL")), (Object)"FromHeader");
        this.shuttle.add((Component)new JLabel(HCSArb.getString("LANGUAGES_SELECTOR_DIALOG_SELECTED_LANGUAGES_LABEL")), (Object)"ToHeader");
        this.shuttle.setEnabled(true);
    }

    private void populateAvailableLanguages() {
        String[] stringArray;
        for (String string : stringArray = OraLocaleInfo.getAvailableLanguages()) {
            if (this.selectedLanguagesListModel.contains(string)) continue;
            this.allLanguagesListModel.addElement(string);
        }
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(5, 5, 5, 5);
        this.add((Component)new JLabel(HCSArb.getString("LANGUAGES_SELECTOR_DIALOG_ADD_OR_REMOVE_LANGUAGES_LABEL")), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)this.shuttle, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, insets, 0, 0));
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        dialogButtonBar.add((Component)this.helpBtn, DialogButtonBar.CONSTRAINT_HELP);
        dialogButtonBar.add((Component)this.okBtn, DialogButtonBar.CONSTRAINT_APPLY);
        dialogButtonBar.add((Component)this.cancelBtn, DialogButtonBar.CONSTRAINT_CANCEL);
        this.add((Component)dialogButtonBar, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    public boolean isOkClicked() {
        return this.clickedOk;
    }
}

