/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.db.source;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.hcs.HCSImagesArb;
import oracle.hcs.db.IdentifierElement;
import oracle.hcs.db.source.ColumnIdentifier;
import oracle.hcs.db.source.ColumnMatchFilter;
import oracle.hcs.util.CompletionProviderWithFilter;
import oracle.hcs.util.ListSeparatorsRenderer;

public class CompletionColumnMatchProvider
implements CompletionProviderWithFilter<ColumnIdentifier> {
    private List<ColumnIdentifier> columnIdentifiers = new ArrayList<ColumnIdentifier>();
    private boolean filter = true;
    private final ListCellRenderer renderer;
    private ColumnMatchFilter columnMatchFilter;

    public CompletionColumnMatchProvider(JList jList, List<ColumnIdentifier> list) {
        this(jList);
        this.columnIdentifiers = list;
    }

    public CompletionColumnMatchProvider(JComponent jComponent, List<ColumnIdentifier> list) {
        this((JList)jComponent);
        this.columnIdentifiers = list;
    }

    public CompletionColumnMatchProvider(JList jList) {
        this.renderer = new ListSeparatorsRenderer(jList.getCellRenderer()){

            @Override
            protected boolean addSeparatorAfter(JList jList, Object object, int n) {
                Object object2 = null;
                if (n + 1 < jList.getModel().getSize()) {
                    object2 = jList.getModel().getElementAt(n + 1);
                }
                if (object2 != null) {
                    IdentifierElement identifierElement = new IdentifierElement(object2.toString());
                    IdentifierElement identifierElement2 = new IdentifierElement(object.toString());
                    if (identifierElement.getCount() == 2 && identifierElement2.getCount() == 2) {
                        boolean bl = identifierElement.getFirst().equals(identifierElement2.getFirst());
                        return !bl;
                    }
                }
                return false;
            }

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
                if (component instanceof JLabel && object instanceof ColumnIdentifier) {
                    JLabel jLabel = (JLabel)component;
                    ColumnIdentifier columnIdentifier = (ColumnIdentifier)object;
                    if (columnIdentifier.getColumn().isDate()) {
                        jLabel.setIcon(HCSImagesArb.getIcon("DATATYPE_DATE"));
                    }
                    if (columnIdentifier.getColumn().isNumeric()) {
                        jLabel.setIcon(HCSImagesArb.getIcon("DATATYPE_NUMBER"));
                    }
                    if (columnIdentifier.getColumn().isString()) {
                        jLabel.setIcon(HCSImagesArb.getIcon("DATATYPE_STRING"));
                    }
                }
                return component;
            }
        };
    }

    @Override
    public void setFilter(boolean bl) {
        this.filter = bl;
    }

    public ListCellRenderer getCellRenderer() {
        return this.renderer;
    }

    public boolean handlesInsight(Document document, int n) {
        return true;
    }

    public void setColumnMatchFilter(ColumnMatchFilter columnMatchFilter) {
        this.columnMatchFilter = columnMatchFilter;
    }

    public ColumnIdentifier[] getInsightData(Document document, int n) {
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>();
        try {
            String string = document.getText(0, n).toLowerCase();
            if (string.trim().length() == 0) {
                this.filter = false;
            }
            for (ColumnIdentifier columnIdentifier : this.columnIdentifiers) {
                String string2 = columnIdentifier.getIdentifier();
                if (this.filter) {
                    int n2 = string2.toLowerCase().indexOf(string.toLowerCase());
                    if (n2 < 0) continue;
                    if (this.columnMatchFilter != null) {
                        if (this.columnMatchFilter.filter(columnIdentifier)) continue;
                        arrayList.add(columnIdentifier);
                        continue;
                    }
                    arrayList.add(columnIdentifier);
                    continue;
                }
                if (this.columnMatchFilter == null || this.columnMatchFilter.filter(columnIdentifier)) continue;
                arrayList.add(columnIdentifier);
            }
            if (arrayList.size() == 1) {
                ColumnIdentifier columnIdentifier = (ColumnIdentifier)arrayList.get(0);
                if (this.columnMatchFilter != null && !this.columnMatchFilter.filter(columnIdentifier)) {
                    if (((ColumnIdentifier)arrayList.get(0)).getIdentifier().equalsIgnoreCase(string)) {
                        arrayList.clear();
                        arrayList.addAll(this.columnIdentifiers);
                    }
                } else {
                    arrayList.clear();
                }
            }
            if (arrayList.size() == 0) {
                arrayList.addAll(this.columnIdentifiers);
            }
            this.filter = true;
        }
        catch (BadLocationException badLocationException) {
            return new ColumnIdentifier[0];
        }
        return arrayList.toArray(new ColumnIdentifier[arrayList.size()]);
    }

    public void completeInsight(Document document, int n, ColumnIdentifier columnIdentifier) {
        try {
            document.remove(0, document.getLength());
            document.insertString(0, columnIdentifier.getIdentifier(), null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public boolean isAutoPopupChar(char c) {
        return true;
    }
}

