/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.db.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.hcs.HCSArb;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.ui.ComponentWithTitlebar;

public class InvalidDependenciesPanel
extends JPanel {
    private ResultSetTable resultSetTable;
    private String errorsQuery;
    private OracleDatabaseImpl db;
    private JDialog compileResultsDialog;
    private Logger Log = Logger.getLogger(InvalidDependenciesPanel.class.getName());

    public InvalidDependenciesPanel(String string, OracleDatabaseImpl oracleDatabaseImpl) {
        this.errorsQuery = string;
        this.db = oracleDatabaseImpl;
        this.setLayoutComponents();
        this.showCompilationErrors();
    }

    private void setLayoutComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.resultSetTable = new ResultSetTable();
        this.resultSetTable.setSelectionMode(0);
        this.resultSetTable.setBackground(Color.WHITE);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView((Component)this.resultSetTable);
        this.resultSetTable.setFillsViewportHeight(true);
        jScrollPane.setBackground(Color.WHITE);
        ComponentWithTitlebar componentWithTitlebar = new ComponentWithTitlebar();
        componentWithTitlebar.setComponent((JComponent)jScrollPane);
        JButton jButton = new JButton(HCSArb.getString("INVALID_DEPENDENCIES_PANEL_CLOSE_BUTTON_LABEL"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (InvalidDependenciesPanel.this.compileResultsDialog != null) {
                    InvalidDependenciesPanel.this.compileResultsDialog.dispose();
                }
            }
        });
        componentWithTitlebar.setMinimumSize(new Dimension(300, 200));
        this.add((Component)componentWithTitlebar, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        this.add((Component)jButton, gridBagConstraints);
    }

    public void setOwningDialog(JDialog jDialog) {
        this.compileResultsDialog = jDialog;
    }

    public int getRowCount() {
        if (this.resultSetTable != null) {
            return this.resultSetTable.getGridModel().getRowCount();
        }
        return 0;
    }

    private void showCompilationErrors() {
        try {
            String string = this.db.getQualifiedName();
            this.resultSetTable.setQuery(string, this.errorsQuery, null, null);
            this.resultSetTable.refresh();
            this.resultSetTable.allRowsFetched();
        }
        catch (Exception exception) {
            this.Log.log(Level.SEVERE, exception.getMessage());
        }
    }
}

