/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.db.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.UIManager;
import oracle.hcs.HCSArb;
import oracle.hcs.db.model.AbstractSchemaObjectWithDesc;
import oracle.hcs.db.panels.HCSCompileDDLGenerator;
import oracle.hcs.db.panels.InvalidDependenciesPanel;
import oracle.ide.Ide;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class InvalidDependenciesDialog
extends JDialog {
    private List<AbstractSchemaObjectWithDesc> dependencies;
    private DBObjectProvider prov;
    private HCSCompileDDLGenerator compileStatementsGenerator;
    private InvalidDependenciesPanel invalidDependenciespanel;
    private String objectName;
    private final String ERRORS_QUERY_NAME = "objectErrors";

    public InvalidDependenciesDialog(List<AbstractSchemaObjectWithDesc> list, HCSCompileDDLGenerator hCSCompileDDLGenerator, DBObjectProvider dBObjectProvider, String string) {
        super((Frame)Ide.getMainWindow(), HCSArb.get("INVALID_DEPENDENCIES_DIALOG_TITLE"), true);
        this.dependencies = list;
        this.prov = dBObjectProvider;
        this.objectName = string;
        this.compileStatementsGenerator = hCSCompileDDLGenerator;
        this.initComponents();
        this.layoutComponents();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(600, 400));
        this.setLocationRelativeTo((Component)Ide.getMainWindow());
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(HCSArb.format("INVALID_DEPENDENCIES_PANEL_MESSAGE", this.objectName));
        Icon icon = UIManager.getIcon("OptionPane.warningIcon");
        jLabel.setIcon(icon);
        this.invalidDependenciespanel = this.createInvalidDependenciesPanel();
        this.invalidDependenciespanel.setOwningDialog(this);
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.invalidDependenciespanel, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.5, 13, 1, new Insets(0, 0, 5, 5), 0, 0));
    }

    private InvalidDependenciesPanel createInvalidDependenciesPanel() {
        String string = this.compileStatementsGenerator.generateCompileErrorsQuery("objectErrors", this.dependencies);
        return new InvalidDependenciesPanel(string, (OracleDatabaseImpl)this.prov);
    }

    public void display() {
        this.setVisible(true);
    }
}

