/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.HCSArb;
import oracle.hcs.av.AVDimensionalityWorker;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.av.panels.AttributeDimensionNode;
import oracle.hcs.av.panels.AttributeDimensionTreeRenderer;
import oracle.hcs.av.panels.AttributeDimensionTreeTableModel;
import oracle.hcs.db.model.AbstractChildObjectWithDesc;
import oracle.hcs.db.source.Column;
import oracle.hcs.db.source.ColumnIdentifier;
import oracle.hcs.db.source.CompletionColumnMatchProvider;
import oracle.hcs.db.source.DatabaseSource;
import oracle.hcs.db.source.MapExpressionCellRenderer;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.model.DimensionAttribute;
import oracle.hcs.dimension.model.DimensionLevel;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.navigator.HCSNavigatorResource;
import oracle.hcs.util.CompletionCellEditor;
import oracle.hcs.util.FeatureMap;
import oracle.hcs.util.TreeSelectorDialog;
import oracle.hcs.util.TreeSelectorFilter;
import oracle.hcs.util.TreeSelectorToolTip;
import oracle.hcs.util.UIStringUtils;
import oracle.ide.Ide;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.completion.CompletionProvider;
import oracle.javatools.ui.completion.CompletionTextField;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;
import oracle.javatools.ui.table.TableToolbar;

public class AVDimensionalityTablePanel
extends JPanel {
    private AnalyticView updatedObject;
    private List<Hierarchy> allHierarchies;
    private List<AttributeDimension> allDimensions;
    private DatabaseSource source;
    private List<ColumnIdentifier> sourceColumns;
    private AttributeDimensionTreeTableModel treeTableModel;
    protected List<AVDimensionalityWorker.DerivedDimensionality> dimensionalityList;
    private GenericTable dimensionalityTable;
    private DefaultTableModel tableModel;
    private DimensionKeyCellEditor dimensionKeyCellEditor;
    private DimensionAliasCellEditor dimensionAliasCellEditor;
    private AbstractAction addDimensionAction;
    private AbstractAction removeDimensionAction;
    private CompletionColumnMatchProvider sourceCompletionProvider;
    private DBObjectProvider prov;
    private HCSSchema schema;
    private static final int DIMENSION_NAME_COLUMN = 0;
    private static final int DIMENSION_ALIAS_COLUMN = 1;
    private static final int FACT_KEY_TABLE_COLUMN = 2;
    private static final int DIMENSION_KEY_TABLE_COLUMN = 3;
    private static final int AV_DIMENSIONALITY_OBJECT_COLUMN = 4;
    private static final int DISTINCT_COLUMN = 5;
    private static final String AV_DIMENSIONALITY_OBJECT_COLUMN_HDR = "AV_DIMENSIONALITY_OBJECT";
    private static final String CLOB_TYPE = "CLOB";
    private static final String BLOB_TYPE = "BLOB";
    private boolean supportDistinct;

    public AVDimensionalityTablePanel() {
        this.initComponents();
        this.layoutComponents();
        this.dimensionKeyCellEditor = new DimensionKeyCellEditor();
        this.dimensionAliasCellEditor = new DimensionAliasCellEditor();
        this.setTableCellEditorAndRenderer();
    }

    public GenericTable getTable() {
        return this.dimensionalityTable;
    }

    public void commitCellEdit() {
        if (this.dimensionalityTable.isEditing()) {
            this.dimensionalityTable.getCellEditor().stopCellEditing();
        }
    }

    public void setUpdatedObject(AnalyticView analyticView) {
        this.updatedObject = analyticView;
        this.dimensionKeyCellEditor.setAV(analyticView);
    }

    public void setAllHierarchies(List<Hierarchy> list) {
        this.allHierarchies = list;
        this.dimensionKeyCellEditor.setAllHierarchies(list);
    }

    private void initComponents() {
        this.tableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 != 0;
            }

            public Class getColumnClass(int n) {
                if (n == 5) {
                    return Boolean.class;
                }
                return Object.class;
            }
        };
        this.tableModel.addColumn(HCSArb.getString("AV_DIMENSIONS_TABLE_DIMENSION_NAME"));
        this.tableModel.addColumn(HCSArb.getString("AV_DIMENSIONS_TABLE_DIMENSION_ALIAS"));
        this.tableModel.addColumn(HCSArb.getString("AV_DIMENSIONS_TABLE_FACT_TABLE_KEY"));
        this.tableModel.addColumn(HCSArb.getString("AV_DIMENSIONS_TABLE_DIMENSION_ATTRIBUTE"));
        this.tableModel.addColumn(AV_DIMENSIONALITY_OBJECT_COLUMN_HDR);
        this.dimensionalityTable = new GenericTable((TableModel)this.tableModel);
        this.dimensionalityTable.setSelectionMode(0);
        this.dimensionalityTable.setRowSelectionAllowed(false);
        this.dimensionalityTable.setCellSelectionEnabled(true);
        this.dimensionalityTable.putClientProperty((Object)"terminateEditOnFocusLost", (Object)true);
        this.dimensionalityTable.setAutoResizeMode(0);
        int[] nArray = new int[]{100, 115, 125, 175, 0};
        int[] nArray2 = new int[]{75, 75, 75, 75, 0};
        int n = 0;
        for (int n2 : nArray) {
            TableColumn tableColumn = this.dimensionalityTable.getColumnModel().getColumn(n++);
            tableColumn.setMinWidth(nArray2[n - 1]);
            tableColumn.setPreferredWidth(n2);
        }
        Object object = this.dimensionalityTable.getColumnModel();
        TableColumn tableColumn = object.getColumn(4);
        object.removeColumn(tableColumn);
        this.initAbstractActions();
    }

    private void initAbstractActions() {
        this.addDimensionAction = new AbstractAction("", OracleIcons.getIcon((String)"add.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AVDimensionalityTablePanel.this.treeTableModel == null) {
                    AVDimensionalityTablePanel.this.treeTableModel = new AttributeDimensionTreeTableModel(AVDimensionalityTablePanel.this.prov, AVDimensionalityTablePanel.this.allDimensions, AVDimensionalityTablePanel.this.schema);
                } else {
                    AVDimensionalityTablePanel.this.treeTableModel.setDimensions(AVDimensionalityTablePanel.this.allDimensions);
                    AVDimensionalityTablePanel.this.treeTableModel.populate();
                }
                TreeSelectorFilter treeSelectorFilter = new TreeSelectorFilter(){

                    @Override
                    public void filterChanged(String string, String string2) {
                        AVDimensionalityTablePanel.this.treeTableModel.clear();
                        AVDimensionalityTablePanel.this.treeTableModel.populate(string, string2);
                    }

                    @Override
                    public String getName() {
                        return HCSArb.getString("DIMENSION_MEMBER_SELECTOR_FILTER");
                    }

                    @Override
                    public List<String> getCategoriesFilter() {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        for (int i = 0; i < AVDimensionalityTablePanel.this.treeTableModel.getColumnCount(); ++i) {
                            arrayList.add(AVDimensionalityTablePanel.this.treeTableModel.getColumnName(i));
                        }
                        return arrayList;
                    }
                };
                TreeSelectorToolTip treeSelectorToolTip = new TreeSelectorToolTip(){

                    @Override
                    public String getToolTipforNode(Object object) {
                        String string = "";
                        AttributeDimensionNode attributeDimensionNode = (AttributeDimensionNode)object;
                        int n = 0;
                        for (int i = 0; i < AVDimensionalityTablePanel.this.tableModel.getRowCount(); ++i) {
                            if (!String.valueOf(AVDimensionalityTablePanel.this.tableModel.getValueAt(i, 0)).equalsIgnoreCase(attributeDimensionNode.getName())) continue;
                            ++n;
                        }
                        if (n == 1) {
                            string = HCSArb.format("DIMENSION_INCLUDED_ONCE_IN_AV", attributeDimensionNode.getName());
                        } else if (n > 1) {
                            string = HCSArb.format("DIMENSION_INCLUDED_MULTIPLE_TIMES_IN_AV", attributeDimensionNode.getName(), n);
                        }
                        return string;
                    }
                };
                TreeSelectorDialog treeSelectorDialog = new TreeSelectorDialog(AVDimensionalityTablePanel.this.treeTableModel, new AttributeDimensionTreeRenderer(), treeSelectorFilter, "av_select_attribute_dimensions"){

                    @Override
                    protected void noSelectionError() {
                        JOptionPane.showMessageDialog(this, HCSArb.getString("NO_DIMENSION_SELECTED_ERROR"), this.getTitle(), 0);
                    }
                };
                treeSelectorDialog.setTreeSelectorToolTip(treeSelectorToolTip);
                treeSelectorDialog.setVisible(true);
                if (treeSelectorDialog.isOkClicked()) {
                    List<Object> list = treeSelectorDialog.getUserSelection();
                    for (Object object : list) {
                        Object object2;
                        AttributeDimensionNode attributeDimensionNode = (AttributeDimensionNode)object;
                        String string = attributeDimensionNode.getName();
                        if (string == null || string.length() <= 0) continue;
                        int n = 0;
                        for (int i = 0; i < AVDimensionalityTablePanel.this.tableModel.getRowCount(); ++i) {
                            if (!String.valueOf(AVDimensionalityTablePanel.this.tableModel.getValueAt(i, 0)).equalsIgnoreCase(string)) continue;
                            ++n;
                        }
                        String string2 = UIStringUtils.stripDoubleQuotes(string);
                        if (n > 0) {
                            string2 = String.format("%s_%d", string2, n);
                        }
                        string2 = AVDimensionalityTablePanel.this.prov.getExternalName(string2);
                        String string3 = AVDimensionalityTablePanel.this.prov.getInternalName(string);
                        AVDimensionality aVDimensionality = new AVDimensionality();
                        aVDimensionality.setDimensionAlias(AVDimensionalityTablePanel.this.prov.getInternalName(string2));
                        aVDimensionality.setDimensionalityName(string3);
                        aVDimensionality.setName(string3);
                        for (AttributeDimension attributeDimension : AVDimensionalityTablePanel.this.allDimensions) {
                            object2 = attributeDimension.getName();
                            if (!((String)object2).equals(string3)) continue;
                            aVDimensionality.setDimension(attributeDimension);
                            break;
                        }
                        Object[] objectArray = new Object[]{string, string2, "", "", aVDimensionality};
                        if (AVDimensionalityTablePanel.this.supportDistinct) {
                            objectArray = new Object[]{string, string2, "", "", aVDimensionality, false};
                            DatabaseSource[] databaseSourceArray = aVDimensionality.getDimension().getSources();
                            if (databaseSourceArray.length == 1 && (object2 = databaseSourceArray[0]).getQualifiedName().equals(AVDimensionalityTablePanel.this.source.getQualifiedName())) {
                                objectArray = new Object[]{string, string2, "", "", aVDimensionality, true};
                            }
                        }
                        AVDimensionalityTablePanel.this.tableModel.addRow(objectArray);
                    }
                    AVDimensionalityTablePanel.this.removeDimensionAction.setEnabled(true);
                    AVDimensionalityTablePanel.this.autoMap();
                }
            }
        };
        this.addDimensionAction.putValue("ShortDescription", HCSArb.getString("AV_DIMENSIONS_TABLE_ADD_TOOLTIP"));
        this.removeDimensionAction = new AbstractAction("", OracleIcons.getIcon((String)"delete.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AVDimensionalityTablePanel.this.dimensionalityTable.getSelectedRow();
                if (n >= 0) {
                    AVDimensionalityTablePanel.this.addDimensionAction.setEnabled(true);
                    AVDimensionalityTablePanel.this.tableModel.removeRow(n);
                    if (n < AVDimensionalityTablePanel.this.dimensionalityTable.getRowCount() && n > -1) {
                        AVDimensionalityTablePanel.this.dimensionalityTable.addRowSelectionInterval(n, n);
                    } else if (AVDimensionalityTablePanel.this.dimensionalityTable.getRowCount() > 0) {
                        AVDimensionalityTablePanel.this.dimensionalityTable.addRowSelectionInterval(AVDimensionalityTablePanel.this.dimensionalityTable.getRowCount() - 1, AVDimensionalityTablePanel.this.dimensionalityTable.getRowCount() - 1);
                    }
                }
                if (AVDimensionalityTablePanel.this.tableModel.getRowCount() == 0) {
                    AVDimensionalityTablePanel.this.removeDimensionAction.setEnabled(false);
                }
            }
        };
        this.removeDimensionAction.putValue("ShortDescription", HCSArb.getString("AV_DIMENSIONS_TABLE_REMOVE_TOOLTIP"));
    }

    public void autoMap() {
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            String string = (String)this.tableModel.getValueAt(i, 0);
            String string2 = String.format("%s_ID", string);
            if (this.source == null) continue;
            for (Column column : this.source.getColumns()) {
                String string3 = column.getName();
                if (!string3.endsWith("_ID") || !string3.equalsIgnoreCase(string2)) continue;
                this.tableModel.setValueAt(string3, i, 2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void loadTableData() {
        AVDimensionality[] aVDimensionalityArray;
        for (AVDimensionality aVDimensionality : aVDimensionalityArray = this.updatedObject.getDimensions()) {
            void var15_20;
            void var15_24;
            String string;
            CharSequence charSequence;
            String string2 = this.prov.getExternalName(aVDimensionality.getName());
            String string22 = this.prov.getExternalName(aVDimensionality.getDimensionAlias());
            if (aVDimensionality.getDimension() == null) {
                for (AttributeDimension attributeDimension : this.allDimensions) {
                    charSequence = attributeDimension.getName();
                    if (!((String)charSequence).equals(string2)) continue;
                    aVDimensionality.setDimension(attributeDimension);
                }
            }
            String[] stringArray = aVDimensionality.getMapExpressions();
            String[] object2 = aVDimensionality.getMappedDimensions();
            charSequence = new StringBuffer();
            int n = 0;
            for (Object object : stringArray) {
                string = this.prov.getExternalName((String)object);
                if (n > 0) {
                    ((StringBuffer)charSequence).append(",");
                }
                ((StringBuffer)charSequence).append(string);
                ++n;
            }
            n = 0;
            String[] stringArray2 = new StringBuffer();
            String[] stringArray3 = object2;
            int n2 = stringArray3.length;
            boolean bl = false;
            while (var15_24 < n2) {
                string = stringArray3[var15_24];
                String string3 = this.prov.getExternalName(string);
                if (n > 0) {
                    stringArray2.append(",");
                }
                stringArray2.append(string3);
                ++n;
                ++var15_24;
            }
            String string4 = ((StringBuffer)charSequence).toString();
            String string5 = stringArray2.toString();
            Object[] objectArray = new Object[]{string2, string22, string4, string5, aVDimensionality};
            if (this.supportDistinct) {
                boolean bl2 = aVDimensionality.isDistinct();
                Object[] objectArray2 = new Object[]{string2, string22, string4, string5, aVDimensionality, bl2};
            }
            this.tableModel.addRow((Object[])var15_20);
        }
        if (this.tableModel.getRowCount() == 0) {
            this.removeDimensionAction.setEnabled(false);
        }
    }

    private void setTableCellEditorAndRenderer() {
        this.dimensionalityTable.getColumnModel().getColumn(3).setCellEditor(this.dimensionKeyCellEditor);
        this.dimensionalityTable.getColumnModel().getColumn(3).setCellRenderer(new DimensionKeyRenderer());
        this.dimensionalityTable.getColumnModel().getColumn(1).setCellEditor(this.dimensionAliasCellEditor);
        this.dimensionalityTable.getColumnModel().getColumn(0).setCellRenderer(new NameColumnCellRenderer());
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane((Component)this.dimensionalityTable);
        ReorderableTableWithTitleBar reorderableTableWithTitleBar = new ReorderableTableWithTitleBar((JTable)this.dimensionalityTable, (JComponent)jScrollPane, true, true);
        TableToolbar tableToolbar = reorderableTableWithTitleBar.getTableToolbar();
        tableToolbar.setLabel(HCSArb.getString("HIERARCHY_SELECTOR_DIALOG_DIMENSIONS"));
        tableToolbar.addActionControl((Action)this.addDimensionAction);
        tableToolbar.addActionControl((Action)this.removeDimensionAction);
        this.add((Component)reorderableTableWithTitleBar, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void setHierarchyDimensions(List<AttributeDimension> list) {
        this.allDimensions = list;
    }

    public void setSource(DatabaseSource databaseSource) {
        this.source = databaseSource;
        ArrayList<DatabaseSource> arrayList = new ArrayList<DatabaseSource>();
        if (databaseSource != null) {
            arrayList.add(databaseSource);
        }
        this.setMapTableColumns(arrayList);
    }

    public void clearMapping() {
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            this.tableModel.setValueAt("", i, 2);
        }
        this.setMapTableColumns(null);
    }

    public void deriveDimensionality(final JLabel jLabel) {
        if (this.tableModel.getRowCount() > 0) {
            return;
        }
        jLabel.setText(HCSArb.format("DERIVING_AV_DIMENSIONALITY_MSG", this.source.getName()));
        jLabel.setVisible(true);
        AVDimensionalityWorker aVDimensionalityWorker = new AVDimensionalityWorker((OracleDatabaseImpl)this.prov, this.source){

            /*
             * WARNING - void declaration
             */
            @Override
            public void done() {
                try {
                    for (AVDimensionalityWorker.DerivedDimensionality derivedDimensionality : (List)this.get()) {
                        void objectArray2;
                        DatabaseSource[] databaseSourceArray;
                        String string = derivedDimensionality.getDimension();
                        String string2 = derivedDimensionality.getColumn();
                        int n = 0;
                        for (int i = 0; i < AVDimensionalityTablePanel.this.tableModel.getRowCount(); ++i) {
                            if (!String.valueOf(AVDimensionalityTablePanel.this.tableModel.getValueAt(i, 0)).equalsIgnoreCase(string)) continue;
                            ++n;
                        }
                        String string3 = string;
                        if (n > 0) {
                            string3 = String.format("%s_%d", string, n);
                        }
                        string3 = AVDimensionalityTablePanel.this.prov.getExternalName(string3);
                        AVDimensionality aVDimensionality = new AVDimensionality();
                        aVDimensionality.setDimensionAlias(AVDimensionalityTablePanel.this.prov.getInternalName(string3));
                        aVDimensionality.setDimensionalityName(string);
                        aVDimensionality.setName(string);
                        for (AttributeDimension attributeDimension : AVDimensionalityTablePanel.this.allDimensions) {
                            databaseSourceArray = attributeDimension.getName();
                            if (!databaseSourceArray.equals(string)) continue;
                            aVDimensionality.setDimension(attributeDimension);
                        }
                        String string4 = AVDimensionalityTablePanel.this.prov.getExternalName(string);
                        Object[] objectArray = new Object[]{string4, string3, string2, "", aVDimensionality};
                        if (AVDimensionalityTablePanel.this.supportDistinct) {
                            DatabaseSource databaseSource;
                            Object[] objectArray3 = new Object[]{string4, string3, string2, "", aVDimensionality, false};
                            databaseSourceArray = aVDimensionality.getDimension().getSources();
                            if (databaseSourceArray.length == 1 && (databaseSource = databaseSourceArray[0]).getQualifiedName().equals(AVDimensionalityTablePanel.this.source.getQualifiedName())) {
                                Object[] objectArray4 = new Object[]{string4, string3, "", string2, aVDimensionality, true};
                            }
                        }
                        AVDimensionalityTablePanel.this.tableModel.addRow((Object[])objectArray2);
                    }
                    if (AVDimensionalityTablePanel.this.tableModel.getRowCount() > 0) {
                        AVDimensionalityTablePanel.this.removeDimensionAction.setEnabled(true);
                    }
                    jLabel.setVisible(false);
                }
                catch (Exception exception) {
                    String string = null;
                    String string5 = exception.getCause().getLocalizedMessage();
                    if (string5 == null || string5.length() == 0) {
                        string5 = exception.getClass().toString();
                    }
                    String string6 = HCSArb.get("DERIVING_AV_DIMENSIONALITY_ERROR");
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string5, (String)string6, string);
                }
            }
        };
        aVDimensionalityWorker.execute();
    }

    public void setProvider(DBObjectProvider dBObjectProvider) {
        this.prov = dBObjectProvider;
        String string = Connections.getInstance().getConnectionName((Database)((OracleDatabaseImpl)dBObjectProvider));
        if (FeatureMap.getInstance().isSupported(string, "REFERENCES_DISTINCT")) {
            this.supportDistinct = true;
            this.tableModel.addColumn(HCSArb.getString("AV_DIMENSION_TABLE_DISTINCT_COLUMN"));
            int[] nArray = new int[]{100, 115, 120, 140, 0, 60};
            int[] nArray2 = new int[]{75, 75, 75, 75, 0, 60};
            int n = 0;
            for (int n2 : nArray) {
                TableColumn tableColumn = this.dimensionalityTable.getColumnModel().getColumn(n++);
                tableColumn.setMinWidth(nArray2[n - 1]);
                tableColumn.setPreferredWidth(n2);
            }
            this.setTableCellEditorAndRenderer();
        }
    }

    public void setSchema(HCSSchema hCSSchema) {
        this.schema = hCSSchema;
    }

    public int getDimensionsCount() {
        return this.tableModel.getRowCount();
    }

    public boolean isDistinct(int n) {
        if (this.supportDistinct) {
            return (Boolean)this.tableModel.getValueAt(n, 5);
        }
        return this.supportDistinct;
    }

    public String getDimension(int n) {
        return (String)this.tableModel.getValueAt(n, 0);
    }

    public String getDimensionKey(int n) {
        return (String)this.tableModel.getValueAt(n, 2);
    }

    public String getDimensionAttribute(int n) {
        return (String)this.tableModel.getValueAt(n, 3);
    }

    public String getDimensionAlias(int n) {
        return (String)this.tableModel.getValueAt(n, 1);
    }

    public AVDimensionality getDimensionality(int n) {
        return (AVDimensionality)this.tableModel.getValueAt(n, 4);
    }

    private void setMapTableColumns(List<DatabaseSource> list) {
        Object object;
        Object object2;
        String string2 = this.updatedObject.getSchema().getName();
        this.sourceColumns = new ArrayList<ColumnIdentifier>();
        if (list != null) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = (DatabaseSource)object2.next();
                for (Column column : object.getColumns()) {
                    String string3;
                    if (!this.isColumnValidDataType(column.getDataType().trim())) continue;
                    String string4 = AVDimensionalityTablePanel.getQuotedIdentifier(object.getSchemaName());
                    String string5 = AVDimensionalityTablePanel.getQuotedIdentifier(object.getName());
                    String string6 = string3 = AVDimensionalityTablePanel.getQuotedIdentifier(column.getName());
                    this.sourceColumns.add(new ColumnIdentifier(null, null, null, string3, column));
                }
            }
        }
        if (((TableColumn)(object2 = this.dimensionalityTable.getColumnModel().getColumn(2))).getModelIndex() != 2) {
            object = this.dimensionalityTable.getColumnModel().getColumns();
            while (object.hasMoreElements() && ((TableColumn)(object2 = (TableColumn)object.nextElement())).getModelIndex() != 2) {
            }
        }
        object = new CompletionTextField();
        this.sourceCompletionProvider = new CompletionColumnMatchProvider(object.getPopupHandler().getInsightList(), this.sourceColumns);
        object.getPopupHandler().registerInsightProvider((CompletionProvider)this.sourceCompletionProvider);
        ((TableColumn)object2).setCellRenderer(new MapExpressionCellRenderer(string -> {
            for (ColumnIdentifier columnIdentifier : this.sourceColumns) {
                if (!columnIdentifier.getIdentifier().equals(string)) continue;
                return columnIdentifier.getColumn();
            }
            return null;
        }));
        ((TableColumn)object2).setCellEditor(new CompletionCellEditor((CompletionTextField)object, this.sourceCompletionProvider));
    }

    public List<ColumnIdentifier> getSourceColumns() {
        return this.sourceColumns;
    }

    public boolean isColumnValidDataType(String string) {
        return !string.equalsIgnoreCase(CLOB_TYPE) && !string.equalsIgnoreCase(BLOB_TYPE);
    }

    private static String getQuotedIdentifier(String string) {
        if (string.indexOf(".") != -1 || !string.toUpperCase().equals(string)) {
            return "\"" + string + "\"";
        }
        return string;
    }

    public Column getColumn(String string) {
        for (ColumnIdentifier columnIdentifier : this.sourceColumns) {
            if (!columnIdentifier.getIdentifier().equals(string)) continue;
            return columnIdentifier.getColumn();
        }
        return null;
    }

    protected void updateNameToUppercase(String string, int n, int n2) {
        final String string2 = string;
        final int n3 = n;
        final int n4 = n2;
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                    String string = (String)AVDimensionalityTablePanel.this.tableModel.getValueAt(n3, n4);
                    String string22 = (String)string2;
                    if (string22 != null && string22.equalsIgnoreCase(string)) {
                        AVDimensionalityTablePanel.this.tableModel.setValueAt(string2, n3, n4);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        SwingUtilities.invokeLater(thread);
    }

    private class DimensionKeyCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private AnalyticView analyticView;
        private List<Hierarchy> allHiers;
        private JComboBox combo;

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, final int n, int n2) {
            this.combo = new JComboBox();
            this.combo.setEditable(true);
            String string = (String)AVDimensionalityTablePanel.this.tableModel.getValueAt(n, 0);
            this.populateComboBox(string, n, this.combo);
            this.combo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AVDimensionalityTablePanel.this.dimensionalityTable.changeSelection(n, 0, false, false);
                }
            });
            return this.combo;
        }

        public void setAV(AnalyticView analyticView) {
            this.analyticView = analyticView;
        }

        public void setAllHierarchies(List<Hierarchy> list) {
            this.allHiers = list;
        }

        private void populateComboBox(String string, int n, JComboBox jComboBox) {
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            jComboBox.setModel(defaultComboBoxModel);
            String string2 = (String)AVDimensionalityTablePanel.this.tableModel.getValueAt(n, 3);
            string2 = AVDimensionalityTablePanel.this.prov.getExternalName(string2);
            String string3 = null;
            boolean bl = false;
            for (AttributeDimension attributeDimension : AVDimensionalityTablePanel.this.allDimensions) {
                String string4;
                String string5 = AVDimensionalityTablePanel.this.prov.getInternalName(string);
                if (!attributeDimension.getName().equals(string5)) continue;
                DimensionAttribute[] dimensionAttributeArray = attributeDimension.getAttributes();
                if (this.analyticView != null) {
                    String string6 = attributeDimension.getName();
                    AVDimensionality aVDimensionality = this.analyticView.findDimensionality(string6);
                    if (aVDimensionality == null || aVDimensionality.getDimension() == null) {
                        aVDimensionality = new AVDimensionality(attributeDimension);
                        for (Hierarchy hierarchy : this.allHiers) {
                            string4 = hierarchy.getDimensionName();
                            if (!string4.equals(string6)) continue;
                            aVDimensionality.addHierarchy(new AVHierarchy(hierarchy));
                        }
                    }
                    if ((string2 == null || string2.isEmpty()) && aVDimensionality.getHierarchies().length > 0) {
                        DimensionLevel[] dimensionLevelArray = aVDimensionality.getSortedLevels(this.allHiers);
                        dimensionAttributeArray = aVDimensionality.getSortedAttributes(dimensionLevelArray);
                        DimensionAttribute dimensionAttribute = aVDimensionality.getLeafAttribute(dimensionLevelArray);
                        if (dimensionAttribute != null) {
                            string2 = AVDimensionalityTablePanel.this.prov.getExternalName(dimensionAttribute.getName());
                        }
                    }
                }
                for (DimensionAttribute dimensionAttribute : dimensionAttributeArray) {
                    string4 = AVDimensionalityTablePanel.this.prov.getExternalName(dimensionAttribute.getName());
                    defaultComboBoxModel.addElement(string4);
                    if (string2 == null && string4.endsWith(string5 + "_ID")) {
                        string2 = string4;
                    }
                    if (string3 != null || !string4.endsWith("_ID")) continue;
                    string3 = string4;
                }
                if (string2 == null) {
                    string2 = string3;
                }
                if (string2 != null) {
                    defaultComboBoxModel.setSelectedItem(string2);
                }
                bl = true;
            }
            if (!bl) {
                defaultComboBoxModel.addElement(string2);
                defaultComboBoxModel.setSelectedItem(string2);
            }
        }

        @Override
        public Object getCellEditorValue() {
            String string = (String)this.combo.getEditor().getItem();
            if (string != null) {
                return string;
            }
            return this.combo.getSelectedItem();
        }
    }

    private class DimensionAliasCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        protected JTable table;
        protected JTextField cellTextField = new JTextField();
        protected AbstractChildObjectWithDesc abstractChildObjectWithDesc;
        protected int row;
        protected int column;
        protected KeyAdapter ka = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\u001b') {
                    return;
                }
            }
        };

        public DimensionAliasCellEditor() {
            this.cellTextField.addKeyListener(this.ka);
            this.cellTextField.getDocument().addDocumentListener(new DocumentListener(){

                public void common() {
                    TableColumn tableColumn = DimensionAliasCellEditor.this.table.getColumnModel().getColumn(DimensionAliasCellEditor.this.column);
                    int n = tableColumn.getModelIndex();
                    AVDimensionalityTablePanel.this.dimensionalityTable.changeSelection(DimensionAliasCellEditor.this.row, n, false, false);
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.common();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.common();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.common();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.row = n;
            this.column = n2;
            this.table = jTable;
            this.cellTextField.setText((String)object);
            return this.cellTextField;
        }

        @Override
        public Object getCellEditorValue() {
            String string = this.cellTextField.getText();
            return string;
        }

        @Override
        public boolean stopCellEditing() {
            int n = 1;
            TableColumn tableColumn = this.table.getColumnModel().getColumn(this.column);
            int n2 = tableColumn.getModelIndex();
            if (n2 == n) {
                boolean bl = true;
                String string = null;
                String string2 = (String)AVDimensionalityTablePanel.this.tableModel.getValueAt(this.row, 1);
                String string3 = this.cellTextField.getText();
                if (string3 == null || string3.length() == 0) {
                    bl = false;
                    string = HCSArb.getString("NO_ALIAS_HIERARCHY_DIMENSION_ERROR");
                } else {
                    try {
                        AVDimensionalityTablePanel.this.prov.validateName("ATTRIBUTE DIMENSION", string3);
                    }
                    catch (InvalidNameException invalidNameException) {
                        string = HCSArb.get("ATTRIBUTE_DIMENSION_ALIAS_ERROR_NAME");
                        bl = false;
                    }
                }
                if (!bl) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)HCSArb.get("GENERIC_ERROR_TITLE"), null);
                    this.cellTextField.setText(string2);
                    return bl;
                }
                if (string3 != null && !string3.isEmpty() && !UIStringUtils.isQuotedName(string3)) {
                    AVDimensionalityTablePanel.this.updateNameToUppercase(string3.toUpperCase(), this.row, 1);
                }
            }
            return super.stopCellEditing();
        }
    }

    private class DimensionKeyRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component;
            if (object == null || object.toString().isEmpty()) {
                object = HCSArb.getString("AV_DIMENSION_TABLE_SELECT_KEY_COLUMN");
            }
            if ((component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2)) instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                if (object.equals(HCSArb.getString("AV_DIMENSION_TABLE_SELECT_KEY_COLUMN"))) {
                    jLabel.setEnabled(false);
                } else {
                    jLabel.setEnabled(true);
                }
            }
            return component;
        }
    }

    private class NameColumnCellRenderer
    extends DefaultTableCellRenderer {
        private JLabel label;

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            String string = (String)object;
            if (AVDimensionalityTablePanel.this.schema != null) {
                AttributeDimension attributeDimension = AVDimensionalityTablePanel.this.schema.findDimension(string);
                if (component instanceof JLabel) {
                    this.label = (JLabel)component;
                    this.label.setText((String)object);
                    boolean bl3 = false;
                    if (attributeDimension != null) {
                        bl3 = attributeDimension.isValid();
                    }
                    if (!bl3) {
                        Icon icon = HCSNavigatorResource.getIcon("NAMECONFLICTERROR");
                        this.label.setPreferredSize(new Dimension(5, 5));
                        this.label.setIcon(icon);
                        this.label.setIconTextGap(3);
                        this.label.setToolTipText(HCSArb.format("AV_DIMENSIONS_PANEL_TOOLTIP", string));
                    } else {
                        int n3 = this.getFontMetrics(this.getFont()).stringWidth(string);
                        int n4 = this.getFontMetrics(this.getFont()).stringWidth(string);
                        this.label.setPreferredSize(new Dimension(n3, n4));
                        this.label.setToolTipText(null);
                        this.label.setIcon(null);
                    }
                }
            }
            return component;
        }
    }

    private class ComboBoxRenderer
    extends JComboBox
    implements TableCellRenderer {
        public ComboBoxRenderer() {
            this.setUI(new BasicComboBoxUI(){

                @Override
                protected JButton createArrowButton() {
                    return new BasicArrowButton(5, Color.white, Color.white, Color.black, Color.white);
                }
            });
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null) {
                this.removeAllItems();
                this.addItem(object);
            }
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            return this;
        }
    }

    private class FactTableColumnCellEditor
    extends DefaultCellEditor {
        private DatabaseSource source;

        public FactTableColumnCellEditor(DatabaseSource databaseSource) {
            super(new JComboBox());
            this.source = databaseSource;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            if (component instanceof JComboBox) {
                this.populateComboBox((JComboBox)component);
                return component;
            }
            return null;
        }

        private void populateComboBox(JComboBox jComboBox) {
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            jComboBox.setModel(defaultComboBoxModel);
            for (Column column : this.source.getColumns()) {
                String string = column.getName();
                if (!string.endsWith("_ID")) continue;
                defaultComboBoxModel.addElement(string);
            }
        }
    }
}

